/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.ConfigGroup;
import org.apache.flink.annotation.docs.ConfigGroups;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.connector.pulsar.source.config.CursorVerification;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;

@ConfigGroups(groups={@ConfigGroup(name="PulsarSource", keyPrefix="pulsar.source."), @ConfigGroup(name="PulsarConsumer", keyPrefix="pulsar.consumer.")})
@PublicEvolving
public final class PulsarSourceOptions {
    public static final String SOURCE_CONFIG_PREFIX = "pulsar.source.";
    public static final String CONSUMER_CONFIG_PREFIX = "pulsar.consumer.";
    public static final ConfigOption<Long> PULSAR_PARTITION_DISCOVERY_INTERVAL_MS = ConfigOptions.key((String)"pulsar.source.partitionDiscoveryIntervalMs").longType().defaultValue((Object)Duration.ofSeconds(30L).toMillis()).withDescription(Description.builder().text("The interval (in ms) for the Pulsar source to discover the new partitions.").text(" A non-positive value disables the partition discovery.").build());
    public static final ConfigOption<Boolean> PULSAR_ENABLE_AUTO_ACKNOWLEDGE_MESSAGE = ConfigOptions.key((String)"pulsar.source.enableAutoAcknowledgeMessage").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("Flink commits the consuming position with pulsar transactions on checkpoint.").text(" However, if you have disabled the Flink checkpoint or disabled transaction for your Pulsar cluster,").text(" ensure that you have set this option to %s.", new InlineElement[]{TextElement.code((String)"true")}).linebreak().text("The source would use pulsar client's internal mechanism and commit cursor in two ways.").list(new InlineElement[]{TextElement.text((String)"For %s and %s subscription, the cursor would be committed once the message is consumed.", (InlineElement[])new InlineElement[]{TextElement.code((String)"Key_Shared"), TextElement.code((String)"Shared")}), TextElement.text((String)"For %s and %s subscription, the cursor would be committed in a given interval.", (InlineElement[])new InlineElement[]{TextElement.code((String)"Exclusive"), TextElement.code((String)"Failover")})}).build());
    public static final ConfigOption<Long> PULSAR_AUTO_COMMIT_CURSOR_INTERVAL = ConfigOptions.key((String)"pulsar.source.autoCommitCursorInterval").longType().defaultValue((Object)Duration.ofSeconds(5L).toMillis()).withDescription(Description.builder().text("This option is used only when the user disables the checkpoint and uses Exclusive or Failover subscription.").text(" We would automatically commit the cursor using the given period (in ms).").build());
    public static final ConfigOption<Long> PULSAR_READ_TRANSACTION_TIMEOUT = ConfigOptions.key((String)"pulsar.source.transactionTimeoutMillis").longType().defaultValue((Object)Duration.ofHours(3L).toMillis()).withDescription(Description.builder().text("This option is used in %s or %s subscription.", new InlineElement[]{TextElement.code((String)"Shared"), TextElement.code((String)"Key_Shared")}).text(" You should configure this option when you do not enable the %s option.", new InlineElement[]{TextElement.code((String)"pulsar.source.enableAutoAcknowledgeMessage")}).linebreak().text("The value (in ms) should be greater than the checkpoint interval.").build());
    @Deprecated
    public static final ConfigOption<Long> PULSAR_TRANSACTION_TIMEOUT_MILLIS = PULSAR_READ_TRANSACTION_TIMEOUT;
    public static final ConfigOption<Long> PULSAR_MAX_FETCH_TIME = ConfigOptions.key((String)"pulsar.source.maxFetchTime").longType().defaultValue((Object)Duration.ofSeconds(10L).toMillis()).withDescription(Description.builder().text("The maximum time (in ms) to wait when fetching records.").text(" A longer time increases throughput but also latency.").text(" A fetch batch might be finished earlier because of %s.", new InlineElement[]{TextElement.code((String)"pulsar.source.maxFetchRecords")}).build());
    public static final ConfigOption<Integer> PULSAR_MAX_FETCH_RECORDS = ConfigOptions.key((String)"pulsar.source.maxFetchRecords").intType().defaultValue((Object)100).withDescription(Description.builder().text("The maximum number of records to fetch to wait when polling.").text(" A longer time increases throughput but also latency.").text(" A fetch batch might be finished earlier because of %s.", new InlineElement[]{TextElement.code((String)"pulsar.source.maxFetchTime")}).build());
    public static final ConfigOption<CursorVerification> PULSAR_VERIFY_INITIAL_OFFSETS = ConfigOptions.key((String)"pulsar.source.verifyInitialOffsets").enumType(CursorVerification.class).defaultValue((Object)CursorVerification.WARN_ON_MISMATCH).withDescription(Description.builder().text("Upon (re)starting the source, check whether the expected message can be read.").text(" If failure is enabled, the application fails. Otherwise, it logs a warning.").text(" A possible solution is to adjust the retention settings in Pulsar or ignoring the check result.").build());
    public static final ConfigOption<Boolean> PULSAR_READ_SCHEMA_EVOLUTION = ConfigOptions.key((String)"pulsar.source.enableSchemaEvolution").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("If you enable this option, we would consume and deserialize the message by using Pulsar's %s.", new InlineElement[]{TextElement.code((String)"Schema")}).build());
    public static final ConfigOption<String> PULSAR_SUBSCRIPTION_NAME = ConfigOptions.key((String)"pulsar.consumer.subscriptionName").stringType().noDefaultValue().withDescription(Description.builder().text("Specify the subscription name for this consumer.").text(" This argument is required when constructing the consumer.").build());
    public static final ConfigOption<SubscriptionType> PULSAR_SUBSCRIPTION_TYPE = ConfigOptions.key((String)"pulsar.consumer.subscriptionType").enumType(SubscriptionType.class).defaultValue((Object)SubscriptionType.Shared).withDescription(Description.builder().text("Subscription type.").linebreak().linebreak().text("Four subscription types are available:").list(new InlineElement[]{TextElement.text((String)"Exclusive"), TextElement.text((String)"Failover"), TextElement.text((String)"Shared"), TextElement.text((String)"Key_Shared")}).build());
    public static final ConfigOption<SubscriptionMode> PULSAR_SUBSCRIPTION_MODE = ConfigOptions.key((String)"pulsar.consumer.subscriptionMode").enumType(SubscriptionMode.class).defaultValue((Object)SubscriptionMode.Durable).withDescription(Description.builder().text("Select the subscription mode to be used when subscribing to the topic.").list(new InlineElement[]{TextElement.text((String)"%s: Make the subscription to be backed by a durable cursor that will retain messages and persist the current position.", (InlineElement[])new InlineElement[]{TextElement.code((String)"Durable")}), TextElement.text((String)"%s: Lightweight subscription mode that doesn't have a durable cursor associated", (InlineElement[])new InlineElement[]{TextElement.code((String)"NonDurable")})}).build());
    public static final ConfigOption<Integer> PULSAR_RECEIVER_QUEUE_SIZE = ConfigOptions.key((String)"pulsar.consumer.receiverQueueSize").intType().defaultValue((Object)1000).withDescription(Description.builder().text("Size of a consumer's receiver queue.").linebreak().text("For example, the number of messages accumulated by a consumer before an application calls %s.", new InlineElement[]{TextElement.code((String)"Receive")}).linebreak().text("A value higher than the default value increases consumer throughput, though at the expense of more memory utilization.").build());
    public static final ConfigOption<Long> PULSAR_ACKNOWLEDGEMENTS_GROUP_TIME_MICROS = ConfigOptions.key((String)"pulsar.consumer.acknowledgementsGroupTimeMicros").longType().defaultValue((Object)TimeUnit.MILLISECONDS.toMicros(100L)).withDescription(Description.builder().text("Group a consumer acknowledgment for a specified time (in \u03bcs).").text(" By default, a consumer uses %s grouping time to send out acknowledgments to a broker.", new InlineElement[]{TextElement.code((String)"100\u03bcs")}).text(" If the group time is set to %s, acknowledgments are sent out immediately.", new InlineElement[]{TextElement.code((String)"0")}).text(" A longer ack group time is more efficient at the expense of a slight increase in message re-deliveries after a failure.").build());
    public static final ConfigOption<Long> PULSAR_NEGATIVE_ACK_REDELIVERY_DELAY_MICROS = ConfigOptions.key((String)"pulsar.consumer.negativeAckRedeliveryDelayMicros").longType().defaultValue((Object)TimeUnit.MINUTES.toMicros(1L)).withDescription(Description.builder().text("Delay (in \u03bcs) to wait before redelivering messages that failed to be processed.").linebreak().text("When an application uses %s, failed messages are redelivered after a fixed timeout.", new InlineElement[]{TextElement.code((String)"Consumer.negativeAcknowledge(Message)")}).build());
    public static final ConfigOption<Integer> PULSAR_MAX_TOTAL_RECEIVER_QUEUE_SIZE_ACROSS_PARTITIONS = ConfigOptions.key((String)"pulsar.consumer.maxTotalReceiverQueueSizeAcrossPartitions").intType().defaultValue((Object)50000).withDescription(Description.builder().text("The maximum total receiver queue size across partitions.").linebreak().text("This setting reduces the receiver queue size for individual partitions if the total receiver queue size exceeds this value.").build());
    public static final ConfigOption<String> PULSAR_CONSUMER_NAME = ConfigOptions.key((String)"pulsar.consumer.consumerName").stringType().noDefaultValue().withDescription("The consumer name is informative and it can be used to identify a particular consumer instance from the topic stats.");
    public static final ConfigOption<Long> PULSAR_ACK_TIMEOUT_MILLIS = ConfigOptions.key((String)"pulsar.consumer.ackTimeoutMillis").longType().defaultValue((Object)0L).withDescription(Description.builder().text("The timeout (in ms) for unacknowledged messages, truncated to the nearest millisecond. The timeout needs to be greater than 1 second.").linebreak().text("By default, the acknowledge timeout is disabled and that means that messages delivered to a consumer will not be re-delivered unless the consumer crashes.").linebreak().text("When acknowledgement timeout being enabled, if a message is not acknowledged within the specified timeout it will be re-delivered to the consumer (possibly to a different consumer in case of a shared subscription).").build());
    public static final ConfigOption<Long> PULSAR_TICK_DURATION_MILLIS = ConfigOptions.key((String)"pulsar.consumer.tickDurationMillis").longType().defaultValue((Object)1000L).withDescription(Description.builder().text("Granularity (in ms) of the ack-timeout redelivery.").linebreak().text("A greater (for example, 1 hour) %s reduces the memory overhead to track messages.", new InlineElement[]{TextElement.code((String)"tickDurationMillis")}).build());
    public static final ConfigOption<Integer> PULSAR_PRIORITY_LEVEL = ConfigOptions.key((String)"pulsar.consumer.priorityLevel").intType().defaultValue((Object)0).withDescription(Description.builder().text("Priority level for a consumer to which a broker gives more priorities while dispatching messages in the shared subscription type.").linebreak().text("The broker follows descending priorities. For example, 0=max-priority, 1, 2,...").linebreak().text("In shared subscription mode, the broker first dispatches messages to the consumers on the highest priority level if they have permits.").text(" Otherwise, the broker considers consumers on the next priority level.").linebreak().linebreak().text("Example 1").linebreak().text("If a subscription has consumer A with %s 0 and consumer B with %s 1, then the broker only dispatches messages to consumer A until it runs out permits and then starts dispatching messages to consumer B.", new InlineElement[]{TextElement.code((String)"priorityLevel"), TextElement.code((String)"priorityLevel")}).linebreak().text("Example 2").linebreak().text("Consumer Priority, Level, Permits\nC1, 0, 2\nC2, 0, 1\nC3, 0, 1\nC4, 1, 2\nC5, 1, 1\n").linebreak().text("The order in which a broker dispatches messages to consumers is: C1, C2, C3, C1, C4, C5, C4.").build());
    public static final ConfigOption<Integer> PULSAR_MAX_PENDING_CHUNKED_MESSAGE = ConfigOptions.key((String)"pulsar.consumer.maxPendingChunkedMessage").intType().defaultValue((Object)10).withDescription(Description.builder().text("The consumer buffers chunk messages into memory until it receives all the chunks of the original message.").text(" While consuming chunk-messages, chunks from the same message might not be contiguous in the stream and they might be mixed with other messages' chunks.").text(" So, consumer has to maintain multiple buffers to manage chunks coming from different messages.").text(" This mainly happens when multiple publishers are publishing messages on the topic concurrently or publishers failed to publish all chunks of the messages.").linebreak().text("For example, there are M1-C1, M2-C1, M1-C2, M2-C2 messages.").text("Messages M1-C1 and M1-C2 belong to the M1 original message while M2-C1 and M2-C2 belong to the M2 message.").linebreak().text("Buffering a large number of outstanding uncompleted chunked messages can bring memory pressure and it can be guarded by providing this %s threshold.", new InlineElement[]{TextElement.code((String)"pulsar.consumer.maxPendingChunkedMessage")}).text(" Once, a consumer reaches this threshold, it drops the outstanding unchunked messages by silently acknowledging or asking the broker to redeliver messages later by marking it unacknowledged.").text(" This behavior can be controlled by the %s option.", new InlineElement[]{TextElement.code((String)"pulsar.consumer.autoAckOldestChunkedMessageOnQueueFull")}).build());
    public static final ConfigOption<Boolean> PULSAR_AUTO_ACK_OLDEST_CHUNKED_MESSAGE_ON_QUEUE_FULL = ConfigOptions.key((String)"pulsar.consumer.autoAckOldestChunkedMessageOnQueueFull").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("Buffering a large number of outstanding uncompleted chunked messages can bring memory pressure and it can be guarded by providing this %s threshold.", new InlineElement[]{TextElement.code((String)"pulsar.consumer.maxPendingChunkedMessage")}).text(" Once a consumer reaches this threshold, it drops the outstanding unchunked-messages by silently acknowledging if %s is true. Otherwise, it marks them for redelivery.", new InlineElement[]{TextElement.code((String)"pulsar.consumer.autoAckOldestChunkedMessageOnQueueFull")}).build());
    public static final ConfigOption<Long> PULSAR_EXPIRE_TIME_OF_INCOMPLETE_CHUNKED_MESSAGE_MILLIS = ConfigOptions.key((String)"pulsar.consumer.expireTimeOfIncompleteChunkedMessageMillis").longType().defaultValue((Object)60000L).withDescription(Description.builder().text("If a producer fails to publish all the chunks of a message,").text(" the consumer can expire incomplete chunks if the consumer cannot receive all chunks in expire times (default 1 hour, in ms).").build());
    public static final ConfigOption<ConsumerCryptoFailureAction> PULSAR_CRYPTO_FAILURE_ACTION = ConfigOptions.key((String)"pulsar.consumer.cryptoFailureAction").enumType(ConsumerCryptoFailureAction.class).defaultValue((Object)ConsumerCryptoFailureAction.FAIL).withDescription(Description.builder().text("The consumer should take action when it receives a message that can not be decrypted.").list(new InlineElement[]{TextElement.text((String)"%s: this is the default option to fail messages until crypto succeeds.", (InlineElement[])new InlineElement[]{TextElement.code((String)"FAIL")}), TextElement.text((String)"%s: silently acknowledge but do not deliver messages to an application.", (InlineElement[])new InlineElement[]{TextElement.code((String)"DISCARD")}), TextElement.text((String)"%s: deliver encrypted messages to applications. It is the application's responsibility to decrypt the message.", (InlineElement[])new InlineElement[]{TextElement.code((String)"CONSUME")})}).linebreak().text("Fail to decompress the messages.").linebreak().text("If messages contain batch messages, a client is not be able to retrieve individual messages in batch.").linebreak().text("The delivered encrypted message contains %s which contains encryption and compression information in.", new InlineElement[]{TextElement.code((String)"EncryptionContext")}).text(" You can use an application to decrypt the consumed message payload.").build());
    public static final ConfigOption<Map<String, String>> PULSAR_CONSUMER_PROPERTIES = ConfigOptions.key((String)"pulsar.consumer.properties").mapType().defaultValue(Collections.emptyMap()).withDescription(Description.builder().text("A name or value property of this consumer.").text(" %s is application defined metadata attached to a consumer.", new InlineElement[]{TextElement.code((String)"properties")}).text(" When getting a topic stats, associate this metadata with the consumer stats for easier identification.").build());
    public static final ConfigOption<Boolean> PULSAR_READ_COMPACTED = ConfigOptions.key((String)"pulsar.consumer.readCompacted").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("If enabling %s, a consumer reads messages from a compacted topic rather than reading a full message backlog of a topic.", new InlineElement[]{TextElement.code((String)"readCompacted")}).linebreak().text("A consumer only sees the latest value for each key in the compacted topic, up until reaching the point in the topic message when compacting backlog. Beyond that point, send messages as normal.").linebreak().text("Only enabling %s on subscriptions to persistent topics, which have a single active consumer (like failure or exclusive subscriptions).", new InlineElement[]{TextElement.code((String)"readCompacted")}).linebreak().text("Attempting to enable it on subscriptions to non-persistent topics or on shared subscriptions leads to a subscription call throwing a %s.", new InlineElement[]{TextElement.code((String)"PulsarClientException")}).build());
    @Deprecated
    public static final ConfigOption<SubscriptionInitialPosition> PULSAR_SUBSCRIPTION_INITIAL_POSITION = ConfigOptions.key((String)"pulsar.consumer.subscriptionInitialPosition").enumType(SubscriptionInitialPosition.class).defaultValue((Object)SubscriptionInitialPosition.Latest).withDescription("Initial position at which to set cursor when subscribing to a topic at first time.");
    public static final ConfigOption<Integer> PULSAR_MAX_REDELIVER_COUNT = ConfigOptions.key((String)"pulsar.consumer.deadLetterPolicy.maxRedeliverCount").intType().defaultValue((Object)0).withDescription("The maximum number of times that a message are redelivered before being sent to the dead letter queue.");
    public static final ConfigOption<String> PULSAR_RETRY_LETTER_TOPIC = ConfigOptions.key((String)"pulsar.consumer.deadLetterPolicy.retryLetterTopic").stringType().noDefaultValue().withDescription("Name of the retry topic where the failed messages are sent.");
    public static final ConfigOption<String> PULSAR_DEAD_LETTER_TOPIC = ConfigOptions.key((String)"pulsar.consumer.deadLetterPolicy.deadLetterTopic").stringType().noDefaultValue().withDescription("Name of the dead topic where the failed messages are sent.");
    public static final ConfigOption<Boolean> PULSAR_RETRY_ENABLE = ConfigOptions.key((String)"pulsar.consumer.retryEnable").booleanType().defaultValue((Object)false).withDescription("If enabled, the consumer will automatically retry messages.");
    public static final ConfigOption<Integer> PULSAR_AUTO_UPDATE_PARTITIONS_INTERVAL_SECONDS = ConfigOptions.key((String)"pulsar.consumer.autoUpdatePartitionsIntervalSeconds").intType().defaultValue((Object)60).withDescription("The interval (in seconds) of updating partitions. This only works if autoUpdatePartitions is enabled.");
    public static final ConfigOption<Boolean> PULSAR_REPLICATE_SUBSCRIPTION_STATE = ConfigOptions.key((String)"pulsar.consumer.replicateSubscriptionState").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("If %s is enabled, a subscription state is replicated to geo-replicated clusters.", new InlineElement[]{TextElement.code((String)"replicateSubscriptionState")}).build());
    public static final ConfigOption<Boolean> PULSAR_ACK_RECEIPT_ENABLED = ConfigOptions.key((String)"pulsar.consumer.ackReceiptEnabled").booleanType().defaultValue((Object)false).withDescription("Acknowledgement will return a receipt but this does not mean that the message will not be resent after getting the receipt.");
    public static final ConfigOption<Boolean> PULSAR_POOL_MESSAGES = ConfigOptions.key((String)"pulsar.consumer.poolMessages").booleanType().defaultValue((Object)false).withDescription("Enable pooling of messages and the underlying data buffers.");

    private PulsarSourceOptions() {
    }
}

