/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.pulsar.common.config.PulsarConfigBuilder;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSchemaWrapper;
import org.apache.flink.connector.pulsar.source.PulsarSource;
import org.apache.flink.connector.pulsar.source.PulsarSourceOptions;
import org.apache.flink.connector.pulsar.source.config.PulsarSourceConfigUtils;
import org.apache.flink.connector.pulsar.source.config.SourceConfiguration;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StartCursor;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.subscriber.PulsarSubscriber;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.FullRangeGenerator;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.UniformRangeGenerator;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarDeserializationSchema;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public final class PulsarSourceBuilder<OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarSourceBuilder.class);
    private final PulsarConfigBuilder configBuilder = new PulsarConfigBuilder();
    private PulsarSubscriber subscriber;
    private RangeGenerator rangeGenerator;
    private StartCursor startCursor = StartCursor.defaultStartCursor();
    private StopCursor stopCursor = StopCursor.defaultStopCursor();
    private Boundedness boundedness = Boundedness.CONTINUOUS_UNBOUNDED;
    private PulsarDeserializationSchema<OUT> deserializationSchema;
    @Nullable
    private CryptoKeyReader cryptoKeyReader;

    PulsarSourceBuilder() {
    }

    public PulsarSourceBuilder<OUT> setAdminUrl(String adminUrl) {
        return this.setConfig(PulsarOptions.PULSAR_ADMIN_URL, adminUrl);
    }

    public PulsarSourceBuilder<OUT> setServiceUrl(String serviceUrl) {
        return this.setConfig(PulsarOptions.PULSAR_SERVICE_URL, serviceUrl);
    }

    public PulsarSourceBuilder<OUT> setSubscriptionName(String subscriptionName) {
        return this.setConfig(PulsarSourceOptions.PULSAR_SUBSCRIPTION_NAME, subscriptionName);
    }

    public PulsarSourceBuilder<OUT> setSubscriptionType(SubscriptionType subscriptionType) {
        return this.setConfig(PulsarSourceOptions.PULSAR_SUBSCRIPTION_TYPE, subscriptionType);
    }

    public PulsarSourceBuilder<OUT> setTopics(String ... topics) {
        return this.setTopics(Arrays.asList(topics));
    }

    public PulsarSourceBuilder<OUT> setTopics(List<String> topics) {
        this.ensureSubscriberIsNull("topics");
        List<String> distinctTopics = TopicNameUtils.distinctTopics(topics);
        this.subscriber = PulsarSubscriber.getTopicListSubscriber(distinctTopics);
        return this;
    }

    public PulsarSourceBuilder<OUT> setTopicPattern(String topicsPattern) {
        return this.setTopicPattern(Pattern.compile(topicsPattern));
    }

    public PulsarSourceBuilder<OUT> setTopicPattern(Pattern topicsPattern) {
        return this.setTopicPattern(topicsPattern, RegexSubscriptionMode.AllTopics);
    }

    public PulsarSourceBuilder<OUT> setTopicPattern(String topicsPattern, RegexSubscriptionMode regexSubscriptionMode) {
        return this.setTopicPattern(Pattern.compile(topicsPattern), regexSubscriptionMode);
    }

    public PulsarSourceBuilder<OUT> setTopicPattern(Pattern topicsPattern, RegexSubscriptionMode regexSubscriptionMode) {
        this.ensureSubscriberIsNull("topic pattern");
        this.subscriber = PulsarSubscriber.getTopicPatternSubscriber(topicsPattern, regexSubscriptionMode);
        return this;
    }

    public PulsarSourceBuilder<OUT> setConsumerName(String consumerName) {
        return this.setConfig(PulsarSourceOptions.PULSAR_CONSUMER_NAME, consumerName);
    }

    public PulsarSourceBuilder<OUT> enableSchemaEvolution() {
        this.configBuilder.set(PulsarSourceOptions.PULSAR_READ_SCHEMA_EVOLUTION, true);
        return this;
    }

    public PulsarSourceBuilder<OUT> setRangeGenerator(RangeGenerator rangeGenerator) {
        if (this.configBuilder.contains(PulsarSourceOptions.PULSAR_SUBSCRIPTION_TYPE)) {
            SubscriptionType subscriptionType = this.configBuilder.get(PulsarSourceOptions.PULSAR_SUBSCRIPTION_TYPE);
            Preconditions.checkArgument((subscriptionType == SubscriptionType.Key_Shared ? 1 : 0) != 0, (String)"Key_Shared subscription should be used for custom rangeGenerator instead of %s", (Object[])new Object[]{subscriptionType});
        } else {
            LOG.warn("No subscription type provided, set it to Key_Shared.");
            this.setSubscriptionType(SubscriptionType.Key_Shared);
        }
        this.rangeGenerator = (RangeGenerator)Preconditions.checkNotNull((Object)rangeGenerator);
        return this;
    }

    public PulsarSourceBuilder<OUT> setStartCursor(StartCursor startCursor) {
        this.startCursor = (StartCursor)Preconditions.checkNotNull((Object)startCursor);
        return this;
    }

    public PulsarSourceBuilder<OUT> setUnboundedStopCursor(StopCursor stopCursor) {
        this.boundedness = Boundedness.CONTINUOUS_UNBOUNDED;
        this.stopCursor = (StopCursor)Preconditions.checkNotNull((Object)stopCursor);
        return this;
    }

    public PulsarSourceBuilder<OUT> setBoundedStopCursor(StopCursor stopCursor) {
        this.boundedness = Boundedness.BOUNDED;
        this.stopCursor = (StopCursor)Preconditions.checkNotNull((Object)stopCursor);
        return this;
    }

    public <T extends OUT> PulsarSourceBuilder<T> setDeserializationSchema(PulsarDeserializationSchema<T> deserializationSchema) {
        PulsarSourceBuilder<T> self = this.specialized();
        self.deserializationSchema = deserializationSchema;
        return self;
    }

    public PulsarSourceBuilder<OUT> setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.cryptoKeyReader = (CryptoKeyReader)Preconditions.checkNotNull((Object)cryptoKeyReader);
        return this;
    }

    public <T> PulsarSourceBuilder<OUT> setConfig(ConfigOption<T> key, T value) {
        this.configBuilder.set(key, value);
        return this;
    }

    public PulsarSourceBuilder<OUT> setConfig(Configuration config) {
        this.configBuilder.set(config);
        return this;
    }

    public PulsarSourceBuilder<OUT> setProperties(Properties properties) {
        this.configBuilder.set(properties);
        return this;
    }

    public PulsarSource<OUT> build() {
        Preconditions.checkNotNull((Object)this.subscriber, (String)"No topic names or topic pattern are provided.");
        SubscriptionType subscriptionType = this.configBuilder.get(PulsarSourceOptions.PULSAR_SUBSCRIPTION_TYPE);
        if (subscriptionType == SubscriptionType.Key_Shared) {
            if (this.rangeGenerator == null) {
                LOG.warn("No range generator provided for key_shared subscription, we would use the UniformRangeGenerator as the default range generator.");
                this.rangeGenerator = new UniformRangeGenerator();
            }
        } else {
            this.rangeGenerator = new FullRangeGenerator();
        }
        if (this.boundedness == null) {
            LOG.warn("No boundedness was set, mark it as a endless stream.");
            this.boundedness = Boundedness.CONTINUOUS_UNBOUNDED;
        }
        if (this.boundedness == Boundedness.BOUNDED && this.configBuilder.get(PulsarSourceOptions.PULSAR_PARTITION_DISCOVERY_INTERVAL_MS) >= 0L) {
            LOG.warn("{} property is overridden to -1 because the source is bounded.", PulsarSourceOptions.PULSAR_PARTITION_DISCOVERY_INTERVAL_MS);
            this.configBuilder.override(PulsarSourceOptions.PULSAR_PARTITION_DISCOVERY_INTERVAL_MS, -1L);
        }
        Preconditions.checkNotNull(this.deserializationSchema, (String)"deserializationSchema should be set.");
        if (Boolean.FALSE.equals(this.configBuilder.get(PulsarSourceOptions.PULSAR_ENABLE_AUTO_ACKNOWLEDGE_MESSAGE)) && (subscriptionType == SubscriptionType.Key_Shared || subscriptionType == SubscriptionType.Shared)) {
            LOG.info("Pulsar cursor auto commit is disabled, make sure checkpoint is enabled and your pulsar cluster is support the transaction.");
            this.configBuilder.override(PulsarOptions.PULSAR_ENABLE_TRANSACTION, true);
            if (!this.configBuilder.contains(PulsarSourceOptions.PULSAR_READ_TRANSACTION_TIMEOUT)) {
                LOG.warn("The default pulsar transaction timeout is 3 hours, make sure it was greater than your checkpoint interval.");
            } else {
                Long timeout = this.configBuilder.get(PulsarSourceOptions.PULSAR_READ_TRANSACTION_TIMEOUT);
                LOG.warn("The configured transaction timeout is {} mille seconds, make sure it was greater than your checkpoint interval.", (Object)timeout);
            }
        }
        if (this.deserializationSchema instanceof PulsarSchemaWrapper && !Boolean.TRUE.equals(this.configBuilder.get(PulsarSourceOptions.PULSAR_READ_SCHEMA_EVOLUTION))) {
            LOG.info("It seems like you want to read message using Pulsar Schema. You can enableSchemaEvolution for using this feature. We would use Schema.BYTES as the default schema if you don't enable this option.");
        }
        if (Boolean.TRUE.equals(this.configBuilder.get(PulsarSourceOptions.PULSAR_READ_SCHEMA_EVOLUTION))) {
            Preconditions.checkState((boolean)(this.deserializationSchema instanceof PulsarSchemaWrapper), (Object)"When enabling schema evolution, you must use a Pulsar schema.");
        }
        if (!this.configBuilder.contains(PulsarSourceOptions.PULSAR_CONSUMER_NAME)) {
            LOG.warn("We recommend set a readable consumer name through setConsumerName(String) in production mode.");
        }
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable((Object)this.startCursor), (Object)"StartCursor isn't serializable");
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable((Object)this.stopCursor), (Object)"StopCursor isn't serializable");
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable((Object)this.rangeGenerator), (Object)"RangeGenerator isn't serializable");
        SourceConfiguration sourceConfiguration = this.configBuilder.build(PulsarSourceConfigUtils.SOURCE_CONFIG_VALIDATOR, SourceConfiguration::new);
        return new PulsarSource<OUT>(sourceConfiguration, this.subscriber, this.rangeGenerator, this.startCursor, this.stopCursor, this.boundedness, this.deserializationSchema, this.cryptoKeyReader);
    }

    private <T extends OUT> PulsarSourceBuilder<T> specialized() {
        return this;
    }

    private void ensureSubscriberIsNull(String attemptingSubscribeMode) {
        if (this.subscriber != null) {
            throw new IllegalStateException(String.format("Cannot use %s for consumption because a %s is already set for consumption.", attemptingSubscribeMode, this.subscriber.getClass().getSimpleName()));
        }
    }
}

