/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.serializer;

import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchema;
import org.apache.flink.connector.pulsar.sink.writer.context.PulsarSinkContext;
import org.apache.flink.connector.pulsar.sink.writer.message.PulsarMessage;
import org.apache.flink.connector.pulsar.sink.writer.message.PulsarMessageBuilder;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSerializationSchema;
import org.apache.pulsar.client.api.Schema;

@Internal
public class PulsarSchemaWrapper<IN>
implements PulsarSerializationSchema<IN> {
    private static final long serialVersionUID = -2567052498398184194L;
    private final PulsarSchema<IN> pulsarSchema;

    public PulsarSchemaWrapper(PulsarSchema<IN> pulsarSchema) {
        this.pulsarSchema = pulsarSchema;
    }

    @Override
    public PulsarMessage<?> serialize(IN element, PulsarSinkContext sinkContext) {
        Schema<IN> schema = this.pulsarSchema.getPulsarSchema();
        if (sinkContext.isEnableSchemaEvolution()) {
            PulsarMessageBuilder<IN> builder = new PulsarMessageBuilder<IN>();
            builder.value(schema, element);
            return builder.build();
        }
        PulsarMessageBuilder<byte[]> builder = new PulsarMessageBuilder<byte[]>();
        byte[] bytes = schema.encode(element);
        builder.value(Schema.BYTES, bytes);
        return builder.build();
    }
}

