/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.committer;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.connector.pulsar.common.config.PulsarClientFactory;
import org.apache.flink.connector.pulsar.common.utils.PulsarTransactionUtils;
import org.apache.flink.connector.pulsar.sink.committer.PulsarCommittable;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClient;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClientException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class PulsarCommitter
implements Committer<PulsarCommittable>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarCommitter.class);
    private final SinkConfiguration sinkConfiguration;
    private PulsarClient pulsarClient;
    private TransactionCoordinatorClient coordinatorClient;

    public PulsarCommitter(SinkConfiguration sinkConfiguration) {
        this.sinkConfiguration = (SinkConfiguration)((Object)Preconditions.checkNotNull((Object)((Object)sinkConfiguration)));
    }

    public void commit(Collection<Committer.CommitRequest<PulsarCommittable>> requests) throws IOException, InterruptedException {
        TransactionCoordinatorClient client = this.transactionCoordinatorClient();
        for (Committer.CommitRequest<PulsarCommittable> request : requests) {
            PulsarCommittable committable = (PulsarCommittable)request.getCommittable();
            TxnID txnID = committable.getTxnID();
            String topic = committable.getTopic();
            LOG.debug("Start committing the Pulsar transaction {} for topic {}", (Object)txnID, (Object)topic);
            try {
                client.commit(txnID);
            }
            catch (TransactionCoordinatorClientException e) {
                TransactionCoordinatorClientException ex = PulsarTransactionUtils.unwrap(e);
                if (ex instanceof TransactionCoordinatorClientException.CoordinatorNotFoundException) {
                    LOG.error("We couldn't find the Transaction Coordinator from Pulsar broker {}. Check your broker configuration.", (Object)committable, (Object)ex);
                    request.signalFailedWithKnownReason((Throwable)ex);
                    continue;
                }
                if (ex instanceof TransactionCoordinatorClientException.InvalidTxnStatusException) {
                    LOG.error("Unable to commit transaction ({}) because it's in an invalid state. Most likely the transaction has been aborted for some reason. Please check the Pulsar broker logs for more details.", (Object)committable, (Object)ex);
                    request.signalAlreadyCommitted();
                    continue;
                }
                if (ex instanceof TransactionCoordinatorClientException.TransactionNotFoundException) {
                    if (request.getNumberOfRetries() == 0) {
                        LOG.error("Unable to commit transaction ({}) because it's not found on Pulsar broker. Most likely the checkpoint interval exceed the transaction timeout.", (Object)committable, (Object)ex);
                        request.signalFailedWithKnownReason((Throwable)ex);
                        continue;
                    }
                    LOG.warn("We can't find the transaction {} after {} retry committing. This may mean that the transaction have been committed in previous but failed with timeout. So we just mark it as committed.", (Object)txnID, (Object)request.getNumberOfRetries());
                    request.signalAlreadyCommitted();
                    continue;
                }
                if (ex instanceof TransactionCoordinatorClientException.MetaStoreHandlerNotExistsException) {
                    LOG.error("We can't find the meta store handler by the mostSigBits from TxnID {}. Did you change the metadata for topic {}?", new Object[]{committable, TopicName.TRANSACTION_COORDINATOR_ASSIGN, ex});
                    request.signalFailedWithKnownReason((Throwable)ex);
                    continue;
                }
                LOG.error("Encountered retriable exception while committing transaction {} for topic {}.", new Object[]{committable, topic, ex});
                int maxRecommitTimes = this.sinkConfiguration.getMaxRecommitTimes();
                if (request.getNumberOfRetries() < maxRecommitTimes) {
                    request.retryLater();
                    continue;
                }
                String message = String.format("Failed to commit transaction %s after retrying %d times", txnID, maxRecommitTimes);
                request.signalFailedWithKnownReason((Throwable)new FlinkRuntimeException(message, (Throwable)ex));
            }
            catch (Exception e) {
                LOG.error("Transaction ({}) encountered unknown error and data could be potentially lost.", (Object)committable, (Object)e);
                request.signalFailedWithUnknownReason((Throwable)e);
            }
        }
    }

    private TransactionCoordinatorClient transactionCoordinatorClient() {
        if (this.coordinatorClient == null) {
            this.pulsarClient = PulsarClientFactory.createClient(this.sinkConfiguration);
            this.coordinatorClient = ((PulsarClientImpl)this.pulsarClient).getTcClient();
            Preconditions.checkNotNull((Object)this.coordinatorClient, (String)"You haven't enable transaction in Pulsar client.");
        }
        return this.coordinatorClient;
    }

    @Override
    public void close() throws IOException {
        if (this.pulsarClient != null) {
            this.pulsarClient.close();
        }
    }
}

