/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.pulsar.common.config.PulsarConfigBuilder;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.flink.connector.pulsar.sink.PulsarSink;
import org.apache.flink.connector.pulsar.sink.PulsarSinkOptions;
import org.apache.flink.connector.pulsar.sink.config.PulsarSinkConfigUtils;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.flink.connector.pulsar.sink.writer.delayer.MessageDelayer;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRouter;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRoutingMode;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSchemaWrapper;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSerializationSchema;
import org.apache.flink.connector.pulsar.sink.writer.topic.TopicExtractor;
import org.apache.flink.connector.pulsar.sink.writer.topic.TopicRegister;
import org.apache.flink.connector.pulsar.sink.writer.topic.register.DynamicTopicRegister;
import org.apache.flink.connector.pulsar.sink.writer.topic.register.EmptyTopicRegister;
import org.apache.flink.connector.pulsar.sink.writer.topic.register.FixedTopicRegister;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class PulsarSinkBuilder<IN> {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarSinkBuilder.class);
    private final PulsarConfigBuilder configBuilder;
    private PulsarSerializationSchema<IN> serializationSchema;
    private TopicRegister<IN> topicRegister;
    private TopicRoutingMode topicRoutingMode;
    private TopicRouter<IN> topicRouter;
    private MessageDelayer<IN> messageDelayer;
    @Nullable
    private CryptoKeyReader cryptoKeyReader;
    private List<String> encryptionKeys = new ArrayList<String>();

    PulsarSinkBuilder() {
        this.configBuilder = new PulsarConfigBuilder();
    }

    public PulsarSinkBuilder<IN> setAdminUrl(String adminUrl) {
        return this.setConfig(PulsarOptions.PULSAR_ADMIN_URL, adminUrl);
    }

    public PulsarSinkBuilder<IN> setServiceUrl(String serviceUrl) {
        return this.setConfig(PulsarOptions.PULSAR_SERVICE_URL, serviceUrl);
    }

    public PulsarSinkBuilder<IN> setProducerName(String producerName) {
        return this.setConfig(PulsarSinkOptions.PULSAR_PRODUCER_NAME, producerName);
    }

    public PulsarSinkBuilder<IN> setTopics(String ... topics) {
        return this.setTopics(Arrays.asList(topics));
    }

    public PulsarSinkBuilder<IN> setTopics(List<String> topics) {
        Preconditions.checkState((this.topicRegister == null ? 1 : 0) != 0, (Object)"setTopics couldn't be set twice.");
        List<String> topicSet = TopicNameUtils.distinctTopics(topics);
        this.topicRegister = topicSet.isEmpty() ? new EmptyTopicRegister() : new FixedTopicRegister(topicSet);
        return this;
    }

    public PulsarSinkBuilder<IN> setTopics(TopicExtractor<IN> extractor) {
        Preconditions.checkState((this.topicRegister == null ? 1 : 0) != 0, (Object)"setTopics couldn't be set twice.");
        this.topicRegister = new DynamicTopicRegister<IN>(extractor);
        return this;
    }

    public PulsarSinkBuilder<IN> setDeliveryGuarantee(DeliveryGuarantee deliveryGuarantee) {
        Preconditions.checkNotNull((Object)deliveryGuarantee, (String)"deliveryGuarantee");
        this.configBuilder.override(PulsarSinkOptions.PULSAR_WRITE_DELIVERY_GUARANTEE, deliveryGuarantee);
        return this;
    }

    public PulsarSinkBuilder<IN> setTopicRoutingMode(TopicRoutingMode topicRoutingMode) {
        Preconditions.checkArgument((topicRoutingMode != TopicRoutingMode.CUSTOM ? 1 : 0) != 0, (Object)"CUSTOM mode should be set by using setTopicRouter method.");
        this.topicRoutingMode = (TopicRoutingMode)((Object)Preconditions.checkNotNull((Object)((Object)topicRoutingMode), (String)"topicRoutingMode"));
        return this;
    }

    public PulsarSinkBuilder<IN> setTopicRouter(TopicRouter<IN> topicRouter) {
        if (this.topicRoutingMode != null && this.topicRoutingMode != TopicRoutingMode.CUSTOM) {
            LOG.warn("We would override topicRoutingMode to CUSTOM if you provide TopicRouter.");
        }
        this.topicRoutingMode = TopicRoutingMode.CUSTOM;
        this.topicRouter = (TopicRouter)Preconditions.checkNotNull(topicRouter, (String)"topicRouter");
        return this;
    }

    public <T extends IN> PulsarSinkBuilder<T> setSerializationSchema(PulsarSerializationSchema<T> serializationSchema) {
        PulsarSinkBuilder<T> self = this.specialized();
        self.serializationSchema = serializationSchema;
        return self;
    }

    public PulsarSinkBuilder<IN> enableSchemaEvolution() {
        this.configBuilder.override(PulsarSinkOptions.PULSAR_WRITE_SCHEMA_EVOLUTION, true);
        return this;
    }

    public PulsarSinkBuilder<IN> delaySendingMessage(MessageDelayer<IN> messageDelayer) {
        this.messageDelayer = (MessageDelayer)Preconditions.checkNotNull(messageDelayer);
        return this;
    }

    public PulsarSinkBuilder<IN> setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.cryptoKeyReader = (CryptoKeyReader)Preconditions.checkNotNull((Object)cryptoKeyReader);
        return this;
    }

    public PulsarSinkBuilder<IN> setEncryptionKeys(String ... keys) {
        this.encryptionKeys.addAll(Arrays.asList(keys));
        return this;
    }

    public <T> PulsarSinkBuilder<IN> setConfig(ConfigOption<T> key, T value) {
        this.configBuilder.set(key, value);
        return this;
    }

    public PulsarSinkBuilder<IN> setConfig(Configuration config) {
        this.configBuilder.set(config);
        return this;
    }

    public PulsarSinkBuilder<IN> setProperties(Properties properties) {
        this.configBuilder.set(properties);
        return this;
    }

    public PulsarSink<IN> build() {
        DeliveryGuarantee deliveryGuarantee = this.configBuilder.get(PulsarSinkOptions.PULSAR_WRITE_DELIVERY_GUARANTEE);
        if (deliveryGuarantee == DeliveryGuarantee.NONE) {
            LOG.warn("You haven't set delivery guarantee or set it to NONE, this would cause data loss. Make sure you have known this shortcoming.");
        } else if (deliveryGuarantee == DeliveryGuarantee.EXACTLY_ONCE) {
            LOG.info("Exactly once require flink checkpoint and your pulsar cluster should support the transaction.");
            this.configBuilder.override(PulsarOptions.PULSAR_ENABLE_TRANSACTION, true);
            this.configBuilder.override(PulsarSinkOptions.PULSAR_SEND_TIMEOUT_MS, 0L);
            if (!this.configBuilder.contains(PulsarSinkOptions.PULSAR_WRITE_TRANSACTION_TIMEOUT)) {
                LOG.warn("The default pulsar transaction timeout is 3 hours, make sure it was greater than your checkpoint interval.");
            } else {
                Long timeout = this.configBuilder.get(PulsarSinkOptions.PULSAR_WRITE_TRANSACTION_TIMEOUT);
                LOG.warn("The configured transaction timeout is {} mille seconds, make sure it was greater than your checkpoint interval.", (Object)timeout);
            }
        }
        if (!this.configBuilder.contains(PulsarSinkOptions.PULSAR_PRODUCER_NAME)) {
            LOG.warn("We recommend set a readable producer name through setProducerName(String) in production mode.");
        }
        Preconditions.checkNotNull(this.serializationSchema, (String)"serializationSchema must be set.");
        if (this.serializationSchema instanceof PulsarSchemaWrapper && !Boolean.TRUE.equals(this.configBuilder.get(PulsarSinkOptions.PULSAR_WRITE_SCHEMA_EVOLUTION))) {
            LOG.info("It seems like you want to send message in Pulsar Schema. You can enableSchemaEvolution for using this feature. We would use Schema.BYTES as the default schema if you don't enable this option.");
        }
        if (this.topicRegister == null) {
            if (this.topicRouter == null) {
                throw new NullPointerException("No topic names or custom topic router are provided.");
            }
            LOG.warn("No topic set has been provided, make sure your custom topic router support empty topic set.");
            this.topicRegister = new EmptyTopicRegister();
        }
        if (this.topicRoutingMode == null) {
            LOG.info("No topic routing mode has been chosen. We use round-robin mode as default.");
            this.topicRoutingMode = TopicRoutingMode.ROUND_ROBIN;
        }
        if (this.messageDelayer == null) {
            this.messageDelayer = MessageDelayer.never();
        }
        if (this.cryptoKeyReader != null) {
            Preconditions.checkArgument((!this.encryptionKeys.isEmpty() ? 1 : 0) != 0, (Object)"You should provide at least on encryption key.");
            this.configBuilder.set(PulsarSinkOptions.PULSAR_ENCRYPTION_KEYS, this.encryptionKeys);
        }
        SinkConfiguration sinkConfiguration = this.configBuilder.build(PulsarSinkConfigUtils.SINK_CONFIG_VALIDATOR, SinkConfiguration::new);
        return new PulsarSink<IN>(sinkConfiguration, this.serializationSchema, this.topicRegister, this.topicRoutingMode, this.topicRouter, this.messageDelayer, this.cryptoKeyReader);
    }

    private <T extends IN> PulsarSinkBuilder<T> specialized() {
        return this;
    }
}

