/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.utils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.common.utils.PulsarExceptionUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.api.transaction.TransactionBuilder;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClientException;

@Internal
public final class PulsarTransactionUtils {
    private PulsarTransactionUtils() {
    }

    public static Transaction createTransaction(PulsarClient pulsarClient, long timeoutMs) {
        try {
            CompletableFuture future = ((TransactionBuilder)PulsarExceptionUtils.sneakyClient(() -> ((PulsarClient)pulsarClient).newTransaction())).withTransactionTimeout(timeoutMs, TimeUnit.MILLISECONDS).build();
            return (Transaction)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public static TransactionCoordinatorClientException unwrap(TransactionCoordinatorClientException e) {
        return ExceptionUtils.findThrowable((Throwable)e.getCause(), TransactionCoordinatorClientException.class).orElse(e);
    }
}

