/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.schema;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchema;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaTypeSerializer;

@Internal
public class PulsarSchemaTypeInformation<T>
extends TypeInformation<T> {
    private static final long serialVersionUID = 7284667318651333519L;
    private final PulsarSchema<T> schema;

    public PulsarSchemaTypeInformation(PulsarSchema<T> schema) {
        this.schema = schema;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.schema.getRecordClass();
    }

    public boolean isKeyType() {
        return false;
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        return new PulsarSchemaTypeSerializer<T>(this.schema);
    }

    public String toString() {
        return this.schema.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PulsarSchemaTypeInformation) {
            PulsarSchemaTypeInformation that = (PulsarSchemaTypeInformation)((Object)obj);
            return Objects.equals(this.schema, that.schema);
        }
        return false;
    }

    public int hashCode() {
        return this.schema.hashCode();
    }

    public boolean canEqual(Object obj) {
        return obj instanceof PulsarSchemaTypeInformation;
    }
}

