/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.schema;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ReflectionUtil;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

@Internal
public final class PulsarSchema<T>
implements Serializable {
    private static final long serialVersionUID = -2561088131419607555L;
    private transient Schema<T> schema;
    private transient SchemaInfo schemaInfo;

    public PulsarSchema(Schema<T> schema) {
        SchemaInfo info = schema.getSchemaInfo();
        SchemaType type = info.getType();
        Preconditions.checkArgument((type != SchemaType.JSON ? 1 : 0) != 0, (Object)"Json Schema should provide the type class");
        Preconditions.checkArgument((type != SchemaType.AVRO ? 1 : 0) != 0, (Object)"Avro Schema should provide the type class");
        Preconditions.checkArgument((type != SchemaType.PROTOBUF ? 1 : 0) != 0, (Object)"Protobuf Schema should provide the type class");
        Preconditions.checkArgument((type != SchemaType.PROTOBUF_NATIVE ? 1 : 0) != 0, (Object)"Protobuf Native Schema should provide the type class");
        Preconditions.checkArgument((type != SchemaType.KEY_VALUE ? 1 : 0) != 0, (Object)"Key Value Schema should provide the type class of key and value");
        Class typeClass = ReflectionUtil.getTemplateType1(schema.getClass());
        this.schemaInfo = PulsarSchemaUtils.encodeClassInfo(info, typeClass);
        this.schema = PulsarSchemaUtils.createSchema(this.schemaInfo);
    }

    public PulsarSchema(Schema<T> schema, Class<T> typeClass) {
        SchemaInfo info = schema.getSchemaInfo();
        Preconditions.checkArgument((info.getType() != SchemaType.KEY_VALUE ? 1 : 0) != 0, (Object)"Key Value Schema should provide the type classes of key and value");
        this.validateSchemaInfo(info);
        this.schemaInfo = PulsarSchemaUtils.encodeClassInfo(info, typeClass);
        this.schema = PulsarSchemaUtils.createSchema(this.schemaInfo);
    }

    public <K, V> PulsarSchema(Schema<KeyValue<K, V>> kvSchema, Class<K> keyClass, Class<V> valueClass) {
        SchemaInfo info = kvSchema.getSchemaInfo();
        Preconditions.checkArgument((info.getType() == SchemaType.KEY_VALUE ? 1 : 0) != 0, (Object)"This constructor could only be applied for KeyValueSchema");
        KeyValue infoKeyValue = KeyValueSchemaInfo.decodeKeyValueSchemaInfo((SchemaInfo)info);
        SchemaInfo infoKey = PulsarSchemaUtils.encodeClassInfo((SchemaInfo)infoKeyValue.getKey(), keyClass);
        this.validateSchemaInfo(infoKey);
        SchemaInfo infoValue = PulsarSchemaUtils.encodeClassInfo((SchemaInfo)infoKeyValue.getValue(), valueClass);
        this.validateSchemaInfo(infoValue);
        KeyValueEncodingType encodingType = KeyValueSchemaInfo.decodeKeyValueEncodingType((SchemaInfo)info);
        SchemaInfo encodedInfo = KeyValueSchemaInfo.encodeKeyValueSchemaInfo((String)info.getName(), (SchemaInfo)infoKey, (SchemaInfo)infoValue, (KeyValueEncodingType)encodingType);
        this.schemaInfo = PulsarSchemaUtils.encodeClassInfo(encodedInfo, KeyValue.class);
        this.schema = PulsarSchemaUtils.createSchema(this.schemaInfo);
    }

    public Schema<T> getPulsarSchema() {
        return this.schema;
    }

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public Class<T> getRecordClass() {
        return PulsarSchemaUtils.decodeClassInfo(this.schemaInfo);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.schemaInfo.getName());
        byte[] schemaBytes = this.schemaInfo.getSchema();
        oos.writeInt(schemaBytes.length);
        oos.write(schemaBytes);
        SchemaType type = this.schemaInfo.getType();
        oos.writeInt(type.getValue());
        Map properties = this.schemaInfo.getProperties();
        oos.writeInt(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            oos.writeUTF((String)entry.getKey());
            oos.writeUTF((String)entry.getValue());
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        String name = ois.readUTF();
        int byteLen = ois.readInt();
        byte[] schemaBytes = new byte[byteLen];
        int read = ois.read(schemaBytes);
        Preconditions.checkState((read == byteLen ? 1 : 0) != 0);
        int typeIdx = ois.readInt();
        SchemaType type = SchemaType.valueOf((int)typeIdx);
        int propSize = ois.readInt();
        HashMap<String, String> properties = new HashMap<String, String>(propSize);
        for (int i = 0; i < propSize; ++i) {
            properties.put(ois.readUTF(), ois.readUTF());
        }
        this.schemaInfo = new SchemaInfoImpl(name, schemaBytes, type, properties);
        this.schema = PulsarSchemaUtils.createSchema(this.schemaInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaInfo that = ((PulsarSchema)o).getPulsarSchema().getSchemaInfo();
        return Objects.equals(this.schemaInfo.getType(), that.getType()) && Arrays.equals(this.schemaInfo.getSchema(), that.getSchema()) && Objects.equals(this.schemaInfo.getProperties(), that.getProperties());
    }

    public int hashCode() {
        return Objects.hash(this.schemaInfo.getType(), Arrays.hashCode(this.schemaInfo.getSchema()), this.schemaInfo.getProperties());
    }

    public String toString() {
        return this.schemaInfo.toString();
    }

    private void validateSchemaInfo(SchemaInfo info) {
        SchemaType type = info.getType();
        if (type == SchemaType.PROTOBUF || type == SchemaType.PROTOBUF_NATIVE) {
            Preconditions.checkState((boolean)PulsarSchemaUtils.haveProtobuf(), (Object)"protobuf-java should be provided if you use related schema.");
        }
    }
}

