/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.apache.bookkeeper.test.ZooKeeperUtil;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZkUtils
extends TestCase {
    private static final Logger logger = LoggerFactory.getLogger(TestZkUtils.class);
    protected ZooKeeperUtil zkUtil = new ZooKeeperUtil();

    @Before
    public void setUp() throws Exception {
        logger.info("Setting up test {}.", (Object)this.getName());
        this.zkUtil.startCluster();
    }

    @After
    public void tearDown() throws Exception {
        this.zkUtil.killCluster();
        logger.info("Teared down test {}.", (Object)this.getName());
    }

    @Test
    public void testAsyncCreateAndDeleteFullPathOptimistic() throws IOException, KeeperException, InterruptedException {
        ZooKeeper zkc = new ZooKeeper(this.zkUtil.getZooKeeperConnectString(), 10000, null);
        String ledgerZnodePath = "/ledgers/000/000/000/001";
        ZkUtils.createFullPathOptimistic((ZooKeeper)zkc, (String)ledgerZnodePath, (byte[])"data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        TestZkUtils.assertTrue((String)(ledgerZnodePath + " zNode should exist"), (null != zkc.exists(ledgerZnodePath, false) ? 1 : 0) != 0);
        ledgerZnodePath = "/ledgers/000/000/000/002";
        ZkUtils.createFullPathOptimistic((ZooKeeper)zkc, (String)ledgerZnodePath, (byte[])"data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        TestZkUtils.assertTrue((String)(ledgerZnodePath + " zNode should exist"), (null != zkc.exists(ledgerZnodePath, false) ? 1 : 0) != 0);
        ZkUtils.deleteFullPathOptimistic((ZooKeeper)zkc, (String)ledgerZnodePath, (int)-1);
        TestZkUtils.assertTrue((String)(ledgerZnodePath + " zNode should not exist, since it is deleted"), (null == zkc.exists(ledgerZnodePath, false) ? 1 : 0) != 0);
        ledgerZnodePath = "/ledgers/000/000/000/001";
        TestZkUtils.assertTrue((String)(ledgerZnodePath + " zNode should exist"), (null != zkc.exists(ledgerZnodePath, false) ? 1 : 0) != 0);
        ZkUtils.deleteFullPathOptimistic((ZooKeeper)zkc, (String)ledgerZnodePath, (int)-1);
        TestZkUtils.assertTrue((String)(ledgerZnodePath + " zNode should not exist, since it is deleted"), (null == zkc.exists(ledgerZnodePath, false) ? 1 : 0) != 0);
        TestZkUtils.assertTrue((String)"/ledgers/000 zNode should not exist, since it should be deleted recursively", (null == zkc.exists(ledgerZnodePath, false) ? 1 : 0) != 0);
    }
}

