/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.component;

import java.io.IOException;
import java.util.List;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Test;

public class TestServerLifecycleComponent {
    @Test
    public void testNewComponent() throws Exception {
        BookieConfiguration conf = new BookieConfiguration(new ServerConfiguration());
        NullStatsLogger statsLogger = NullStatsLogger.INSTANCE;
        ServerLifecycleComponent component = ServerLifecycleComponent.newComponent(TestComponent.class, (BookieConfiguration)conf, (StatsLogger)statsLogger);
        Assert.assertEquals((Object)"test-component", (Object)component.getName());
        Assert.assertEquals((Object)conf, (Object)component.getConf());
    }

    @Test
    public void testLoadServerComponents() throws Exception {
        BookieConfiguration conf = new BookieConfiguration(new ServerConfiguration());
        NullStatsLogger statsLogger = NullStatsLogger.INSTANCE;
        String[] clsNames = new String[]{TestComponent.class.getName(), TestComponent2.class.getName()};
        List components = ServerLifecycleComponent.loadServerComponents((String[])clsNames, (BookieConfiguration)conf, (StatsLogger)statsLogger);
        Assert.assertEquals((long)2L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof TestComponent));
        Assert.assertTrue((boolean)(components.get(1) instanceof TestComponent2));
    }

    static class TestComponent2
    extends TestComponent {
        public TestComponent2(BookieConfiguration conf, StatsLogger statsLogger) {
            super(conf, statsLogger);
        }
    }

    static class TestComponent
    extends ServerLifecycleComponent {
        public TestComponent(BookieConfiguration conf, StatsLogger statsLogger) {
            super("test-component", conf, statsLogger);
        }

        protected void doStart() {
        }

        protected void doStop() {
        }

        protected void doClose() throws IOException {
        }
    }
}

