/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.MockLedgerData;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.util.ByteBufList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockBookies {
    static final Logger LOG = LoggerFactory.getLogger(MockBookies.class);
    final ConcurrentHashMap<BookieId, ConcurrentHashMap<Long, MockLedgerData>> data = new ConcurrentHashMap();

    public void seedLedgerForBookie(BookieId bookieId, long ledgerId, LedgerMetadata metadata) throws Exception {
        this.seedLedgerBase(ledgerId, metadata, (bookie, entry) -> bookie.equals((Object)bookieId));
    }

    public void seedLedger(long ledgerId, LedgerMetadata metadata) throws Exception {
        this.seedLedgerBase(ledgerId, metadata, (bookie, entry) -> true);
    }

    public void seedLedgerBase(long ledgerId, LedgerMetadata metadata, BiPredicate<BookieId, Long> shouldSeed) throws Exception {
        RoundRobinDistributionSchedule schedule = new RoundRobinDistributionSchedule(metadata.getWriteQuorumSize(), metadata.getAckQuorumSize(), metadata.getEnsembleSize());
        long lastEntry = metadata.isClosed() ? metadata.getLastEntryId() : (Long)metadata.getAllEnsembles().lastEntry().getKey() - 1L;
        long lac = -1L;
        long e = 0L;
        while (e <= lastEntry) {
            List ensemble = metadata.getEnsembleAt(e);
            DistributionSchedule.WriteSet ws = schedule.getWriteSet(e);
            for (int i = 0; i < ws.size(); ++i) {
                BookieId bookieId = (BookieId)ensemble.get(ws.get(i));
                if (!shouldSeed.test(bookieId, e)) continue;
                this.seedEntries(bookieId, ledgerId, e, lac);
            }
            lac = e++;
        }
    }

    public void seedEntries(BookieId bookieId, long ledgerId, long entryId, long lac) throws Exception {
        ByteBuf entry = this.generateEntry(ledgerId, entryId, lac);
        MockLedgerData ledger = this.getBookieData(bookieId).computeIfAbsent(ledgerId, MockLedgerData::new);
        ledger.addEntry(entryId, entry);
    }

    public ByteBuf generateEntry(long ledgerId, long entryId, long lac) throws Exception {
        DigestManager digestManager = DigestManager.instantiate((long)ledgerId, (byte[])new byte[0], (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32C, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)false);
        return ByteBufList.coalesce((ByteBufList)((ByteBufList)digestManager.computeDigestAndPackageForSending(entryId, lac, 0L, Unpooled.buffer((int)10), new byte[20], 0)));
    }

    public void addEntry(BookieId bookieId, long ledgerId, long entryId, ByteBuf entry) throws BKException {
        MockLedgerData ledger = this.getBookieData(bookieId).computeIfAbsent(ledgerId, MockLedgerData::new);
        if (ledger.isFenced()) {
            throw new BKException.BKLedgerFencedException();
        }
        ledger.addEntry(entryId, entry);
    }

    public void recoveryAddEntry(BookieId bookieId, long ledgerId, long entryId, ByteBuf entry) throws BKException {
        MockLedgerData ledger = this.getBookieData(bookieId).computeIfAbsent(ledgerId, MockLedgerData::new);
        ledger.addEntry(entryId, entry);
    }

    public ByteBuf readEntry(BookieId bookieId, int flags, long ledgerId, long entryId) throws BKException {
        ByteBuf entry;
        MockLedgerData ledger = this.getBookieData(bookieId).get(ledgerId);
        if (ledger == null) {
            LOG.warn("[{};L{}] ledger not found", (Object)bookieId, (Object)ledgerId);
            throw new BKException.BKNoSuchLedgerExistsException();
        }
        if ((flags & 1) == 1) {
            ledger.fence();
        }
        if ((entry = ledger.getEntry(entryId)) == null) {
            LOG.warn("[{};L{}] entry({}) not found", new Object[]{bookieId, ledgerId, entryId});
            throw new BKException.BKNoSuchEntryException();
        }
        return entry;
    }

    public ByteBufList batchReadEntries(BookieId bookieId, int flags, long ledgerId, long startEntryId, int maxCount, long maxSize) throws BKException {
        MockLedgerData ledger = this.getBookieData(bookieId).get(ledgerId);
        if (ledger == null) {
            LOG.warn("[{};L{}] ledger not found", (Object)bookieId, (Object)ledgerId);
            throw new BKException.BKNoSuchLedgerExistsException();
        }
        if ((flags & 1) == 1) {
            ledger.fence();
        }
        ByteBufList data = null;
        if (maxCount <= 0) {
            maxCount = Integer.MAX_VALUE;
        }
        long frameSize = 36L;
        for (long i = startEntryId; i < startEntryId + (long)maxCount; ++i) {
            ByteBuf entry = ledger.getEntry(i);
            frameSize += (long)(entry.readableBytes() + 4);
            if (data == null) {
                data = ByteBufList.get((ByteBuf)entry);
                continue;
            }
            if (frameSize > maxSize) {
                entry.release();
                break;
            }
            data.add(entry);
        }
        return data;
    }

    public ConcurrentHashMap<Long, MockLedgerData> getBookieData(BookieId bookieId) {
        return this.data.computeIfAbsent(bookieId, key -> new ConcurrentHashMap());
    }
}

