/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta.zk;

import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public abstract class ZKMetadataDriverTestBase {
    protected AbstractConfiguration<?> conf;
    protected String ledgersRootPath;
    protected String metadataServiceUri;
    protected ZooKeeperClient.Builder mockZkBuilder;
    protected ZooKeeperClient mockZkc;
    protected MockedStatic<ZooKeeperClient> zooKeeperClientMockedStatic;

    public void setup(AbstractConfiguration<?> conf) throws Exception {
        this.ledgersRootPath = "/path/to/ledgers";
        this.metadataServiceUri = "zk://127.0.0.1" + this.ledgersRootPath;
        this.conf = conf;
        conf.setMetadataServiceUri(this.metadataServiceUri);
        this.mockZkBuilder = (ZooKeeperClient.Builder)Mockito.mock(ZooKeeperClient.Builder.class);
        Mockito.when((Object)this.mockZkBuilder.connectString((String)ArgumentMatchers.eq((Object)"127.0.0.1"))).thenReturn((Object)this.mockZkBuilder);
        Mockito.when((Object)this.mockZkBuilder.sessionTimeoutMs(ArgumentMatchers.anyInt())).thenReturn((Object)this.mockZkBuilder);
        Mockito.when((Object)this.mockZkBuilder.operationRetryPolicy((RetryPolicy)ArgumentMatchers.any(RetryPolicy.class))).thenReturn((Object)this.mockZkBuilder);
        Mockito.when((Object)this.mockZkBuilder.requestRateLimit(ArgumentMatchers.anyDouble())).thenReturn((Object)this.mockZkBuilder);
        Mockito.when((Object)this.mockZkBuilder.statsLogger((StatsLogger)ArgumentMatchers.any(StatsLogger.class))).thenReturn((Object)this.mockZkBuilder);
        this.mockZkc = (ZooKeeperClient)Mockito.mock(ZooKeeperClient.class);
        Mockito.when((Object)this.mockZkc.exists(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)false))).thenReturn(null);
        Mockito.when((Object)this.mockZkBuilder.build()).thenReturn((Object)this.mockZkc);
        this.zooKeeperClientMockedStatic = Mockito.mockStatic(ZooKeeperClient.class);
        this.zooKeeperClientMockedStatic.when(() -> ZooKeeperClient.newBuilder()).thenReturn((Object)this.mockZkBuilder);
    }

    public void teardown() {
        this.zooKeeperClientMockedStatic.close();
    }
}

