/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta.zk;

import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.discover.ZKRegistrationManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataBookieDriver;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverTestBase;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ZKMetadataBookieDriverTest
extends ZKMetadataDriverTestBase {
    private ZKMetadataBookieDriver driver;
    private ServerConfiguration conf;

    @Before
    public void setup() throws Exception {
        this.conf = new ServerConfiguration();
        super.setup((AbstractConfiguration<?>)this.conf);
        this.driver = (ZKMetadataBookieDriver)Mockito.spy((Object)new ZKMetadataBookieDriver());
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
        this.driver.close();
    }

    @Test
    public void testGetRegManager() throws Exception {
        this.driver.initialize(this.conf, (StatsLogger)NullStatsLogger.INSTANCE);
        Assert.assertSame((Object)this.conf, (Object)this.driver.serverConf);
        ZKRegistrationManager mockRegManager = (ZKRegistrationManager)Mockito.mock(ZKRegistrationManager.class);
        ((ZKMetadataBookieDriver)Mockito.doReturn((Object)mockRegManager).when((Object)this.driver)).newZKRegistrationManager((ServerConfiguration)ArgumentMatchers.any(ServerConfiguration.class), (ZooKeeper)ArgumentMatchers.any(ZooKeeper.class));
        try (RegistrationManager manager = this.driver.createRegistrationManager();){
            Assert.assertSame((Object)mockRegManager, (Object)manager);
            ((ZKMetadataBookieDriver)Mockito.verify((Object)this.driver, (VerificationMode)Mockito.times((int)1))).newZKRegistrationManager((ServerConfiguration)ArgumentMatchers.same((Object)this.conf), (ZooKeeper)ArgumentMatchers.same((Object)this.mockZkc));
        }
    }
}

