/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.conf;

import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestServerConfiguration {
    private final ServerConfiguration serverConf = new ServerConfiguration();

    @Before
    public void setup() throws Exception {
        this.serverConf.loadConf(this.getClass().getClassLoader().getResource("bk_server.conf"));
    }

    @Test
    public void testEphemeralPortsAllowed() throws ConfigurationException {
        ServerConfiguration conf = new ServerConfiguration();
        conf.setAllowEphemeralPorts(true);
        conf.setBookiePort(0);
        conf.validate();
        Assert.assertTrue((boolean)true);
    }

    @Test(expected=ConfigurationException.class)
    public void testEphemeralPortsDisallowed() throws ConfigurationException {
        ServerConfiguration conf = new ServerConfiguration();
        conf.setAllowEphemeralPorts(false);
        conf.setBookiePort(0);
        conf.validate();
    }

    @Test
    public void testSetExtraServerComponents() {
        ServerConfiguration conf = new ServerConfiguration();
        Assert.assertNull((Object)conf.getExtraServerComponents());
        Object[] components = new String[]{"test1", "test2", "test3"};
        conf.setExtraServerComponents((String[])components);
        Assert.assertArrayEquals((Object[])components, (Object[])conf.getExtraServerComponents());
    }

    @Test
    public void testGetExtraServerComponents() {
        Object[] components = new String[]{"test1", "test2", "test3"};
        Assert.assertArrayEquals((Object[])components, (Object[])this.serverConf.getExtraServerComponents());
    }

    @Test(expected=ConfigurationException.class)
    public void testMismatchofJournalAndFileInfoVersionsOlderJournalVersion() throws ConfigurationException {
        ServerConfiguration conf = new ServerConfiguration();
        conf.setJournalFormatVersionToWrite(5);
        conf.setFileInfoFormatVersionToWrite(1);
        conf.validate();
    }

    @Test(expected=ConfigurationException.class)
    public void testMismatchofJournalAndFileInfoVersionsOlderFileInfoVersion() throws ConfigurationException {
        ServerConfiguration conf = new ServerConfiguration();
        conf.setJournalFormatVersionToWrite(6);
        conf.setFileInfoFormatVersionToWrite(0);
        conf.validate();
    }

    @Test
    public void testValidityOfJournalAndFileInfoVersions() throws ConfigurationException {
        ServerConfiguration conf = new ServerConfiguration();
        conf.setJournalFormatVersionToWrite(5);
        conf.setFileInfoFormatVersionToWrite(0);
        conf.validate();
        conf = new ServerConfiguration();
        conf.setJournalFormatVersionToWrite(6);
        conf.setFileInfoFormatVersionToWrite(1);
        conf.validate();
    }

    @Test
    public void testEntryLogSizeLimit() throws ConfigurationException {
        ServerConfiguration conf = new ServerConfiguration();
        try {
            conf.setEntryLogSizeLimit(-1L);
            Assert.fail((String)"should fail setEntryLogSizeLimit since `logSizeLimit` is too small");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            conf.setProperty("logSizeLimit", (Object)"-1");
            conf.validate();
            Assert.fail((String)"Invalid configuration since `logSizeLimit` is too small");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        try {
            conf.setEntryLogSizeLimit(Integer.MAX_VALUE);
            Assert.fail((String)"Should fail setEntryLogSizeLimit size `logSizeLimit` is too large");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            conf.validate();
            Assert.fail((String)"Invalid configuration since `logSizeLimit` is too large");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        conf.setEntryLogSizeLimit(0x20000000L);
        conf.validate();
        Assert.assertEquals((long)0x20000000L, (long)conf.getEntryLogSizeLimit());
        conf.setEntryLogSizeLimit(0x40000000L);
        conf.validate();
        Assert.assertEquals((long)0x40000000L, (long)conf.getEntryLogSizeLimit());
    }

    @Test
    public void testCompactionSettings() throws ConfigurationException {
        ServerConfiguration conf = new ServerConfiguration();
        long major = conf.getMajorCompactionMaxTimeMillis();
        long minor = conf.getMinorCompactionMaxTimeMillis();
        Assert.assertEquals((long)-1L, (long)major);
        Assert.assertEquals((long)-1L, (long)minor);
        conf.setMajorCompactionMaxTimeMillis(500L).setMinorCompactionMaxTimeMillis(250L);
        major = conf.getMajorCompactionMaxTimeMillis();
        minor = conf.getMinorCompactionMaxTimeMillis();
        Assert.assertEquals((long)500L, (long)major);
        Assert.assertEquals((long)250L, (long)minor);
        conf.setMinorCompactionMaxTimeMillis(150L).setMajorCompactionMaxTimeMillis(1500L);
        major = conf.getMajorCompactionMaxTimeMillis();
        minor = conf.getMinorCompactionMaxTimeMillis();
        Assert.assertEquals((long)1500L, (long)major);
        Assert.assertEquals((long)150L, (long)minor);
        major = conf.getMajorCompactionInterval();
        minor = conf.getMinorCompactionInterval();
        Assert.assertEquals((long)3600L, (long)minor);
        Assert.assertEquals((long)86400L, (long)major);
        conf.setMajorCompactionInterval(43200L).setMinorCompactionInterval(1800L);
        major = conf.getMajorCompactionInterval();
        minor = conf.getMinorCompactionInterval();
        Assert.assertEquals((long)1800L, (long)minor);
        Assert.assertEquals((long)43200L, (long)major);
        conf.setMinorCompactionInterval(900L).setMajorCompactionInterval(21700L);
        major = conf.getMajorCompactionInterval();
        minor = conf.getMinorCompactionInterval();
        Assert.assertEquals((long)900L, (long)minor);
        Assert.assertEquals((long)21700L, (long)major);
        conf.setMinorCompactionInterval(500L);
        try {
            conf.validate();
            Assert.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        conf.setMinorCompactionInterval(600L);
        conf.validate();
        conf.setMajorCompactionInterval(550L);
        try {
            conf.validate();
            Assert.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        conf.setMajorCompactionInterval(600L);
        conf.validate();
        double majorThreshold = conf.getMajorCompactionThreshold();
        double minorThreshold = conf.getMinorCompactionThreshold();
        Assert.assertEquals((double)0.8, (double)majorThreshold, (double)1.0E-5);
        Assert.assertEquals((double)0.2, (double)minorThreshold, (double)1.0E-5);
        conf.setMajorCompactionThreshold(0.7).setMinorCompactionThreshold(0.1);
        majorThreshold = conf.getMajorCompactionThreshold();
        minorThreshold = conf.getMinorCompactionThreshold();
        Assert.assertEquals((double)0.7, (double)majorThreshold, (double)1.0E-5);
        Assert.assertEquals((double)0.1, (double)minorThreshold, (double)1.0E-5);
        conf.setMinorCompactionThreshold(0.3).setMajorCompactionThreshold(0.6);
        majorThreshold = conf.getMajorCompactionThreshold();
        minorThreshold = conf.getMinorCompactionThreshold();
        Assert.assertEquals((double)0.6, (double)majorThreshold, (double)1.0E-5);
        Assert.assertEquals((double)0.3, (double)minorThreshold, (double)1.0E-5);
        long entryLocationCompactionInterval = conf.getEntryLocationCompactionInterval();
        Assert.assertEquals((long)-1L, (long)entryLocationCompactionInterval);
        conf.setEntryLocationCompactionInterval(3600L);
        entryLocationCompactionInterval = conf.getEntryLocationCompactionInterval();
        Assert.assertEquals((long)3600L, (long)entryLocationCompactionInterval);
        conf.setEntryLocationCompactionInterval(550L);
        try {
            conf.validate();
            Assert.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        conf.setEntryLocationCompactionInterval(650L);
        conf.validate();
    }
}

