/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.storage.EntryLogIds;
import org.apache.bookkeeper.bookie.storage.EntryLogTestUtils;
import org.apache.bookkeeper.bookie.storage.MockEntryLogIds;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectEntryLogger;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectReader;
import org.apache.bookkeeper.bookie.storage.directentrylogger.Header;
import org.apache.bookkeeper.bookie.storage.directentrylogger.LogReader;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.bookkeeper.common.util.nativeio.NativeIOImpl;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.bookkeeper.slogger.Slogger;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TmpDirs;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDirectEntryLogger {
    private static final Logger log = LoggerFactory.getLogger(TestDirectEntryLogger.class);
    private final Slogger slog = Slogger.CONSOLE;
    private static final long ledgerId1 = 1234L;
    private final TmpDirs tmpDirs = new TmpDirs();

    @After
    public void cleanup() throws Exception {
        this.tmpDirs.cleanup();
    }

    @Test
    public void testLogRolling() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("logRolling", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        ByteBuf e1 = EntryLogTestUtils.makeEntry(1234L, 1L, 4000);
        ByteBuf e2 = EntryLogTestUtils.makeEntry(1234L, 2L, 4000);
        ByteBuf e3 = EntryLogTestUtils.makeEntry(1234L, 3L, 4000);
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 9000L, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            long loc1 = elog.addEntry(1234L, e1.slice());
            int logId1 = EntryLogTestUtils.logIdFromLocation(loc1);
            MatcherAssert.assertThat((Object)logId1, (Matcher)Matchers.equalTo((Object)1));
            long loc2 = elog.addEntry(1234L, e2.slice());
            int logId2 = EntryLogTestUtils.logIdFromLocation(loc2);
            MatcherAssert.assertThat((Object)logId2, (Matcher)Matchers.equalTo((Object)2));
            long loc3 = elog.addEntry(1234L, e3.slice());
            int logId3 = EntryLogTestUtils.logIdFromLocation(loc3);
            MatcherAssert.assertThat((Object)logId3, (Matcher)Matchers.equalTo((Object)3));
        }
    }

    @Test
    public void testReadLog() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("logRolling", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        ByteBuf e1 = EntryLogTestUtils.makeEntry(1234L, 1L, 100);
        ByteBuf e2 = EntryLogTestUtils.makeEntry(1234L, 2L, 100);
        ByteBuf e3 = EntryLogTestUtils.makeEntry(1234L, 3L, 100);
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 200000L, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            long loc1 = elog.addEntry(1234L, e1.slice());
            long loc2 = elog.addEntry(1234L, e2.slice());
            elog.flush();
            ByteBuf e1read = elog.readEntry(1234L, 1L, loc1);
            ByteBuf e2read = elog.readEntry(1234L, 2L, loc2);
            EntryLogTestUtils.assertEntryEquals(e1read, e1);
            EntryLogTestUtils.assertEntryEquals(e2read, e2);
            ReferenceCountUtil.release((Object)e1read);
            ReferenceCountUtil.release((Object)e2read);
            long loc3 = elog.addEntry(1234L, e3.slice());
            elog.flush();
            ByteBuf e3read = elog.readEntry(1234L, 3L, loc3);
            EntryLogTestUtils.assertEntryEquals(e3read, e3);
            ReferenceCountUtil.release((Object)e3read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogReaderCleanup() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("logRolling", "ledgers");
        final File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        int entrySize = 4096;
        int maxFileSize = Header.EMPTY_HEADER.length + 4096;
        int maxCachedReaders = 16;
        final AtomicInteger outstandingReaders = new AtomicInteger(0);
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), maxFileSize, 0xA00000, 0x100000L, 16 * maxFileSize, maxFileSize, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE){

            LogReader newDirectReader(int logId) throws IOException {
                outstandingReaders.incrementAndGet();
                return new DirectReader(logId, 1.logFilename((File)curDir, (int)logId), ByteBufAllocator.DEFAULT, (NativeIO)new NativeIOImpl(), 4096, 0xA00000, NullStatsLogger.INSTANCE.getOpStatsLogger("")){

                    public void close() throws IOException {
                        super.close();
                        outstandingReaders.decrementAndGet();
                    }
                };
            }
        };){
            ArrayList<Long> locations = new ArrayList<Long>();
            for (int i = 0; i < 17; ++i) {
                ByteBuf e = EntryLogTestUtils.makeEntry(1234L, i, 4096);
                long loc = elog.addEntry(1234L, e.slice());
                locations.add(loc);
            }
            elog.flush();
            for (Long loc : locations) {
                ReferenceCountUtil.release((Object)elog.readEntry(loc.longValue()));
            }
            MatcherAssert.assertThat((Object)outstandingReaders.get(), (Matcher)Matchers.equalTo((Object)16));
        }
        MatcherAssert.assertThat((Object)outstandingReaders.get(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testReadMetadataAndScan() throws Exception {
        long loc3;
        long loc2;
        long loc1;
        File ledgerDir = this.tmpDirs.createNew("directCanReadAndScanMeta", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        long ledgerId1 = 1L;
        long ledgerId2 = 2L;
        ByteBuf e1 = EntryLogTestUtils.makeEntry(ledgerId1, 1L, 1000);
        ByteBuf e2 = EntryLogTestUtils.makeEntry(ledgerId2, 2L, 2000);
        ByteBuf e3 = EntryLogTestUtils.makeEntry(ledgerId1, 3L, 3000);
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 131072L, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            loc1 = elog.addEntry(ledgerId1, e1);
            loc2 = elog.addEntry(ledgerId2, e2);
            loc3 = elog.addEntry(ledgerId1, e3);
        }
        elog = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 131072L, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);
        var17_9 = null;
        try {
            int logId = EntryLogTestUtils.logIdFromLocation(loc1);
            MatcherAssert.assertThat((Object)logId, (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc2)));
            MatcherAssert.assertThat((Object)logId, (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc3)));
            EntryLogMetadata metaRead = elog.readEntryLogIndex((long)logId);
            MatcherAssert.assertThat((Object)metaRead.getEntryLogId(), (Matcher)Matchers.equalTo((Object)logId));
            MatcherAssert.assertThat((Object)metaRead.getTotalSize(), (Matcher)Matchers.equalTo((Object)6012L));
            MatcherAssert.assertThat((Object)metaRead.getRemainingSize(), (Matcher)Matchers.equalTo((Object)metaRead.getTotalSize()));
            MatcherAssert.assertThat((Object)metaRead.getLedgersMap().get(ledgerId1), (Matcher)Matchers.equalTo((Object)4008L));
            MatcherAssert.assertThat((Object)metaRead.getLedgersMap().get(ledgerId2), (Matcher)Matchers.equalTo((Object)2004L));
            EntryLogMetadata metaScan = elog.scanEntryLogMetadata((long)logId, null);
            MatcherAssert.assertThat((Object)metaScan.getEntryLogId(), (Matcher)Matchers.equalTo((Object)logId));
            MatcherAssert.assertThat((Object)metaScan.getTotalSize(), (Matcher)Matchers.equalTo((Object)6012L));
            MatcherAssert.assertThat((Object)metaScan.getRemainingSize(), (Matcher)Matchers.equalTo((Object)metaScan.getTotalSize()));
            MatcherAssert.assertThat((Object)metaScan.getLedgersMap().get(ledgerId1), (Matcher)Matchers.equalTo((Object)4008L));
            MatcherAssert.assertThat((Object)metaScan.getLedgersMap().get(ledgerId2), (Matcher)Matchers.equalTo((Object)2004L));
        }
        catch (Throwable throwable) {
            var17_9 = throwable;
            throw throwable;
        }
        finally {
            if (elog != null) {
                if (var17_9 != null) {
                    try {
                        elog.close();
                    }
                    catch (Throwable throwable) {
                        var17_9.addSuppressed(throwable);
                    }
                } else {
                    elog.close();
                }
            }
        }
    }

    @Test
    public void testMetadataFallback() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("directMetaFallback", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        long ledgerId1 = 1L;
        long ledgerId2 = 2L;
        ByteBuf e1 = EntryLogTestUtils.makeEntry(ledgerId1, 1L, 1000);
        ByteBuf e2 = EntryLogTestUtils.makeEntry(ledgerId2, 2L, 2000);
        ByteBuf e3 = EntryLogTestUtils.makeEntry(ledgerId1, 3L, 3000);
        int maxFileSize = 10108;
        try (DirectEntryLogger writer = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 131072L, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            long loc1 = writer.addEntry(ledgerId1, e1);
            long loc2 = writer.addEntry(ledgerId2, e2);
            long loc3 = writer.addEntry(ledgerId1, e3);
            writer.flush();
            try (DirectEntryLogger reader = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 131072L, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
                int logId = EntryLogTestUtils.logIdFromLocation(loc1);
                try {
                    reader.readEntryLogIndex((long)logId);
                    Assert.fail((String)"Shouldn't be there");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                EntryLogMetadata metaRead = reader.getEntryLogMetadata((long)logId);
                MatcherAssert.assertThat((Object)metaRead.getEntryLogId(), (Matcher)Matchers.equalTo((Object)logId));
                MatcherAssert.assertThat((Object)metaRead.getTotalSize(), (Matcher)Matchers.equalTo((Object)6012L));
                MatcherAssert.assertThat((Object)metaRead.getRemainingSize(), (Matcher)Matchers.equalTo((Object)metaRead.getTotalSize()));
                MatcherAssert.assertThat((Object)metaRead.getLedgersMap().get(ledgerId1), (Matcher)Matchers.equalTo((Object)4008L));
                MatcherAssert.assertThat((Object)metaRead.getLedgersMap().get(ledgerId2), (Matcher)Matchers.equalTo((Object)2004L));
            }
        }
    }

    @Test
    public void testMetadataManyBatch() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("directMetaManyBatches", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        long lastLoc = -1L;
        int ledgerCount = 11000;
        try (DirectEntryLogger writer = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 0x2000000L, 0xA00000, 0x2000000L, 0x2000000L, 0x1000000, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            for (int i = 0; i < ledgerCount; ++i) {
                long loc = writer.addEntry((long)i, EntryLogTestUtils.makeEntry(i, 1L, 1000));
                if (lastLoc >= 0L) {
                    MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc), (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(lastLoc)));
                }
                lastLoc = loc;
            }
            writer.flush();
        }
        var7_6 = null;
        try (DirectEntryLogger reader = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 0x200000L, 0xA00000, 0x2000000L, 0x2000000L, 0x1000000, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            int logId = EntryLogTestUtils.logIdFromLocation(lastLoc);
            EntryLogMetadata metaRead = reader.readEntryLogIndex((long)logId);
            MatcherAssert.assertThat((Object)metaRead.getEntryLogId(), (Matcher)Matchers.equalTo((Object)logId));
            MatcherAssert.assertThat((Object)metaRead.getTotalSize(), (Matcher)Matchers.equalTo((Object)(1004L * (long)ledgerCount)));
            MatcherAssert.assertThat((Object)metaRead.getRemainingSize(), (Matcher)Matchers.equalTo((Object)metaRead.getTotalSize()));
            for (int i = 0; i < ledgerCount; ++i) {
                MatcherAssert.assertThat((Object)metaRead.getLedgersMap().containsKey((long)i), (Matcher)Matchers.equalTo((Object)true));
            }
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFlushedLogs() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("testFlushedLogs", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        ExecutorService executor = Executors.newFixedThreadPool(5);
        final CompletableFuture<Object> blockClose = new CompletableFuture<Object>();
        NativeIOImpl nativeIO = new NativeIOImpl(){

            public int close(int fd) {
                try {
                    blockClose.join();
                    return super.close(fd);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        DirectEntryLogger entryLogger = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)nativeIO, ByteBufAllocator.DEFAULT, executor, executor, 23000L, 0xA00000, 0x100000L, 0x100000L, 32768, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);
        try {
            long loc1 = entryLogger.addEntry(1L, EntryLogTestUtils.makeEntry(1L, 1L, 5000));
            long loc2 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, 1L, 5000));
            MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc2), (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc1)));
            long loc3 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, 1L, 15000));
            MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc3), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(EntryLogTestUtils.logIdFromLocation(loc2))));
            long loc4 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, 1L, 15000));
            MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc4), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(EntryLogTestUtils.logIdFromLocation(loc3))));
            long loc5 = entryLogger.addEntry(3L, EntryLogTestUtils.makeEntry(3L, 1L, 1000));
            MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc5), (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc4)));
            long logId1 = EntryLogTestUtils.logIdFromLocation(loc2);
            long logId2 = EntryLogTestUtils.logIdFromLocation(loc3);
            long logId3 = EntryLogTestUtils.logIdFromLocation(loc5);
            MatcherAssert.assertThat((Object)entryLogger.logExists(logId1), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)entryLogger.logExists(logId2), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)entryLogger.logExists(logId3), (Matcher)Matchers.equalTo((Object)true));
            MatcherAssert.assertThat((Object)entryLogger.getFlushedLogIds(), (Matcher)Matchers.empty());
            blockClose.complete(null);
            entryLogger.flush();
            MatcherAssert.assertThat((Object)entryLogger.getFlushedLogIds(), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{logId1, logId2}));
            long loc6 = entryLogger.addEntry(3L, EntryLogTestUtils.makeEntry(3L, 1L, 25000));
            MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc6), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(EntryLogTestUtils.logIdFromLocation(loc5))));
            entryLogger.flush();
            MatcherAssert.assertThat((Object)entryLogger.getFlushedLogIds(), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{logId1, logId2, logId3}));
        }
        finally {
            blockClose.complete(null);
            entryLogger.close();
            executor.shutdownNow();
        }
    }

    @Test
    public void testBufferSizeNotPageAligned() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("logRolling", "ledgers");
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        ByteBuf e1 = EntryLogTestUtils.makeEntry(1234L, 1L, 4000);
        ByteBuf e2 = EntryLogTestUtils.makeEntry(1234L, 2L, 4000);
        ByteBuf e3 = EntryLogTestUtils.makeEntry(1234L, 3L, 4000);
        try (DirectEntryLogger elog = new DirectEntryLogger(curDir, (EntryLogIds)new MockEntryLogIds(), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), 9000L, 0xA00000, 131572L, 131372L, 65536, 1, 300, this.slog, (StatsLogger)NullStatsLogger.INSTANCE);){
            long loc1 = elog.addEntry(1234L, e1.slice());
            int logId1 = EntryLogTestUtils.logIdFromLocation(loc1);
            MatcherAssert.assertThat((Object)logId1, (Matcher)Matchers.equalTo((Object)1));
            long loc2 = elog.addEntry(1234L, e2.slice());
            int logId2 = EntryLogTestUtils.logIdFromLocation(loc2);
            MatcherAssert.assertThat((Object)logId2, (Matcher)Matchers.equalTo((Object)2));
            long loc3 = elog.addEntry(1234L, e3.slice());
            int logId3 = EntryLogTestUtils.logIdFromLocation(loc3);
            MatcherAssert.assertThat((Object)logId3, (Matcher)Matchers.equalTo((Object)3));
        }
    }
}

