/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import org.apache.bookkeeper.bookie.DefaultEntryLogger;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.storage.EntryLogIds;
import org.apache.bookkeeper.bookie.storage.EntryLogger;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectEntryLogger;
import org.apache.bookkeeper.bookie.storage.directentrylogger.EntryLogIdsImpl;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.bookkeeper.common.util.nativeio.NativeIOImpl;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.bookkeeper.slogger.Slogger;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.DiskChecker;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class EntryLogTestUtils {
    private static final Slogger slog = Slogger.CONSOLE;

    public static LedgerDirsManager newDirsManager(File ... ledgerDir) throws Exception {
        return new LedgerDirsManager(new ServerConfiguration(), ledgerDir, new DiskChecker(0.999f, 0.999f));
    }

    public static EntryLogger newLegacyEntryLogger(int logSizeLimit, File ... ledgerDir) throws Exception {
        ServerConfiguration conf = new ServerConfiguration();
        conf.setEntryLogSizeLimit((long)logSizeLimit);
        return new DefaultEntryLogger(conf, EntryLogTestUtils.newDirsManager(ledgerDir), null, (StatsLogger)NullStatsLogger.INSTANCE, ByteBufAllocator.DEFAULT);
    }

    public static DirectEntryLogger newDirectEntryLogger(int logSizeLimit, File ledgerDir) throws Exception {
        File curDir = new File(ledgerDir, "current");
        curDir.mkdirs();
        return new DirectEntryLogger(curDir, (EntryLogIds)new EntryLogIdsImpl(EntryLogTestUtils.newDirsManager(ledgerDir), slog), (NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, (ExecutorService)MoreExecutors.newDirectExecutorService(), (ExecutorService)MoreExecutors.newDirectExecutorService(), (long)logSizeLimit, 0xA00000, 0x100000L, 0x100000L, 65536, 1, 300, slog, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    public static int logIdFromLocation(long location) {
        return (int)(location >> 32);
    }

    public static ByteBuf makeEntry(long ledgerId, long entryId, int size) {
        return EntryLogTestUtils.makeEntry(ledgerId, entryId, size, (byte)-35);
    }

    public static ByteBuf makeEntry(long ledgerId, long entryId, int size, byte pattern) {
        ByteBuf buf = Unpooled.buffer((int)size);
        buf.writeLong(ledgerId).writeLong(entryId);
        byte[] data = new byte[buf.writableBytes()];
        Arrays.fill(data, pattern);
        buf.writeBytes(data);
        return buf;
    }

    public static void assertEntryEquals(ByteBuf e1, ByteBuf e2) throws Exception {
        MatcherAssert.assertThat((Object)e1.readableBytes(), (Matcher)Matchers.equalTo((Object)e2.readableBytes()));
        MatcherAssert.assertThat((Object)e1, (Matcher)Matchers.equalTo((Object)e2));
    }
}

