/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.versioning;

import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.junit.Assert;
import org.junit.Test;

public class TestLongVersion {
    @Test
    public void testNullIntVersion() {
        LongVersion longVersion = new LongVersion(99L);
        try {
            longVersion.compare(null);
            Assert.fail((String)"Should fail comparing with null version.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidVersion() {
        LongVersion longVersion = new LongVersion(99L);
        try {
            longVersion.compare(v -> Version.Occurred.AFTER);
            Assert.fail((String)"Should not reach here!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCompare() {
        LongVersion iv = new LongVersion(99L);
        Assert.assertEquals((Object)Version.Occurred.AFTER, (Object)iv.compare((Version)new LongVersion(98L)));
        Assert.assertEquals((Object)Version.Occurred.BEFORE, (Object)iv.compare((Version)new LongVersion(100L)));
        Assert.assertEquals((Object)Version.Occurred.CONCURRENTLY, (Object)iv.compare((Version)new LongVersion(99L)));
        Assert.assertEquals((Object)Version.Occurred.CONCURRENTLY, (Object)iv.compare(Version.ANY));
        Assert.assertEquals((Object)Version.Occurred.AFTER, (Object)iv.compare(Version.NEW));
    }
}

