/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.bookkeeper.util.SubTreeCache;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SubTreeCacheTest {
    TestTreeProvider tree = new TestTreeProvider();
    SubTreeCache cache = new SubTreeCache((SubTreeCache.TreeProvider)this.tree);

    TestWatch setWatch() {
        TestWatch watch = new TestWatch();
        this.cache.registerWatcher((Watcher)watch);
        return watch;
    }

    void assertFired(TestWatch watch) {
        Assert.assertTrue((boolean)watch.getFired());
    }

    void assertNotFired(TestWatch watch) {
        Assert.assertFalse((boolean)watch.getFired());
    }

    TestWatchGuard setWatchWithGuard() {
        TestWatchGuard watch = new TestWatchGuard();
        watch.setGuard(this.cache.registerWatcherWithGuard((Watcher)watch));
        return watch;
    }

    void readAssertChildren(String path, String[] children) throws KeeperException, InterruptedException {
        TreeSet<String> shouldBe = new TreeSet<String>(Arrays.asList(children));
        List returned = this.cache.getChildren(path);
        TreeSet is = new TreeSet(returned);
        returned.clear();
        Assert.assertEquals(shouldBe, is);
    }

    @Before
    public void setUp() throws Exception {
        String[] preCreate;
        for (String path : preCreate = new String[]{"/a", "/a/a", "/a/a/a", "/a/a/b", "/a/b", "/a/c", "/b", "/b/a"}) {
            this.tree.createNode(path);
        }
    }

    @Test
    public void testNoUpdate() throws Exception {
        TestWatch watch = this.setWatch();
        this.readAssertChildren("/a/a", new String[]{"a", "b"});
        this.assertNotFired(watch);
    }

    @Test
    public void testSingleCreate() throws Exception {
        TestWatch watch = this.setWatch();
        this.readAssertChildren("/a/a", new String[]{"a", "b"});
        this.tree.createNode("/a/a/c");
        this.assertFired(watch);
    }

    @Test
    public void testSingleRemoval() throws Exception {
        TestWatch watch = this.setWatch();
        this.readAssertChildren("/a/a", new String[]{"a", "b"});
        this.tree.removeNode("/a/a/b");
        this.assertFired(watch);
    }

    @Test
    public void testCancelation() throws Exception {
        TestWatch watch = this.setWatch();
        this.readAssertChildren("/a/a", new String[]{"a", "b"});
        this.cache.cancelWatcher((Watcher)watch);
        this.tree.createNode("/a/a/c");
        this.assertNotFired(watch);
    }

    @Test
    public void testGuardCancelation() throws Exception {
        TestWatchGuard watch;
        try (TestWatchGuard guard = this.setWatchWithGuard();){
            this.readAssertChildren("/a/a", new String[]{"a", "b"});
            watch = guard;
        }
        this.tree.createNode("/a/a/c");
        this.assertNotFired(watch);
    }

    @Test
    public void testGuardCancelationExceptional() throws Exception {
        TestWatchGuard watch = null;
        try (TestWatchGuard guard = this.setWatchWithGuard();){
            watch = guard;
            this.readAssertChildren("/z/a", new String[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tree.createNode("/a/a/c");
        this.assertNotFired(watch);
    }

    @Test
    public void testDuplicateWatch() throws Exception {
        try (TestWatchGuard watch = this.setWatchWithGuard();){
            this.readAssertChildren("/a/a", new String[]{"a", "b"});
        }
        watch = this.setWatchWithGuard();
        var2_2 = null;
        try {
            this.readAssertChildren("/a/a", new String[]{"a", "b"});
            this.assertNotFired(watch);
            this.tree.createNode("/a/a/e");
            this.assertFired(watch);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (watch != null) {
                if (var2_2 != null) {
                    try {
                        watch.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    watch.close();
                }
            }
        }
    }

    @Test(expected=KeeperException.NoNodeException.class)
    public void testNoNode() throws Exception {
        try (TestWatchGuard watch = this.setWatchWithGuard();){
            this.readAssertChildren("/z/a", new String[0]);
        }
    }

    @Test
    public void testRemoveEmptyNode() throws Exception {
        try (TestWatchGuard watch = this.setWatchWithGuard();){
            this.readAssertChildren("/a/a/a", new String[0]);
            this.tree.removeNode("/a/a/a");
            this.assertFired(watch);
        }
    }

    @Test
    public void doubleWatch() throws Exception {
        try (TestWatchGuard watch1 = this.setWatchWithGuard();){
            this.readAssertChildren("/a/a", new String[]{"a", "b"});
            try (TestWatchGuard watch2 = this.setWatchWithGuard();){
                this.tree.createNode("/a/a/e");
                this.assertFired(watch1);
                this.readAssertChildren("/a/b", new String[0]);
                this.tree.createNode("/a/b/e");
                this.assertFired(watch2);
            }
        }
    }

    @Test
    public void sequentialWatch() throws Exception {
        try (TestWatchGuard watch = this.setWatchWithGuard();){
            this.readAssertChildren("/a/a", new String[]{"a", "b"});
            this.tree.removeNode("/a/a/a");
            this.assertFired(watch);
        }
        watch = this.setWatchWithGuard();
        var2_2 = null;
        try {
            this.readAssertChildren("/a/a", new String[]{"b"});
            this.tree.removeNode("/a/a/b");
            this.assertFired(watch);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (watch != null) {
                if (var2_2 != null) {
                    try {
                        watch.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    watch.close();
                }
            }
        }
    }

    class TestWatchGuard
    extends TestWatch
    implements AutoCloseable {
        SubTreeCache.WatchGuard guard;

        TestWatchGuard() {
        }

        void setGuard(SubTreeCache.WatchGuard guard) {
            this.guard = guard;
        }

        @Override
        public void close() throws Exception {
            this.guard.close();
        }
    }

    class TestWatch
    implements Watcher {
        boolean fired = false;

        TestWatch() {
        }

        public void process(WatchedEvent event) {
            this.fired = true;
        }

        public boolean getFired() {
            return this.fired;
        }
    }

    class TestTreeProvider
    implements SubTreeCache.TreeProvider {
        final Node root = new Node();

        TestTreeProvider() {
        }

        Node getNode(String path) throws KeeperException {
            String[] pathSegments = path.split("/");
            Node cur = this.root;
            for (String segment : pathSegments) {
                if (segment.length() == 0) continue;
                if (cur.children.containsKey(segment)) {
                    cur = cur.children.get(segment);
                    continue;
                }
                throw KeeperException.create((KeeperException.Code)KeeperException.Code.NONODE);
            }
            return cur;
        }

        public List<String> getChildren(String path, Watcher watcher) throws InterruptedException, KeeperException {
            Node node = this.getNode(path);
            Assert.assertTrue((null == node.watcher ? 1 : 0) != 0);
            node.watcher = watcher;
            return new ArrayList<String>(node.children.keySet());
        }

        public void createNode(String path) throws KeeperException {
            String[] segments = path.split("/");
            if (segments.length == 0) {
                throw KeeperException.create((KeeperException.Code)KeeperException.Code.NONODE);
            }
            String child = segments[segments.length - 1];
            CharSequence[] parentSegments = Arrays.copyOfRange(segments, 0, segments.length - 1);
            Node parent = this.getNode(String.join((CharSequence)"/", parentSegments));
            if (parent.children.containsKey(child)) {
                throw KeeperException.create((KeeperException.Code)KeeperException.Code.NODEEXISTS);
            }
            parent.children.put(child, new Node());
            if (null != parent.watcher) {
                parent.watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, path));
                parent.watcher = null;
            }
        }

        public void removeNode(String path) throws KeeperException {
            String[] segments = path.split("/");
            if (segments.length == 0) {
                throw KeeperException.create((KeeperException.Code)KeeperException.Code.NONODE);
            }
            String child = segments[segments.length - 1];
            CharSequence[] parentSegments = Arrays.copyOfRange(segments, 0, segments.length - 1);
            String parentPath = String.join((CharSequence)"/", parentSegments);
            Node parent = this.getNode(parentPath);
            if (!parent.children.containsKey(child)) {
                throw KeeperException.create((KeeperException.Code)KeeperException.Code.NONODE);
            }
            Node cNode = parent.children.get(child);
            if (!cNode.children.isEmpty()) {
                throw KeeperException.create((KeeperException.Code)KeeperException.Code.NOTEMPTY);
            }
            if (null != cNode.watcher) {
                cNode.watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, path));
                cNode.watcher = null;
            }
            if (null != parent.watcher) {
                parent.watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, parentPath));
                parent.watcher = null;
            }
            parent.children.remove(child);
        }

        class Node {
            Watcher watcher = null;
            public Map<String, Node> children = new HashMap<String, Node>();

            Node() {
            }
        }
    }
}

