/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LedgerCreateDeleteTest
extends BookKeeperClusterTestCase {
    public LedgerCreateDeleteTest() {
        super(1);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.baseConf.setOpenFileLimit(1);
        super.setUp();
    }

    @Test
    public void testCreateDeleteLedgers() throws Exception {
        int j;
        int numLedgers = 3;
        ArrayList<Long> ledgers = new ArrayList<Long>();
        for (int i = 0; i < numLedgers; ++i) {
            LedgerHandle lh = this.bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, "bk is cool".getBytes());
            for (j = 0; j < 5; ++j) {
                lh.addEntry("just test".getBytes());
            }
            ledgers.add(lh.getId());
            lh.close();
        }
        Iterator i = ledgers.iterator();
        while (i.hasNext()) {
            long ledgerId = (Long)i.next();
            this.bkc.deleteLedger(ledgerId);
        }
        ledgers.clear();
        Thread.sleep(this.baseConf.getGcWaitTime() * 2L);
        for (int i2 = 0; i2 < numLedgers; ++i2) {
            LedgerHandle lh = this.bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, "bk is cool".getBytes());
            for (j = 0; j < 5; ++j) {
                lh.addEntry("just test".getBytes());
            }
            ledgers.add(lh.getId());
            lh.close();
        }
    }

    @Test
    public void testCreateLedgerWithBKNotEnoughBookiesException() throws Exception {
        try {
            this.bkc.createLedger(2, 2, BookKeeper.DigestType.CRC32, "bk is cool".getBytes());
            Assert.fail((String)"Should be able to throw BKNotEnoughBookiesException");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateLedgerWithZKException() throws Exception {
        this.stopZKCluster();
        try {
            this.bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, "bk is cool".getBytes());
            Assert.fail((String)"Should be able to throw ZKException");
        }
        catch (BKException.ZKException zKException) {
            // empty catch block
        }
    }
}

