/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server;

import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.util.Collections;
import java.util.function.Supplier;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieResources;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.LegacyCookieValidation;
import org.apache.bookkeeper.bookie.UncleanShutdownDetection;
import org.apache.bookkeeper.bookie.UncleanShutdownDetectionImpl;
import org.apache.bookkeeper.common.allocator.ByteBufAllocatorWithOomHandler;
import org.apache.bookkeeper.common.component.LifecycleComponentStack;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.NullMetadataBookieDriver;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.server.EmbeddedServer;
import org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.util.DiskChecker;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestEmbeddedServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildBookieServer() throws Exception {
        MockedStatic bookieResourcesMockedStatic = Mockito.mockStatic(BookieResources.class, (Answer)Mockito.CALLS_REAL_METHODS);
        try {
            bookieResourcesMockedStatic.when(() -> BookieResources.createMetadataDriver((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()))).thenReturn((Object)new NullMetadataBookieDriver());
            bookieResourcesMockedStatic.when(() -> BookieResources.createAllocator((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()))).thenReturn(Mockito.mock(ByteBufAllocatorWithOomHandler.class));
            ServerConfiguration serverConf = new ServerConfiguration().setAllowLoopback(true).setAutoRecoveryDaemonEnabled(false).setHttpServerEnabled(false).setExtraServerComponents(new String[]{TestComponent.class.getName()});
            BookieConfiguration conf = new BookieConfiguration(serverConf);
            MockedStatic legacyCookieValidationMockedStatic = Mockito.mockStatic(LegacyCookieValidation.class);
            try {
                legacyCookieValidationMockedStatic.when(() -> LegacyCookieValidation.newLegacyCookieValidation((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (RegistrationManager)((RegistrationManager)ArgumentMatchers.any()))).thenReturn(Mockito.mock(LegacyCookieValidation.class));
                MockedStatic bookieMockedStatic = Mockito.mockStatic(BookieImpl.class, (Answer)Mockito.CALLS_REAL_METHODS);
                try {
                    bookieMockedStatic.when(() -> BookieImpl.newBookieImpl((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (RegistrationManager)((RegistrationManager)ArgumentMatchers.any()), (LedgerStorage)((LedgerStorage)ArgumentMatchers.any()), (DiskChecker)((DiskChecker)ArgumentMatchers.any()), (LedgerDirsManager)((LedgerDirsManager)ArgumentMatchers.any()), (LedgerDirsManager)((LedgerDirsManager)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()), (ByteBufAllocator)((ByteBufAllocator)ArgumentMatchers.any()), (Supplier)((Supplier)ArgumentMatchers.any()))).thenReturn(Mockito.mock(BookieImpl.class));
                    BookieServer mockServer = (BookieServer)Mockito.mock(BookieServer.class);
                    BookieSocketAddress bookieAddress = new BookieSocketAddress("127.0.0.1", 1281);
                    Mockito.when((Object)mockServer.getLocalAddress()).thenReturn((Object)bookieAddress);
                    MockedStatic bookieServerMockedStatic = Mockito.mockStatic(BookieServer.class);
                    try {
                        bookieServerMockedStatic.when(() -> BookieServer.newBookieServer((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (Bookie)((Bookie)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()), (ByteBufAllocator)((ByteBufAllocator)ArgumentMatchers.any()), (UncleanShutdownDetection)((UncleanShutdownDetection)ArgumentMatchers.any()))).thenReturn((Object)mockServer);
                        EmbeddedServer server = EmbeddedServer.builder((BookieConfiguration)conf).build();
                        LifecycleComponentStack stack = server.getLifecycleComponentStack();
                        Assert.assertEquals((long)7L, (long)stack.getNumComponents());
                        Assert.assertTrue((boolean)(stack.getComponent(6) instanceof TestComponent));
                        stack.start();
                        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).start();
                        stack.stop();
                        stack.close();
                        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).shutdown();
                    }
                    finally {
                        if (Collections.singletonList(bookieServerMockedStatic).get(0) != null) {
                            bookieServerMockedStatic.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(bookieMockedStatic).get(0) != null) {
                        bookieMockedStatic.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(legacyCookieValidationMockedStatic).get(0) != null) {
                    legacyCookieValidationMockedStatic.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(bookieResourcesMockedStatic).get(0) != null) {
                bookieResourcesMockedStatic.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildBookieServerCustomComponents() throws Exception {
        ServerConfiguration serverConf = new ServerConfiguration().setAllowLoopback(true).setAutoRecoveryDaemonEnabled(false).setHttpServerEnabled(false).setExtraServerComponents(new String[]{TestComponent.class.getName()});
        BookieConfiguration conf = new BookieConfiguration(serverConf);
        NullStatsProvider statsProvider = new NullStatsProvider();
        StatsLogger rootStatsLogger = statsProvider.getStatsLogger("");
        NullMetadataBookieDriver.NullRegistrationManager registrationManager = new NullMetadataBookieDriver.NullRegistrationManager();
        NullMetadataBookieDriver.NullLedgerManagerFactory ledgerManagerFactory = new NullMetadataBookieDriver.NullLedgerManagerFactory();
        DiskChecker diskChecker = BookieResources.createDiskChecker((ServerConfiguration)serverConf);
        LedgerDirsManager ledgerDirsManager = BookieResources.createLedgerDirsManager((ServerConfiguration)conf.getServerConf(), (DiskChecker)diskChecker, (StatsLogger)rootStatsLogger.scope("ledger"));
        LedgerDirsManager indexDirsManager = BookieResources.createIndexDirsManager((ServerConfiguration)conf.getServerConf(), (DiskChecker)diskChecker, (StatsLogger)rootStatsLogger.scope("index"), (LedgerDirsManager)ledgerDirsManager);
        UncleanShutdownDetectionImpl uncleanShutdownDetection = new UncleanShutdownDetectionImpl(ledgerDirsManager);
        ByteBufAllocatorWithOomHandler byteBufFromResources = (ByteBufAllocatorWithOomHandler)Mockito.mock(ByteBufAllocatorWithOomHandler.class);
        ByteBufAllocatorWithOomHandler byteBuf = (ByteBufAllocatorWithOomHandler)Mockito.mock(ByteBufAllocatorWithOomHandler.class);
        MockedStatic bookieResourcesMockedStatic = Mockito.mockStatic(BookieResources.class);
        try {
            bookieResourcesMockedStatic.when(() -> BookieResources.createMetadataDriver((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()))).thenReturn((Object)new NullMetadataBookieDriver());
            bookieResourcesMockedStatic.when(() -> BookieResources.createAllocator((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()))).thenReturn((Object)byteBufFromResources);
            MockedStatic legacyCookieValidationMockedStatic = Mockito.mockStatic(LegacyCookieValidation.class);
            try {
                legacyCookieValidationMockedStatic.when(() -> LegacyCookieValidation.newLegacyCookieValidation((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (RegistrationManager)((RegistrationManager)ArgumentMatchers.any()))).thenReturn(Mockito.mock(LegacyCookieValidation.class));
                MockedStatic bookieMockedStatic = Mockito.mockStatic(BookieImpl.class, (Answer)Mockito.CALLS_REAL_METHODS);
                try {
                    bookieMockedStatic.when(() -> BookieImpl.newBookieImpl((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (RegistrationManager)((RegistrationManager)ArgumentMatchers.any()), (LedgerStorage)((LedgerStorage)ArgumentMatchers.any()), (DiskChecker)((DiskChecker)ArgumentMatchers.any()), (LedgerDirsManager)((LedgerDirsManager)ArgumentMatchers.any()), (LedgerDirsManager)((LedgerDirsManager)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()), (ByteBufAllocator)((ByteBufAllocator)ArgumentMatchers.any()), (Supplier)((Supplier)ArgumentMatchers.any()))).thenReturn(Mockito.mock(BookieImpl.class));
                    BookieServer mockServer = (BookieServer)Mockito.mock(BookieServer.class);
                    MockedStatic bookieServerMockedStatic = Mockito.mockStatic(BookieServer.class);
                    try {
                        bookieServerMockedStatic.when(() -> BookieServer.newBookieServer((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (Bookie)((Bookie)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()), (ByteBufAllocator)((ByteBufAllocator)ArgumentMatchers.any()), (UncleanShutdownDetection)((UncleanShutdownDetection)ArgumentMatchers.any()))).thenReturn((Object)mockServer);
                        BookieSocketAddress bookieAddress = new BookieSocketAddress("127.0.0.1", 1281);
                        Mockito.when((Object)mockServer.getLocalAddress()).thenReturn((Object)bookieAddress);
                        EmbeddedServer server = EmbeddedServer.builder((BookieConfiguration)conf).statsProvider((StatsProvider)statsProvider).registrationManager((RegistrationManager)registrationManager).ledgerManagerFactory((LedgerManagerFactory)ledgerManagerFactory).diskChecker(diskChecker).ledgerDirsManager(ledgerDirsManager).indexDirsManager(indexDirsManager).allocator((ByteBufAllocator)byteBuf).uncleanShutdownDetection((UncleanShutdownDetection)uncleanShutdownDetection).build();
                        Assert.assertSame((Object)statsProvider, (Object)server.getStatsProvider());
                        Assert.assertSame((Object)registrationManager, (Object)server.getRegistrationManager());
                        Assert.assertSame((Object)ledgerManagerFactory, (Object)server.getLedgerManagerFactory());
                        Assert.assertSame((Object)diskChecker, (Object)server.getDiskChecker());
                        Assert.assertSame((Object)ledgerDirsManager, (Object)server.getLedgerDirsManager());
                        Assert.assertSame((Object)indexDirsManager, (Object)server.getIndexDirsManager());
                        LifecycleComponentStack stack = server.getLifecycleComponentStack();
                        Assert.assertEquals((long)3L, (long)stack.getNumComponents());
                        Assert.assertTrue((boolean)(stack.getComponent(2) instanceof TestComponent));
                        stack.start();
                        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).start();
                        stack.stop();
                        stack.close();
                        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).shutdown();
                    }
                    finally {
                        if (Collections.singletonList(bookieServerMockedStatic).get(0) != null) {
                            bookieServerMockedStatic.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(bookieMockedStatic).get(0) != null) {
                        bookieMockedStatic.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(legacyCookieValidationMockedStatic).get(0) != null) {
                    legacyCookieValidationMockedStatic.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(bookieResourcesMockedStatic).get(0) != null) {
                bookieResourcesMockedStatic.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIgnoreExtraServerComponentsStartupFailures() throws Exception {
        MockedStatic bookieResourcesMockedStatic = Mockito.mockStatic(BookieResources.class, (Answer)Mockito.CALLS_REAL_METHODS);
        try {
            bookieResourcesMockedStatic.when(() -> BookieResources.createMetadataDriver((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()))).thenReturn((Object)new NullMetadataBookieDriver());
            ServerConfiguration serverConf = new ServerConfiguration().setAllowLoopback(true).setAutoRecoveryDaemonEnabled(false).setHttpServerEnabled(false).setExtraServerComponents(new String[]{"bad-server-component"}).setIgnoreExtraServerComponentsStartupFailures(true);
            BookieConfiguration conf = new BookieConfiguration(serverConf);
            MockedStatic legacyCookieValidationMockedStatic = Mockito.mockStatic(LegacyCookieValidation.class);
            try {
                legacyCookieValidationMockedStatic.when(() -> LegacyCookieValidation.newLegacyCookieValidation((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (RegistrationManager)((RegistrationManager)ArgumentMatchers.any()))).thenReturn(Mockito.mock(LegacyCookieValidation.class));
                MockedStatic bookieMockedStatic = Mockito.mockStatic(BookieImpl.class, (Answer)Mockito.CALLS_REAL_METHODS);
                try {
                    bookieMockedStatic.when(() -> BookieImpl.newBookieImpl((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (RegistrationManager)((RegistrationManager)ArgumentMatchers.any()), (LedgerStorage)((LedgerStorage)ArgumentMatchers.any()), (DiskChecker)((DiskChecker)ArgumentMatchers.any()), (LedgerDirsManager)((LedgerDirsManager)ArgumentMatchers.any()), (LedgerDirsManager)((LedgerDirsManager)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()), (ByteBufAllocator)((ByteBufAllocator)ArgumentMatchers.any()), (Supplier)((Supplier)ArgumentMatchers.any()))).thenReturn(Mockito.mock(BookieImpl.class));
                    BookieServer mockServer = (BookieServer)Mockito.mock(BookieServer.class);
                    MockedStatic bookieServerMockedStatic = Mockito.mockStatic(BookieServer.class);
                    try {
                        bookieServerMockedStatic.when(() -> BookieServer.newBookieServer((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (Bookie)((Bookie)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()), (ByteBufAllocator)((ByteBufAllocator)ArgumentMatchers.any()), (UncleanShutdownDetection)((UncleanShutdownDetection)ArgumentMatchers.any()))).thenReturn((Object)mockServer);
                        BookieSocketAddress bookieAddress = new BookieSocketAddress("127.0.0.1", 1281);
                        Mockito.when((Object)mockServer.getLocalAddress()).thenReturn((Object)bookieAddress);
                        LifecycleComponentStack stack = EmbeddedServer.builder((BookieConfiguration)conf).build().getLifecycleComponentStack();
                        Assert.assertEquals((long)6L, (long)stack.getNumComponents());
                        stack.start();
                        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).start();
                        stack.stop();
                        stack.close();
                        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).shutdown();
                    }
                    finally {
                        if (Collections.singletonList(bookieServerMockedStatic).get(0) != null) {
                            bookieServerMockedStatic.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(bookieMockedStatic).get(0) != null) {
                        bookieMockedStatic.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(legacyCookieValidationMockedStatic).get(0) != null) {
                    legacyCookieValidationMockedStatic.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(bookieResourcesMockedStatic).get(0) != null) {
                bookieResourcesMockedStatic.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExtraServerComponentsStartupFailures() throws Exception {
        MockedStatic bookieResourcesMockedStatic = Mockito.mockStatic(BookieResources.class, (Answer)Mockito.CALLS_REAL_METHODS);
        try {
            bookieResourcesMockedStatic.when(() -> BookieResources.createMetadataDriver((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()))).thenReturn((Object)new NullMetadataBookieDriver());
            ServerConfiguration serverConf = new ServerConfiguration().setAllowLoopback(true).setAutoRecoveryDaemonEnabled(false).setHttpServerEnabled(false).setExtraServerComponents(new String[]{"bad-server-component"}).setIgnoreExtraServerComponentsStartupFailures(false);
            BookieConfiguration conf = new BookieConfiguration(serverConf);
            MockedStatic legacyCookieValidationMockedStatic = Mockito.mockStatic(LegacyCookieValidation.class);
            try {
                legacyCookieValidationMockedStatic.when(() -> LegacyCookieValidation.newLegacyCookieValidation((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (RegistrationManager)((RegistrationManager)ArgumentMatchers.any()))).thenReturn(Mockito.mock(LegacyCookieValidation.class));
                MockedStatic bookieMockedStatic = Mockito.mockStatic(BookieImpl.class, (Answer)Mockito.CALLS_REAL_METHODS);
                try {
                    bookieMockedStatic.when(() -> BookieImpl.newBookieImpl((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (RegistrationManager)((RegistrationManager)ArgumentMatchers.any()), (LedgerStorage)((LedgerStorage)ArgumentMatchers.any()), (DiskChecker)((DiskChecker)ArgumentMatchers.any()), (LedgerDirsManager)((LedgerDirsManager)ArgumentMatchers.any()), (LedgerDirsManager)((LedgerDirsManager)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()), (ByteBufAllocator)((ByteBufAllocator)ArgumentMatchers.any()), (Supplier)((Supplier)ArgumentMatchers.any()))).thenReturn(Mockito.mock(BookieImpl.class));
                    BookieServer mockServer = (BookieServer)Mockito.mock(BookieServer.class);
                    MockedStatic bookieServerMockedStatic = Mockito.mockStatic(BookieServer.class);
                    try {
                        bookieServerMockedStatic.when(() -> BookieServer.newBookieServer((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (Bookie)((Bookie)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()), (ByteBufAllocator)((ByteBufAllocator)ArgumentMatchers.any()), (UncleanShutdownDetection)((UncleanShutdownDetection)ArgumentMatchers.any()))).thenReturn((Object)mockServer);
                        try {
                            EmbeddedServer.builder((BookieConfiguration)conf).build().getLifecycleComponentStack();
                            Assert.fail((String)"Should fail to start bookie server if `ignoreExtraServerComponentsStartupFailures` is set to false");
                        }
                        catch (RuntimeException re) {
                            Assert.assertTrue((boolean)(re.getCause() instanceof ClassNotFoundException));
                        }
                    }
                    finally {
                        if (Collections.singletonList(bookieServerMockedStatic).get(0) != null) {
                            bookieServerMockedStatic.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(bookieMockedStatic).get(0) != null) {
                        bookieMockedStatic.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(legacyCookieValidationMockedStatic).get(0) != null) {
                    legacyCookieValidationMockedStatic.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(bookieResourcesMockedStatic).get(0) != null) {
                bookieResourcesMockedStatic.close();
            }
        }
    }

    static class TestComponent
    extends ServerLifecycleComponent {
        public TestComponent(BookieConfiguration conf, StatsLogger statsLogger) {
            super("test-component", conf, statsLogger);
        }

        protected void doStart() {
        }

        protected void doStop() {
        }

        protected void doClose() throws IOException {
        }
    }
}

