/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.net;

import java.util.UUID;
import org.apache.bookkeeper.net.BookieId;
import org.junit.Assert;
import org.junit.Test;

public class BookieIdTest {
    @Test
    public void testToString() {
        Assert.assertEquals((Object)"test", (Object)BookieId.parse((String)"test").toString());
    }

    @Test
    public void testParse() {
        Assert.assertEquals((Object)"test", (Object)BookieId.parse((String)"test").getId());
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)BookieId.parse((String)"test"), (Object)BookieId.parse((String)"test"));
        Assert.assertNotEquals((Object)BookieId.parse((String)"test"), (Object)BookieId.parse((String)"test2"));
    }

    @Test
    public void testHashcode() {
        Assert.assertEquals((long)BookieId.parse((String)"test").hashCode(), (long)BookieId.parse((String)"test").hashCode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidate1() {
        BookieId.parse((String)"non valid");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidate2() {
        BookieId.parse((String)"non$valid");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidateReservedWord() {
        BookieId.parse((String)"readonly");
    }

    @Test
    public void testValidateHostnamePort() {
        BookieId.parse((String)"this.is.an.hostname:1234");
    }

    @Test
    public void testValidateIPv4Port() {
        BookieId.parse((String)"1.2.3.4:1234");
    }

    @Test
    public void testValidateUUID() {
        BookieId.parse((String)UUID.randomUUID().toString());
    }

    @Test
    public void testWithDashAndUnderscore() {
        BookieId.parse((String)"testRegisterUnregister_ReadonlyBookie-readonly:3181");
    }
}

