/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.discover;

import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.discover.ZKRegistrationManager;
import org.apache.bookkeeper.test.ZooKeeperCluster;
import org.apache.bookkeeper.test.ZooKeeperUtil;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestZkRegistrationManager {
    private ZooKeeperCluster localZkServer;
    private ZooKeeper zkc;

    @Before
    public void setup() throws Exception {
        this.localZkServer = new ZooKeeperUtil();
        this.localZkServer.startCluster();
    }

    @After
    public void teardown() throws Exception {
        this.localZkServer.stopCluster();
    }

    @Test
    public void testPrepareFormat() throws Exception {
        try {
            ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
            conf.setMetadataServiceUri("zk+hierarchical://localhost:2181/test/ledgers");
            this.zkc = this.localZkServer.getZooKeeperClient();
            ZKRegistrationManager zkRegistrationManager = new ZKRegistrationManager(conf, this.zkc);
            zkRegistrationManager.prepareFormat();
            Assert.assertNotNull((Object)this.zkc.exists("/test/ledgers", false));
        }
        finally {
            if (this.zkc != null) {
                this.zkc.close();
            }
        }
    }
}

