/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerFragmentReplicator;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieClientImpl;
import org.apache.bookkeeper.proto.BookieProtoEncoding;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.proto.checksum.DummyDigestManager;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.zookeeper.AsyncCallback;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestLedgerFragmentReplicationWithMock {
    @Test
    public void testRecoverLedgerFragmentEntrySendRightRequestWithFlag() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        BookieClientImpl bookieClient = (BookieClientImpl)Mockito.mock(BookieClientImpl.class);
        ((BookieClientImpl)Mockito.doAnswer(invocationOnMock -> {
            ByteBuf toSend = (ByteBuf)invocationOnMock.getArgument(4);
            BookieProtoEncoding.RequestEnDeCoderPreV3 deCoderPreV3 = new BookieProtoEncoding.RequestEnDeCoderPreV3(null);
            toSend.readerIndex(4);
            BookieProtocol.ParsedAddRequest request = (BookieProtocol.ParsedAddRequest)deCoderPreV3.decode(toSend);
            Field flagField = request.getClass().getSuperclass().getDeclaredField("flags");
            flagField.setAccessible(true);
            short flag = flagField.getShort(request);
            Assert.assertEquals((long)flag, (long)2L);
            latch.countDown();
            return null;
        }).when((Object)bookieClient)).addEntry((BookieId)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ReferenceCounted)ArgumentMatchers.any(), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.any(), ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), (EnumSet)ArgumentMatchers.any());
        BookKeeper bkc = (BookKeeper)Mockito.mock(BookKeeper.class);
        Mockito.when((Object)bkc.getBookieClient()).thenReturn((Object)bookieClient);
        LedgerHandle lh = (LedgerHandle)Mockito.mock(LedgerHandle.class);
        DummyDigestManager ds = new DummyDigestManager(1L, true, ByteBufAllocator.DEFAULT);
        Mockito.when((Object)lh.getDigestManager()).thenReturn((Object)ds);
        Mockito.when((Object)lh.getLedgerKey()).thenReturn((Object)DigestManager.generateMasterKey((byte[])"".getBytes()));
        ByteBuf data = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        LedgerEntry entry = new LedgerEntry(LedgerEntryImpl.create((long)1L, (long)1L, (long)data.readableBytes(), (ByteBuf)data));
        LinkedList<LedgerEntry> list = new LinkedList<LedgerEntry>();
        list.add(entry);
        Enumeration entries = IteratorUtils.asEnumeration(list.iterator());
        ((LedgerHandle)Mockito.doAnswer(invocation -> {
            AsyncCallback.ReadCallback rc = (AsyncCallback.ReadCallback)invocation.getArgument(2, AsyncCallback.ReadCallback.class);
            rc.readComplete(0, lh, entries, null);
            return null;
        }).when((Object)lh)).asyncReadEntries(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (AsyncCallback.ReadCallback)ArgumentMatchers.any(), ArgumentMatchers.any());
        ClientConfiguration conf = new ClientConfiguration();
        LedgerFragmentReplicator lfr = new LedgerFragmentReplicator(bkc, conf);
        HashSet<BookieId> bookies = new HashSet<BookieId>();
        bookies.add(BookieId.parse((String)"127.0.0.1:3181"));
        AsyncCallback.VoidCallback vc = new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
            }
        };
        lfr.recoverLedgerFragmentEntry(Long.valueOf(1L), lh, vc, bookies, (lid, le) -> {});
        latch.await();
    }
}

