/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BatchedReadOp;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBatchedRead
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestBatchedRead.class);
    final BookKeeper.DigestType digestType;
    final byte[] passwd = "sequence-read".getBytes();

    public TestBatchedRead() {
        super(6);
        this.baseClientConf.setUseV2WireProtocol(true);
        this.digestType = BookKeeper.DigestType.CRC32;
    }

    long getLedgerToRead(int ensemble, int writeQuorum, int ackQuorum, int numEntries) throws Exception {
        LedgerHandle lh = this.bkc.createLedger(ensemble, writeQuorum, ackQuorum, this.digestType, this.passwd);
        for (int i = 0; i < numEntries; ++i) {
            lh.addEntry(("" + i).getBytes());
        }
        lh.close();
        return lh.getId();
    }

    BatchedReadOp createReadOp(LedgerHandle lh, long startEntry, int count) {
        return new BatchedReadOp(lh, this.bkc.getClientCtx(), startEntry, count, (long)(1024 * count), false);
    }

    BatchedReadOp createRecoveryReadOp(LedgerHandle lh, long startEntry, int count) {
        return new BatchedReadOp(lh, this.bkc.getClientCtx(), startEntry, count, (long)(1024 * count), true);
    }

    @Test
    public void testNormalRead() throws Exception {
        LedgerEntry entry;
        int numEntries = 10;
        long id = this.getLedgerToRead(5, 5, 2, numEntries);
        LedgerHandle lh = this.bkc.openLedger(id, this.digestType, this.passwd);
        for (int i = 0; i < numEntries; ++i) {
            BatchedReadOp readOp = this.createReadOp(lh, i, 1);
            readOp.submit();
            Iterator entries = ((LedgerEntries)readOp.future().get()).iterator();
            Assert.assertTrue((boolean)entries.hasNext());
            entry = (LedgerEntry)entries.next();
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)i, (long)Integer.parseInt(new String(entry.getEntryBytes())));
            entry.close();
            Assert.assertFalse((boolean)entries.hasNext());
        }
        BatchedReadOp readOp = this.createReadOp(lh, 0L, numEntries);
        readOp.submit();
        Iterator iterator = ((LedgerEntries)readOp.future().get()).iterator();
        int numReads = 0;
        while (iterator.hasNext()) {
            entry = (LedgerEntry)iterator.next();
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)numReads, (long)Integer.parseInt(new String(entry.getEntryBytes())));
            entry.close();
            ++numReads;
        }
        Assert.assertEquals((long)numEntries, (long)numReads);
        lh.close();
    }

    @Test
    public void testReadWhenEnsembleNotEqualWQ() throws Exception {
        LedgerEntry entry;
        Iterator entries;
        BatchedReadOp readOp;
        int i;
        int numEntries = 10;
        long id = this.getLedgerToRead(5, 2, 2, numEntries);
        LedgerHandle lh = this.bkc.openLedger(id, this.digestType, this.passwd);
        for (i = 0; i < numEntries; ++i) {
            readOp = this.createReadOp(lh, i, 1);
            readOp.submit();
            entries = ((LedgerEntries)readOp.future().get()).iterator();
            Assert.assertTrue((boolean)entries.hasNext());
            entry = (LedgerEntry)entries.next();
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)i, (long)Integer.parseInt(new String(entry.getEntryBytes())));
            entry.close();
            Assert.assertFalse((boolean)entries.hasNext());
        }
        for (i = 0; i < numEntries; ++i) {
            readOp = this.createReadOp(lh, i, numEntries);
            readOp.submit();
            entries = ((LedgerEntries)readOp.future().get()).iterator();
            Assert.assertTrue((boolean)entries.hasNext());
            entry = (LedgerEntry)entries.next();
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)i, (long)Integer.parseInt(new String(entry.getEntryBytes())));
            entry.close();
            Assert.assertFalse((boolean)entries.hasNext());
        }
        lh.close();
    }

    private static <T> void expectFail(CompletableFuture<T> future, int expectedRc) {
        try {
            FutureUtils.result(future);
            Assert.fail((String)"Expect to fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof BKException));
            BKException bke = (BKException)((Object)e);
            Assert.assertEquals((long)expectedRc, (long)bke.getCode());
        }
    }

    @Test
    public void testReadMissingEntries() throws Exception {
        int numEntries = 10;
        long id = this.getLedgerToRead(5, 5, 2, numEntries);
        LedgerHandle lh = this.bkc.openLedger(id, this.digestType, this.passwd);
        BatchedReadOp readOp = this.createReadOp(lh, 10L, 1);
        readOp.submit();
        TestBatchedRead.expectFail(readOp.future(), -13);
        readOp = this.createReadOp(lh, 8L, 3);
        readOp.submit();
        int index = 8;
        int numReads = 0;
        for (LedgerEntry entry : (LedgerEntries)readOp.future().get()) {
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)index, (long)Integer.parseInt(new String(entry.getEntryBytes())));
            entry.close();
            ++index;
            ++numReads;
        }
        Assert.assertEquals((long)2L, (long)numReads);
        lh.close();
    }

    @Test
    public void testFailRecoveryReadMissingEntryImmediately() throws Exception {
        int numEntries = 1;
        long id = this.getLedgerToRead(5, 5, 3, numEntries);
        ClientConfiguration newConf = new ClientConfiguration().setReadEntryTimeout(30000);
        newConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper newBk = new BookKeeper(newConf);
        LedgerHandle lh = this.bkc.openLedger(id, this.digestType, this.passwd);
        List ensemble = lh.getLedgerMetadata().getEnsembleAt(10L);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.sleepBookie((BookieId)ensemble.get(0), latch1);
        this.sleepBookie((BookieId)ensemble.get(1), latch2);
        BatchedReadOp readOp = this.createRecoveryReadOp(lh, 10L, 1);
        readOp.submit();
        TestBatchedRead.expectFail(readOp.future(), -13);
        latch1.countDown();
        latch2.countDown();
        lh.close();
        newBk.close();
    }

    @Test
    public void testReadWithFailedBookies() throws Exception {
        int numEntries = 10;
        long id = this.getLedgerToRead(5, 3, 3, numEntries);
        ClientConfiguration newConf = new ClientConfiguration().setReadEntryTimeout(30000);
        newConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper newBk = new BookKeeper(newConf);
        LedgerHandle lh = this.bkc.openLedger(id, this.digestType, this.passwd);
        List ensemble = lh.getLedgerMetadata().getEnsembleAt(5L);
        this.killBookie((BookieId)ensemble.get(0));
        this.killBookie((BookieId)ensemble.get(1));
        int numReads = 0;
        int i = 0;
        while (i < numEntries) {
            BatchedReadOp readOp = this.createReadOp(lh, i, numEntries);
            readOp.submit();
            Iterator entries = ((LedgerEntries)readOp.future().get()).iterator();
            if (!entries.hasNext()) {
                ++i;
                continue;
            }
            while (entries.hasNext()) {
                LedgerEntry entry = (LedgerEntry)entries.next();
                Assert.assertNotNull((Object)entry);
                Assert.assertEquals((long)i, (long)Integer.parseInt(new String(entry.getEntryBytes())));
                entry.close();
                ++i;
                ++numReads;
            }
        }
        Assert.assertEquals((long)10L, (long)numReads);
        lh.close();
        newBk.close();
    }

    @Test
    public void testReadFailureWithFailedBookies() throws Exception {
        int numEntries = 10;
        long id = this.getLedgerToRead(5, 3, 3, numEntries);
        ClientConfiguration newConf = new ClientConfiguration().setReadEntryTimeout(30000);
        newConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper newBk = new BookKeeper(newConf);
        LedgerHandle lh = this.bkc.openLedger(id, this.digestType, this.passwd);
        List ensemble = lh.getLedgerMetadata().getEnsembleAt(5L);
        this.killBookie((BookieId)ensemble.get(0));
        this.killBookie((BookieId)ensemble.get(1));
        this.killBookie((BookieId)ensemble.get(2));
        BatchedReadOp readOp = this.createReadOp(lh, 0L, numEntries);
        readOp.submit();
        TestBatchedRead.expectFail(readOp.future(), -8);
        lh.close();
        newBk.close();
    }
}

