/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Random;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class BookieWriteLedgersWithDifferentDigestsTest
extends BookKeeperClusterTestCase
implements AsyncCallback.AddCallbackWithLatency {
    private static final Logger LOG = LoggerFactory.getLogger(BookieWriteLedgersWithDifferentDigestsTest.class);
    byte[] ledgerPassword = "aaa".getBytes();
    LedgerHandle lh;
    Enumeration<LedgerEntry> ls;
    final int numEntriesToWrite = 20;
    int maxInt = Integer.MAX_VALUE;
    Random rng;
    ArrayList<byte[]> entries1;
    ArrayList<byte[]> entries2;
    private final BookKeeper.DigestType digestType;
    private final BookKeeper.DigestType otherDigestType;

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        return Arrays.asList({BookKeeper.DigestType.MAC}, {BookKeeper.DigestType.CRC32}, {BookKeeper.DigestType.CRC32C});
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rng = new Random(System.currentTimeMillis());
        this.entries1 = new ArrayList();
        this.entries2 = new ArrayList();
    }

    public BookieWriteLedgersWithDifferentDigestsTest(BookKeeper.DigestType digestType) {
        super(3);
        this.digestType = digestType;
        this.otherDigestType = digestType == BookKeeper.DigestType.CRC32 ? BookKeeper.DigestType.MAC : BookKeeper.DigestType.CRC32;
        String ledgerManagerFactory = "org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory";
        this.baseConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
        this.baseClientConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
    }

    @Test
    public void testLedgersWithDifferentDigestTypesNoAutodetection() throws Exception {
        this.bkc.conf.setEnableDigestTypeAutodetection(false);
        this.lh = this.bkc.createLedgerAdv(3, 2, 2, this.digestType, this.ledgerPassword);
        long id = this.lh.ledgerId;
        LOG.info("Ledger ID: {}, digestType: {}", (Object)this.lh.getId(), (Object)this.digestType);
        SyncObj syncObj1 = new SyncObj();
        for (int i = 19; i >= 0; --i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(0, entry.array());
            this.lh.asyncAddEntry((long)i, entry.array(), 0, entry.capacity(), (AsyncCallback.AddCallbackWithLatency)this, (Object)syncObj1);
        }
        this.waitForEntriesAddition(syncObj1, 20);
        this.readEntries(this.lh, this.entries1);
        this.lh.close();
        try {
            this.bkc.openLedgerNoRecovery(id, this.otherDigestType, this.ledgerPassword).close();
            Assert.fail((String)"digest mismatch error is expected");
        }
        catch (BKException bKException) {
            // empty catch block
        }
    }

    @Test
    public void testLedgersWithDifferentDigestTypesWithAutodetection() throws Exception {
        this.bkc.conf.setEnableDigestTypeAutodetection(true);
        this.lh = this.bkc.createLedgerAdv(3, 2, 2, this.digestType, this.ledgerPassword);
        long id = this.lh.ledgerId;
        LOG.info("Ledger ID-1: " + this.lh.getId());
        SyncObj syncObj1 = new SyncObj();
        for (int i = 19; i >= 0; --i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(0, entry.array());
            this.lh.asyncAddEntry((long)i, entry.array(), 0, entry.capacity(), (AsyncCallback.AddCallbackWithLatency)this, (Object)syncObj1);
        }
        this.waitForEntriesAddition(syncObj1, 20);
        this.readEntries(this.lh, this.entries1);
        this.lh.close();
        this.lh = this.bkc.openLedgerNoRecovery(id, this.otherDigestType, this.ledgerPassword);
        this.readEntries(this.lh, this.entries1);
        this.lh.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEntriesAddition(SyncObj syncObj, int numEntriesToWrite) throws InterruptedException {
        SyncObj syncObj2 = syncObj;
        synchronized (syncObj2) {
            while (syncObj.counter < numEntriesToWrite) {
                syncObj.wait();
            }
            Assert.assertEquals((long)0L, (long)syncObj.rc);
        }
    }

    private void readEntries(LedgerHandle lh, ArrayList<byte[]> entries) throws InterruptedException, BKException {
        this.ls = lh.readEntries(0L, 19L);
        int index = 0;
        while (this.ls.hasMoreElements()) {
            ByteBuffer origbb = ByteBuffer.wrap(entries.get(index++));
            Integer origEntry = origbb.getInt();
            ByteBuffer result = ByteBuffer.wrap(this.ls.nextElement().getEntry());
            Integer retrEntry = result.getInt();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Length of result: " + result.capacity());
                LOG.debug("Original entry: " + origEntry);
                LOG.debug("Retrieved entry: " + retrEntry);
            }
            Assert.assertTrue((String)("Checking entry " + index + " for equality"), (boolean)origEntry.equals(retrEntry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompleteWithLatency(int rc, LedgerHandle lh, long entryId, long qwcLatency, Object ctx) {
        SyncObj x = (SyncObj)ctx;
        this.captureThrowable(() -> Assert.assertTrue((String)"Successful write should have non-zero latency", (rc != 0 || qwcLatency > 0L ? 1 : 0) != 0));
        SyncObj syncObj = x;
        synchronized (syncObj) {
            x.rc = rc;
            ++x.counter;
            x.notify();
        }
    }

    private static class SyncObj {
        volatile int counter = 0;
        volatile int rc;
    }
}

