/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;

public class BookieRecoveryUseIOThreadTest
extends BookKeeperClusterTestCase {
    public BookieRecoveryUseIOThreadTest() {
        super(1);
    }

    @Override
    public void setUp() throws Exception {
        this.baseConf.setNumAddWorkerThreads(0);
        this.baseConf.setNumReadWorkerThreads(0);
        this.baseConf.setNumHighPriorityWorkerThreads(0);
        super.setUp();
    }

    @Test
    public void testRecoveryClosedLedger() throws BKException, IOException, InterruptedException {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        conf.setUseV2WireProtocol(true);
        final AtomicInteger finalRc = new AtomicInteger(Integer.MAX_VALUE);
        final CountDownLatch latch = new CountDownLatch(1);
        try (final BookKeeper bkc = new BookKeeper(conf);){
            bkc.asyncCreateLedger(1, 1, BookKeeper.DigestType.CRC32, "".getBytes(), new AsyncCallback.CreateCallback(){

                public void createComplete(int rc, LedgerHandle lh, Object ctx) {
                    lh.asyncAddEntry("hello".getBytes(), new AsyncCallback.AddCallback(){

                        public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
                            if (rc == 0) {
                                bkc.asyncOpenLedger(lh.ledgerId, BookKeeper.DigestType.CRC32, "".getBytes(), new AsyncCallback.OpenCallback(){

                                    public void openComplete(int rc, LedgerHandle lh, Object ctx) {
                                        finalRc.set(rc);
                                        latch.countDown();
                                    }
                                }, null);
                            }
                        }
                    }, null);
                }
            }, null);
            latch.await();
        }
        Assert.assertEquals((long)finalRc.get(), (long)0L);
    }
}

