/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TmpDirs;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class DbReadLedgerIndexEntriesTest {
    private static final int TEST_LEDGER_MIN_ID = 0;
    private static final int TEST_LEDGER_MAX_ID = 5;
    private static final int TEST_ENTRY_MIN_ID = 0;
    private static final int TEST_ENTRY_MAX_ID = 10;
    CheckpointSource checkpointSource = new CheckpointSource(){

        public CheckpointSource.Checkpoint newCheckpoint() {
            return CheckpointSource.Checkpoint.MAX;
        }

        public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
        }
    };
    Checkpointer checkpointer = new Checkpointer(){

        public void startCheckpoint(CheckpointSource.Checkpoint checkpoint) {
        }

        public void start() {
        }
    };
    protected final TmpDirs tmpDirs = new TmpDirs();

    private String newDirectory() throws Exception {
        File d = this.tmpDirs.createNew("bkTest", ".dir");
        d.delete();
        d.mkdir();
        File curDir = BookieImpl.getCurrentDirectory((File)d);
        BookieImpl.checkDirectoryStructure((File)curDir);
        return d.getPath();
    }

    @Test
    public void testReadLedgerIndexEntries() throws Exception {
        long ledgerId;
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setLedgerDirNames(new String[]{this.newDirectory(), this.newDirectory()});
        conf.setIndexDirName(new String[]{this.newDirectory(), this.newDirectory()});
        conf.setLedgerStorageClass(DbLedgerStorage.class.getName());
        DiskChecker diskChecker = new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold());
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), diskChecker);
        LedgerDirsManager indexDirsManager = new LedgerDirsManager(conf, conf.getIndexDirs(), diskChecker);
        DbLedgerStorage ledgerStorage = new DbLedgerStorage();
        ledgerStorage.initialize(conf, null, ledgerDirsManager, indexDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        ledgerStorage.setCheckpointer(this.checkpointer);
        ledgerStorage.setCheckpointSource(this.checkpointSource);
        for (ledgerId = 0L; ledgerId <= 5L; ++ledgerId) {
            ledgerStorage.setMasterKey(ledgerId, ("ledger-" + ledgerId).getBytes());
            ledgerStorage.setFenced(ledgerId);
            for (long entryId = 0L; entryId <= 10L; ++entryId) {
                ByteBuf entry = Unpooled.buffer((int)128);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId);
                entry.writeBytes(("entry-" + entryId).getBytes());
                ledgerStorage.addEntry(entry);
            }
        }
        ledgerStorage.flush();
        ledgerStorage.shutdown();
        ledgerId = 0L;
        try {
            for (ledgerId = 0L; ledgerId <= 5L; ++ledgerId) {
                ArrayBlockingQueue entrys = new ArrayBlockingQueue(11);
                DbLedgerStorage.readLedgerIndexEntries((long)ledgerId, (ServerConfiguration)conf, (eId, entryLodId, pos) -> {
                    System.out.println("entry " + eId + "\t:\t(log: " + entryLodId + ", pos: " + pos + ")");
                    entrys.add(eId);
                });
                for (long entryId = 0L; entryId <= 10L; ++entryId) {
                    Assert.assertTrue((boolean)entrys.contains(entryId));
                }
            }
        }
        catch (Exception e) {
            System.err.printf("ERROR: initializing dbLedgerStorage %s", e.getMessage());
            Assert.fail((String)("fail to read this ledger(" + ledgerId + ") index entries"));
        }
        ArrayList toDeleted = Lists.newArrayList((Object[])conf.getLedgerDirNames());
        toDeleted.addAll(Lists.newArrayList((Object[])conf.getIndexDirNames()));
        toDeleted.forEach(d -> {
            try {
                FileUtils.forceDelete((File)new File((String)d));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

