/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import java.io.File;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectEntryLogger;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorageTest;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.junit.Assert;
import org.junit.Before;

public class DbLedgerStorageWithDirectEntryLoggerTest
extends DbLedgerStorageTest {
    @Override
    @Before
    public void setup() throws Exception {
        this.tmpDir = File.createTempFile("bkTest", ".dir");
        this.tmpDir.delete();
        this.tmpDir.mkdir();
        File curDir = BookieImpl.getCurrentDirectory((File)this.tmpDir);
        BookieImpl.checkDirectoryStructure((File)curDir);
        int gcWaitTime = 1000;
        this.conf = TestBKConfiguration.newServerConfiguration();
        this.conf.setGcWaitTime((long)gcWaitTime);
        this.conf.setLedgerStorageClass(DbLedgerStorage.class.getName());
        this.conf.setLedgerDirNames(new String[]{this.tmpDir.toString()});
        this.conf.setProperty("dbStorage_directIOEntryLogger", (Object)true);
        TestBookieImpl bookie = new TestBookieImpl(this.conf);
        this.ledgerDirsManager = bookie.getLedgerDirsManager();
        this.storage = (DbLedgerStorage)bookie.getLedgerStorage();
        this.storage.getLedgerStorageList().forEach(singleDirectoryDbLedgerStorage -> Assert.assertTrue((boolean)(singleDirectoryDbLedgerStorage.getEntryLogger() instanceof DirectEntryLogger)));
    }
}

