/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DbLedgerStorageIndexDirTest {
    private DbLedgerStorage storage;
    private File tmpLedgerDir;
    private File tmpIndexDir;
    private static final String LOCATION_INDEX_SUB_PATH = "locations";
    private static final String METADATA_INDEX_SUB_PATH = "ledgers";

    @Before
    public void setup() throws Exception {
        this.tmpLedgerDir = File.createTempFile("ledgerDir", ".dir");
        this.tmpLedgerDir.delete();
        this.tmpLedgerDir.mkdir();
        File curLedgerDir = BookieImpl.getCurrentDirectory((File)this.tmpLedgerDir);
        BookieImpl.checkDirectoryStructure((File)curLedgerDir);
        this.tmpIndexDir = File.createTempFile("indexDir", ".dir");
        this.tmpIndexDir.delete();
        this.tmpIndexDir.mkdir();
        File curIndexDir = BookieImpl.getCurrentDirectory((File)this.tmpIndexDir);
        BookieImpl.checkDirectoryStructure((File)curIndexDir);
        int gcWaitTime = 1000;
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setGcWaitTime((long)gcWaitTime);
        conf.setLedgerStorageClass(DbLedgerStorage.class.getName());
        conf.setProperty("dbStorage_writeCacheMaxSizeMb", (Object)1);
        conf.setProperty("dbStorage_maxThrottleTimeMs", (Object)1000);
        conf.setLedgerDirNames(new String[]{this.tmpLedgerDir.toString()});
        conf.setIndexDirName(new String[]{this.tmpIndexDir.toString()});
        TestBookieImpl bookie = new TestBookieImpl(conf);
        this.storage = (DbLedgerStorage)bookie.getLedgerStorage();
    }

    @After
    public void teardown() throws Exception {
        this.storage.shutdown();
        this.tmpLedgerDir.delete();
        this.tmpIndexDir.delete();
    }

    public boolean hasIndexStructure(File tmpDir) {
        File indexParentDir = BookieImpl.getCurrentDirectory((File)tmpDir);
        String[] indexSubPaths = indexParentDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return DbLedgerStorageIndexDirTest.LOCATION_INDEX_SUB_PATH.equals(name) || DbLedgerStorageIndexDirTest.METADATA_INDEX_SUB_PATH.equals(name);
            }
        });
        if (indexSubPaths.length == 0) {
            return false;
        }
        long hasIndexPathCount = Arrays.stream(indexSubPaths).filter(isp -> {
            String[] indexFiles = new File(indexParentDir, (String)isp).list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return "LOCK".equals(name) || "IDENTITY".equals(name) || "CURRENT".equals(name);
                }
            });
            return indexFiles.length == 3;
        }).count();
        return hasIndexPathCount == (long)indexSubPaths.length;
    }

    @Test
    public void checkIndexNotExistsInLedgerDirStructure() {
        Assert.assertEquals((Object)false, (Object)this.hasIndexStructure(this.tmpLedgerDir));
    }

    @Test
    public void checkIndexDirectoryStructure() {
        Assert.assertEquals((Object)true, (Object)this.hasIndexStructure(this.tmpIndexDir));
    }

    @Test
    public void simpleRegressionTest() throws Exception {
        Assert.assertEquals((Object)false, (Object)this.storage.ledgerExists(3L));
        try {
            this.storage.isFenced(3L);
            Assert.fail((String)"should have failed");
        }
        catch (Bookie.NoLedgerException noLedgerException) {
            // empty catch block
        }
        Assert.assertEquals((Object)false, (Object)this.storage.ledgerExists(3L));
        try {
            this.storage.setFenced(3L);
            Assert.fail((String)"should have failed");
        }
        catch (Bookie.NoLedgerException noLedgerException) {
            // empty catch block
        }
        this.storage.setMasterKey(3L, "key".getBytes());
        try {
            this.storage.setMasterKey(3L, "other-key".getBytes());
            Assert.fail((String)"should have failed");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe.getCause() instanceof BookieException.BookieIllegalOpException));
        }
        this.storage.setMasterKey(3L, "key".getBytes());
        Assert.assertEquals((Object)true, (Object)this.storage.ledgerExists(3L));
        Assert.assertEquals((Object)true, (Object)this.storage.setFenced(3L));
        Assert.assertEquals((Object)true, (Object)this.storage.isFenced(3L));
        Assert.assertEquals((Object)false, (Object)this.storage.setFenced(3L));
        this.storage.setMasterKey(4L, "key".getBytes());
        Assert.assertEquals((Object)false, (Object)this.storage.isFenced(4L));
        Assert.assertEquals((Object)true, (Object)this.storage.ledgerExists(4L));
        Assert.assertEquals((Object)"key", (Object)new String(this.storage.readMasterKey(4L)));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{4L, 3L}), (Object)Lists.newArrayList((Iterable)this.storage.getActiveLedgersInRange(0L, 100L)));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{4L, 3L}), (Object)Lists.newArrayList((Iterable)this.storage.getActiveLedgersInRange(3L, 100L)));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{3L}), (Object)Lists.newArrayList((Iterable)this.storage.getActiveLedgersInRange(0L, 4L)));
        ByteBuf entry = Unpooled.buffer((int)1024);
        entry.writeLong(4L);
        entry.writeLong(1L);
        entry.writeLong(0L);
        entry.writeBytes("entry-1".getBytes());
        Assert.assertEquals((Object)false, (Object)this.storage.isFlushRequired());
        Assert.assertEquals((long)1L, (long)this.storage.addEntry(entry));
        Assert.assertEquals((Object)true, (Object)this.storage.isFlushRequired());
        Assert.assertTrue((boolean)this.storage.entryExists(4L, 1L));
        ByteBuf res = this.storage.getEntry(4L, 1L);
        Assert.assertEquals((Object)entry, (Object)res);
        this.storage.flush();
        Assert.assertEquals((Object)false, (Object)this.storage.isFlushRequired());
        Assert.assertTrue((boolean)this.storage.entryExists(4L, 1L));
        res = this.storage.getEntry(4L, 1L);
        Assert.assertEquals((Object)entry, (Object)res);
        try {
            this.storage.getEntry(4L, 2L);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (Bookie.NoEntryException noEntryException) {
            // empty catch block
        }
        ByteBuf entry2 = Unpooled.buffer((int)1024);
        entry2.writeLong(4L);
        entry2.writeLong(2L);
        entry2.writeLong(1L);
        entry2.writeBytes("entry-2".getBytes());
        this.storage.addEntry(entry2);
        res = this.storage.getEntry(4L, -1L);
        Assert.assertEquals((Object)entry2, (Object)res);
        Assert.assertEquals((long)1L, (long)this.storage.getLastAddConfirmed(4L));
        ByteBuf entry3 = Unpooled.buffer((int)1024);
        entry3.writeLong(4L);
        entry3.writeLong(3L);
        entry3.writeLong(2L);
        entry3.writeBytes("entry-3".getBytes());
        this.storage.addEntry(entry3);
        ByteBuf entry4 = Unpooled.buffer((int)1024);
        entry4.writeLong(4L);
        entry4.writeLong(4L);
        entry4.writeLong(3L);
        entry4.writeBytes("entry-4".getBytes());
        this.storage.addEntry(entry4);
        res = this.storage.getEntry(4L, 4L);
        Assert.assertEquals((Object)entry4, (Object)res);
        Assert.assertEquals((long)3L, (long)this.storage.getLastAddConfirmed(4L));
        Assert.assertEquals((Object)true, (Object)this.storage.ledgerExists(4L));
        this.storage.deleteLedger(4L);
        Assert.assertEquals((Object)false, (Object)this.storage.ledgerExists(4L));
        this.storage.flush();
        try {
            this.storage.getEntry(4L, 4L);
            Assert.fail((String)"Should have thrown exception since the ledger was deleted");
        }
        catch (Bookie.NoLedgerException noLedgerException) {
            // empty catch block
        }
    }
}

