/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.bookkeeper.bookie.storage.directentrylogger.BufferPool;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectEntryLogger;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectWriter;
import org.apache.bookkeeper.bookie.storage.directentrylogger.LogWriter;
import org.apache.bookkeeper.bookie.storage.directentrylogger.TestBuffer;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.bookkeeper.common.util.nativeio.NativeIOException;
import org.apache.bookkeeper.common.util.nativeio.NativeIOImpl;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.bookkeeper.slogger.Slogger;
import org.apache.bookkeeper.test.TmpDirs;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestDirectWriter {
    private static final Slogger slog = Slogger.CONSOLE;
    private final TmpDirs tmpDirs = new TmpDirs();
    private final ExecutorService writeExecutor = Executors.newSingleThreadExecutor();

    @After
    public void cleanup() throws Exception {
        this.tmpDirs.cleanup();
        this.writeExecutor.shutdownNow();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWriteAtAlignment() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("writeAlignment", "logs");
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 4096, 8);
             DirectWriter writer = new DirectWriter(5678, DirectEntryLogger.logFilename((File)ledgerDir, (int)5678), 0x1000000L, this.writeExecutor, buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);){
            ByteBuf bb = Unpooled.buffer((int)4096);
            TestBuffer.fillByteBuf(bb, -555819298);
            writer.writeAt(1234L, bb);
            writer.flush();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWriteAlignmentSize() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("writeAlignment", "logs");
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 4096, 8);
             DirectWriter writer = new DirectWriter(5678, DirectEntryLogger.logFilename((File)ledgerDir, (int)5678), 0x1000000L, this.writeExecutor, buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);){
            ByteBuf bb = Unpooled.buffer((int)123);
            TestBuffer.fillByteBuf(bb, -555819298);
            writer.writeAt(0L, bb);
            writer.flush();
        }
    }

    @Test
    public void testWriteAlignedNotAtStart() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("writeAlignment", "logs");
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 4096, 8);
             DirectWriter writer = new DirectWriter(5678, DirectEntryLogger.logFilename((File)ledgerDir, (int)5678), 0x1000000L, this.writeExecutor, buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);){
            ByteBuf bb = Unpooled.buffer((int)4096);
            TestBuffer.fillByteBuf(bb, -555819298);
            writer.writeAt(8192L, bb);
            writer.flush();
        }
    }

    @Test(timeout=10000L)
    public void testFlushingWillWaitForBuffer() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("writeFailFailsFlush", "logs");
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 4096, 1);
             DirectWriter writer = new DirectWriter(5678, DirectEntryLogger.logFilename((File)ledgerDir, (int)5678), 0x1000000L, this.writeExecutor, buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);){
            ByteBuf bb = Unpooled.buffer((int)2048);
            TestBuffer.fillByteBuf(bb, -555819298);
            writer.writeDelimited(bb);
            writer.flush();
        }
    }

    @Test(expected=IOException.class)
    public void testWriteFailFailsFlush() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("writeFailFailsFlush", "logs");
        NativeIOImpl io = new NativeIOImpl(){
            boolean failed = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int pwrite(int fd, long pointer, int count, long offset) throws NativeIOException {
                1 var7_5 = this;
                synchronized (var7_5) {
                    if (!this.failed) {
                        this.failed = true;
                        throw new NativeIOException("fail for test");
                    }
                }
                return super.pwrite(fd, pointer, count, offset);
            }
        };
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 4096, 8);
             DirectWriter writer = new DirectWriter(5678, DirectEntryLogger.logFilename((File)ledgerDir, (int)5678), 0x1000000L, this.writeExecutor, buffers, (NativeIO)io, Slogger.CONSOLE);){
            for (int i = 0; i < 10; ++i) {
                ByteBuf bb = Unpooled.buffer((int)2048);
                TestBuffer.fillByteBuf(bb, -555819298);
                writer.writeDelimited(bb);
            }
            writer.flush();
        }
    }

    @Test(expected=IOException.class)
    public void testWriteAtFailFailsFlush() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("writeFailFailsFlush", "logs");
        NativeIOImpl io = new NativeIOImpl(){
            boolean failed = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int pwrite(int fd, long pointer, int count, long offset) throws NativeIOException {
                2 var7_5 = this;
                synchronized (var7_5) {
                    if (!this.failed) {
                        this.failed = true;
                        throw new NativeIOException("fail for test");
                    }
                }
                return super.pwrite(fd, pointer, count, offset);
            }
        };
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 16384, 8);
             DirectWriter writer = new DirectWriter(5678, DirectEntryLogger.logFilename((File)ledgerDir, (int)5678), 0x1000000L, this.writeExecutor, buffers, (NativeIO)io, Slogger.CONSOLE);){
            ByteBuf bb = Unpooled.buffer((int)4096);
            TestBuffer.fillByteBuf(bb, -555819298);
            writer.writeAt(0L, bb);
            writer.flush();
        }
    }

    @Test
    public void testWriteWithPadding() throws Exception {
        int i;
        File ledgerDir = this.tmpDirs.createNew("paddingWrite", "logs");
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 16384, 8);
             DirectWriter writer = new DirectWriter(5678, DirectEntryLogger.logFilename((File)ledgerDir, (int)5678), 0x1000000L, this.writeExecutor, buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);){
            ByteBuf bb = Unpooled.buffer((int)4096);
            TestBuffer.fillByteBuf(bb, -555819298);
            bb.writerIndex(123);
            writer.writeDelimited(bb);
            writer.flush();
        }
        ByteBuf contents = TestDirectWriter.readIntoByteBuf(ledgerDir, 5678);
        MatcherAssert.assertThat((Object)contents.readInt(), (Matcher)Matchers.equalTo((Object)123));
        for (i = 0; i < 123; ++i) {
            MatcherAssert.assertThat((Object)contents.readByte(), (Matcher)Matchers.equalTo((Object)-34));
        }
        for (i = 0; i < 3969; ++i) {
            MatcherAssert.assertThat((Object)contents.readByte(), (Matcher)Matchers.equalTo((Object)-16));
        }
        while (contents.isReadable()) {
            MatcherAssert.assertThat((Object)contents.readByte(), (Matcher)Matchers.equalTo((Object)0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteBlocksFlush() throws Exception {
        ExecutorService flushExecutor = Executors.newSingleThreadExecutor();
        try {
            File ledgerDir = this.tmpDirs.createNew("blockWrite", "logs");
            try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 16384, 8);
                 DirectWriter writer = new DirectWriter(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), 0x1000000L, this.writeExecutor, buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);){
                CompletableFuture<Object> blocker = new CompletableFuture<Object>();
                this.writeExecutor.submit(() -> {
                    blocker.join();
                    return null;
                });
                ByteBuf bb = Unpooled.buffer((int)4096);
                TestBuffer.fillByteBuf(bb, -559038737);
                writer.writeAt(0L, bb);
                Future<Object> f = flushExecutor.submit(() -> TestDirectWriter.lambda$testWriteBlocksFlush$1((LogWriter)writer));
                Thread.sleep(100L);
                MatcherAssert.assertThat((Object)f.isDone(), (Matcher)Matchers.equalTo((Object)false));
                blocker.complete(null);
                f.get();
            }
            ByteBuf contents = TestDirectWriter.readIntoByteBuf(ledgerDir, 1234);
            for (int i = 0; i < 1024; ++i) {
                MatcherAssert.assertThat((Object)contents.readInt(), (Matcher)Matchers.equalTo((Object)-559038737));
            }
            if (contents.readableBytes() > 0) {
                while (contents.isReadable()) {
                    MatcherAssert.assertThat((Object)contents.readByte(), (Matcher)Matchers.equalTo((Object)0));
                }
            }
        }
        finally {
            flushExecutor.shutdownNow();
        }
    }

    @Test(expected=IOException.class)
    public void testFailsToOpen() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("failOpen", "logs");
        ledgerDir.delete();
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 16384, 8);){
            new DirectWriter(1234, DirectEntryLogger.logFilename((File)ledgerDir, (int)1234), 0x40000000L, (ExecutorService)MoreExecutors.newDirectExecutorService(), buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);
        }
    }

    @Test
    public void fallocateNotAvailable() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("fallocUnavailable", "logs");
        NativeIOImpl nativeIO = new NativeIOImpl(){

            public int fallocate(int fd, int mode, long offset, long len) throws NativeIOException {
                throw new NativeIOException("pretending I'm a mac");
            }
        };
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 16384, 8);
             DirectWriter writer = new DirectWriter(3456, DirectEntryLogger.logFilename((File)ledgerDir, (int)3456), 0x1000000L, this.writeExecutor, buffers, (NativeIO)nativeIO, Slogger.CONSOLE);){
            ByteBuf bb = Unpooled.buffer((int)4096);
            TestBuffer.fillByteBuf(bb, -559038737);
            writer.writeAt(0L, bb);
            writer.flush();
        }
        ByteBuf contents = TestDirectWriter.readIntoByteBuf(ledgerDir, 3456);
        MatcherAssert.assertThat((Object)contents.readableBytes(), (Matcher)Matchers.equalTo((Object)4096));
        while (contents.isReadable()) {
            MatcherAssert.assertThat((Object)contents.readInt(), (Matcher)Matchers.equalTo((Object)-559038737));
        }
    }

    @Test
    public void testWriteAtIntLimit() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("intLimit", "logs");
        try (BufferPool buffers = new BufferPool((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 16384, 8);
             DirectWriter writer = new DirectWriter(3456, DirectEntryLogger.logFilename((File)ledgerDir, (int)3456), 2147893247L, this.writeExecutor, buffers, (NativeIO)new NativeIOImpl(), Slogger.CONSOLE);){
            ByteBuf b1 = Unpooled.buffer((int)4087);
            TestBuffer.fillByteBuf(b1, -559038737);
            long finalSeekablePosition = 0x7FFFF000L;
            writer.position(finalSeekablePosition);
            long offset = writer.writeDelimited(b1);
            MatcherAssert.assertThat((Object)offset, (Matcher)Matchers.equalTo((Object)(finalSeekablePosition + 4L)));
            MatcherAssert.assertThat((Object)writer.position(), (Matcher)Matchers.equalTo((Object)0x7FFFFFFBL));
            offset = writer.writeDelimited(b1);
            MatcherAssert.assertThat((Object)offset, (Matcher)Matchers.equalTo((Object)Integer.MAX_VALUE));
            writer.flush();
            try {
                writer.writeDelimited(b1);
                Assert.fail((String)"Shouldn't be possible, we've gone past MAX_INT");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static ByteBuf readIntoByteBuf(File directory, int logId) throws Exception {
        byte[] bytes = new byte[1024];
        File file = new File(DirectEntryLogger.logFilename((File)directory, (int)logId));
        slog.kv((Object)"filename", (Object)file.toString()).info("reading in");
        ByteBuf byteBuf = Unpooled.buffer((int)((int)file.length()));
        try (FileInputStream is = new FileInputStream(file);){
            int bytesRead = is.read(bytes);
            while (bytesRead > 0) {
                byteBuf.writeBytes(bytes, 0, bytesRead);
                bytesRead = is.read(bytes);
            }
        }
        MatcherAssert.assertThat((Object)byteBuf.readableBytes(), (Matcher)Matchers.equalTo((Object)((int)file.length())));
        return byteBuf;
    }

    private static /* synthetic */ Object lambda$testWriteBlocksFlush$1(LogWriter writer) throws Exception {
        writer.flush();
        return null;
    }
}

