/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.DefaultEntryLogger;
import org.apache.bookkeeper.bookie.EntryLocation;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.GarbageCollectorThread;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.bookie.TransactionalEntryLogCompactor;
import org.apache.bookkeeper.bookie.storage.CompactionEntryLog;
import org.apache.bookkeeper.bookie.storage.ldb.PersistentEntryLogMetadataMap;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.bookkeeper.util.TestUtils;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.zookeeper.AsyncCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactionTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionTest.class);
    private static final int ENTRY_SIZE = 1024;
    private static final int NUM_BOOKIES = 1;
    private final boolean isThrottleByBytes;
    private final BookKeeper.DigestType digestType;
    private final byte[] passwdBytes;
    private final int numEntries;
    private final int gcWaitTime;
    private final double minorCompactionThreshold;
    private final double majorCompactionThreshold;
    private final long minorCompactionInterval;
    private final long majorCompactionInterval;
    private final String msg;
    private final boolean useMetadataCache;

    public CompactionTest(boolean isByBytes, boolean useMetadataCache) {
        super(1);
        this.isThrottleByBytes = isByBytes;
        this.useMetadataCache = useMetadataCache;
        this.digestType = BookKeeper.DigestType.CRC32;
        this.passwdBytes = "".getBytes();
        this.numEntries = 100;
        this.gcWaitTime = 1000;
        this.minorCompactionThreshold = 0.1f;
        this.majorCompactionThreshold = 0.5;
        this.minorCompactionInterval = 2 * this.gcWaitTime / 1000;
        this.majorCompactionInterval = 4 * this.gcWaitTime / 1000;
        StringBuilder msgSB = new StringBuilder();
        for (int i = 0; i < 1024; ++i) {
            msgSB.append("a");
        }
        this.msg = msgSB.toString();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.baseConf.setEntryLogSizeLimit((long)(this.numEntries * 1024));
        this.baseConf.setGcWaitTime((long)this.gcWaitTime);
        this.baseConf.setFlushInterval(100);
        this.baseConf.setMinorCompactionThreshold(this.minorCompactionThreshold);
        this.baseConf.setMajorCompactionThreshold(this.majorCompactionThreshold);
        this.baseConf.setMinorCompactionInterval(this.minorCompactionInterval);
        this.baseConf.setMajorCompactionInterval(this.majorCompactionInterval);
        this.baseConf.setEntryLogFilePreAllocationEnabled(false);
        this.baseConf.setLedgerStorageClass(InterleavedLedgerStorage.class.getName());
        this.baseConf.setIsThrottleByBytes(this.isThrottleByBytes);
        this.baseConf.setIsForceGCAllowWhenNoSpace(false);
        this.baseConf.setGcEntryLogMetadataCacheEnabled(this.useMetadataCache);
        super.setUp();
    }

    private GarbageCollectorThread getGCThread() throws Exception {
        Assert.assertEquals((long)1L, (long)this.bookieCount());
        BookieServer server = this.serverByIndex(0);
        return ((InterleavedLedgerStorage)server.getBookie().getLedgerStorage()).gcThread;
    }

    LedgerHandle[] prepareData(int numEntryLogs, boolean changeNum) throws Exception {
        int num1 = 2;
        int num3 = (int)((float)this.numEntries * 0.7f);
        int num2 = this.numEntries - num3 - num1;
        LedgerHandle[] lhs = new LedgerHandle[3];
        for (int i = 0; i < 3; ++i) {
            lhs[i] = this.bkc.createLedger(1, 1, this.digestType, this.passwdBytes);
        }
        for (int n = 0; n < numEntryLogs; ++n) {
            int k;
            for (k = 0; k < num1; ++k) {
                lhs[0].addEntry(this.msg.getBytes());
            }
            for (k = 0; k < num2; ++k) {
                lhs[1].addEntry(this.msg.getBytes());
            }
            for (k = 0; k < num3; ++k) {
                lhs[2].addEntry(this.msg.getBytes());
            }
            if (!changeNum) continue;
            --num2;
            ++num3;
        }
        return lhs;
    }

    private void verifyLedger(long lid, long startEntryId, long endEntryId) throws Exception {
        LedgerHandle lh = this.bkc.openLedger(lid, this.digestType, this.passwdBytes);
        Enumeration entries = lh.readEntries(startEntryId, endEntryId);
        while (entries.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)entries.nextElement();
            Assert.assertEquals((Object)this.msg, (Object)new String(entry.getEntry()));
        }
    }

    @Test
    public void testDisableCompaction() throws Exception {
        LedgerHandle[] lhs = this.prepareData(3, false);
        this.restartBookies(c -> {
            c.setMinorCompactionThreshold(0.0);
            c.setMajorCompactionThreshold(0.0);
            return c;
        });
        long lastMinorCompactionTime = this.getGCThread().lastMinorCompactionTime;
        long lastMajorCompactionTime = this.getGCThread().lastMajorCompactionTime;
        this.bkc.deleteLedger(lhs[1].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        Assert.assertFalse((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertFalse((boolean)this.getGCThread().enableMinorCompaction);
        this.getGCThread().triggerGC().get();
        if (this.useMetadataCache) {
            Assert.assertTrue((boolean)(this.getGCThread().getEntryLogMetaMap() instanceof PersistentEntryLogMetadataMap));
        }
        Assert.assertEquals((long)lastMinorCompactionTime, (long)this.getGCThread().lastMinorCompactionTime);
        Assert.assertEquals((long)lastMajorCompactionTime, (long)this.getGCThread().lastMajorCompactionTime);
        for (File ledgerDirectory : this.bookieLedgerDirs()) {
            Assert.assertTrue((String)("Not Found entry log file ([0,1].log that should have been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, false, 0, 1));
        }
    }

    @Test
    public void testForceGarbageCollectionWhenDisableCompactionConfigurationSettings() throws Exception {
        LedgerHandle[] lhs = this.prepareData(3, false);
        this.restartBookies(c -> {
            c.setForceAllowCompaction(true);
            c.setMajorCompactionThreshold(0.5);
            c.setMinorCompactionThreshold((double)0.2f);
            c.setMajorCompactionInterval(0L);
            c.setMinorCompactionInterval(0L);
            return c;
        });
        Assert.assertFalse((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertFalse((boolean)this.getGCThread().enableMinorCompaction);
        Assert.assertTrue((boolean)this.getGCThread().isForceMajorCompactionAllow);
        Assert.assertTrue((boolean)this.getGCThread().isForceMinorCompactionAllow);
        Assert.assertEquals((double)0.5, (double)this.getGCThread().majorCompactionThreshold, (double)0.0);
        Assert.assertEquals((double)0.2f, (double)this.getGCThread().minorCompactionThreshold, (double)0.0);
    }

    @Test
    public void testForceGarbageCollection() throws Exception {
        this.testForceGarbageCollection(true);
        this.testForceGarbageCollection(false);
    }

    public void testForceGarbageCollection(boolean isForceCompactionAllowWhenDisableCompaction) throws Exception {
        ServerConfiguration conf = this.newServerConfiguration();
        conf.setGcWaitTime(60000L);
        if (isForceCompactionAllowWhenDisableCompaction) {
            conf.setMinorCompactionInterval(0L);
            conf.setMajorCompactionInterval(0L);
            conf.setForceAllowCompaction(true);
            conf.setMajorCompactionThreshold(0.5);
            conf.setMinorCompactionThreshold((double)0.2f);
        } else {
            conf.setMinorCompactionInterval(120000L);
            conf.setMajorCompactionInterval(240000L);
        }
        LedgerDirsManager dirManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
        CheckpointSource cp = new CheckpointSource(){

            public CheckpointSource.Checkpoint newCheckpoint() {
                return null;
            }

            public void checkpointComplete(CheckpointSource.Checkpoint checkPoint, boolean compact) throws IOException {
            }
        };
        for (File journalDir : conf.getJournalDirs()) {
            BookieImpl.checkDirectoryStructure((File)journalDir);
        }
        for (File dir : dirManager.getAllLedgerDirs()) {
            BookieImpl.checkDirectoryStructure((File)dir);
        }
        MetadataDrivers.runFunctionWithLedgerManagerFactory((ServerConfiguration)conf, lmf -> {
            try (LedgerManager lm = lmf.newLedgerManager();){
                InterleavedLedgerStorage storage = new InterleavedLedgerStorage();
                storage.initialize(conf, lm, dirManager, dirManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
                storage.setCheckpointSource(cp);
                storage.setCheckpointer(Checkpointer.NULL);
                storage.start();
                long startTime = System.currentTimeMillis();
                storage.gcThread.enableForceGC();
                storage.gcThread.triggerGC().get();
                storage.gcThread.triggerGC().get();
                Assert.assertTrue((String)"Minor or major compaction did not trigger even on forcing.", (storage.gcThread.lastMajorCompactionTime > startTime && storage.gcThread.lastMinorCompactionTime > startTime ? 1 : 0) != 0);
                storage.shutdown();
            }
            catch (Exception e) {
                throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
            }
            return null;
        });
    }

    @Test
    public void testForceGarbageCollectionWhenDiskIsFull() throws Exception {
        this.testForceGarbageCollectionWhenDiskIsFull(true);
        this.testForceGarbageCollectionWhenDiskIsFull(false);
    }

    public void testForceGarbageCollectionWhenDiskIsFull(boolean isForceCompactionAllowWhenDisableCompaction) throws Exception {
        this.restartBookies(conf -> {
            if (isForceCompactionAllowWhenDisableCompaction) {
                conf.setMinorCompactionInterval(0L);
                conf.setMajorCompactionInterval(0L);
                conf.setForceAllowCompaction(true);
                conf.setMajorCompactionThreshold(0.5);
                conf.setMinorCompactionThreshold((double)0.2f);
            } else {
                conf.setMinorCompactionInterval(120000L);
                conf.setMajorCompactionInterval(240000L);
            }
            return conf;
        });
        this.getGCThread().suspendMajorGC();
        this.getGCThread().suspendMinorGC();
        long majorCompactionCntBeforeGC = 0L;
        long minorCompactionCntBeforeGC = 0L;
        long majorCompactionCntAfterGC = 0L;
        long minorCompactionCntAfterGC = 0L;
        majorCompactionCntBeforeGC = this.getGCThread().getGarbageCollectionStatus().getMajorCompactionCounter();
        minorCompactionCntBeforeGC = this.getGCThread().getGarbageCollectionStatus().getMinorCompactionCounter();
        this.getGCThread().triggerGC(true, true, true).get();
        majorCompactionCntAfterGC = this.getGCThread().getGarbageCollectionStatus().getMajorCompactionCounter();
        minorCompactionCntAfterGC = this.getGCThread().getGarbageCollectionStatus().getMinorCompactionCounter();
        Assert.assertEquals((long)majorCompactionCntBeforeGC, (long)majorCompactionCntAfterGC);
        Assert.assertEquals((long)minorCompactionCntBeforeGC, (long)minorCompactionCntAfterGC);
        majorCompactionCntBeforeGC = this.getGCThread().getGarbageCollectionStatus().getMajorCompactionCounter();
        minorCompactionCntBeforeGC = this.getGCThread().getGarbageCollectionStatus().getMinorCompactionCounter();
        this.getGCThread().triggerGC(true, false, false).get();
        majorCompactionCntAfterGC = this.getGCThread().getGarbageCollectionStatus().getMajorCompactionCounter();
        minorCompactionCntAfterGC = this.getGCThread().getGarbageCollectionStatus().getMinorCompactionCounter();
        Assert.assertEquals((long)(majorCompactionCntBeforeGC + 1L), (long)majorCompactionCntAfterGC);
        Assert.assertEquals((long)minorCompactionCntBeforeGC, (long)minorCompactionCntAfterGC);
        majorCompactionCntBeforeGC = this.getGCThread().getGarbageCollectionStatus().getMajorCompactionCounter();
        minorCompactionCntBeforeGC = this.getGCThread().getGarbageCollectionStatus().getMinorCompactionCounter();
        this.getGCThread().triggerGC(true, false, true).get();
        majorCompactionCntAfterGC = this.getGCThread().getGarbageCollectionStatus().getMajorCompactionCounter();
        minorCompactionCntAfterGC = this.getGCThread().getGarbageCollectionStatus().getMinorCompactionCounter();
        Assert.assertEquals((long)(majorCompactionCntBeforeGC + 1L), (long)majorCompactionCntAfterGC);
        Assert.assertEquals((long)minorCompactionCntBeforeGC, (long)minorCompactionCntAfterGC);
        majorCompactionCntBeforeGC = this.getGCThread().getGarbageCollectionStatus().getMajorCompactionCounter();
        minorCompactionCntBeforeGC = this.getGCThread().getGarbageCollectionStatus().getMinorCompactionCounter();
        this.getGCThread().triggerGC(true, true, false).get();
        majorCompactionCntAfterGC = this.getGCThread().getGarbageCollectionStatus().getMajorCompactionCounter();
        minorCompactionCntAfterGC = this.getGCThread().getGarbageCollectionStatus().getMinorCompactionCounter();
        Assert.assertEquals((long)majorCompactionCntBeforeGC, (long)majorCompactionCntAfterGC);
        Assert.assertEquals((long)(minorCompactionCntBeforeGC + 1L), (long)minorCompactionCntAfterGC);
    }

    @Test
    public void testMinorCompaction() throws Exception {
        LedgerHandle[] lhs;
        for (LedgerHandle lh : lhs = this.prepareData(3, false)) {
            lh.close();
        }
        this.restartBookies(c -> {
            c.setMajorCompactionThreshold(0.0);
            c.setGcWaitTime(60000L);
            c.setMinorCompactionInterval(120000L);
            c.setMajorCompactionInterval(240000L);
            return c;
        });
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        if (this.useMetadataCache) {
            Assert.assertTrue((boolean)(this.getGCThread().getEntryLogMetaMap() instanceof PersistentEntryLogMetadataMap));
        }
        Assert.assertTrue((String)"ACTIVE_ENTRY_LOG_COUNT should have been updated", (this.getStatsProvider(0).getGauge("bookie.gc.ACTIVE_ENTRY_LOG_TOTAL").getSample().intValue() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"ACTIVE_ENTRY_LOG_SPACE_BYTES should have been updated", (this.getStatsProvider(0).getGauge("bookie.gc.ACTIVE_ENTRY_LOG_SPACE_BYTES").getSample().intValue() > 0 ? 1 : 0) != 0);
        long lastMinorCompactionTime = this.getGCThread().lastMinorCompactionTime;
        long lastMajorCompactionTime = this.getGCThread().lastMajorCompactionTime;
        Assert.assertFalse((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertTrue((boolean)this.getGCThread().enableMinorCompaction);
        this.bkc.deleteLedger(lhs[1].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        Assert.assertEquals((long)lastMajorCompactionTime, (long)this.getGCThread().lastMajorCompactionTime);
        Assert.assertTrue((this.getGCThread().lastMinorCompactionTime > lastMinorCompactionTime ? 1 : 0) != 0);
        for (File ledgerDirectory : this.bookieLedgerDirs()) {
            Assert.assertFalse((String)("Found entry log file ([0,1,2].log that should have not been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0, 1, 2));
        }
        this.verifyLedger(lhs[0].getId(), 0L, lhs[0].getLastAddConfirmed());
        Assert.assertTrue((String)"RECLAIMED_COMPACTION_SPACE_BYTES should have been updated", (this.getStatsProvider(0).getCounter("bookie.gc.RECLAIMED_COMPACTION_SPACE_BYTES").get().intValue() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"RECLAIMED_DELETION_SPACE_BYTES should have been updated", (this.getStatsProvider(0).getCounter("bookie.gc.RECLAIMED_DELETION_SPACE_BYTES").get().intValue() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMinorCompactionWithMaxTimeMillisOk() throws Exception {
        LedgerHandle[] lhs;
        for (LedgerHandle lh : lhs = this.prepareData(6, false)) {
            lh.close();
        }
        this.restartBookies(c -> {
            c.setMajorCompactionThreshold(0.0);
            c.setGcWaitTime(60000L);
            c.setMinorCompactionInterval(120000L);
            c.setMajorCompactionInterval(240000L);
            c.setMinorCompactionMaxTimeMillis(5000L);
            c.setMajorCompactionMaxTimeMillis(5000L);
            return c;
        });
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        Assert.assertTrue((String)"ACTIVE_ENTRY_LOG_COUNT should have been updated", (this.getStatsProvider(0).getGauge("bookie.gc.ACTIVE_ENTRY_LOG_TOTAL").getSample().intValue() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"ACTIVE_ENTRY_LOG_SPACE_BYTES should have been updated", (this.getStatsProvider(0).getGauge("bookie.gc.ACTIVE_ENTRY_LOG_SPACE_BYTES").getSample().intValue() > 0 ? 1 : 0) != 0);
        long lastMinorCompactionTime = this.getGCThread().lastMinorCompactionTime;
        long lastMajorCompactionTime = this.getGCThread().lastMajorCompactionTime;
        Assert.assertFalse((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertTrue((boolean)this.getGCThread().enableMinorCompaction);
        this.bkc.deleteLedger(lhs[1].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        Assert.assertEquals((long)lastMajorCompactionTime, (long)this.getGCThread().lastMajorCompactionTime);
        Assert.assertTrue((this.getGCThread().lastMinorCompactionTime > lastMinorCompactionTime ? 1 : 0) != 0);
        for (File ledgerDirectory : this.tmpDirs.getDirs()) {
            Assert.assertFalse((String)("Found entry log file ([0,1,2].log that should have not been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0, 1, 2));
        }
        this.verifyLedger(lhs[0].getId(), 0L, lhs[0].getLastAddConfirmed());
        Assert.assertTrue((String)"RECLAIMED_COMPACTION_SPACE_BYTES should have been updated", (this.getStatsProvider(0).getCounter("bookie.gc.RECLAIMED_COMPACTION_SPACE_BYTES").get().intValue() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"RECLAIMED_DELETION_SPACE_BYTES should have been updated", (this.getStatsProvider(0).getCounter("bookie.gc.RECLAIMED_DELETION_SPACE_BYTES").get().intValue() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMinorCompactionWithMaxTimeMillisTooShort() throws Exception {
        LedgerHandle[] lhs;
        for (LedgerHandle lh : lhs = this.prepareData(6, false)) {
            lh.close();
        }
        this.restartBookies(c -> {
            c.setMajorCompactionThreshold(0.0);
            c.setGcWaitTime(60000L);
            c.setMinorCompactionInterval(120000L);
            c.setMajorCompactionInterval(240000L);
            c.setMinorCompactionMaxTimeMillis(1L);
            c.setMajorCompactionMaxTimeMillis(1L);
            return c;
        });
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        Assert.assertTrue((String)"ACTIVE_ENTRY_LOG_COUNT should have been updated", (this.getStatsProvider(0).getGauge("bookie.gc.ACTIVE_ENTRY_LOG_TOTAL").getSample().intValue() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"ACTIVE_ENTRY_LOG_SPACE_BYTES should have been updated", (this.getStatsProvider(0).getGauge("bookie.gc.ACTIVE_ENTRY_LOG_SPACE_BYTES").getSample().intValue() > 0 ? 1 : 0) != 0);
        long lastMinorCompactionTime = this.getGCThread().lastMinorCompactionTime;
        long lastMajorCompactionTime = this.getGCThread().lastMajorCompactionTime;
        Assert.assertFalse((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertTrue((boolean)this.getGCThread().enableMinorCompaction);
        this.bkc.deleteLedger(lhs[1].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        Assert.assertEquals((long)lastMajorCompactionTime, (long)this.getGCThread().lastMajorCompactionTime);
        Assert.assertTrue((this.getGCThread().lastMinorCompactionTime > lastMinorCompactionTime ? 1 : 0) != 0);
        for (File ledgerDirectory : this.tmpDirs.getDirs()) {
            Assert.assertTrue((String)("Not found entry log file ([0,1,2].log that should not have been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0, 1, 2));
        }
        this.verifyLedger(lhs[0].getId(), 0L, lhs[0].getLastAddConfirmed());
    }

    @Test
    public void testForceMinorCompaction() throws Exception {
        LedgerHandle[] lhs;
        for (LedgerHandle lh : lhs = this.prepareData(3, false)) {
            lh.close();
        }
        this.restartBookies(c -> {
            c.setMajorCompactionThreshold(0.0);
            c.setGcWaitTime(60000L);
            c.setMinorCompactionInterval(-1L);
            c.setMajorCompactionInterval(-1L);
            c.setForceAllowCompaction(true);
            return c;
        });
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        Assert.assertTrue((String)"ACTIVE_ENTRY_LOG_COUNT should have been updated", (this.getStatsProvider(0).getGauge("bookie.gc.ACTIVE_ENTRY_LOG_TOTAL").getSample().intValue() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"ACTIVE_ENTRY_LOG_SPACE_BYTES should have been updated", (this.getStatsProvider(0).getGauge("bookie.gc.ACTIVE_ENTRY_LOG_SPACE_BYTES").getSample().intValue() > 0 ? 1 : 0) != 0);
        long lastMinorCompactionTime = this.getGCThread().lastMinorCompactionTime;
        long lastMajorCompactionTime = this.getGCThread().lastMajorCompactionTime;
        Assert.assertFalse((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertFalse((boolean)this.getGCThread().enableMinorCompaction);
        this.bkc.deleteLedger(lhs[1].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        Assert.assertEquals((long)lastMajorCompactionTime, (long)this.getGCThread().lastMajorCompactionTime);
        Assert.assertTrue((this.getGCThread().lastMinorCompactionTime > lastMinorCompactionTime ? 1 : 0) != 0);
        for (File ledgerDirectory : this.tmpDirs.getDirs()) {
            Assert.assertFalse((String)("Found entry log file ([0,1,2].log that should have not been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0, 1, 2));
        }
        this.verifyLedger(lhs[0].getId(), 0L, lhs[0].getLastAddConfirmed());
        Assert.assertTrue((String)"RECLAIMED_COMPACTION_SPACE_BYTES should have been updated", (this.getStatsProvider(0).getCounter("bookie.gc.RECLAIMED_COMPACTION_SPACE_BYTES").get().intValue() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"RECLAIMED_DELETION_SPACE_BYTES should have been updated", (this.getStatsProvider(0).getCounter("bookie.gc.RECLAIMED_DELETION_SPACE_BYTES").get().intValue() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMinorCompactionWithEntryLogPerLedgerEnabled() throws Exception {
        LedgerHandle[] lhs;
        this.restartBookies(c -> {
            c.setMajorCompactionThreshold(0.0);
            c.setGcWaitTime(60000L);
            c.setMinorCompactionInterval(120000L);
            c.setMajorCompactionInterval(240000L);
            c.setForceAllowCompaction(true);
            c.setEntryLogPerLedgerEnabled(true);
            return c;
        });
        for (LedgerHandle lh : lhs = this.prepareData(3, false)) {
            lh.close();
        }
        long lastMinorCompactionTime = this.getGCThread().lastMinorCompactionTime;
        long lastMajorCompactionTime = this.getGCThread().lastMajorCompactionTime;
        Assert.assertFalse((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertTrue((boolean)this.getGCThread().enableMinorCompaction);
        this.bkc.deleteLedger(lhs[1].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        while (!this.getGCThread().entryLogger.getFlushedLogIds().contains(3L)) {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        LOG.info("Finished deleting the ledgers contains most entries.");
        this.getGCThread().triggerGC(true, false, false).get();
        Assert.assertEquals((long)lastMajorCompactionTime, (long)this.getGCThread().lastMajorCompactionTime);
        Assert.assertTrue((this.getGCThread().lastMinorCompactionTime > lastMinorCompactionTime ? 1 : 0) != 0);
        Assert.assertTrue((String)("Not found entry log files [0, 1, 4].log that should not have been compacted in: " + this.tmpDirs.getDirs().get(0)), (boolean)TestUtils.hasAllLogFiles(this.tmpDirs.getDirs().get(0), 0, 1, 4));
        Assert.assertTrue((String)("Found entry log files [2, 3].log that should have been compacted in ledgerDirectory: " + this.tmpDirs.getDirs().get(0)), (boolean)TestUtils.hasNoneLogFiles(this.tmpDirs.getDirs().get(0), 2, 3));
        ((DefaultEntryLogger)this.getGCThread().entryLogger).recentlyCreatedEntryLogsStatus.flushRotatedEntryLog(Long.valueOf(1L));
        this.getGCThread().triggerGC(true, false, false).get();
        Assert.assertTrue((String)("Found entry log file 1.log that should have been compacted in ledgerDirectory: " + this.tmpDirs.getDirs().get(0)), (boolean)TestUtils.hasNoneLogFiles(this.tmpDirs.getDirs().get(0), 1));
        this.bkc.deleteLedger(lhs[0].getId());
        this.getGCThread().triggerGC(true, false, false).get();
        Assert.assertTrue((String)("Found entry log file 0.log that should not have been compacted in ledgerDirectory: " + this.tmpDirs.getDirs().get(0)), (boolean)TestUtils.hasAllLogFiles(this.tmpDirs.getDirs().get(0), 0));
        ((DefaultEntryLogger)this.getGCThread().entryLogger).recentlyCreatedEntryLogsStatus.flushRotatedEntryLog(Long.valueOf(0L));
        this.getGCThread().triggerGC(true, false, false).get();
        Assert.assertTrue((String)("Found entry log file 0.log that should have been compacted in ledgerDirectory: " + this.tmpDirs.getDirs().get(0)), (boolean)TestUtils.hasNoneLogFiles(this.tmpDirs.getDirs().get(0), 0));
    }

    @Test
    public void testMinorCompactionWithNoWritableLedgerDirs() throws Exception {
        LedgerHandle[] lhs;
        for (LedgerHandle lh : lhs = this.prepareData(3, false)) {
            lh.close();
        }
        this.restartBookies(c -> {
            c.setMajorCompactionThreshold(0.0);
            c.setGcWaitTime(60000L);
            c.setMinorCompactionInterval(120000L);
            c.setMajorCompactionInterval(240000L);
            return c;
        });
        long lastMinorCompactionTime = this.getGCThread().lastMinorCompactionTime;
        long lastMajorCompactionTime = this.getGCThread().lastMajorCompactionTime;
        Assert.assertFalse((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertTrue((boolean)this.getGCThread().enableMinorCompaction);
        for (int i = 0; i < this.bookieCount(); ++i) {
            BookieImpl bookie = (BookieImpl)this.serverByIndex(i).getBookie();
            LedgerDirsManager ledgerDirsManager = bookie.getLedgerDirsManager();
            List ledgerDirs = ledgerDirsManager.getAllLedgerDirs();
            for (File ledgerDir : ledgerDirs) {
                ledgerDirsManager.addToFilledDirs(ledgerDir);
            }
        }
        this.bkc.deleteLedger(lhs[1].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        this.getGCThread().triggerGC().get();
        if (this.useMetadataCache) {
            Assert.assertTrue((boolean)(this.getGCThread().getEntryLogMetaMap() instanceof PersistentEntryLogMetadataMap));
        }
        Assert.assertEquals((long)lastMajorCompactionTime, (long)this.getGCThread().lastMajorCompactionTime);
        Assert.assertEquals((long)lastMinorCompactionTime, (long)this.getGCThread().lastMinorCompactionTime);
        for (File ledgerDirectory : this.bookieLedgerDirs()) {
            Assert.assertTrue((String)("All the entry log files ([0,1,2].log are not available, which is not expected" + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, false, 0, 1, 2));
        }
    }

    @Test
    public void testMinorCompactionWithNoWritableLedgerDirsButIsForceGCAllowWhenNoSpaceIsSet() throws Exception {
        List ledgerDirs;
        LedgerDirsManager ledgerDirsManager;
        BookieImpl bookie;
        LedgerHandle[] lhs;
        this.stopAllBookies();
        ServerConfiguration conf = this.newServerConfiguration();
        conf.setMajorCompactionThreshold(0.0);
        conf.setIsForceGCAllowWhenNoSpace(true);
        conf.setGcWaitTime(600000L);
        conf.setMinorCompactionInterval(120000L);
        conf.setMajorCompactionInterval(240000L);
        File ledgerDir1 = this.tmpDirs.createNew("ledger", "test1");
        File ledgerDir2 = this.tmpDirs.createNew("ledger", "test2");
        File journalDir = this.tmpDirs.createNew("journal", "test");
        String[] ledgerDirNames = new String[]{ledgerDir1.getPath(), ledgerDir2.getPath()};
        conf.setLedgerDirNames(ledgerDirNames);
        conf.setJournalDirName(journalDir.getPath());
        BookieServer server = this.startAndAddBookie(conf).getServer();
        for (LedgerHandle lh : lhs = this.prepareData(3, false)) {
            lh.close();
        }
        long lastMinorCompactionTime = this.getGCThread().lastMinorCompactionTime;
        long lastMajorCompactionTime = this.getGCThread().lastMajorCompactionTime;
        Assert.assertFalse((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertTrue((boolean)this.getGCThread().enableMinorCompaction);
        if (this.useMetadataCache) {
            Assert.assertTrue((boolean)(this.getGCThread().getEntryLogMetaMap() instanceof PersistentEntryLogMetadataMap));
        }
        for (int i = 0; i < this.bookieCount(); ++i) {
            bookie = (BookieImpl)this.serverByIndex(i).getBookie();
            bookie.getLedgerStorage().flush();
            bookie.dirsMonitor.shutdown();
            ledgerDirsManager = bookie.getLedgerDirsManager();
            ledgerDirs = ledgerDirsManager.getAllLedgerDirs();
            for (File ledgerDir : ledgerDirs) {
                ledgerDirsManager.addToFilledDirs(ledgerDir);
            }
        }
        this.bkc.deleteLedger(lhs[1].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        this.getGCThread().triggerGC(true, false, false).get();
        Assert.assertEquals((long)lastMajorCompactionTime, (long)this.getGCThread().lastMajorCompactionTime);
        Assert.assertTrue((this.getGCThread().lastMinorCompactionTime > lastMinorCompactionTime ? 1 : 0) != 0);
        for (File ledgerDirectory : ((BookieImpl)server.getBookie()).getLedgerDirsManager().getAllLedgerDirs()) {
            Assert.assertFalse((String)("Found entry log file ([0,1,2].log that should have not been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory.getParentFile(), true, 0, 1, 2));
        }
        this.verifyLedger(lhs[0].getId(), 0L, lhs[0].getLastAddConfirmed());
        for (int i = 0; i < this.bookieCount(); ++i) {
            bookie = (BookieImpl)this.serverByIndex(i).getBookie();
            ledgerDirsManager = bookie.getLedgerDirsManager();
            try {
                ledgerDirs = ledgerDirsManager.getWritableLedgerDirs();
                Assert.fail((String)"It is expected not to have any writableLedgerDirs");
                continue;
            }
            catch (LedgerDirsManager.NoWritableLedgerDirException noWritableLedgerDirException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testMajorCompaction() throws Exception {
        LedgerHandle[] lhs;
        for (LedgerHandle lh : lhs = this.prepareData(3, true)) {
            lh.close();
        }
        this.restartBookies(c -> {
            c.setMinorCompactionThreshold(0.0);
            c.setGcWaitTime(60000L);
            c.setMinorCompactionInterval(120000L);
            c.setMajorCompactionInterval(240000L);
            return c;
        });
        long lastMinorCompactionTime = this.getGCThread().lastMinorCompactionTime;
        long lastMajorCompactionTime = this.getGCThread().lastMajorCompactionTime;
        Assert.assertTrue((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertFalse((boolean)this.getGCThread().enableMinorCompaction);
        this.bkc.deleteLedger(lhs[0].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        if (this.useMetadataCache) {
            Assert.assertTrue((boolean)(this.getGCThread().getEntryLogMetaMap() instanceof PersistentEntryLogMetadataMap));
        }
        Assert.assertTrue((this.getGCThread().lastMinorCompactionTime > lastMinorCompactionTime ? 1 : 0) != 0);
        Assert.assertTrue((this.getGCThread().lastMajorCompactionTime > lastMajorCompactionTime ? 1 : 0) != 0);
        for (File ledgerDirectory : this.bookieLedgerDirs()) {
            Assert.assertFalse((String)("Found entry log file ([0,1,2].log that should have not been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0, 1, 2));
        }
        this.verifyLedger(lhs[1].getId(), 0L, lhs[1].getLastAddConfirmed());
    }

    @Test
    public void testForceMajorCompaction() throws Exception {
        LedgerHandle[] lhs;
        for (LedgerHandle lh : lhs = this.prepareData(3, true)) {
            lh.close();
        }
        this.restartBookies(c -> {
            c.setMinorCompactionThreshold(0.0);
            c.setGcWaitTime(60000L);
            c.setMinorCompactionInterval(-1L);
            c.setMajorCompactionInterval(-1L);
            c.setForceAllowCompaction(true);
            return c;
        });
        long lastMinorCompactionTime = this.getGCThread().lastMinorCompactionTime;
        long lastMajorCompactionTime = this.getGCThread().lastMajorCompactionTime;
        Assert.assertFalse((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertFalse((boolean)this.getGCThread().enableMinorCompaction);
        Assert.assertTrue((boolean)this.getGCThread().isForceMajorCompactionAllow);
        Assert.assertFalse((boolean)this.getGCThread().isForceMinorCompactionAllow);
        this.bkc.deleteLedger(lhs[0].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        if (this.useMetadataCache) {
            Assert.assertTrue((boolean)(this.getGCThread().getEntryLogMetaMap() instanceof PersistentEntryLogMetadataMap));
        }
        Assert.assertTrue((this.getGCThread().lastMinorCompactionTime > lastMinorCompactionTime ? 1 : 0) != 0);
        Assert.assertTrue((this.getGCThread().lastMajorCompactionTime > lastMajorCompactionTime ? 1 : 0) != 0);
        for (File ledgerDirectory : this.tmpDirs.getDirs()) {
            Assert.assertFalse((String)("Found entry log file ([0,1,2].log that should have not been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0, 1, 2));
        }
        this.verifyLedger(lhs[1].getId(), 0L, lhs[1].getLastAddConfirmed());
    }

    @Test
    public void testCompactionPersistence() throws Exception {
        LedgerHandle[] lhs;
        Assert.assertEquals((String)"Numbers of Bookies in this cluster", (long)1L, (long)this.numBookies);
        Assert.assertFalse((String)"Bookies must be using EntryLogCompactor", (boolean)this.baseConf.getUseTransactionalCompaction());
        for (LedgerHandle lh : lhs = this.prepareData(3, true)) {
            lh.close();
        }
        this.restartBookies(c -> {
            c.setMinorCompactionThreshold(0.0);
            c.setGcWaitTime(60000L);
            c.setMinorCompactionInterval(120000L);
            c.setMajorCompactionInterval(240000L);
            return c;
        });
        long lastMinorCompactionTime = this.getGCThread().lastMinorCompactionTime;
        long lastMajorCompactionTime = this.getGCThread().lastMajorCompactionTime;
        Assert.assertTrue((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertFalse((boolean)this.getGCThread().enableMinorCompaction);
        this.bkc.deleteLedger(lhs[0].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        Assert.assertTrue((this.getGCThread().lastMinorCompactionTime > lastMinorCompactionTime ? 1 : 0) != 0);
        Assert.assertTrue((this.getGCThread().lastMajorCompactionTime > lastMajorCompactionTime ? 1 : 0) != 0);
        for (File ledgerDirectory : this.bookieLedgerDirs()) {
            Assert.assertFalse((String)("Found entry log file ([0,1,2].log that should have not been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0, 1, 2));
        }
        long ledgerId = lhs[1].getId();
        long lastAddConfirmed = lhs[1].getLastAddConfirmed();
        this.verifyLedger(ledgerId, 0L, lastAddConfirmed);
        ServerConfiguration bookieServerConfig = ((BookieImpl)this.serverByIndex((int)0).getBookie()).conf;
        ServerConfiguration newBookieConf = new ServerConfiguration((AbstractConfiguration)bookieServerConfig);
        newBookieConf.setMetadataServiceUri(null);
        String entryLogCachePath = this.tmpDirs.createNew("entry", "bk2").getAbsolutePath();
        newBookieConf.setGcEntryLogMetadataCachePath(entryLogCachePath);
        TestBookieImpl newbookie = new TestBookieImpl(newBookieConf);
        DigestManager digestManager = DigestManager.instantiate((long)ledgerId, (byte[])this.passwdBytes, (DataFormats.LedgerMetadataFormat.DigestType)BookKeeper.DigestType.toProtoDigestType((BookKeeper.DigestType)this.digestType), (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)this.baseClientConf.getUseV2WireProtocol());
        for (long entryId = 0L; entryId <= lastAddConfirmed; ++entryId) {
            ByteBuf readEntryBufWithChecksum = newbookie.readEntry(ledgerId, entryId);
            ByteBuf readEntryBuf = digestManager.verifyDigestAndReturnData(entryId, readEntryBufWithChecksum);
            byte[] readEntryBytes = new byte[readEntryBuf.readableBytes()];
            readEntryBuf.readBytes(readEntryBytes);
            Assert.assertEquals((Object)this.msg, (Object)new String(readEntryBytes));
        }
    }

    @Test
    public void testCompactionWhenLedgerDirsAreFull() throws Exception {
        LedgerHandle[] lhs;
        Assert.assertEquals((String)"Numbers of Bookies in this cluster", (long)1L, (long)this.bookieCount());
        ServerConfiguration serverConfig = this.confByIndex(0);
        File ledgerDir = serverConfig.getLedgerDirs()[0];
        Assert.assertEquals((String)"Number of Ledgerdirs for this bookie", (long)1L, (long)serverConfig.getLedgerDirs().length);
        Assert.assertTrue((String)"indexdirs should be configured to null", (null == serverConfig.getIndexDirs() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Bookies must be using EntryLogCompactor", (boolean)this.baseConf.getUseTransactionalCompaction());
        for (LedgerHandle lh : lhs = this.prepareData(3, true)) {
            lh.close();
        }
        this.serverByIndex(0).getBookie().getLedgerStorage().flush();
        Assert.assertTrue((String)("entry log file ([0,1,2].log should be available in ledgerDirectory: " + serverConfig.getLedgerDirs()[0]), (boolean)TestUtils.hasLogFiles(serverConfig.getLedgerDirs()[0], false, 0, 1, 2));
        long usableSpace = ledgerDir.getUsableSpace();
        long totalSpace = ledgerDir.getTotalSpace();
        this.restartBookies(c -> {
            c.setForceReadOnlyBookie(true);
            c.setIsForceGCAllowWhenNoSpace(true);
            c.setMinorCompactionThreshold(0.0);
            c.setGcWaitTime(60000L);
            c.setMinorCompactionInterval(120000L);
            c.setMajorCompactionInterval(240000L);
            c.setMinUsableSizeForEntryLogCreation(1L);
            c.setMinUsableSizeForIndexFileCreation(1L);
            c.setDiskUsageThreshold((1.0f - (float)usableSpace / (float)totalSpace) * 0.9f);
            c.setDiskUsageWarnThreshold(0.0f);
            return c;
        });
        Assert.assertFalse((String)"There shouldn't be any writable ledgerDir", (boolean)((BookieImpl)this.serverByIndex(0).getBookie()).getLedgerDirsManager().hasWritableLedgerDirs());
        long lastMinorCompactionTime = this.getGCThread().lastMinorCompactionTime;
        long lastMajorCompactionTime = this.getGCThread().lastMajorCompactionTime;
        Assert.assertTrue((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertFalse((boolean)this.getGCThread().enableMinorCompaction);
        this.bkc.deleteLedger(lhs[0].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        if (this.useMetadataCache) {
            Assert.assertTrue((boolean)(this.getGCThread().getEntryLogMetaMap() instanceof PersistentEntryLogMetadataMap));
        }
        Assert.assertTrue((this.getGCThread().lastMinorCompactionTime > lastMinorCompactionTime ? 1 : 0) != 0);
        Assert.assertTrue((this.getGCThread().lastMajorCompactionTime > lastMajorCompactionTime ? 1 : 0) != 0);
        for (File ledgerDirectory : this.bookieLedgerDirs()) {
            Assert.assertFalse((String)("Found entry log file ([0,1,2].log that should have not been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0, 1, 2));
        }
        long ledgerId = lhs[1].getId();
        long lastAddConfirmed = lhs[1].getLastAddConfirmed();
        this.verifyLedger(ledgerId, 0L, lastAddConfirmed);
    }

    @Test
    public void testMajorCompactionAboveThreshold() throws Exception {
        LedgerHandle[] lhs;
        for (LedgerHandle lh : lhs = this.prepareData(3, false)) {
            lh.close();
        }
        long lastMinorCompactionTime = this.getGCThread().lastMinorCompactionTime;
        long lastMajorCompactionTime = this.getGCThread().lastMajorCompactionTime;
        Assert.assertTrue((boolean)this.getGCThread().enableMajorCompaction);
        Assert.assertTrue((boolean)this.getGCThread().enableMinorCompaction);
        this.bkc.deleteLedger(lhs[0].getId());
        this.bkc.deleteLedger(lhs[1].getId());
        LOG.info("Finished deleting the ledgers contains less entries.");
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        Assert.assertTrue((this.getGCThread().lastMinorCompactionTime > lastMinorCompactionTime ? 1 : 0) != 0);
        Assert.assertTrue((this.getGCThread().lastMajorCompactionTime > lastMajorCompactionTime ? 1 : 0) != 0);
        for (File ledgerDirectory : this.bookieLedgerDirs()) {
            Assert.assertTrue((String)("Not Found entry log file ([1,2].log that should have been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, false, 0, 1, 2));
        }
    }

    @Test
    public void testCompactionSmallEntryLogs() throws Exception {
        LedgerHandle alh = this.bkc.createLedger(1, 1, this.digestType, "".getBytes());
        for (int i = 0; i < 3; ++i) {
            alh.addEntry(this.msg.getBytes());
        }
        alh.close();
        this.restartBookies();
        LedgerHandle[] lhs = this.prepareData(3, false);
        for (LedgerHandle lh : lhs) {
            lh.close();
        }
        this.bkc.deleteLedger(lhs[1].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        this.restartBookies();
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        if (this.useMetadataCache) {
            Assert.assertTrue((boolean)(this.getGCThread().getEntryLogMetaMap() instanceof PersistentEntryLogMetadataMap));
        }
        for (File ledgerDirectory : this.bookieLedgerDirs()) {
            Assert.assertTrue((String)("Not Found entry log file ([0].log that should have been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0));
            Assert.assertFalse((String)("Found entry log file ([1,2,3].log that should have not been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 1, 2, 3));
        }
        this.verifyLedger(lhs[0].getId(), 0L, lhs[0].getLastAddConfirmed());
    }

    @Test
    public void testCompactionSafety() throws Exception {
        this.tearDown();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        Set<Long> ledgers = Collections.newSetFromMap(new ConcurrentHashMap());
        LedgerManager manager = this.getLedgerManager(ledgers);
        File tmpDir = this.tmpDirs.createNew("bkTest", ".dir");
        File curDir = BookieImpl.getCurrentDirectory((File)tmpDir);
        BookieImpl.checkDirectoryStructure((File)curDir);
        conf.setLedgerDirNames(new String[]{tmpDir.toString()});
        conf.setEntryLogSizeLimit(4108L);
        conf.setGcWaitTime(100L);
        conf.setMinorCompactionThreshold((double)0.7f);
        conf.setMajorCompactionThreshold(0.0);
        conf.setMinorCompactionInterval(1L);
        conf.setMajorCompactionInterval(10L);
        conf.setPageLimit(1);
        CheckpointSource checkpointSource = new CheckpointSource(){
            AtomicInteger idGen = new AtomicInteger(0);

            public CheckpointSource.Checkpoint newCheckpoint() {
                return new MyCheckpoint();
            }

            public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
            }

            class MyCheckpoint
            implements CheckpointSource.Checkpoint {
                int id;

                MyCheckpoint() {
                    this.id = idGen.incrementAndGet();
                }

                public int compareTo(CheckpointSource.Checkpoint o) {
                    if (o == CheckpointSource.Checkpoint.MAX) {
                        return -1;
                    }
                    if (o == CheckpointSource.Checkpoint.MIN) {
                        return 1;
                    }
                    return this.id - ((MyCheckpoint)o).id;
                }
            }
        };
        byte[] key = "foobar".getBytes();
        File log0 = new File(curDir, "0.log");
        LedgerDirsManager dirs = new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
        Assert.assertFalse((String)"Log shouldnt exist", (boolean)log0.exists());
        InterleavedLedgerStorage storage = new InterleavedLedgerStorage();
        storage.initialize(conf, manager, dirs, dirs, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        storage.setCheckpointSource(checkpointSource);
        storage.setCheckpointer(Checkpointer.NULL);
        ledgers.add(1L);
        ledgers.add(2L);
        ledgers.add(3L);
        storage.setMasterKey(1L, key);
        storage.setMasterKey(2L, key);
        storage.setMasterKey(3L, key);
        storage.addEntry(this.genEntry(1L, 1L, 1024));
        storage.addEntry(this.genEntry(2L, 1L, 1024));
        storage.addEntry(this.genEntry(2L, 2L, 1024));
        storage.addEntry(this.genEntry(3L, 2L, 1024));
        storage.flush();
        storage.shutdown();
        Assert.assertTrue((String)"Log should exist", (boolean)log0.exists());
        ledgers.remove(2L);
        ledgers.remove(3L);
        storage = new InterleavedLedgerStorage();
        storage.initialize(conf, manager, dirs, dirs, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        storage.setCheckpointSource(checkpointSource);
        storage.setCheckpointer(Checkpointer.NULL);
        storage.start();
        for (int i = 0; i < 10 && log0.exists(); ++i) {
            Thread.sleep(1000L);
            storage.entryLogger.flush();
        }
        Assert.assertFalse((String)"Log shouldnt exist", (boolean)log0.exists());
        ledgers.add(4L);
        storage.setMasterKey(4L, key);
        storage.addEntry(this.genEntry(4L, 1L, 1024));
        storage.shutdown();
        storage = new InterleavedLedgerStorage();
        storage.initialize(conf, manager, dirs, dirs, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        storage.setCheckpointSource(checkpointSource);
        storage.setCheckpointer(Checkpointer.NULL);
        storage.getEntry(1L, 1L);
    }

    @Test
    public void testCancelledCompactionWhenShuttingDown() throws Exception {
        LedgerHandle[] lhs = this.prepareData(3, false);
        this.restartBookies(c -> {
            c.setIsThrottleByBytes(true);
            c.setCompactionRateByBytes(1);
            c.setMinorCompactionThreshold((double)0.2f);
            c.setMajorCompactionThreshold(0.5);
            return c;
        });
        this.bkc.deleteLedger(lhs[1].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        this.getGCThread().triggerGC(true, false, false);
        this.getGCThread().throttler.cancelledAcquire();
        this.waitUntilTrue(() -> {
            try {
                return this.getGCThread().compacting.get();
            }
            catch (Exception e) {
                Assert.fail((String)"Get GC thread failed");
                return null;
            }
        }, () -> "Not attempting to complete", 10000L, 200L);
        this.getGCThread().shutdown();
        Assert.assertFalse((boolean)this.getGCThread().running);
    }

    private void waitUntilTrue(Supplier<Boolean> condition, Supplier<String> msg, long waitTime, long pause) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        while (!condition.get().booleanValue()) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                Assert.fail((String)msg.get());
            }
            Thread.sleep(Math.min(waitTime, pause));
        }
        return;
    }

    private LedgerManager getLedgerManager(final Set<Long> ledgers) {
        LedgerManager manager = new LedgerManager(){

            public CompletableFuture<Versioned<LedgerMetadata>> createLedgerMetadata(long lid, LedgerMetadata metadata) {
                this.unsupported();
                return null;
            }

            public CompletableFuture<Void> removeLedgerMetadata(long ledgerId, Version version) {
                this.unsupported();
                return null;
            }

            public CompletableFuture<Versioned<LedgerMetadata>> readLedgerMetadata(long ledgerId) {
                this.unsupported();
                return null;
            }

            public CompletableFuture<Versioned<LedgerMetadata>> writeLedgerMetadata(long ledgerId, LedgerMetadata metadata, Version currentVersion) {
                this.unsupported();
                return null;
            }

            public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, Object context, int successRc, int failureRc) {
                this.unsupported();
            }

            public void registerLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
                this.unsupported();
            }

            public void unregisterLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
                this.unsupported();
            }

            public void close() throws IOException {
            }

            void unsupported() {
                LOG.error("Unsupported operation called", (Throwable)new Exception());
                throw new RuntimeException("Unsupported op");
            }

            public LedgerManager.LedgerRangeIterator getLedgerRanges(long zkOpTimeoutMs) {
                final AtomicBoolean hasnext = new AtomicBoolean(true);
                return new LedgerManager.LedgerRangeIterator(){

                    public boolean hasNext() throws IOException {
                        return hasnext.get();
                    }

                    public LedgerManager.LedgerRange next() throws IOException {
                        hasnext.set(false);
                        return new LedgerManager.LedgerRange(ledgers);
                    }
                };
            }
        };
        return manager;
    }

    @Test
    public void testWhenNoLogsToCompact() throws Exception {
        this.tearDown();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        File tmpDir = this.tmpDirs.createNew("bkTest", ".dir");
        File curDir = BookieImpl.getCurrentDirectory((File)tmpDir);
        BookieImpl.checkDirectoryStructure((File)curDir);
        conf.setLedgerDirNames(new String[]{tmpDir.toString()});
        LedgerDirsManager dirs = new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
        Set<Long> ledgers = Collections.newSetFromMap(new ConcurrentHashMap());
        LedgerManager manager = this.getLedgerManager(ledgers);
        CheckpointSource checkpointSource = new CheckpointSource(){

            public CheckpointSource.Checkpoint newCheckpoint() {
                return null;
            }

            public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
            }
        };
        InterleavedLedgerStorage storage = new InterleavedLedgerStorage();
        storage.initialize(conf, manager, dirs, dirs, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        storage.setCheckpointSource(checkpointSource);
        storage.setCheckpointer(Checkpointer.NULL);
        double threshold = 0.1;
        long limit = 0L;
        storage.gcThread.doCompactEntryLogs(threshold, limit);
    }

    private ByteBuf genEntry(long ledger, long entry, int size) {
        ByteBuf bb = Unpooled.buffer((int)size);
        bb.writeLong(ledger);
        bb.writeLong(entry);
        while (bb.isWritable()) {
            bb.writeByte(-1);
        }
        return bb;
    }

    @Test
    public void testSuspendGarbageCollection() throws Exception {
        ServerConfiguration conf = this.newServerConfiguration();
        conf.setGcWaitTime(500L);
        conf.setMinorCompactionInterval(1L);
        conf.setMajorCompactionInterval(2L);
        conf.setMajorCompactionMaxTimeMillis(5000L);
        MetadataDrivers.runFunctionWithLedgerManagerFactory((ServerConfiguration)conf, lmf -> {
            try (LedgerManager lm = lmf.newLedgerManager();){
                this.testSuspendGarbageCollection(conf, lm);
            }
            catch (Exception e) {
                throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
            }
            return null;
        });
    }

    private void testSuspendGarbageCollection(ServerConfiguration conf, LedgerManager lm) throws Exception {
        LedgerDirsManager dirManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
        CheckpointSource cp = new CheckpointSource(){

            public CheckpointSource.Checkpoint newCheckpoint() {
                return null;
            }

            public void checkpointComplete(CheckpointSource.Checkpoint checkPoint, boolean compact) throws IOException {
            }
        };
        for (File journalDir : conf.getJournalDirs()) {
            BookieImpl.checkDirectoryStructure((File)journalDir);
        }
        for (File dir : dirManager.getAllLedgerDirs()) {
            BookieImpl.checkDirectoryStructure((File)dir);
        }
        InterleavedLedgerStorage storage = new InterleavedLedgerStorage();
        TestStatsProvider stats = new TestStatsProvider();
        storage.initialize(conf, lm, dirManager, dirManager, (StatsLogger)stats.getStatsLogger("storage"), (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        storage.setCheckpointSource(cp);
        storage.setCheckpointer(Checkpointer.NULL);
        storage.start();
        int majorCompactions = stats.getCounter("storage.gc.MAJOR_COMPACTION_TOTAL").get().intValue();
        int minorCompactions = stats.getCounter("storage.gc.MINOR_COMPACTION_TOTAL").get().intValue();
        Thread.sleep(3L * (conf.getMajorCompactionInterval() * 1000L + conf.getGcWaitTime() + conf.getMajorCompactionMaxTimeMillis()));
        Assert.assertTrue((String)"Major compaction should have happened", (stats.getCounter("storage.gc.MAJOR_COMPACTION_TOTAL").get() > (long)majorCompactions ? 1 : 0) != 0);
        storage.gcThread.suspendMajorGC();
        Thread.sleep(1000L);
        long startTime = System.currentTimeMillis();
        majorCompactions = stats.getCounter("storage.gc.MAJOR_COMPACTION_TOTAL").get().intValue();
        Thread.sleep(conf.getMajorCompactionInterval() * 1000L + conf.getGcWaitTime());
        Assert.assertTrue((String)"major compaction triggered while suspended", (storage.gcThread.lastMajorCompactionTime < startTime ? 1 : 0) != 0);
        Assert.assertTrue((String)"major compaction triggered while suspended", (stats.getCounter("storage.gc.MAJOR_COMPACTION_TOTAL").get() == (long)majorCompactions ? 1 : 0) != 0);
        Thread.sleep(conf.getMinorCompactionInterval() * 1000L + conf.getGcWaitTime());
        Assert.assertTrue((String)"Minor compaction should have happened", (stats.getCounter("storage.gc.MINOR_COMPACTION_TOTAL").get() > (long)minorCompactions ? 1 : 0) != 0);
        storage.gcThread.suspendMinorGC();
        Thread.sleep(1000L);
        startTime = System.currentTimeMillis();
        minorCompactions = stats.getCounter("storage.gc.MINOR_COMPACTION_TOTAL").get().intValue();
        Thread.sleep(conf.getMajorCompactionInterval() * 1000L + conf.getGcWaitTime());
        Assert.assertTrue((String)"minor compaction triggered while suspended", (storage.gcThread.lastMinorCompactionTime < startTime ? 1 : 0) != 0);
        Assert.assertTrue((String)"minor compaction triggered while suspended", (stats.getCounter("storage.gc.MINOR_COMPACTION_TOTAL").get() == (long)minorCompactions ? 1 : 0) != 0);
        storage.gcThread.resumeMinorGC();
        storage.gcThread.resumeMajorGC();
        Thread.sleep((conf.getMajorCompactionInterval() + conf.getMinorCompactionInterval()) * 1000L + conf.getGcWaitTime() * 2L);
        Assert.assertTrue((String)"Major compaction should have happened", (stats.getCounter("storage.gc.MAJOR_COMPACTION_TOTAL").get() > (long)majorCompactions ? 1 : 0) != 0);
        Assert.assertTrue((String)"Minor compaction should have happened", (stats.getCounter("storage.gc.MINOR_COMPACTION_TOTAL").get() > (long)minorCompactions ? 1 : 0) != 0);
        Assert.assertTrue((String)"gcThreadRunttime should be non-zero", (stats.getOpStatsLogger("storage.gc.THREAD_RUNTIME").getSuccessCount() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverIndexWhenIndexIsPartiallyFlush() throws Exception {
        LedgerHandle[] lhs;
        for (LedgerHandle lh : lhs = this.prepareData(3, false)) {
            lh.close();
        }
        this.restartBookies(c -> {
            c.setMinorCompactionThreshold(0.0);
            c.setMajorCompactionThreshold(0.0);
            c.setGcWaitTime(600000L);
            return c;
        });
        BookieImpl bookie = (BookieImpl)this.serverByIndex(0).getBookie();
        InterleavedLedgerStorage storage = (InterleavedLedgerStorage)bookie.ledgerStorage;
        this.bkc.deleteLedger(lhs[1].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        MockTransactionalEntryLogCompactor partialCompactionWorker = new MockTransactionalEntryLogCompactor(((InterleavedLedgerStorage)bookie.getLedgerStorage()).gcThread);
        for (long logId = 0L; logId < 3L; ++logId) {
            EntryLogMetadata meta = storage.entryLogger.getEntryLogMetadata(logId);
            partialCompactionWorker.compactWithIndexFlushFailure(meta);
        }
        for (File ledgerDirectory : this.bookieLedgerDirs()) {
            Assert.assertTrue((String)("Entry log file ([0,1,2].log should not be compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0, 1, 2));
        }
        this.verifyLedger(lhs[0].getId(), 0L, lhs[0].getLastAddConfirmed());
        Assert.assertEquals((long)this.findCompactedEntryLogFiles().size(), (long)3L);
        partialCompactionWorker.cleanUpAndRecover();
        Assert.assertEquals((long)this.findCompactedEntryLogFiles().size(), (long)0L);
        for (File ledgerDirectory : this.bookieLedgerDirs()) {
            Assert.assertFalse((String)("Entry log file ([0,1,2].log should have been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0, 1, 2));
        }
        this.verifyLedger(lhs[0].getId(), 0L, lhs[0].getLastAddConfirmed());
    }

    @Test
    public void testCompactionFailureShouldNotResultInDuplicatedData() throws Exception {
        LedgerHandle[] lhs;
        for (LedgerHandle lh : lhs = this.prepareData(5, false)) {
            lh.close();
        }
        this.restartBookies(c -> {
            c.setMinorCompactionThreshold(0.0);
            c.setMajorCompactionThreshold(0.0);
            c.setUseTransactionalCompaction(true);
            return c;
        });
        this.bkc.deleteLedger(lhs[1].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        LOG.info("Finished deleting the ledgers contains most entries.");
        Thread.sleep(this.baseConf.getMajorCompactionInterval() * 1000L + this.baseConf.getGcWaitTime());
        BookieImpl bookie = (BookieImpl)this.serverByIndex(0).getBookie();
        InterleavedLedgerStorage storage = (InterleavedLedgerStorage)bookie.ledgerStorage;
        List ledgerDirs = bookie.getLedgerDirsManager().getAllLedgerDirs();
        ArrayList usageBeforeCompaction = new ArrayList();
        ledgerDirs.forEach(file -> usageBeforeCompaction.add(this.getDirectorySpaceUsage((File)file)));
        MockTransactionalEntryLogCompactor partialCompactionWorker = new MockTransactionalEntryLogCompactor(((InterleavedLedgerStorage)bookie.ledgerStorage).gcThread);
        for (long logId = 0L; logId < 5L; ++logId) {
            EntryLogMetadata meta = storage.entryLogger.getEntryLogMetadata(logId);
            partialCompactionWorker.compactWithLogFlushFailure(meta);
        }
        for (File ledgerDirectory : this.bookieLedgerDirs()) {
            Assert.assertTrue((String)("Entry log file ([0,1,2].log should not be compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0, 1, 2, 3, 4));
        }
        this.verifyLedger(lhs[0].getId(), 0L, lhs[0].getLastAddConfirmed());
        ArrayList freeSpaceAfterCompactionFailed = new ArrayList();
        ledgerDirs.forEach(file -> freeSpaceAfterCompactionFailed.add(this.getDirectorySpaceUsage((File)file)));
        for (int i = 0; i < usageBeforeCompaction.size(); ++i) {
            Assert.assertEquals(usageBeforeCompaction.get(i), freeSpaceAfterCompactionFailed.get(i));
        }
        this.restartBookies(c -> {
            c.setMajorCompactionThreshold(0.5);
            c.setMajorCompactionMaxTimeMillis(5000L);
            return c;
        });
        this.getGCThread().enableForceGC();
        this.getGCThread().triggerGC().get();
        Thread.sleep(this.confByIndex(0).getMajorCompactionInterval() * 1000L + this.confByIndex(0).getGcWaitTime() + this.confByIndex(0).getMajorCompactionMaxTimeMillis());
        for (File ledgerDirectory : this.bookieLedgerDirs()) {
            Assert.assertFalse((String)("Entry log file ([0,1,2].log should have been compacted in ledgerDirectory: " + ledgerDirectory), (boolean)TestUtils.hasLogFiles(ledgerDirectory, true, 0, 1, 2, 3, 4));
        }
        this.verifyLedger(lhs[0].getId(), 0L, lhs[0].getLastAddConfirmed());
    }

    private long getDirectorySpaceUsage(File dir) {
        long size = 0L;
        for (File file : dir.listFiles()) {
            size += file.length();
        }
        return size;
    }

    private Set<File> findCompactedEntryLogFiles() throws Exception {
        HashSet<File> compactedLogFiles = new HashSet<File>();
        for (File ledgerDirectory : this.bookieLedgerDirs()) {
            File[] files = BookieImpl.getCurrentDirectory((File)ledgerDirectory).listFiles(file -> file.getName().endsWith(".compacted"));
            if (files == null) continue;
            Collections.addAll(compactedLogFiles, files);
        }
        return compactedLogFiles;
    }

    private static class MockTransactionalEntryLogCompactor
    extends TransactionalEntryLogCompactor {
        public MockTransactionalEntryLogCompactor(GarbageCollectorThread gcThread) {
            super(gcThread.conf, gcThread.entryLogger, gcThread.ledgerStorage, entry -> {
                try {
                    gcThread.removeEntryLog(entry);
                }
                catch (BookieException.EntryLogMetadataMapException e) {
                    LOG.warn("Failed to remove entry-log metadata {}", (Object)entry, (Object)e);
                }
            });
        }

        synchronized void compactWithIndexFlushFailure(EntryLogMetadata metadata) throws IOException {
            LOG.info("Compacting entry log {}.", (Object)metadata.getEntryLogId());
            CompactionEntryLog compactionLog = this.entryLogger.newCompactionLog(metadata.getEntryLogId());
            TransactionalEntryLogCompactor.ScanEntryLogPhase scanEntryLog = new TransactionalEntryLogCompactor.ScanEntryLogPhase((TransactionalEntryLogCompactor)this, metadata, compactionLog);
            if (!scanEntryLog.run()) {
                LOG.info("Compaction for {} end in ScanEntryLogPhase.", (Object)metadata.getEntryLogId());
                return;
            }
            TransactionalEntryLogCompactor.FlushCompactionLogPhase flushCompactionLog = new TransactionalEntryLogCompactor.FlushCompactionLogPhase((TransactionalEntryLogCompactor)this, compactionLog);
            if (!flushCompactionLog.run()) {
                LOG.info("Compaction for {} end in FlushCompactionLogPhase.", (Object)metadata.getEntryLogId());
                return;
            }
            PartialFlushIndexPhase partialFlushIndexPhase = new PartialFlushIndexPhase(compactionLog);
            if (!partialFlushIndexPhase.run()) {
                LOG.info("Compaction for {} end in PartialFlushIndexPhase.", (Object)metadata.getEntryLogId());
                return;
            }
            this.logRemovalListener.removeEntryLog(metadata.getEntryLogId());
            LOG.info("Compacted entry log : {}.", (Object)metadata.getEntryLogId());
        }

        synchronized void compactWithLogFlushFailure(EntryLogMetadata metadata) throws IOException {
            LOG.info("Compacting entry log {}", (Object)metadata.getEntryLogId());
            CompactionEntryLog compactionLog = this.entryLogger.newCompactionLog(metadata.getEntryLogId());
            TransactionalEntryLogCompactor.ScanEntryLogPhase scanEntryLog = new TransactionalEntryLogCompactor.ScanEntryLogPhase((TransactionalEntryLogCompactor)this, metadata, compactionLog);
            if (!scanEntryLog.run()) {
                LOG.info("Compaction for {} end in ScanEntryLogPhase.", (Object)metadata.getEntryLogId());
                return;
            }
            LogFlushFailurePhase logFlushFailurePhase = new LogFlushFailurePhase(compactionLog);
            if (!logFlushFailurePhase.run()) {
                LOG.info("Compaction for {} end in FlushCompactionLogPhase.", (Object)metadata.getEntryLogId());
                return;
            }
            TransactionalEntryLogCompactor.UpdateIndexPhase updateIndex = new TransactionalEntryLogCompactor.UpdateIndexPhase((TransactionalEntryLogCompactor)this, compactionLog);
            if (!updateIndex.run()) {
                LOG.info("Compaction for entry log {} end in UpdateIndexPhase.", (Object)metadata.getEntryLogId());
                return;
            }
            this.logRemovalListener.removeEntryLog(metadata.getEntryLogId());
            LOG.info("Compacted entry log : {}.", (Object)metadata.getEntryLogId());
        }

        private class LogFlushFailurePhase
        extends TransactionalEntryLogCompactor.FlushCompactionLogPhase {
            LogFlushFailurePhase(CompactionEntryLog compactionEntryLog) {
                super((TransactionalEntryLogCompactor)MockTransactionalEntryLogCompactor.this, compactionEntryLog);
            }

            void start() throws IOException {
                this.compactionLog.flush();
                throw new IOException("Encounter IOException when trying to flush compaction log");
            }
        }

        private class PartialFlushIndexPhase
        extends TransactionalEntryLogCompactor.UpdateIndexPhase {
            public PartialFlushIndexPhase(CompactionEntryLog compactionLog) {
                super((TransactionalEntryLogCompactor)MockTransactionalEntryLogCompactor.this, compactionLog);
            }

            void start() throws IOException {
                this.compactionLog.makeAvailable();
                Assert.assertTrue((MockTransactionalEntryLogCompactor.this.offsets.size() > 1 ? 1 : 0) != 0);
                EntryLocation el = (EntryLocation)MockTransactionalEntryLogCompactor.this.offsets.get(0);
                MockTransactionalEntryLogCompactor.this.ledgerStorage.updateEntriesLocations((Iterable)MockTransactionalEntryLogCompactor.this.offsets);
                MockTransactionalEntryLogCompactor.this.ledgerStorage.flushEntriesLocationsIndex();
                throw new IOException("Flush ledger index encounter exception");
            }
        }
    }
}

