/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.bookie.Cookie;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.shaded.com.google.common.collect.Maps;
import org.apache.bookkeeper.tools.cli.commands.bookie.LastMarkCommand;
import org.apache.bookkeeper.tools.cli.commands.bookies.ClusterInfoCommand;
import org.apache.bookkeeper.tools.cli.commands.bookies.ListBookiesCommand;
import org.apache.bookkeeper.tools.cli.commands.client.SimpleTestCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.util.EntryFormatter;
import org.apache.bookkeeper.util.LedgerIdFormatter;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.ParseException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class BookieShellTest {
    private ClientConfiguration clientConf;
    private BookieShell shell;
    private BookKeeperAdmin admin;
    private RegistrationManager rm;
    private Cookie cookie;
    private Version version;
    private ListBookiesCommand.Flags mockListBookiesFlags;
    private ListBookiesCommand mockListBookiesCommand;
    private MockedStatic<ListBookiesCommand> listBookiesCommandMockedStatic;
    private MockedStatic<MetadataDrivers> metadataDriversMockedStatic;
    private MockedStatic<BookKeeperAdmin> bookKeeperAdminMockedStatic;
    private MockedStatic<ListBookiesCommand.Flags> listBookiesCommandflagsMockedStatic;

    @Before
    public void setup() throws Exception {
        this.shell = new BookieShell(LedgerIdFormatter.LONG_LEDGERID_FORMATTER, EntryFormatter.STRING_FORMATTER);
        this.mockListBookiesFlags = (ListBookiesCommand.Flags)Mockito.spy((Object)new ListBookiesCommand.Flags());
        this.listBookiesCommandflagsMockedStatic = Mockito.mockStatic(ListBookiesCommand.Flags.class);
        this.listBookiesCommandflagsMockedStatic.when(() -> ListBookiesCommand.Flags.newFlags()).thenReturn((Object)this.mockListBookiesFlags);
        this.mockListBookiesCommand = (ListBookiesCommand)Mockito.spy((Object)new ListBookiesCommand());
        ((ListBookiesCommand)Mockito.doReturn((Object)true).when((Object)this.mockListBookiesCommand)).apply((ServerConfiguration)ArgumentMatchers.any(ServerConfiguration.class), (CliFlags)ArgumentMatchers.any(ListBookiesCommand.Flags.class));
        this.listBookiesCommandMockedStatic = Mockito.mockStatic(ListBookiesCommand.class);
        this.listBookiesCommandMockedStatic.when(() -> ListBookiesCommand.newListBookiesCommand((ListBookiesCommand.Flags)this.mockListBookiesFlags)).thenReturn((Object)this.mockListBookiesCommand);
        this.admin = (BookKeeperAdmin)Mockito.mock(BookKeeperAdmin.class);
        this.bookKeeperAdminMockedStatic = Mockito.mockStatic(BookKeeperAdmin.class);
        this.bookKeeperAdminMockedStatic.when(() -> BookKeeperAdmin.newBookKeeperAdmin((ClientConfiguration)((ClientConfiguration)ArgumentMatchers.any(ClientConfiguration.class)))).thenReturn((Object)this.admin);
        this.clientConf = new ClientConfiguration();
        this.clientConf.setMetadataServiceUri("zk://127.0.0.1/path/to/ledgers");
        Mockito.when((Object)this.admin.getConf()).thenReturn((Object)this.clientConf);
        this.rm = (RegistrationManager)Mockito.mock(RegistrationManager.class);
        this.cookie = Cookie.newBuilder().setBookieId("127.0.0.1:3181").setInstanceId("xyz").setJournalDirs("/path/to/journal/dir").setLedgerDirs("/path/to/journal/dir").setLayoutVersion(5).build();
        this.version = new LongVersion(1L);
        Mockito.when((Object)this.rm.readCookie((BookieId)ArgumentMatchers.any(BookieId.class))).thenReturn((Object)new Versioned((Object)this.cookie.toString().getBytes(StandardCharsets.UTF_8), this.version));
        this.metadataDriversMockedStatic = Mockito.mockStatic(MetadataDrivers.class);
        this.metadataDriversMockedStatic.when(() -> MetadataDrivers.runFunctionWithRegistrationManager((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any(ServerConfiguration.class)), (Function)((Function)ArgumentMatchers.any(Function.class)))).thenAnswer(invocationOnMock -> {
            Function function = (Function)invocationOnMock.getArgument(1);
            function.apply(this.rm);
            return null;
        });
    }

    @After
    public void teardown() throws Exception {
        this.listBookiesCommandMockedStatic.close();
        this.listBookiesCommandflagsMockedStatic.close();
        this.metadataDriversMockedStatic.close();
        this.bookKeeperAdminMockedStatic.close();
    }

    private static CommandLine parseCommandLine(BookieShell.MyCommand cmd, String ... args) throws ParseException {
        BasicParser parser = new BasicParser();
        return parser.parse(cmd.getOptions(), args);
    }

    @Test
    public void testRecoverCmdMissingArgument() throws Exception {
        BookieShell.RecoverCmd cmd = (BookieShell.RecoverCmd)this.shell.commands.get("recover");
        CommandLine cmdLine = BookieShellTest.parseCommandLine((BookieShell.MyCommand)cmd, new String[0]);
        try {
            cmd.runCmd(cmdLine);
            Assert.fail((String)"should fail running command when the arguments are missing");
        }
        catch (MissingArgumentException missingArgumentException) {
            // empty catch block
        }
        this.bookKeeperAdminMockedStatic.verify(() -> BookKeeperAdmin.newBookKeeperAdmin((ClientConfiguration)((ClientConfiguration)ArgumentMatchers.any(ClientConfiguration.class))), Mockito.never());
    }

    @Test
    public void testRecoverCmdInvalidBookieAddress() throws Exception {
        BookieShell.RecoverCmd cmd = (BookieShell.RecoverCmd)this.shell.commands.get("recover");
        CommandLine cmdLine = BookieShellTest.parseCommandLine((BookieShell.MyCommand)cmd, "non.valid$$bookie.id");
        Assert.assertEquals((long)-1L, (long)cmd.runCmd(cmdLine));
        this.bookKeeperAdminMockedStatic.verify(() -> BookKeeperAdmin.newBookKeeperAdmin((ClientConfiguration)((ClientConfiguration)ArgumentMatchers.any(ClientConfiguration.class))), Mockito.never());
    }

    @Test
    public void testRecoverCmdQuery() throws Exception {
        TreeMap ledgersContainBookies = Maps.newTreeMap();
        Mockito.when((Object)this.admin.getLedgersContainBookies((Set)ArgumentMatchers.any(Set.class))).thenReturn((Object)ledgersContainBookies);
        BookieShell.RecoverCmd cmd = (BookieShell.RecoverCmd)this.shell.commands.get("recover");
        CommandLine cmdLine = BookieShellTest.parseCommandLine((BookieShell.MyCommand)cmd, "-force", "-q", "127.0.0.1:3181");
        Assert.assertEquals((long)0L, (long)cmd.runCmd(cmdLine));
        this.bookKeeperAdminMockedStatic.verify(() -> BookKeeperAdmin.newBookKeeperAdmin((ClientConfiguration)((ClientConfiguration)ArgumentMatchers.any(ClientConfiguration.class))), Mockito.times((int)1));
        ((BookKeeperAdmin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).getLedgersContainBookies((Set)ArgumentMatchers.any(Set.class));
        ((BookKeeperAdmin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testRecoverCmdRecoverLedgerDefault() throws Exception {
        this.testRecoverCmdRecoverLedger(12345L, false, false, false, "-force", "-l", "12345", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverLedgerDeleteCookie() throws Exception {
        this.testRecoverCmdRecoverLedger(12345L, false, false, true, "-force", "-l", "12345", "-deleteCookie", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverLedgerSkipOpenLedgersDeleteCookie() throws Exception {
        this.testRecoverCmdRecoverLedger(12345L, false, true, true, "-force", "-l", "12345", "-deleteCookie", "-skipOpenLedgers", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverLedgerDryrun() throws Exception {
        this.testRecoverCmdRecoverLedger(12345L, true, false, false, "-force", "-l", "12345", "-dryrun", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverLedgerDryrunDeleteCookie() throws Exception {
        this.testRecoverCmdRecoverLedger(12345L, true, false, false, "-force", "-l", "12345", "-dryrun", "-deleteCookie", "127.0.0.1:3181");
    }

    void testRecoverCmdRecoverLedger(long ledgerId, boolean dryrun, boolean skipOpenLedgers, boolean removeCookies, String ... args) throws Exception {
        BookieShell.RecoverCmd cmd = (BookieShell.RecoverCmd)this.shell.commands.get("recover");
        CommandLine cmdLine = BookieShellTest.parseCommandLine((BookieShell.MyCommand)cmd, args);
        Assert.assertEquals((long)0L, (long)cmd.runCmd(cmdLine));
        this.bookKeeperAdminMockedStatic.verify(() -> BookKeeperAdmin.newBookKeeperAdmin((ClientConfiguration)((ClientConfiguration)ArgumentMatchers.any(ClientConfiguration.class))), Mockito.times((int)1));
        ((BookKeeperAdmin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).recoverBookieData(ArgumentMatchers.eq((long)ledgerId), (Set)ArgumentMatchers.any(Set.class), ArgumentMatchers.eq((boolean)dryrun), ArgumentMatchers.eq((boolean)skipOpenLedgers));
        ((BookKeeperAdmin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).close();
        if (removeCookies) {
            MetadataDrivers.runFunctionWithRegistrationManager((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any(ServerConfiguration.class)), (Function)((Function)ArgumentMatchers.any(Function.class)));
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)1))).readCookie((BookieId)ArgumentMatchers.any(BookieId.class));
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)1))).removeCookie((BookieId)ArgumentMatchers.any(BookieId.class), (Version)ArgumentMatchers.eq((Object)this.version));
        } else {
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)0))).readCookie((BookieId)ArgumentMatchers.any(BookieId.class));
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)0))).removeCookie((BookieId)ArgumentMatchers.any(BookieId.class), (Version)ArgumentMatchers.eq((Object)this.version));
        }
    }

    @Test
    public void testRecoverCmdRecoverDefault() throws Exception {
        this.testRecoverCmdRecover(false, false, false, false, "-force", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverDeleteCookie() throws Exception {
        this.testRecoverCmdRecover(false, false, true, false, "-force", "-deleteCookie", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverSkipOpenLedgersDeleteCookie() throws Exception {
        this.testRecoverCmdRecover(false, true, true, false, "-force", "-deleteCookie", "-skipOpenLedgers", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverDryrun() throws Exception {
        this.testRecoverCmdRecover(true, false, false, false, "-force", "-dryrun", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverDryrunDeleteCookie() throws Exception {
        this.testRecoverCmdRecover(true, false, false, false, "-force", "-dryrun", "-deleteCookie", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverSkipUnrecoverableLedgers() throws Exception {
        this.testRecoverCmdRecover(false, false, false, true, "-force", "-sku", "127.0.0.1:3181");
    }

    void testRecoverCmdRecover(boolean dryrun, boolean skipOpenLedgers, boolean removeCookies, boolean skipUnrecoverableLedgers, String ... args) throws Exception {
        BookieShell.RecoverCmd cmd = (BookieShell.RecoverCmd)this.shell.commands.get("recover");
        CommandLine cmdLine = BookieShellTest.parseCommandLine((BookieShell.MyCommand)cmd, args);
        Assert.assertEquals((long)0L, (long)cmd.runCmd(cmdLine));
        this.bookKeeperAdminMockedStatic.verify(() -> BookKeeperAdmin.newBookKeeperAdmin((ClientConfiguration)((ClientConfiguration)ArgumentMatchers.any(ClientConfiguration.class))), Mockito.times((int)1));
        ((BookKeeperAdmin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).recoverBookieData((Set)ArgumentMatchers.any(Set.class), ArgumentMatchers.eq((boolean)dryrun), ArgumentMatchers.eq((boolean)skipOpenLedgers), ArgumentMatchers.eq((boolean)skipUnrecoverableLedgers));
        ((BookKeeperAdmin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).close();
        if (removeCookies) {
            MetadataDrivers.runFunctionWithRegistrationManager((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any(ServerConfiguration.class)), (Function)((Function)ArgumentMatchers.any(Function.class)));
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)1))).readCookie((BookieId)ArgumentMatchers.any(BookieId.class));
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)1))).removeCookie((BookieId)ArgumentMatchers.any(BookieId.class), (Version)ArgumentMatchers.eq((Object)this.version));
        } else {
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)0))).readCookie((BookieId)ArgumentMatchers.any(BookieId.class));
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)0))).removeCookie((BookieId)ArgumentMatchers.any(BookieId.class), (Version)ArgumentMatchers.eq((Object)this.version));
        }
    }

    @Test
    public void testLastMarkCmd() throws Exception {
        LastMarkCommand mockLastMarkCommand = (LastMarkCommand)Mockito.mock(LastMarkCommand.class);
        MockedStatic lastMarkCommandMockedStatic = Mockito.mockStatic(LastMarkCommand.class);
        try {
            lastMarkCommandMockedStatic.when(() -> LastMarkCommand.newLastMarkCommand()).thenReturn((Object)mockLastMarkCommand);
            this.shell.run(new String[]{"lastmark"});
            lastMarkCommandMockedStatic.verify(() -> LastMarkCommand.newLastMarkCommand(), Mockito.times((int)1));
            ((LastMarkCommand)Mockito.verify((Object)mockLastMarkCommand, (VerificationMode)Mockito.times((int)1))).apply((ServerConfiguration)ArgumentMatchers.same((Object)this.shell.bkConf), (CliFlags)ArgumentMatchers.any(CliFlags.class));
        }
        finally {
            if (Collections.singletonList(lastMarkCommandMockedStatic).get(0) != null) {
                lastMarkCommandMockedStatic.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleTestCmd() throws Exception {
        SimpleTestCommand.Flags mockSimpleTestFlags = (SimpleTestCommand.Flags)Mockito.spy((Object)new SimpleTestCommand.Flags());
        MockedStatic flagsMockedStatic = Mockito.mockStatic(SimpleTestCommand.Flags.class);
        try {
            flagsMockedStatic.when(() -> SimpleTestCommand.Flags.newFlags()).thenReturn((Object)mockSimpleTestFlags);
            SimpleTestCommand mockSimpleTestCommand = (SimpleTestCommand)Mockito.spy((Object)new SimpleTestCommand());
            ((SimpleTestCommand)Mockito.doReturn((Object)true).when((Object)mockSimpleTestCommand)).apply((ServerConfiguration)ArgumentMatchers.any(ServerConfiguration.class), (CliFlags)ArgumentMatchers.any(SimpleTestCommand.Flags.class));
            MockedStatic simpleTestCommandMockedStatic = Mockito.mockStatic(SimpleTestCommand.class);
            try {
                simpleTestCommandMockedStatic.when(() -> SimpleTestCommand.newSimpleTestCommand((SimpleTestCommand.Flags)mockSimpleTestFlags)).thenReturn((Object)mockSimpleTestCommand);
                this.shell.run(new String[]{"simpletest", "-e", "10", "-w", "5", "-a", "3", "-n", "200"});
                simpleTestCommandMockedStatic.verify(() -> SimpleTestCommand.newSimpleTestCommand((SimpleTestCommand.Flags)mockSimpleTestFlags), Mockito.times((int)1));
                ((SimpleTestCommand)Mockito.verify((Object)mockSimpleTestCommand, (VerificationMode)Mockito.times((int)1))).apply((ServerConfiguration)ArgumentMatchers.same((Object)this.shell.bkConf), (CliFlags)ArgumentMatchers.same((Object)mockSimpleTestFlags));
                ((SimpleTestCommand.Flags)Mockito.verify((Object)mockSimpleTestFlags, (VerificationMode)Mockito.times((int)1))).ensembleSize(ArgumentMatchers.eq((int)10));
                ((SimpleTestCommand.Flags)Mockito.verify((Object)mockSimpleTestFlags, (VerificationMode)Mockito.times((int)1))).writeQuorumSize(ArgumentMatchers.eq((int)5));
                ((SimpleTestCommand.Flags)Mockito.verify((Object)mockSimpleTestFlags, (VerificationMode)Mockito.times((int)1))).ackQuorumSize(ArgumentMatchers.eq((int)3));
                ((SimpleTestCommand.Flags)Mockito.verify((Object)mockSimpleTestFlags, (VerificationMode)Mockito.times((int)1))).numEntries(ArgumentMatchers.eq((int)200));
            }
            finally {
                if (Collections.singletonList(simpleTestCommandMockedStatic).get(0) != null) {
                    simpleTestCommandMockedStatic.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(flagsMockedStatic).get(0) != null) {
                flagsMockedStatic.close();
            }
        }
    }

    @Test
    public void testListBookiesCmdNoArgs() throws Exception {
        Assert.assertEquals((long)1L, (long)this.shell.run(new String[]{"listbookies"}));
        this.listBookiesCommandMockedStatic.verify(() -> ListBookiesCommand.newListBookiesCommand((ListBookiesCommand.Flags)this.mockListBookiesFlags), Mockito.times((int)0));
    }

    @Test
    public void testListBookiesCmdConflictArgs() throws Exception {
        Assert.assertEquals((long)1L, (long)this.shell.run(new String[]{"listbookies", "-rw", "-ro"}));
        this.listBookiesCommandMockedStatic.verify(() -> ListBookiesCommand.newListBookiesCommand((ListBookiesCommand.Flags)this.mockListBookiesFlags), Mockito.times((int)0));
    }

    @Test
    public void testListBookiesCmdReadOnly() throws Exception {
        Assert.assertEquals((long)0L, (long)this.shell.run(new String[]{"listbookies", "-ro"}));
        this.listBookiesCommandMockedStatic.verify(() -> ListBookiesCommand.newListBookiesCommand((ListBookiesCommand.Flags)this.mockListBookiesFlags), Mockito.times((int)1));
        ((ListBookiesCommand)Mockito.verify((Object)this.mockListBookiesCommand, (VerificationMode)Mockito.times((int)1))).apply((ServerConfiguration)ArgumentMatchers.same((Object)this.shell.bkConf), (CliFlags)ArgumentMatchers.same((Object)this.mockListBookiesFlags));
        ((ListBookiesCommand.Flags)Mockito.verify((Object)this.mockListBookiesFlags, (VerificationMode)Mockito.times((int)1))).readonly(true);
        ((ListBookiesCommand.Flags)Mockito.verify((Object)this.mockListBookiesFlags, (VerificationMode)Mockito.times((int)1))).readwrite(false);
        ((ListBookiesCommand.Flags)Mockito.verify((Object)this.mockListBookiesFlags, (VerificationMode)Mockito.times((int)1))).all(false);
    }

    @Test
    public void testListBookiesCmdReadWrite() throws Exception {
        Assert.assertEquals((long)0L, (long)this.shell.run(new String[]{"listbookies", "-rw"}));
        this.listBookiesCommandMockedStatic.verify(() -> ListBookiesCommand.newListBookiesCommand((ListBookiesCommand.Flags)this.mockListBookiesFlags), Mockito.times((int)1));
        ((ListBookiesCommand)Mockito.verify((Object)this.mockListBookiesCommand, (VerificationMode)Mockito.times((int)1))).apply((ServerConfiguration)ArgumentMatchers.same((Object)this.shell.bkConf), (CliFlags)ArgumentMatchers.same((Object)this.mockListBookiesFlags));
        ((ListBookiesCommand.Flags)Mockito.verify((Object)this.mockListBookiesFlags, (VerificationMode)Mockito.times((int)1))).readonly(false);
        ((ListBookiesCommand.Flags)Mockito.verify((Object)this.mockListBookiesFlags, (VerificationMode)Mockito.times((int)1))).readwrite(true);
        ((ListBookiesCommand.Flags)Mockito.verify((Object)this.mockListBookiesFlags, (VerificationMode)Mockito.times((int)1))).all(false);
    }

    @Test
    public void testListBookiesCmdAll() throws Exception {
        Assert.assertEquals((long)0L, (long)this.shell.run(new String[]{"listbookies", "-a"}));
        this.listBookiesCommandMockedStatic.verify(() -> ListBookiesCommand.newListBookiesCommand((ListBookiesCommand.Flags)this.mockListBookiesFlags), Mockito.times((int)1));
        ((ListBookiesCommand)Mockito.verify((Object)this.mockListBookiesCommand, (VerificationMode)Mockito.times((int)1))).apply((ServerConfiguration)ArgumentMatchers.same((Object)this.shell.bkConf), (CliFlags)ArgumentMatchers.same((Object)this.mockListBookiesFlags));
        ((ListBookiesCommand.Flags)Mockito.verify((Object)this.mockListBookiesFlags, (VerificationMode)Mockito.times((int)1))).readonly(false);
        ((ListBookiesCommand.Flags)Mockito.verify((Object)this.mockListBookiesFlags, (VerificationMode)Mockito.times((int)1))).readwrite(false);
        ((ListBookiesCommand.Flags)Mockito.verify((Object)this.mockListBookiesFlags, (VerificationMode)Mockito.times((int)1))).all(true);
    }

    @Test
    public void testForceAuditChecksWithNoArgs() throws Exception {
        Assert.assertEquals((long)-1L, (long)this.shell.run(new String[]{"forceauditchecks"}));
    }

    @Test
    public void testForceAuditChecksWithSomeArgs() throws Exception {
        Assert.assertEquals((long)0L, (long)this.shell.run(new String[]{"forceauditchecks", "-calc"}));
    }

    @Test
    public void testForceAuditChecksWithAllArgs() throws Exception {
        Assert.assertEquals((long)0L, (long)this.shell.run(new String[]{"forceauditchecks", "-calc", "-rc", "-ppc"}));
    }

    @Test
    public void testClusterInfoCmd() throws Exception {
        ClusterInfoCommand mockClusterInfoCommand = (ClusterInfoCommand)Mockito.spy((Object)new ClusterInfoCommand());
        MockedStatic clusterInfoCommandMockedStatic = Mockito.mockStatic(ClusterInfoCommand.class);
        try {
            clusterInfoCommandMockedStatic.when(() -> ClusterInfoCommand.newClusterInfoCommand()).thenReturn((Object)mockClusterInfoCommand);
            ((ClusterInfoCommand)Mockito.doReturn((Object)true).when((Object)mockClusterInfoCommand)).apply((ServerConfiguration)ArgumentMatchers.same((Object)this.shell.bkConf), (CliFlags)ArgumentMatchers.any(CliFlags.class));
            this.shell.run(new String[]{"clusterinfo"});
            clusterInfoCommandMockedStatic.verify(() -> ClusterInfoCommand.newClusterInfoCommand(), Mockito.times((int)1));
        }
        finally {
            if (Collections.singletonList(clusterInfoCommandMockedStatic).get(0) != null) {
                clusterInfoCommandMockedStatic.close();
            }
        }
    }
}

