/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieResources;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.shaded.com.google.protobuf.ByteString;
import org.apache.bookkeeper.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.ByteBufList;
import org.apache.bookkeeper.util.PortManager;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieImplTest
extends BookKeeperClusterTestCase {
    private static final Logger log = LoggerFactory.getLogger(BookieImplTest.class);
    private static final int bookiePort = PortManager.nextFreePort();
    private static final int ADD = 0;
    private static final int RECOVERY_ADD = 1;

    public BookieImplTest() {
        super(0);
    }

    @Test
    public void testWriteLac() throws Exception {
        String metadataServiceUri = this.zkUtil.getMetadataServiceUri();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setMetadataServiceUri(metadataServiceUri);
        MetadataBookieDriver metadataDriver = BookieResources.createMetadataDriver((ServerConfiguration)conf, (StatsLogger)NullStatsLogger.INSTANCE);
        RegistrationManager rm = metadataDriver.createRegistrationManager();
        TestBookieImpl.Resources resources = new TestBookieImpl.ResourceBuilder(conf).withMetadataDriver(metadataDriver).withRegistrationManager(rm).build();
        TestBookieImpl b = new TestBookieImpl(resources);
        b.start();
        BookieImpl spyBookie = (BookieImpl)Mockito.spy((Object)((Object)b));
        long ledgerId = 10L;
        long lac = 23L;
        DigestManager digestManager = DigestManager.instantiate((long)10L, (byte[])"".getBytes(StandardCharsets.UTF_8), (DataFormats.LedgerMetadataFormat.DigestType)BookKeeper.DigestType.toProtoDigestType((BookKeeper.DigestType)BookKeeper.DigestType.CRC32), (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)this.baseClientConf.getUseV2WireProtocol());
        ByteBufList toSend = digestManager.computeDigestAndPackageForSendingLac(23L);
        ByteString body = UnsafeByteOperations.unsafeWrap((byte[])toSend.array(), (int)toSend.arrayOffset(), (int)toSend.readableBytes());
        ByteBuf lacToAdd = Unpooled.wrappedBuffer((ByteBuffer)body.asReadOnlyByteBuffer());
        byte[] masterKey = ByteString.copyFrom((byte[])"masterKey".getBytes()).toByteArray();
        ByteBuf explicitLACEntry = b.createExplicitLACEntry(10L, lacToAdd);
        lacToAdd.resetReaderIndex();
        ((BookieImpl)Mockito.doReturn((Object)explicitLACEntry).when((Object)spyBookie)).createExplicitLACEntry(ArgumentMatchers.eq((long)10L), (ByteBuf)ArgumentMatchers.eq((Object)lacToAdd));
        final AtomicBoolean complete = new AtomicBoolean(false);
        BookkeeperInternalCallbacks.WriteCallback writeCallback = new BookkeeperInternalCallbacks.WriteCallback(){

            public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
                complete.set(true);
            }
        };
        spyBookie.setExplicitLac(lacToAdd, writeCallback, null, masterKey);
        Awaitility.await().untilAsserted(() -> Assert.assertTrue((boolean)complete.get()));
        Assert.assertEquals((long)0L, (long)lacToAdd.refCnt());
        Assert.assertEquals((long)0L, (long)explicitLACEntry.refCnt());
        b.shutdown();
    }

    @Test
    public void testAddEntry() throws Exception {
        this.mockAddEntryReleased(0);
    }

    @Test
    public void testRecoveryAddEntry() throws Exception {
        this.mockAddEntryReleased(1);
    }

    public void mockAddEntryReleased(int flag) throws Exception {
        String metadataServiceUri = this.zkUtil.getMetadataServiceUri();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setMetadataServiceUri(metadataServiceUri);
        MetadataBookieDriver metadataDriver = BookieResources.createMetadataDriver((ServerConfiguration)conf, (StatsLogger)NullStatsLogger.INSTANCE);
        RegistrationManager rm = metadataDriver.createRegistrationManager();
        TestBookieImpl.Resources resources = new TestBookieImpl.ResourceBuilder(conf).withMetadataDriver(metadataDriver).withRegistrationManager(rm).build();
        TestBookieImpl b = new TestBookieImpl(resources);
        b.start();
        BookieImpl spyBookie = (BookieImpl)Mockito.spy((Object)((Object)b));
        long ledgerId = 10L;
        byte[] masterKey = ByteString.copyFrom((byte[])"masterKey".getBytes()).toByteArray();
        ByteBuf masterKeyEntry = b.createMasterKeyEntry(10L, masterKey);
        ((BookieImpl)Mockito.doReturn((Object)masterKeyEntry).when((Object)spyBookie)).createMasterKeyEntry(ArgumentMatchers.eq((long)10L), (byte[])ArgumentMatchers.eq((Object)masterKey));
        ByteBuf entry = this.generateEntry(10L, 0L);
        final AtomicBoolean complete = new AtomicBoolean(false);
        BookkeeperInternalCallbacks.WriteCallback writeCallback = new BookkeeperInternalCallbacks.WriteCallback(){

            public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
                complete.set(true);
            }
        };
        switch (flag) {
            case 0: {
                spyBookie.addEntry(entry, false, writeCallback, null, masterKey);
                break;
            }
            case 1: {
                spyBookie.recoveryAddEntry(entry, writeCallback, null, masterKey);
                break;
            }
            default: {
                throw new IllegalArgumentException("Only support ADD and RECOVERY_ADD flag.");
            }
        }
        Awaitility.await().untilAsserted(() -> Assert.assertTrue((boolean)complete.get()));
        Assert.assertEquals((long)0L, (long)entry.refCnt());
        Assert.assertEquals((long)0L, (long)masterKeyEntry.refCnt());
        b.shutdown();
    }

    private ByteBuf generateEntry(long ledger, long entry) {
        byte[] data = ("ledger-" + ledger + "-" + entry).getBytes();
        ByteBuf bb = Unpooled.buffer((int)(16 + data.length));
        bb.writeLong(ledger);
        bb.writeLong(entry);
        bb.writeBytes(data);
        return bb;
    }
}

