/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import java.net.SocketAddress;
import org.apache.bookkeeper.util.ByteBufList;
import org.junit.Assert;
import org.junit.Test;

public class ByteBufListTest {
    @Test
    public void testSingle() throws Exception {
        ByteBuf b1 = PooledByteBufAllocator.DEFAULT.heapBuffer(128, 128);
        b1.writerIndex(b1.capacity());
        ByteBufList buf = ByteBufList.get((ByteBuf)b1);
        Assert.assertEquals((long)1L, (long)buf.size());
        Assert.assertEquals((long)128L, (long)buf.readableBytes());
        Assert.assertEquals((Object)b1, (Object)buf.getBuffer(0));
        Assert.assertEquals((long)buf.refCnt(), (long)1L);
        Assert.assertEquals((long)b1.refCnt(), (long)1L);
        buf.release();
        Assert.assertEquals((long)buf.refCnt(), (long)0L);
        Assert.assertEquals((long)b1.refCnt(), (long)0L);
    }

    @Test
    public void testDouble() throws Exception {
        ByteBuf b1 = PooledByteBufAllocator.DEFAULT.heapBuffer(128, 128);
        b1.writerIndex(b1.capacity());
        ByteBuf b2 = PooledByteBufAllocator.DEFAULT.heapBuffer(128, 128);
        b2.writerIndex(b2.capacity());
        ByteBufList buf = ByteBufList.get((ByteBuf)b1, (ByteBuf)b2);
        Assert.assertEquals((long)2L, (long)buf.size());
        Assert.assertEquals((long)256L, (long)buf.readableBytes());
        Assert.assertEquals((Object)b1, (Object)buf.getBuffer(0));
        Assert.assertEquals((Object)b2, (Object)buf.getBuffer(1));
        Assert.assertEquals((long)buf.refCnt(), (long)1L);
        Assert.assertEquals((long)b1.refCnt(), (long)1L);
        Assert.assertEquals((long)b2.refCnt(), (long)1L);
        buf.release();
        Assert.assertEquals((long)buf.refCnt(), (long)0L);
        Assert.assertEquals((long)b1.refCnt(), (long)0L);
        Assert.assertEquals((long)b2.refCnt(), (long)0L);
    }

    @Test
    public void testClone() throws Exception {
        ByteBuf b1 = PooledByteBufAllocator.DEFAULT.heapBuffer(128, 128);
        b1.writerIndex(b1.capacity());
        ByteBuf b2 = PooledByteBufAllocator.DEFAULT.heapBuffer(128, 128);
        b2.writerIndex(b2.capacity());
        ByteBufList buf = ByteBufList.get((ByteBuf)b1, (ByteBuf)b2);
        ByteBufList clone = ByteBufList.clone((ByteBufList)buf);
        Assert.assertEquals((long)2L, (long)buf.size());
        Assert.assertEquals((long)256L, (long)buf.readableBytes());
        Assert.assertEquals((Object)b1, (Object)buf.getBuffer(0));
        Assert.assertEquals((Object)b2, (Object)buf.getBuffer(1));
        Assert.assertEquals((long)2L, (long)clone.size());
        Assert.assertEquals((long)256L, (long)clone.readableBytes());
        Assert.assertEquals((Object)b1, (Object)clone.getBuffer(0));
        Assert.assertEquals((Object)b2, (Object)clone.getBuffer(1));
        Assert.assertEquals((long)buf.refCnt(), (long)1L);
        Assert.assertEquals((long)clone.refCnt(), (long)1L);
        Assert.assertEquals((long)b1.refCnt(), (long)2L);
        Assert.assertEquals((long)b2.refCnt(), (long)2L);
        buf.release();
        Assert.assertEquals((long)buf.refCnt(), (long)0L);
        Assert.assertEquals((long)clone.refCnt(), (long)1L);
        Assert.assertEquals((long)b1.refCnt(), (long)1L);
        Assert.assertEquals((long)b2.refCnt(), (long)1L);
        clone.release();
        Assert.assertEquals((long)buf.refCnt(), (long)0L);
        Assert.assertEquals((long)clone.refCnt(), (long)0L);
        Assert.assertEquals((long)b1.refCnt(), (long)0L);
        Assert.assertEquals((long)b2.refCnt(), (long)0L);
    }

    @Test
    public void testGetBytes() throws Exception {
        ByteBufList buf = ByteBufList.get((ByteBuf)Unpooled.wrappedBuffer((byte[])"hello".getBytes()), (ByteBuf)Unpooled.wrappedBuffer((byte[])"world".getBytes()));
        Assert.assertArrayEquals((byte[])"helloworld".getBytes(), (byte[])buf.toArray());
        buf.prepend(Unpooled.wrappedBuffer((byte[])"prefix-".getBytes()));
        Assert.assertArrayEquals((byte[])"prefix-helloworld".getBytes(), (byte[])buf.toArray());
        byte[] buf100 = new byte[100];
        int res = buf.getBytes(buf100);
        Assert.assertEquals((long)"prefix-helloworld".length(), (long)res);
        byte[] buf4 = new byte[4];
        res = buf.getBytes(buf4);
        Assert.assertEquals((long)4L, (long)res);
        Assert.assertEquals((Object)"pref", (Object)new String(buf4));
    }

    @Test
    public void testCoalesce() throws Exception {
        ByteBufList buf = ByteBufList.get((ByteBuf)Unpooled.wrappedBuffer((byte[])"hello".getBytes()), (ByteBuf)Unpooled.wrappedBuffer((byte[])"world".getBytes()));
        Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])"helloworld".getBytes()), (Object)ByteBufList.coalesce((ByteBufList)buf));
    }

    @Test
    public void testRetain() throws Exception {
        ByteBuf b1 = PooledByteBufAllocator.DEFAULT.heapBuffer(128, 128);
        b1.writerIndex(b1.capacity());
        ByteBufList buf = ByteBufList.get((ByteBuf)b1);
        Assert.assertEquals((long)1L, (long)buf.size());
        Assert.assertEquals((long)128L, (long)buf.readableBytes());
        Assert.assertEquals((Object)b1, (Object)buf.getBuffer(0));
        Assert.assertEquals((long)buf.refCnt(), (long)1L);
        Assert.assertEquals((long)b1.refCnt(), (long)1L);
        buf.retain();
        Assert.assertEquals((long)buf.refCnt(), (long)2L);
        Assert.assertEquals((long)b1.refCnt(), (long)1L);
        buf.release();
        Assert.assertEquals((long)buf.refCnt(), (long)1L);
        Assert.assertEquals((long)b1.refCnt(), (long)1L);
        buf.release();
        Assert.assertEquals((long)buf.refCnt(), (long)0L);
        Assert.assertEquals((long)b1.refCnt(), (long)0L);
    }

    @Test
    public void testEncoder() throws Exception {
        ByteBuf b1 = PooledByteBufAllocator.DEFAULT.heapBuffer(128, 128);
        b1.writerIndex(b1.capacity());
        ByteBuf b2 = PooledByteBufAllocator.DEFAULT.heapBuffer(128, 128);
        b2.writerIndex(b2.capacity());
        ByteBufList buf = ByteBufList.get((ByteBuf)b1, (ByteBuf)b2);
        MockChannelHandlerContext ctx = new MockChannelHandlerContext();
        ByteBufList.ENCODER.write((ChannelHandlerContext)ctx, (Object)buf, null);
        Assert.assertEquals((long)buf.refCnt(), (long)0L);
        Assert.assertEquals((long)b1.refCnt(), (long)0L);
        Assert.assertEquals((long)b2.refCnt(), (long)0L);
    }

    class MockChannelHandlerContext
    implements ChannelHandlerContext {
        MockChannelHandlerContext() {
        }

        public ChannelFuture bind(SocketAddress localAddress) {
            return null;
        }

        public ChannelFuture connect(SocketAddress remoteAddress) {
            return null;
        }

        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
            return null;
        }

        public ChannelFuture disconnect() {
            return null;
        }

        public ChannelFuture close() {
            return null;
        }

        public ChannelFuture deregister() {
            return null;
        }

        public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
            return null;
        }

        public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
            return null;
        }

        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            return null;
        }

        public ChannelFuture disconnect(ChannelPromise promise) {
            return null;
        }

        public ChannelFuture close(ChannelPromise promise) {
            return null;
        }

        public ChannelFuture deregister(ChannelPromise promise) {
            return null;
        }

        public ChannelFuture write(Object msg) {
            ReferenceCountUtil.release((Object)msg);
            return null;
        }

        public ChannelFuture write(Object msg, ChannelPromise promise) {
            ReferenceCountUtil.release((Object)msg);
            return null;
        }

        public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
            ReferenceCountUtil.release((Object)msg);
            return null;
        }

        public ChannelFuture writeAndFlush(Object msg) {
            ReferenceCountUtil.release((Object)msg);
            return null;
        }

        public ChannelPromise newPromise() {
            return null;
        }

        public ChannelProgressivePromise newProgressivePromise() {
            return null;
        }

        public ChannelFuture newSucceededFuture() {
            return null;
        }

        public ChannelFuture newFailedFuture(Throwable cause) {
            return null;
        }

        public ChannelPromise voidPromise() {
            return null;
        }

        public Channel channel() {
            return null;
        }

        public EventExecutor executor() {
            return null;
        }

        public String name() {
            return null;
        }

        public ChannelHandler handler() {
            return null;
        }

        public boolean isRemoved() {
            return false;
        }

        public ChannelHandlerContext fireChannelRegistered() {
            return null;
        }

        public ChannelHandlerContext fireChannelUnregistered() {
            return null;
        }

        public ChannelHandlerContext fireChannelActive() {
            return null;
        }

        public ChannelHandlerContext fireChannelInactive() {
            return null;
        }

        public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
            return null;
        }

        public ChannelHandlerContext fireUserEventTriggered(Object evt) {
            return null;
        }

        public ChannelHandlerContext fireChannelRead(Object msg) {
            return null;
        }

        public ChannelHandlerContext fireChannelReadComplete() {
            return null;
        }

        public ChannelHandlerContext fireChannelWritabilityChanged() {
            return null;
        }

        public ChannelHandlerContext read() {
            return null;
        }

        public ChannelHandlerContext flush() {
            return null;
        }

        public ChannelPipeline pipeline() {
            return null;
        }

        public ByteBufAllocator alloc() {
            return null;
        }

        @Deprecated
        public <T> Attribute<T> attr(AttributeKey<T> key) {
            return null;
        }

        @Deprecated
        public <T> boolean hasAttr(AttributeKey<T> key) {
            return false;
        }
    }
}

