/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tls;

import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.auth.AuthCallbacks;
import org.apache.bookkeeper.auth.AuthToken;
import org.apache.bookkeeper.auth.BookieAuthProvider;
import org.apache.bookkeeper.auth.ClientAuthProvider;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.BookKeeperTestClient;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieConnectionPeer;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.proto.ClientConnectionPeer;
import org.apache.bookkeeper.proto.TestPerChannelBookieClient;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.tls.BookieAuthZFactory;
import org.apache.bookkeeper.tls.SecurityException;
import org.apache.bookkeeper.tls.TLSContextFactory;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.TestUtils;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestTLS
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestPerChannelBookieClient.class);
    private static boolean secureClientSideChannel = false;
    private static Collection<Object> secureClientSideChannelPrincipals = null;
    private static boolean secureBookieSideChannel = false;
    private static Collection<Object> secureBookieSideChannelPrincipals = null;
    private TLSContextFactory.KeyStoreType clientKeyStoreFormat;
    private TLSContextFactory.KeyStoreType clientTrustStoreFormat;
    private TLSContextFactory.KeyStoreType serverKeyStoreFormat;
    private TLSContextFactory.KeyStoreType serverTrustStoreFormat;
    private final boolean useV2Protocol;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"JKS", "JKS", false}, {"PEM", "PEM", false}, {"PEM", "PEM", true}, {"PKCS12", "PKCS12", false}, {"JKS", "PEM", false}, {"PEM", "PKCS12", false}, {"PKCS12", "JKS", false});
    }

    public TestTLS(String keyStoreFormat, String trustStoreFormat, boolean useV2Protocol) {
        super(3);
        this.clientKeyStoreFormat = TLSContextFactory.KeyStoreType.valueOf((String)keyStoreFormat);
        this.clientTrustStoreFormat = TLSContextFactory.KeyStoreType.valueOf((String)trustStoreFormat);
        this.serverKeyStoreFormat = TLSContextFactory.KeyStoreType.valueOf((String)keyStoreFormat);
        this.serverTrustStoreFormat = TLSContextFactory.KeyStoreType.valueOf((String)trustStoreFormat);
        this.useV2Protocol = useV2Protocol;
    }

    private String getResourcePath(String resource) throws Exception {
        return this.getClass().getClassLoader().getResource(resource).toURI().getPath();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.baseClientConf.setTLSProviderFactoryClass(TLSContextFactory.class.getName());
        this.baseClientConf.setTLSClientAuthentication(true);
        this.baseClientConf.setUseV2WireProtocol(this.useV2Protocol);
        this.baseClientConf.setLimitStatsLogging(false);
        switch (this.clientKeyStoreFormat) {
            case PEM: {
                this.baseClientConf.setTLSKeyStoreType("PEM");
                this.baseClientConf.setTLSKeyStore(this.getResourcePath("client-key.pem"));
                this.baseClientConf.setTLSCertificatePath(this.getResourcePath("client-cert.pem"));
                break;
            }
            case JKS: {
                this.baseClientConf.setTLSKeyStoreType("JKS");
                this.baseClientConf.setTLSKeyStore(this.getResourcePath("client-key.jks"));
                this.baseClientConf.setTLSKeyStorePasswordPath(this.getResourcePath("keyStoreClientPassword.txt"));
                break;
            }
            case PKCS12: {
                this.baseClientConf.setTLSKeyStoreType("PKCS12");
                this.baseClientConf.setTLSKeyStore(this.getResourcePath("client-key.p12"));
                this.baseClientConf.setTLSKeyStorePasswordPath(this.getResourcePath("keyStoreClientPassword.txt"));
                break;
            }
            default: {
                throw new Exception("Invalid client keystore format" + this.clientKeyStoreFormat);
            }
        }
        switch (this.clientTrustStoreFormat) {
            case PEM: {
                this.baseClientConf.setTLSTrustStoreType("PEM");
                this.baseClientConf.setTLSTrustStore(this.getResourcePath("server-cert.pem"));
                break;
            }
            case JKS: {
                this.baseClientConf.setTLSTrustStoreType("JKS");
                this.baseClientConf.setTLSTrustStore(this.getResourcePath("server-key.jks"));
                this.baseClientConf.setTLSTrustStorePasswordPath(this.getResourcePath("keyStoreServerPassword.txt"));
                break;
            }
            case PKCS12: {
                this.baseClientConf.setTLSTrustStoreType("PKCS12");
                this.baseClientConf.setTLSTrustStore(this.getResourcePath("server-key.p12"));
                this.baseClientConf.setTLSTrustStorePasswordPath(this.getResourcePath("keyStoreServerPassword.txt"));
                break;
            }
            default: {
                throw new Exception("Invalid client keystore format" + this.clientTrustStoreFormat);
            }
        }
        this.baseConf.setTLSProviderFactoryClass(TLSContextFactory.class.getName());
        this.baseConf.setTLSClientAuthentication(true);
        switch (this.serverKeyStoreFormat) {
            case PEM: {
                this.baseConf.setTLSKeyStoreType("PEM");
                this.baseConf.setTLSKeyStore(this.getResourcePath("server-key.pem"));
                this.baseConf.setTLSCertificatePath(this.getResourcePath("server-cert.pem"));
                break;
            }
            case JKS: {
                this.baseConf.setTLSKeyStoreType("JKS");
                this.baseConf.setTLSKeyStore(this.getResourcePath("server-key.jks"));
                this.baseConf.setTLSKeyStorePasswordPath(this.getResourcePath("keyStoreServerPassword.txt"));
                break;
            }
            case PKCS12: {
                this.baseConf.setTLSKeyStoreType("PKCS12");
                this.baseConf.setTLSKeyStore(this.getResourcePath("server-key.p12"));
                this.baseConf.setTLSKeyStorePasswordPath(this.getResourcePath("keyStoreServerPassword.txt"));
                break;
            }
            default: {
                throw new Exception("Invalid server keystore format" + this.serverKeyStoreFormat);
            }
        }
        switch (this.serverTrustStoreFormat) {
            case PEM: {
                this.baseConf.setTLSTrustStoreType("PEM");
                this.baseConf.setTLSTrustStore(this.getResourcePath("client-cert.pem"));
                break;
            }
            case JKS: {
                this.baseConf.setTLSTrustStoreType("JKS");
                this.baseConf.setTLSTrustStore(this.getResourcePath("client-key.jks"));
                this.baseConf.setTLSTrustStorePasswordPath(this.getResourcePath("keyStoreClientPassword.txt"));
                break;
            }
            case PKCS12: {
                this.baseConf.setTLSTrustStoreType("PKCS12");
                this.baseConf.setTLSTrustStore(this.getResourcePath("client-key.p12"));
                this.baseConf.setTLSTrustStorePasswordPath(this.getResourcePath("keyStoreClientPassword.txt"));
                break;
            }
            default: {
                throw new Exception("Invalid server keystore format" + this.serverTrustStoreFormat);
            }
        }
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGetBouncyCastleProviderName() throws Exception {
        String bcName = TLSContextFactory.getProvider().getName();
        Assert.assertEquals((Object)bcName, (Object)"BCFIPS");
    }

    @Test
    public void testStartTLSServerNoKeyStore() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration().setTLSKeyStore(null);
        try {
            this.startAndAddBookie(bookieConf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (SecurityException se) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testKeyMismatchFailure() throws Exception {
        Assume.assumeTrue((this.serverKeyStoreFormat == TLSContextFactory.KeyStoreType.PEM ? 1 : 0) != 0);
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        int restartBookieIdx = 0;
        ServerConfiguration bookieConf = this.confByIndex(restartBookieIdx).setTLSCertificatePath(this.getResourcePath("client-cert.pem"));
        this.killBookie(restartBookieIdx);
        LOG.info("Sleeping for 1s before restarting bookie with bad cert");
        Thread.sleep(1000L);
        this.startAndAddBookie(bookieConf);
        BookKeeper client = new BookKeeper(clientConf);
        byte[] passwd = "testPassword".getBytes();
        int numEntries = 2;
        byte[] testEntry = "testEntry".getBytes();
        try (LedgerHandle lh = client.createLedger(this.numBookies, this.numBookies, BookKeeper.DigestType.CRC32, passwd);){
            for (int i = 0; i <= numEntries; ++i) {
                lh.addEntry(testEntry);
            }
            Assert.fail((String)"Should have failed with not enough bookies to write");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testStartTLSServerBadPassword() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration().setTLSKeyStorePasswordPath("badpassword");
        try {
            this.startAndAddBookie(bookieConf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (SecurityException se) {
            Assert.assertTrue((boolean)true);
        }
    }

    private LedgerMetadata testClient(BookKeeper client, int clusterSize) throws Exception {
        long lid;
        byte[] passwd = "testPassword".getBytes();
        int numEntries = 100;
        byte[] testEntry = "testEntry".getBytes();
        try (LedgerHandle lh = client.createLedger(clusterSize, clusterSize, BookKeeper.DigestType.CRC32, passwd);){
            for (int i = 0; i <= numEntries; ++i) {
                lh.addEntry(testEntry);
            }
            lid = lh.getId();
        }
        lh = client.openLedger(lid, BookKeeper.DigestType.CRC32, passwd);
        var9_7 = null;
        try {
            Enumeration entries = lh.readEntries(0L, (long)numEntries);
            while (entries.hasMoreElements()) {
                LedgerEntry e = (LedgerEntry)entries.nextElement();
                Assert.assertTrue((String)"Entry contents incorrect", (boolean)Arrays.equals(e.getEntry(), testEntry));
            }
            BookKeeperAdmin admin = new BookKeeperAdmin(client, this.baseClientConf);
            LedgerMetadata ledgerMetadata = admin.getLedgerMetadata(lh);
            return ledgerMetadata;
        }
        catch (Throwable throwable) {
            var9_7 = throwable;
            throw throwable;
        }
        finally {
            if (lh != null) {
                if (var9_7 != null) {
                    try {
                        lh.close();
                    }
                    catch (Throwable throwable) {
                        var9_7.addSuppressed(throwable);
                    }
                } else {
                    lh.close();
                }
            }
        }
    }

    private LedgerMetadata testClient(ClientConfiguration conf, int clusterSize) throws Exception {
        try (BookKeeper client = new BookKeeper(conf);){
            LedgerMetadata ledgerMetadata = this.testClient(client, clusterSize);
            return ledgerMetadata;
        }
    }

    @Test
    public void testConnectToTLSClusterTLSClient() throws Exception {
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        this.testClient(clientConf, this.numBookies);
    }

    @Test
    public void testConnectToLocalTLSClusterTLSClient() throws Exception {
        if (this.useV2Protocol) {
            return;
        }
        this.restartBookies(c -> {
            c.setDisableServerSocketBind(true);
            c.setEnableLocalTransport(true);
            return c;
        });
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        this.testClient(clientConf, this.numBookies);
    }

    @Test
    public void testRefreshDurationForBookieCerts() throws Exception {
        Assume.assumeTrue((this.serverKeyStoreFormat == TLSContextFactory.KeyStoreType.PEM ? 1 : 0) != 0);
        String originalTlsKeyFilePath = this.confByIndex(0).getTLSKeyStore();
        String invalidServerKey = this.getResourcePath("client-key.pem");
        File originalTlsCertFile = new File(originalTlsKeyFilePath);
        File newTlsKeyFile = IOUtils.createTempFileAndDeleteOnExit((String)originalTlsKeyFilePath, (String)"refresh");
        newTlsKeyFile.deleteOnExit();
        File invalidServerKeyFile = new File(invalidServerKey);
        FileUtils.copyFile((File)invalidServerKeyFile, (File)newTlsKeyFile);
        long refreshDurationInSec = 1L;
        this.restartBookies(c -> {
            c.setTLSCertFilesRefreshDurationSeconds(1L);
            c.setTLSKeyStore(newTlsKeyFile.getAbsolutePath());
            return c;
        });
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        try {
            this.testClient(clientConf, this.numBookies);
            Assert.fail((String)"Should have fail due to invalid cert");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.sleep(refreshDurationInSec * 1000L + 1000L);
        FileUtils.copyFile((File)originalTlsCertFile, (File)newTlsKeyFile);
        newTlsKeyFile.setLastModified(System.currentTimeMillis() + 1000L);
        this.testClient(clientConf, this.numBookies);
        newTlsKeyFile.delete();
    }

    @Test
    public void testRefreshDurationForBookkeeperClientCerts() throws Exception {
        Assume.assumeTrue((this.serverKeyStoreFormat == TLSContextFactory.KeyStoreType.PEM ? 1 : 0) != 0);
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        String originalTlsCertFilePath = this.baseClientConf.getTLSCertificatePath();
        String invalidClientCert = this.getResourcePath("server-cert.pem");
        File originalTlsCertFile = new File(originalTlsCertFilePath);
        File newTlsCertFile = IOUtils.createTempFileAndDeleteOnExit((String)originalTlsCertFilePath, (String)"refresh");
        newTlsCertFile.deleteOnExit();
        File invalidClientCertFile = new File(invalidClientCert);
        FileUtils.copyFile((File)invalidClientCertFile, (File)newTlsCertFile);
        long refreshDurationInSec = 2L;
        clientConf.setTLSCertFilesRefreshDurationSeconds(1L);
        clientConf.setTLSCertificatePath(newTlsCertFile.getAbsolutePath());
        try (BookKeeper client = new BookKeeper(clientConf);){
            byte[] testEntry = "testEntry".getBytes();
            byte[] passwd = "testPassword".getBytes();
            int totalAddEntries = 1;
            CountDownLatch latch = new CountDownLatch(totalAddEntries);
            AtomicInteger result = new AtomicInteger(-1);
            LedgerHandle lh = client.createLedger(1, 1, BookKeeper.DigestType.CRC32, passwd);
            for (int i = 0; i <= totalAddEntries; ++i) {
                lh.asyncAddEntry(testEntry, (rc, lgh, entryId, ctx) -> {
                    result.set(rc);
                    latch.countDown();
                }, null);
            }
            latch.await(1L, TimeUnit.SECONDS);
            Assert.assertNotEquals((long)result.get(), (long)0L);
            Thread.sleep(refreshDurationInSec * 1000L + 1000L);
            FileUtils.copyFile((File)originalTlsCertFile, (File)newTlsCertFile);
            newTlsCertFile.setLastModified(System.currentTimeMillis() + 1000L);
            CountDownLatch latchWithValidCert = new CountDownLatch(totalAddEntries);
            AtomicInteger validCertResult = new AtomicInteger(-1);
            lh = client.createLedger(1, 1, BookKeeper.DigestType.CRC32, passwd);
            for (int i = 0; i <= totalAddEntries; ++i) {
                lh.asyncAddEntry(testEntry, (rc, lgh, entryId, ctx) -> {
                    validCertResult.set(rc);
                    latchWithValidCert.countDown();
                }, null);
            }
            latchWithValidCert.await(1L, TimeUnit.SECONDS);
            Assert.assertEquals((long)validCertResult.get(), (long)0L);
            newTlsCertFile.delete();
        }
    }

    @Test
    public void testConnectToTLSClusterMixedClient() throws Exception {
        ClientConfiguration confWithTLS = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        this.testClient(confWithTLS, this.numBookies);
        ClientConfiguration confNoTLS = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        confNoTLS.setTLSProviderFactoryClass(null);
        this.testClient(confNoTLS, this.numBookies);
    }

    @Test
    public void testConnectToTLSClusterTLSClientWithTLSNoAuthentication() throws Exception {
        this.restartBookies(c -> {
            c.setTLSClientAuthentication(false);
            return c;
        });
        ClientConfiguration conf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        this.testClient(conf, this.numBookies);
    }

    @Test
    public void testConnectToTLSClusterTLSClientWithAuthentication() throws Exception {
        ClientConfiguration conf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        try {
            this.testClient(conf, this.numBookies);
        }
        catch (BKException.BKNotEnoughBookiesException nnbe) {
            Assert.fail((String)"Client should be able to connect to bookie");
        }
    }

    @Test
    public void testConnectToTLSClusterNonTLSClient() throws Exception {
        ClientConfiguration conf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        conf.setTLSProviderFactoryClass(null);
        try {
            this.testClient(conf, this.numBookies);
        }
        catch (BKException.BKNotEnoughBookiesException nnbe) {
            Assert.fail((String)"non tls client should be able to connect to tls enabled bookies");
        }
    }

    @Test
    public void testClientWantsTLSNoServersHaveIt() throws Exception {
        this.restartBookies(c -> {
            c.setTLSProviderFactoryClass(null);
            return c;
        });
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        try {
            this.testClient(clientConf, this.numBookies);
            Assert.fail((String)"Shouldn't be able to connect");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testTLSClientButOnlyFewTLSServers() throws Exception {
        this.restartBookies(c -> {
            c.setTLSProviderFactoryClass(null);
            return c;
        });
        this.baseConf.setTLSProviderFactoryClass(TLSContextFactory.class.getName());
        HashSet<Integer> tlsBookiePorts = new HashSet<Integer>();
        tlsBookiePorts.add(this.startNewBookie());
        tlsBookiePorts.add(this.startNewBookie());
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        LedgerMetadata metadata = this.testClient(clientConf, 2);
        Assert.assertTrue((metadata.getAllEnsembles().size() > 0 ? 1 : 0) != 0);
        Collection ensembles = metadata.getAllEnsembles().values();
        try (BookKeeper client = new BookKeeper(clientConf);){
            for (List bookies : ensembles) {
                for (BookieId bookieAddress : bookies) {
                    int port = client.getBookieAddressResolver().resolve(bookieAddress).getPort();
                    Assert.assertTrue((boolean)tlsBookiePorts.contains(port));
                }
            }
        }
    }

    @Test
    public void testClientAuthPlugin() throws Exception {
        secureClientSideChannel = false;
        secureClientSideChannelPrincipals = null;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        clientConf.setClientAuthProviderFactoryClass(AllowOnlyBookiesWithX509Certificates.class.getName());
        this.testClient(clientConf, this.numBookies);
        Assert.assertTrue((boolean)secureClientSideChannel);
        Assert.assertNotNull(secureClientSideChannelPrincipals);
        Assert.assertTrue((!secureClientSideChannelPrincipals.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(secureClientSideChannelPrincipals.iterator().next() instanceof Certificate));
        Certificate cert = (Certificate)secureClientSideChannelPrincipals.iterator().next();
        Assert.assertTrue((boolean)(cert instanceof X509Certificate));
    }

    @Test
    public void testBookieAuthPluginRequireClientTLSAuthentication() throws Exception {
        this.restartBookies(c -> {
            c.setBookieAuthProviderFactoryClass(AllowOnlyClientsWithX509Certificates.class.getName());
            return c;
        });
        secureBookieSideChannel = false;
        secureBookieSideChannelPrincipals = null;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        this.testClient(clientConf, this.numBookies);
        Assert.assertTrue((boolean)secureBookieSideChannel);
        Assert.assertNotNull(secureBookieSideChannelPrincipals);
        Assert.assertTrue((!secureBookieSideChannelPrincipals.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(secureBookieSideChannelPrincipals.iterator().next() instanceof Certificate));
        Certificate cert = (Certificate)secureBookieSideChannelPrincipals.iterator().next();
        Assert.assertTrue((boolean)(cert instanceof X509Certificate));
    }

    @Test
    public void testBookieAuthPluginRequireClientTLSAuthenticationLocal() throws Exception {
        if (this.useV2Protocol) {
            return;
        }
        this.restartBookies(c -> {
            c.setBookieAuthProviderFactoryClass(AllowOnlyClientsWithX509Certificates.class.getName());
            c.setDisableServerSocketBind(true);
            c.setEnableLocalTransport(true);
            return c;
        });
        secureBookieSideChannel = false;
        secureBookieSideChannelPrincipals = null;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        this.testClient(clientConf, this.numBookies);
        Assert.assertTrue((boolean)secureBookieSideChannel);
        Assert.assertNotNull(secureBookieSideChannelPrincipals);
        Assert.assertTrue((!secureBookieSideChannelPrincipals.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(secureBookieSideChannelPrincipals.iterator().next() instanceof Certificate));
        Certificate cert = (Certificate)secureBookieSideChannelPrincipals.iterator().next();
        Assert.assertTrue((boolean)(cert instanceof X509Certificate));
    }

    @Test
    public void testRoleBasedAuthZInCertificate() throws Exception {
        this.restartBookies(serverConf -> {
            serverConf.setBookieAuthProviderFactoryClass(BookieAuthZFactory.class.getCanonicalName());
            serverConf.setAuthorizedRoles("testRole,testRole1");
            return serverConf;
        });
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        try {
            this.testClient(clientConf, this.numBookies);
        }
        catch (BKException.BKUnauthorizedAccessException bke) {
            Assert.fail((String)"Could not verify given role.");
        }
    }

    @Test
    public void testBookieAuthPluginDenyAccesstoClientWithoutTLSAuthentication() throws Exception {
        block3: {
            this.restartBookies(c -> {
                c.setTLSClientAuthentication(false);
                c.setBookieAuthProviderFactoryClass(AllowOnlyClientsWithX509Certificates.class.getName());
                return c;
            });
            secureBookieSideChannel = false;
            secureBookieSideChannelPrincipals = null;
            ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
            clientConf.setTLSClientAuthentication(false);
            try {
                this.testClient(clientConf, this.numBookies);
                Assert.fail((String)"Shouldn't be able to connect");
            }
            catch (BKException.BKUnauthorizedAccessException bKUnauthorizedAccessException) {
            }
            catch (BKException.BKNotEnoughBookiesException notEnoughBookiesException) {
                if (this.useV2Protocol) break block3;
                Assert.fail((String)"Unexpected exception occurred.");
            }
        }
        Assert.assertTrue((boolean)secureBookieSideChannel);
        Assert.assertNotNull(secureBookieSideChannelPrincipals);
        Assert.assertTrue((boolean)secureBookieSideChannelPrincipals.isEmpty());
    }

    @Test
    public void testBookieAuthPluginDenyAccessToClientWithoutTLSAuthenticationLocal() throws Exception {
        block3: {
            this.restartBookies(c -> {
                c.setTLSClientAuthentication(false);
                c.setBookieAuthProviderFactoryClass(AllowOnlyClientsWithX509Certificates.class.getName());
                c.setDisableServerSocketBind(true);
                c.setEnableLocalTransport(true);
                return c;
            });
            secureBookieSideChannel = false;
            secureBookieSideChannelPrincipals = null;
            ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
            clientConf.setTLSClientAuthentication(false);
            try {
                this.testClient(clientConf, this.numBookies);
                Assert.fail((String)"Shouldn't be able to connect");
            }
            catch (BKException.BKUnauthorizedAccessException bKUnauthorizedAccessException) {
            }
            catch (BKException.BKNotEnoughBookiesException notEnoughBookiesException) {
                if (this.useV2Protocol) break block3;
                Assert.fail((String)"Unexpected exception occurred.");
            }
        }
        Assert.assertTrue((boolean)secureBookieSideChannel);
        Assert.assertNotNull(secureBookieSideChannelPrincipals);
        Assert.assertTrue((boolean)secureBookieSideChannelPrincipals.isEmpty());
    }

    @Test
    public void testBookieAuthPluginDenyAccessToClientWithoutTLS() throws Exception {
        this.restartBookies(c -> {
            c.setBookieAuthProviderFactoryClass(AllowOnlyClientsWithX509Certificates.class.getName());
            return c;
        });
        secureBookieSideChannel = false;
        secureBookieSideChannelPrincipals = null;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        clientConf.setTLSProviderFactoryClass(null);
        try {
            this.testClient(clientConf, this.numBookies);
            Assert.fail((String)"Shouldn't be able to connect");
        }
        catch (BKException.BKUnauthorizedAccessException bKUnauthorizedAccessException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)secureBookieSideChannel);
        Assert.assertNull(secureBookieSideChannelPrincipals);
    }

    @Test
    public void testMixedCluster() throws Exception {
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        int origNumBookies = this.numBookies;
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setTLSProviderFactoryClass(TLSContextFactory.class.getName());
        this.startAndAddBookie(bookieConf);
        this.testClient(clientConf, origNumBookies + 1);
    }

    @Test
    public void testHungServer() throws Exception {
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        CountDownLatch latch = new CountDownLatch(1);
        this.sleepBookie(this.getBookie(0), latch);
        try {
            this.testClient(clientConf, this.numBookies);
            Assert.fail((String)"Shouldn't be able to connect");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        LOG.info("latch countdown");
        latch.countDown();
    }

    @Test
    public void testTLSChannelCounters() throws Exception {
        ClientConfiguration tlsClientconf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf).setNumChannelsPerBookie(1);
        ClientConfiguration nonTlsClientconf = (ClientConfiguration)new ClientConfiguration((AbstractConfiguration)this.baseClientConf).setNumChannelsPerBookie(1).setTLSProviderFactoryClass(null);
        TestStatsProvider tlsStatsProvider = new TestStatsProvider();
        TestStatsProvider nonTlsStatsProvider = new TestStatsProvider();
        BookKeeperTestClient tlsClient = new BookKeeperTestClient(tlsClientconf, tlsStatsProvider);
        BookKeeperTestClient nonTlsClient = new BookKeeperTestClient(nonTlsClientconf, nonTlsStatsProvider);
        this.testClient(tlsClient, this.numBookies);
        this.testClient(nonTlsClient, this.numBookies);
        for (int i = 0; i < this.numBookies; ++i) {
            BookieServer bookie = this.serverByIndex(i);
            StringBuilder nameBuilder = new StringBuilder("per_channel_bookie_client").append(".").append("bookie_").append(TestUtils.buildStatsCounterPathFromBookieID(bookie.getBookieId())).append(".");
            TestStatsProvider.TestCounter cntr = tlsClient.getTestStatsProvider().getCounter(nameBuilder + "ACTIVE_TLS_CHANNEL_COUNTER");
            Assert.assertEquals((String)"Mismatch TLS channel count", (long)1L, (long)tlsClient.getTestStatsProvider().getCounter(nameBuilder + "ACTIVE_TLS_CHANNEL_COUNTER").get());
            Assert.assertEquals((String)"TLS handshake failure unexpected", (long)0L, (long)tlsClient.getTestStatsProvider().getCounter(nameBuilder + "FAILED_TLS_HANDSHAKE_COUNTER").get());
            Assert.assertEquals((String)"Mismatch non-TLS channel count", (long)0L, (long)tlsClient.getTestStatsProvider().getCounter(nameBuilder + "ACTIVE_NON_TLS_CHANNEL_COUNTER").get());
            Assert.assertEquals((String)"Connection failures unexpected", (long)0L, (long)tlsClient.getTestStatsProvider().getCounter(nameBuilder + "FAILED_CONNECTION_COUNTER").get());
            Assert.assertEquals((String)"Mismatch TLS channel count", (long)0L, (long)nonTlsClient.getTestStatsProvider().getCounter(nameBuilder + "ACTIVE_TLS_CHANNEL_COUNTER").get());
            Assert.assertEquals((String)"TLS handshake failure unexpected", (long)0L, (long)nonTlsClient.getTestStatsProvider().getCounter(nameBuilder + "FAILED_TLS_HANDSHAKE_COUNTER").get());
            Assert.assertEquals((String)"Mismatch non-TLS channel count", (long)1L, (long)nonTlsClient.getTestStatsProvider().getCounter(nameBuilder + "ACTIVE_NON_TLS_CHANNEL_COUNTER").get());
            Assert.assertEquals((String)"Connection failures unexpected", (long)0L, (long)nonTlsClient.getTestStatsProvider().getCounter(nameBuilder + "FAILED_CONNECTION_COUNTER").get());
            bookie.shutdown();
            Assert.assertEquals((String)"Mismatch TLS channel count", (long)0L, (long)tlsClient.getTestStatsProvider().getCounter(nameBuilder + "ACTIVE_TLS_CHANNEL_COUNTER").get());
            Assert.assertEquals((String)"Mismatch non-TLS channel count", (long)0L, (long)nonTlsClient.getTestStatsProvider().getCounter(nameBuilder + "ACTIVE_NON_TLS_CHANNEL_COUNTER").get());
        }
    }

    @Test
    public void testHandshakeFailure() throws Exception {
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf).setNumChannelsPerBookie(1);
        int restartBookieIdx = 0;
        ServerConfiguration badBookieConf = this.confByIndex(restartBookieIdx);
        switch (this.serverTrustStoreFormat) {
            case PEM: {
                badBookieConf.setTLSTrustStore(this.getResourcePath("server-cert.pem"));
                break;
            }
            case JKS: {
                badBookieConf.setTLSTrustStore(this.getResourcePath("server-key.jks")).setTLSTrustStorePasswordPath(this.getResourcePath("keyStoreServerPassword.txt"));
                break;
            }
            case PKCS12: {
                badBookieConf.setTLSTrustStore(this.getResourcePath("server-key.p12")).setTLSTrustStorePasswordPath(this.getResourcePath("keyStoreServerPassword.txt"));
                break;
            }
            default: {
                throw new Exception("Unrecognized trust store format: " + this.serverTrustStoreFormat);
            }
        }
        this.killBookie(restartBookieIdx);
        LOG.info("Sleeping for 1s before restarting bookie with bad cert");
        Thread.sleep(1000L);
        BookieServer bookie = this.startAndAddBookie(badBookieConf).getServer();
        TestStatsProvider testStatsProvider = new TestStatsProvider();
        BookKeeperTestClient client = new BookKeeperTestClient(clientConf, testStatsProvider);
        byte[] passwd = "testPassword".getBytes();
        int numEntries = 2;
        byte[] testEntry = "testEntry".getBytes();
        try (LedgerHandle lh2 = client.createLedger(this.numBookies, this.numBookies, this.numBookies, BookKeeper.DigestType.CRC32, passwd);){
            for (int i = 0; i <= numEntries; ++i) {
                lh2.addEntry(testEntry);
            }
            Assert.fail((String)"Should have failed with not enough bookies to write");
        }
        catch (BKException.BKNotEnoughBookiesException lh2) {
            // empty catch block
        }
        StringBuilder nameBuilder = new StringBuilder("per_channel_bookie_client").append(".").append("bookie_").append(TestUtils.buildStatsCounterPathFromBookieID(bookie.getBookieId())).append(".");
        Assert.assertEquals((String)"TLS handshake failure expected", (long)1L, (long)client.getTestStatsProvider().getCounter(nameBuilder + "FAILED_TLS_HANDSHAKE_COUNTER").get());
    }

    @Test
    public void testClientAuthPluginWithHostnameVerificationEnabled() throws Exception {
        secureClientSideChannel = false;
        secureClientSideChannelPrincipals = null;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        clientConf.setClientAuthProviderFactoryClass(AllowOnlyBookiesWithX509Certificates.class.getName());
        clientConf.setHostnameVerificationEnabled(true);
        try {
            this.testClient(clientConf, this.numBookies);
            Assert.fail((String)"should have failed with unauthorized exception");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    private static class AllowOnlyClientsWithX509Certificates
    implements BookieAuthProvider.Factory {
        private AllowOnlyClientsWithX509Certificates() {
        }

        public String getPluginName() {
            return "tls";
        }

        public void init(ServerConfiguration conf) throws IOException {
        }

        public BookieAuthProvider newProvider(final BookieConnectionPeer addr, final AuthCallbacks.GenericCallback<Void> completeCb) {
            return new BookieAuthProvider(){
                AuthCallbacks.GenericCallback<Void> completeCallback;
                {
                    this.completeCallback = completeCb;
                }

                public void onProtocolUpgrade() {
                    secureBookieSideChannel = addr.isSecure();
                    secureBookieSideChannelPrincipals = addr.getProtocolPrincipals();
                    Collection certificates = addr.getProtocolPrincipals();
                    if (addr.isSecure() && !certificates.isEmpty()) {
                        Assert.assertTrue((boolean)(certificates.iterator().next() instanceof X509Certificate));
                        this.completeCallback.operationComplete(0, null);
                    } else {
                        this.completeCallback.operationComplete(-102, null);
                    }
                }

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                }
            };
        }
    }

    private static class AllowOnlyBookiesWithX509Certificates
    implements ClientAuthProvider.Factory {
        private AllowOnlyBookiesWithX509Certificates() {
        }

        public String getPluginName() {
            return "tls";
        }

        public void init(ClientConfiguration conf) {
        }

        public ClientAuthProvider newProvider(final ClientConnectionPeer addr, AuthCallbacks.GenericCallback<Void> completeCb) {
            return new ClientAuthProvider(){
                AuthCallbacks.GenericCallback<AuthToken> completeCallback;

                public void init(AuthCallbacks.GenericCallback<AuthToken> cb) {
                    this.completeCallback = cb;
                }

                public void onProtocolUpgrade() {
                    secureClientSideChannel = addr.isSecure();
                    secureClientSideChannelPrincipals = addr.getProtocolPrincipals();
                    Collection certificates = addr.getProtocolPrincipals();
                    if (addr.isSecure() && !certificates.isEmpty()) {
                        Assert.assertTrue((boolean)(certificates.iterator().next() instanceof X509Certificate));
                        this.completeCallback.operationComplete(0, (Object)AuthToken.NULL);
                    } else {
                        this.completeCallback.operationComplete(-102, (Object)AuthToken.NULL);
                    }
                }

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                }
            };
        }
    }
}

