/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.AbstractFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCallbacks {
    private static final Logger logger = LoggerFactory.getLogger(TestCallbacks.class);

    public static class AddCallbackFuture
    extends AbstractFuture<Long>
    implements AsyncCallback.AddCallback {
        private final long expectedEntryId;

        public AddCallbackFuture(long entryId) {
            this.expectedEntryId = entryId;
        }

        public long getExpectedEntryId() {
            return this.expectedEntryId;
        }

        public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
            logger.info("Add entry {} completed : entryId = {}, rc = {}", new Object[]{this.expectedEntryId, entryId, rc});
            if (rc != 0) {
                this.setException(BKException.create((int)rc));
            } else {
                this.set(entryId);
            }
        }
    }
}

