/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.streaming.LedgerInputStream;
import org.apache.bookkeeper.streaming.LedgerOutputStream;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieReadWriteTest
extends BookKeeperClusterTestCase
implements AsyncCallback.AddCallback,
AsyncCallback.ReadCallback,
AsyncCallback.ReadLastConfirmedCallback {
    private static final Logger LOG = LoggerFactory.getLogger(BookieReadWriteTest.class);
    byte[] ledgerPassword = "aaa".getBytes();
    LedgerHandle lh;
    LedgerHandle lh2;
    long ledgerId;
    int numEntriesToWrite = 200;
    int maxInt = Integer.MAX_VALUE;
    Random rng;
    ArrayList<byte[]> entries;
    ArrayList<Integer> entriesSize;
    private final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    public BookieReadWriteTest() {
        super(3);
        String ledgerManagerFactory = "org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory";
        this.baseConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
        this.baseClientConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
    }

    @Test
    public void testOpenException() throws IOException, InterruptedException {
        try {
            this.lh = this.bkc.openLedger(0L, this.digestType, this.ledgerPassword);
            Assert.fail((String)"Haven't thrown exception");
        }
        catch (BKException e) {
            LOG.warn("Successfully thrown and caught exception:", (Throwable)e);
        }
    }

    @Test
    public void testStreamingClients() throws IOException, BKException, InterruptedException {
        int read;
        this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
        String toWrite = "we need to check for this string to match and for the record mahadev is the best";
        LedgerOutputStream lout = new LedgerOutputStream(this.lh, 1);
        byte[] b = toWrite.getBytes();
        lout.write(b);
        lout.close();
        long lId = this.lh.getId();
        this.lh.close();
        this.lh = this.bkc.openLedger(lId, this.digestType, this.ledgerPassword);
        LedgerInputStream lin = new LedgerInputStream(this.lh, 1);
        byte[] bread = new byte[b.length];
        for (read = 0; read < b.length; read += lin.read(bread, read, b.length)) {
        }
        String newString = new String(bread);
        Assert.assertTrue((String)"these two should same", (boolean)toWrite.equals(newString));
        lin.close();
        this.lh.close();
        this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
        lout = new LedgerOutputStream(this.lh);
        for (int i = 0; i < b.length; ++i) {
            lout.write((int)b[i]);
        }
        lout.close();
        lId = this.lh.getId();
        this.lh.close();
        this.lh = this.bkc.openLedger(lId, this.digestType, this.ledgerPassword);
        lin = new LedgerInputStream(this.lh);
        bread = new byte[b.length];
        for (read = 0; read < b.length; read += lin.read(bread, read, b.length)) {
        }
        newString = new String(bread);
        Assert.assertTrue((String)"these two should be same ", (boolean)toWrite.equals(newString));
        lin.close();
        this.lh.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadWriteAsyncSingleClient(int numEntries) throws IOException {
        SyncObj sync = new SyncObj();
        try {
            this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            this.ledgerId = this.lh.getId();
            LOG.info("Ledger ID: " + this.lh.getId());
            for (int i = 0; i < this.numEntriesToWrite; ++i) {
                ByteBuffer entry = ByteBuffer.allocate(4);
                entry.putInt(this.rng.nextInt(this.maxInt));
                entry.position(0);
                this.entries.add(entry.array());
                this.entriesSize.add(entry.array().length);
                this.lh.asyncAddEntry(entry.array(), (AsyncCallback.AddCallback)this, (Object)sync);
            }
            SyncObj i = sync;
            synchronized (i) {
                while (sync.counter < this.numEntriesToWrite) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Entries counter = " + sync.counter);
                    }
                    sync.wait();
                }
                Assert.assertEquals((String)"Error adding", (long)0L, (long)sync.getReturnCode());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** WRITE COMPLETE ***");
            }
            this.lh.close();
            this.lh = this.bkc.openLedger(this.ledgerId, this.digestType, this.ledgerPassword);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number of entries written: " + (this.lh.getLastAddConfirmed() + 1L));
            }
            Assert.assertTrue((String)"Verifying number of entries written", (this.lh.getLastAddConfirmed() == (long)(this.numEntriesToWrite - 1) ? 1 : 0) != 0);
            this.lh.asyncReadEntries(0L, (long)(this.numEntriesToWrite - 1), (AsyncCallback.ReadCallback)this, (Object)sync);
            i = sync;
            synchronized (i) {
                while (!sync.value) {
                    sync.wait();
                }
                Assert.assertEquals((String)"Error reading", (long)0L, (long)sync.getReturnCode());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** READ COMPLETE ***");
            }
            int i2 = 0;
            Enumeration<LedgerEntry> ls = sync.getLedgerEntries();
            while (ls.hasMoreElements()) {
                ByteBuffer origbb = ByteBuffer.wrap(this.entries.get(i2));
                Integer origEntry = origbb.getInt();
                byte[] entry = ls.nextElement().getEntry();
                ByteBuffer result = ByteBuffer.wrap(entry);
                Integer retrEntry = result.getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Length of result: " + result.capacity());
                    LOG.debug("Original entry: " + origEntry);
                    LOG.debug("Retrieved entry: " + retrEntry);
                }
                Assert.assertTrue((String)("Checking entry " + i2 + " for equality"), (boolean)origEntry.equals(retrEntry));
                Assert.assertTrue((String)("Checking entry " + i2 + " for size"), (entry.length == this.entriesSize.get(i2) ? 1 : 0) != 0);
                ++i2;
            }
            Assert.assertTrue((String)"Checking number of read entries", (i2 == this.numEntriesToWrite ? 1 : 0) != 0);
            this.lh.close();
        }
        catch (BKException e) {
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to BookKeeper exception");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to interruption");
        }
    }

    @Test
    public void testReadWriteAsyncSingleClient200() throws IOException {
        this.testReadWriteAsyncSingleClient(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWriteRangeAsyncSingleClient() throws IOException {
        SyncObj sync = new SyncObj();
        try {
            this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            this.ledgerId = this.lh.getId();
            LOG.info("Ledger ID: " + this.lh.getId());
            byte[] bytes = new byte[]{97, 98, 99, 100, 101, 102, 103, 104, 105};
            this.lh.asyncAddEntry(bytes, 0, bytes.length, (AsyncCallback.AddCallback)this, (Object)sync);
            this.lh.asyncAddEntry(bytes, 0, 4, (AsyncCallback.AddCallback)this, (Object)sync);
            this.lh.asyncAddEntry(bytes, 3, 4, (AsyncCallback.AddCallback)this, (Object)sync);
            this.lh.asyncAddEntry(bytes, 3, bytes.length - 3, (AsyncCallback.AddCallback)this, (Object)sync);
            int numEntries = 4;
            SyncObj syncObj = sync;
            synchronized (syncObj) {
                while (sync.counter < numEntries) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Entries counter = " + sync.counter);
                    }
                    sync.wait();
                }
                Assert.assertEquals((String)"Error adding", (long)0L, (long)sync.getReturnCode());
            }
            try {
                this.lh.asyncAddEntry(bytes, -1, bytes.length, (AsyncCallback.AddCallback)this, (Object)sync);
                Assert.fail((String)"Shouldn't be able to use negative offset");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            try {
                this.lh.asyncAddEntry(bytes, 0, bytes.length + 1, (AsyncCallback.AddCallback)this, (Object)sync);
                Assert.fail((String)"Shouldn't be able to use that much length");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            try {
                this.lh.asyncAddEntry(bytes, -1, bytes.length + 2, (AsyncCallback.AddCallback)this, (Object)sync);
                Assert.fail((String)"Shouldn't be able to use negative offset with that much length");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            try {
                this.lh.asyncAddEntry(bytes, 4, -3, (AsyncCallback.AddCallback)this, (Object)sync);
                Assert.fail((String)"Shouldn't be able to use negative length");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            try {
                this.lh.asyncAddEntry(bytes, -4, -3, (AsyncCallback.AddCallback)this, (Object)sync);
                Assert.fail((String)"Shouldn't be able to use negative offset & length");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** WRITE COMPLETE ***");
            }
            this.lh.close();
            this.lh = this.bkc.openLedger(this.ledgerId, this.digestType, this.ledgerPassword);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number of entries written: " + (this.lh.getLastAddConfirmed() + 1L));
            }
            Assert.assertTrue((String)"Verifying number of entries written", (this.lh.getLastAddConfirmed() == (long)(numEntries - 1) ? 1 : 0) != 0);
            this.lh.asyncReadEntries(0L, (long)(numEntries - 1), (AsyncCallback.ReadCallback)this, (Object)sync);
            syncObj = sync;
            synchronized (syncObj) {
                while (!sync.value) {
                    sync.wait();
                }
                Assert.assertEquals((String)"Error reading", (long)0L, (long)sync.getReturnCode());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** READ COMPLETE ***");
            }
            int i = 0;
            Enumeration<LedgerEntry> ls = sync.getLedgerEntries();
            while (ls.hasMoreElements()) {
                byte[] expected = null;
                byte[] entry = ls.nextElement().getEntry();
                switch (i) {
                    case 0: {
                        expected = Arrays.copyOfRange(bytes, 0, bytes.length);
                        break;
                    }
                    case 1: {
                        expected = Arrays.copyOfRange(bytes, 0, 4);
                        break;
                    }
                    case 2: {
                        expected = Arrays.copyOfRange(bytes, 3, 7);
                        break;
                    }
                    case 3: {
                        expected = Arrays.copyOfRange(bytes, 3, 3 + (bytes.length - 3));
                    }
                }
                Assert.assertNotNull((String)"There are more checks than writes", expected);
                String message = "Checking entry " + i + " for equality [" + new String(entry, "UTF-8") + "," + new String(expected, "UTF-8") + "]";
                Assert.assertTrue((String)message, (boolean)Arrays.equals(entry, expected));
                ++i;
            }
            Assert.assertTrue((String)"Checking number of read entries", (i == numEntries ? 1 : 0) != 0);
            this.lh.close();
        }
        catch (BKException e) {
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to BookKeeper exception");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to interruption");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyncReadAsyncWriteStringsSingleClient() throws IOException {
        SyncObj sync = new SyncObj();
        LOG.info("TEST READ WRITE STRINGS MIXED SINGLE CLIENT");
        String charset = "utf-8";
        if (LOG.isDebugEnabled()) {
            LOG.debug("Default charset: " + Charset.defaultCharset());
        }
        try {
            this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            this.ledgerId = this.lh.getId();
            LOG.info("Ledger ID: " + this.lh.getId());
            for (int i = 0; i < this.numEntriesToWrite; ++i) {
                int randomInt = this.rng.nextInt(this.maxInt);
                byte[] entry = Integer.toString(randomInt).getBytes(charset);
                this.entries.add(entry);
                this.lh.asyncAddEntry(entry, (AsyncCallback.AddCallback)this, (Object)sync);
            }
            SyncObj i = sync;
            synchronized (i) {
                while (sync.counter < this.numEntriesToWrite) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Entries counter = " + sync.counter);
                    }
                    sync.wait();
                }
                Assert.assertEquals((String)"Error adding", (long)0L, (long)sync.getReturnCode());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** ASYNC WRITE COMPLETE ***");
            }
            this.lh.close();
            this.lh = this.bkc.openLedger(this.ledgerId, this.digestType, this.ledgerPassword);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number of entries written: " + (this.lh.getLastAddConfirmed() + 1L));
            }
            Assert.assertTrue((String)"Verifying number of entries written", (this.lh.getLastAddConfirmed() == (long)(this.numEntriesToWrite - 1) ? 1 : 0) != 0);
            Enumeration ls = this.lh.readEntries(0L, (long)(this.numEntriesToWrite - 1));
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** SYNC READ COMPLETE ***");
            }
            int i2 = 0;
            while (ls.hasMoreElements()) {
                byte[] origEntryBytes = this.entries.get(i2++);
                byte[] retrEntryBytes = ((LedgerEntry)ls.nextElement()).getEntry();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Original byte entry size: " + origEntryBytes.length);
                    LOG.debug("Saved byte entry size: " + retrEntryBytes.length);
                }
                String origEntry = new String(origEntryBytes, charset);
                String retrEntry = new String(retrEntryBytes, charset);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Original entry: " + origEntry);
                    LOG.debug("Retrieved entry: " + retrEntry);
                }
                Assert.assertTrue((String)("Checking entry " + i2 + " for equality"), (boolean)origEntry.equals(retrEntry));
            }
            Assert.assertTrue((String)"Checking number of read entries", (i2 == this.numEntriesToWrite ? 1 : 0) != 0);
            this.lh.close();
        }
        catch (BKException e) {
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to BookKeeper exception");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to interruption");
        }
    }

    @Test
    public void testReadWriteSyncSingleClient() throws IOException {
        try {
            this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            this.ledgerId = this.lh.getId();
            LOG.info("Ledger ID: " + this.lh.getId());
            for (int i = 0; i < this.numEntriesToWrite; ++i) {
                ByteBuffer entry = ByteBuffer.allocate(4);
                entry.putInt(this.rng.nextInt(this.maxInt));
                entry.position(0);
                this.entries.add(entry.array());
                this.lh.addEntry(entry.array());
            }
            this.lh.close();
            this.lh = this.bkc.openLedger(this.ledgerId, this.digestType, this.ledgerPassword);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number of entries written: " + this.lh.getLastAddConfirmed());
            }
            Assert.assertTrue((String)"Verifying number of entries written", (this.lh.getLastAddConfirmed() == (long)(this.numEntriesToWrite - 1) ? 1 : 0) != 0);
            Enumeration ls = this.lh.readEntries(0L, (long)(this.numEntriesToWrite - 1));
            int i = 0;
            while (ls.hasMoreElements()) {
                ByteBuffer origbb = ByteBuffer.wrap(this.entries.get(i++));
                Integer origEntry = origbb.getInt();
                ByteBuffer result = ByteBuffer.wrap(((LedgerEntry)ls.nextElement()).getEntry());
                Integer retrEntry = result.getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Length of result: " + result.capacity());
                    LOG.debug("Original entry: " + origEntry);
                    LOG.debug("Retrieved entry: " + retrEntry);
                }
                Assert.assertTrue((String)("Checking entry " + i + " for equality"), (boolean)origEntry.equals(retrEntry));
            }
            this.lh.close();
        }
        catch (BKException e) {
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to BookKeeper exception");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to interruption");
        }
    }

    @Test
    public void testReadWriteZero() throws IOException {
        try {
            this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            this.ledgerId = this.lh.getId();
            LOG.info("Ledger ID: " + this.lh.getId());
            final CountDownLatch completeLatch = new CountDownLatch(this.numEntriesToWrite);
            final AtomicInteger rc = new AtomicInteger(0);
            for (int i = 0; i < this.numEntriesToWrite; ++i) {
                this.lh.asyncAddEntry(new byte[0], new AsyncCallback.AddCallback(){

                    public void addComplete(int rccb, LedgerHandle lh, long entryId, Object ctx) {
                        rc.compareAndSet(0, rccb);
                        completeLatch.countDown();
                    }
                }, null);
            }
            completeLatch.await();
            if (rc.get() != 0) {
                throw BKException.create((int)rc.get());
            }
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries.add(entry.array());
            this.lh.addEntry(entry.array());
            this.lh.close();
            this.lh = this.bkc.openLedger(this.ledgerId, this.digestType, this.ledgerPassword);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number of entries written: " + this.lh.getLastAddConfirmed());
            }
            Assert.assertTrue((String)"Verifying number of entries written", (this.lh.getLastAddConfirmed() == (long)this.numEntriesToWrite ? 1 : 0) != 0);
            Enumeration ls = this.lh.readEntries(0L, (long)(this.numEntriesToWrite - 1));
            int i = 0;
            while (ls.hasMoreElements()) {
                ByteBuffer result = ByteBuffer.wrap(((LedgerEntry)ls.nextElement()).getEntry());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Length of result: " + result.capacity());
                }
                Assert.assertTrue((String)("Checking if entry " + i + " has zero bytes"), (result.capacity() == 0 ? 1 : 0) != 0);
            }
            this.lh.close();
        }
        catch (BKException e) {
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to BookKeeper exception");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to interruption");
        }
    }

    @Test
    public void testMultiLedger() throws IOException {
        try {
            ByteBuffer result;
            this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            this.lh2 = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            long ledgerId = this.lh.getId();
            long ledgerId2 = this.lh2.getId();
            final CountDownLatch completeLatch = new CountDownLatch(this.numEntriesToWrite * 2);
            final AtomicInteger rc = new AtomicInteger(0);
            LOG.info("Ledger ID 1: " + this.lh.getId() + ", Ledger ID 2: " + this.lh2.getId());
            for (int i = 0; i < this.numEntriesToWrite; ++i) {
                this.lh.asyncAddEntry(new byte[0], new AsyncCallback.AddCallback(){

                    public void addComplete(int rc2, LedgerHandle lh, long entryId, Object ctx) {
                        rc.compareAndSet(0, rc2);
                        completeLatch.countDown();
                    }
                }, null);
                this.lh2.asyncAddEntry(new byte[0], new AsyncCallback.AddCallback(){

                    public void addComplete(int rc2, LedgerHandle lh, long entryId, Object ctx) {
                        rc.compareAndSet(0, rc2);
                        completeLatch.countDown();
                    }
                }, null);
            }
            completeLatch.await();
            if (rc.get() != 0) {
                throw BKException.create((int)rc.get());
            }
            this.lh.close();
            this.lh2.close();
            this.lh = this.bkc.openLedger(ledgerId, this.digestType, this.ledgerPassword);
            this.lh2 = this.bkc.openLedger(ledgerId2, this.digestType, this.ledgerPassword);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number of entries written: " + this.lh.getLastAddConfirmed() + ", " + this.lh2.getLastAddConfirmed());
            }
            Assert.assertTrue((String)("Verifying number of entries written lh (" + this.lh.getLastAddConfirmed() + ")"), (this.lh.getLastAddConfirmed() == (long)(this.numEntriesToWrite - 1) ? 1 : 0) != 0);
            Assert.assertTrue((String)("Verifying number of entries written lh2 (" + this.lh2.getLastAddConfirmed() + ")"), (this.lh2.getLastAddConfirmed() == (long)(this.numEntriesToWrite - 1) ? 1 : 0) != 0);
            Enumeration ls = this.lh.readEntries(0L, (long)(this.numEntriesToWrite - 1));
            int i = 0;
            while (ls.hasMoreElements()) {
                result = ByteBuffer.wrap(((LedgerEntry)ls.nextElement()).getEntry());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Length of result: " + result.capacity());
                }
                Assert.assertTrue((String)("Checking if entry " + i + " has zero bytes"), (result.capacity() == 0 ? 1 : 0) != 0);
            }
            this.lh.close();
            ls = this.lh2.readEntries(0L, (long)(this.numEntriesToWrite - 1));
            i = 0;
            while (ls.hasMoreElements()) {
                result = ByteBuffer.wrap(((LedgerEntry)ls.nextElement()).getEntry());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Length of result: " + result.capacity());
                }
                Assert.assertTrue((String)("Checking if entry " + i + " has zero bytes"), (result.capacity() == 0 ? 1 : 0) != 0);
            }
            this.lh2.close();
        }
        catch (BKException e) {
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to BookKeeper exception");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to interruption");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWriteAsyncLength() throws IOException {
        SyncObj sync = new SyncObj();
        try {
            this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            this.ledgerId = this.lh.getId();
            LOG.info("Ledger ID: " + this.lh.getId());
            for (int i = 0; i < this.numEntriesToWrite; ++i) {
                ByteBuffer entry = ByteBuffer.allocate(4);
                entry.putInt(this.rng.nextInt(this.maxInt));
                entry.position(0);
                this.entries.add(entry.array());
                this.entriesSize.add(entry.array().length);
                this.lh.asyncAddEntry(entry.array(), (AsyncCallback.AddCallback)this, (Object)sync);
            }
            SyncObj i = sync;
            synchronized (i) {
                while (sync.counter < this.numEntriesToWrite) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Entries counter = " + sync.counter);
                    }
                    sync.wait();
                }
                Assert.assertEquals((String)"Error adding", (long)0L, (long)sync.getReturnCode());
            }
            long length = this.numEntriesToWrite * 4;
            Assert.assertTrue((String)("Ledger length before closing: " + this.lh.getLength()), (this.lh.getLength() == length ? 1 : 0) != 0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** WRITE COMPLETE ***");
            }
            this.lh.close();
            this.lh = this.bkc.openLedger(this.ledgerId, this.digestType, this.ledgerPassword);
            Assert.assertTrue((String)("Ledger length after opening: " + this.lh.getLength()), (this.lh.getLength() == length ? 1 : 0) != 0);
            this.lh.close();
        }
        catch (BKException e) {
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to BookKeeper exception");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to interruption");
        }
    }

    private long writeNEntriesLastWriteSync(LedgerHandle lh, int numToWrite) throws Exception {
        final CountDownLatch completeLatch = new CountDownLatch(numToWrite - 1);
        final AtomicInteger rc = new AtomicInteger(0);
        ByteBuffer entry = ByteBuffer.allocate(4);
        for (int i = 0; i < numToWrite - 1; ++i) {
            entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries.add(entry.array());
            this.entriesSize.add(entry.array().length);
            lh.asyncAddEntry(entry.array(), new AsyncCallback.AddCallback(){

                public void addComplete(int rccb, LedgerHandle lh, long entryId, Object ctx) {
                    rc.compareAndSet(0, rccb);
                    completeLatch.countDown();
                }
            }, null);
        }
        completeLatch.await();
        if (rc.get() != 0) {
            throw BKException.create((int)rc.get());
        }
        entry = ByteBuffer.allocate(4);
        entry.putInt(this.rng.nextInt(this.maxInt));
        entry.position(0);
        this.entries.add(entry.array());
        this.entriesSize.add(entry.array().length);
        lh.addEntry(entry.array());
        return lh.getLastAddConfirmed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFromOpenLedger() throws Exception {
        try {
            this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            this.ledgerId = this.lh.getId();
            LOG.info("Ledger ID: " + this.lh.getId());
            long lac = this.writeNEntriesLastWriteSync(this.lh, this.numEntriesToWrite);
            LedgerHandle lhOpen = this.bkc.openLedgerNoRecovery(this.ledgerId, this.digestType, this.ledgerPassword);
            long toRead = lac - 1L;
            Enumeration readEntry = lhOpen.readEntries(toRead, toRead);
            Assert.assertTrue((String)"Enumeration of ledger entries has no element", (boolean)readEntry.hasMoreElements());
            LedgerEntry e = (LedgerEntry)readEntry.nextElement();
            Assert.assertEquals((long)toRead, (long)e.getEntryId());
            Assert.assertArrayEquals((byte[])this.entries.get((int)toRead), (byte[])e.getEntry());
            try {
                ByteBuffer entry = ByteBuffer.allocate(4);
                entry.putInt(this.rng.nextInt(this.maxInt));
                entry.position(0);
                lhOpen.addEntry(entry.array());
                Assert.fail((String)"Should have thrown an exception here");
            }
            catch (BKException.BKIllegalOpException entry) {
            }
            catch (Exception ex) {
                LOG.error("Unexpected exception", (Throwable)ex);
                Assert.fail((String)"Unexpected exception");
            }
            lhOpen.close();
            lac = this.writeNEntriesLastWriteSync(this.lh, this.numEntriesToWrite);
            Assert.assertEquals((String)"Last confirmed add: ", (long)lac, (long)(this.numEntriesToWrite * 2 - 1));
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** WRITE COMPLETE ***");
            }
            this.lh.close();
            this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            this.ledgerId = this.lh.getId();
            this.writeNEntriesLastWriteSync(this.lh, this.numEntriesToWrite);
            SyncObj sync = new SyncObj();
            this.lh.asyncReadLastConfirmed((AsyncCallback.ReadLastConfirmedCallback)this, (Object)sync);
            SyncObj syncObj = sync;
            synchronized (syncObj) {
                while (sync.lastConfirmed == -1L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Counter = " + sync.lastConfirmed);
                    }
                    sync.wait();
                }
                Assert.assertEquals((String)"Error reading", (long)0L, (long)sync.getReturnCode());
            }
            Assert.assertEquals((String)"Last confirmed add", (long)sync.lastConfirmed, (long)(this.numEntriesToWrite - 2));
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** WRITE COMPLETE ***");
            }
            this.lh.close();
        }
        catch (BKException e) {
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to BookKeeper exception");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to interruption");
        }
    }

    @Test
    public void testReadFromOpenLedgerOpenOnce() throws Exception {
        try {
            this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            this.ledgerId = this.lh.getId();
            LOG.info("Ledger ID: " + this.lh.getId());
            LedgerHandle lhOpen = this.bkc.openLedgerNoRecovery(this.ledgerId, this.digestType, this.ledgerPassword);
            this.writeNEntriesLastWriteSync(this.lh, this.numEntriesToWrite / 2);
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            int toRead = this.numEntriesToWrite / 2 - 2;
            long readLastConfirmed = lhOpen.readLastConfirmed();
            Assert.assertTrue((readLastConfirmed != 0L ? 1 : 0) != 0);
            Enumeration readEntry = lhOpen.readEntries((long)toRead, (long)toRead);
            Assert.assertTrue((String)"Enumeration of ledger entries has no element", (boolean)readEntry.hasMoreElements());
            LedgerEntry e = (LedgerEntry)readEntry.nextElement();
            Assert.assertEquals((long)toRead, (long)e.getEntryId());
            Assert.assertArrayEquals((byte[])this.entries.get(toRead), (byte[])e.getEntry());
            try {
                lhOpen.addEntry(entry.array());
                Assert.fail((String)"Should have thrown an exception here");
            }
            catch (BKException.BKIllegalOpException bKIllegalOpException) {
            }
            catch (Exception ex) {
                LOG.error("Unexpected exception", (Throwable)ex);
                Assert.fail((String)"Unexpected exception");
            }
            this.writeNEntriesLastWriteSync(this.lh, this.numEntriesToWrite / 2);
            long last = this.lh.readLastConfirmed();
            Assert.assertTrue((String)("Last confirmed add: " + last), (last == (long)(this.numEntriesToWrite - 2) ? 1 : 0) != 0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** WRITE COMPLETE ***");
            }
            this.lh.close();
            lhOpen.close();
        }
        catch (BKException e) {
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to BookKeeper exception");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to interruption");
        }
    }

    @Test
    public void testReadFromOpenLedgerZeroAndOne() throws Exception {
        try {
            long readLastConfirmed;
            this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            this.ledgerId = this.lh.getId();
            LOG.info("Ledger ID: " + this.lh.getId());
            LedgerHandle lhOpen = this.bkc.openLedgerNoRecovery(this.ledgerId, this.digestType, this.ledgerPassword);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking that it is empty");
            }
            Assert.assertTrue((String)"Last confirmed has the wrong value", ((readLastConfirmed = lhOpen.readLastConfirmed()) == -1L ? 1 : 0) != 0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to write one entry");
            }
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries.add(entry.array());
            this.entriesSize.add(entry.array().length);
            this.lh.addEntry(entry.array());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking that it is still empty even after writing one entry");
            }
            Assert.assertTrue(((readLastConfirmed = lhOpen.readLastConfirmed()) == -1L ? 1 : 0) != 0);
            entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries.add(entry.array());
            this.entriesSize.add(entry.array().length);
            this.lh.addEntry(entry.array());
            LOG.info("Checking that it has an entry");
            readLastConfirmed = lhOpen.readLastConfirmed();
            Assert.assertTrue((readLastConfirmed == 0L ? 1 : 0) != 0);
            this.lh.close();
            lhOpen.close();
        }
        catch (BKException e) {
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to BookKeeper exception");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to interruption");
        }
    }

    @Test
    public void testWriteUsingReadOnlyHandle() throws Exception {
        this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
        this.ledgerId = this.lh.getId();
        LOG.info("Ledger ID: " + this.lh.getId());
        long lac = this.writeNEntriesLastWriteSync(this.lh, this.numEntriesToWrite);
        LedgerHandle lhOpen = this.bkc.openLedgerNoRecovery(this.ledgerId, this.digestType, this.ledgerPassword);
        CountDownLatch latch = new CountDownLatch(1);
        final int[] rcArray = new int[]{0};
        lhOpen.asyncAddEntry("".getBytes(), new AsyncCallback.AddCallback(){

            public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
                CountDownLatch latch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                latch.countDown();
            }
        }, (Object)latch);
        latch.await();
        if (rcArray[0] != -100) {
            Assert.fail((String)("Test1 - asyncAddOperation is supposed to be failed, but it got following rc - " + KeeperException.Code.get((int)rcArray[0])));
        }
        latch = new CountDownLatch(1);
        rcArray[0] = 0;
        lhOpen.asyncAddEntry("".getBytes(), 0, 0, new AsyncCallback.AddCallback(){

            public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
                CountDownLatch latch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                latch.countDown();
            }
        }, (Object)latch);
        latch.await();
        if (rcArray[0] != -100) {
            Assert.fail((String)("Test2 - asyncAddOperation is supposed to fail with IllegalOpException, but it got following rc - " + KeeperException.Code.get((int)rcArray[0])));
        }
        latch = new CountDownLatch(1);
        rcArray[0] = 0;
        lhOpen.asyncClose(new AsyncCallback.CloseCallback(){

            public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
                CountDownLatch latch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                latch.countDown();
            }
        }, (Object)latch);
        latch.await();
        if (rcArray[0] != KeeperException.Code.OK.intValue()) {
            Assert.fail((String)("Test3 - asyncClose failed because of exception - " + KeeperException.Code.get((int)rcArray[0])));
        }
        this.writeNEntriesLastWriteSync(this.lh, 5);
        this.lh.close();
    }

    @Test
    public void testLedgerHandle() throws Exception {
        this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
        this.ledgerId = this.lh.getId();
        LOG.info("Ledger ID: " + this.lh.getId());
        long lac = this.writeNEntriesLastWriteSync(this.lh, 5);
        CountDownLatch latch = new CountDownLatch(1);
        final int[] rcArray = new int[]{0};
        this.lh.asyncAddEntry(lac + 1L, "".getBytes(), new AsyncCallback.AddCallback(){

            public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
                CountDownLatch latch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                latch.countDown();
            }
        }, (Object)latch);
        latch.await();
        if (rcArray[0] != -100) {
            Assert.fail((String)("Test1 - addEntry with EntryID is expected to fail with IllegalOpException, but it got following rc - " + KeeperException.Code.get((int)rcArray[0])));
        }
        latch = new CountDownLatch(1);
        rcArray[0] = 0;
        this.lh.asyncAddEntry(lac + 1L, "".getBytes(), 0, 0, new AsyncCallback.AddCallback(){

            public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
                CountDownLatch latch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                latch.countDown();
            }
        }, (Object)latch);
        latch.await();
        if (rcArray[0] != -100) {
            Assert.fail((String)("Test2 - addEntry with EntryID is expected to fail with IllegalOpException,but it got following rc - " + KeeperException.Code.get((int)rcArray[0])));
        }
        try {
            this.lh.addEntry(lac + 1L, "".getBytes());
            Assert.fail((String)"Test3 - addEntry with EntryID is expected to fail");
        }
        catch (BKException.BKIllegalOpException bKIllegalOpException) {
            // empty catch block
        }
        try {
            this.lh.addEntry(lac + 1L, "".getBytes(), 0, 0);
            Assert.fail((String)"Test4 - addEntry with EntryID is expected to fail");
        }
        catch (BKException.BKIllegalOpException bKIllegalOpException) {
            // empty catch block
        }
        this.lh.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastConfirmedAdd() throws Exception {
        try {
            this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            this.ledgerId = this.lh.getId();
            LOG.info("Ledger ID: " + this.lh.getId());
            this.writeNEntriesLastWriteSync(this.lh, this.numEntriesToWrite);
            long last = this.lh.readLastConfirmed();
            Assert.assertTrue((String)("Last confirmed add: " + last), (last == (long)(this.numEntriesToWrite - 2) ? 1 : 0) != 0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** WRITE COMPLETE ***");
            }
            this.lh.close();
            this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
            this.ledgerId = this.lh.getId();
            LOG.info("Ledger ID: " + this.lh.getId());
            this.writeNEntriesLastWriteSync(this.lh, this.numEntriesToWrite);
            SyncObj sync = new SyncObj();
            this.lh.asyncReadLastConfirmed((AsyncCallback.ReadLastConfirmedCallback)this, (Object)sync);
            SyncObj syncObj = sync;
            synchronized (syncObj) {
                while (sync.lastConfirmed == -1L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Counter = " + sync.lastConfirmed);
                    }
                    sync.wait();
                }
                Assert.assertEquals((String)"Error reading", (long)0L, (long)sync.getReturnCode());
            }
            Assert.assertTrue((String)("Last confirmed add: " + sync.lastConfirmed), (sync.lastConfirmed == (long)(this.numEntriesToWrite - 2) ? 1 : 0) != 0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** WRITE COMPLETE ***");
            }
            this.lh.close();
        }
        catch (BKException e) {
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to BookKeeper exception");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Test failed", (Throwable)e);
            Assert.fail((String)"Test failed due to interruption");
        }
    }

    @Test
    public void testReadLastConfirmed() throws Exception {
        this.lh = this.bkc.createLedger(this.digestType, this.ledgerPassword);
        this.ledgerId = this.lh.getId();
        LOG.info("Ledger ID: " + this.lh.getId());
        long previousLAC = this.writeNEntriesLastWriteSync(this.lh, 5);
        LedgerHandle lhOpen = this.bkc.openLedgerNoRecovery(this.ledgerId, this.digestType, this.ledgerPassword);
        long currentLAC = this.writeNEntriesLastWriteSync(this.lh, 5);
        long readLAC = lhOpen.getLastAddConfirmed();
        Assert.assertEquals((String)"Test1 - For ReadHandle LAC", (long)(previousLAC - 1L), (long)readLAC);
        this.lh.close();
        Thread.sleep(500L);
        CountDownLatch latch = new CountDownLatch(1);
        final int[] rcArray = new int[]{0};
        final long[] lastConfirmedArray = new long[]{0L};
        lhOpen.asyncReadLastConfirmed(new AsyncCallback.ReadLastConfirmedCallback(){

            public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
                CountDownLatch latch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                lastConfirmedArray[0] = lastConfirmed;
                latch.countDown();
            }
        }, (Object)latch);
        latch.await();
        Assert.assertEquals((String)"Test3 - asyncReadLastConfirmed response", (long)KeeperException.Code.OK.intValue(), (long)rcArray[0]);
        Assert.assertEquals((String)"Test3 - ReadLAC", (long)currentLAC, (long)lastConfirmedArray[0]);
        latch = new CountDownLatch(1);
        rcArray[0] = 0;
        lastConfirmedArray[0] = 0L;
        lhOpen.asyncTryReadLastConfirmed(new AsyncCallback.ReadLastConfirmedCallback(){

            public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
                CountDownLatch latch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                lastConfirmedArray[0] = lastConfirmed;
                latch.countDown();
            }
        }, (Object)latch);
        latch.await();
        Assert.assertEquals((String)"Test4 - asyncTryReadLastConfirmed response", (long)KeeperException.Code.OK.intValue(), (long)rcArray[0]);
        Assert.assertEquals((String)"Test4 - ReadLAC", (long)currentLAC, (long)lastConfirmedArray[0]);
        long tryReadLAC = lhOpen.tryReadLastConfirmed();
        Assert.assertEquals((String)"Test5 - ReadLAC", (long)currentLAC, (long)tryReadLAC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
        SyncObj sync = (SyncObj)ctx;
        sync.setReturnCode(rc);
        SyncObj syncObj = sync;
        synchronized (syncObj) {
            ++sync.counter;
            sync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> seq, Object ctx) {
        SyncObj sync = (SyncObj)ctx;
        sync.setLedgerEntries(seq);
        sync.setReturnCode(rc);
        SyncObj syncObj = sync;
        synchronized (syncObj) {
            sync.value = true;
            sync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
        SyncObj sync = (SyncObj)ctx;
        sync.setReturnCode(rc);
        SyncObj syncObj = sync;
        synchronized (syncObj) {
            sync.lastConfirmed = lastConfirmed;
            sync.notify();
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rng = new Random(System.currentTimeMillis());
        this.entries = new ArrayList();
        this.entriesSize = new ArrayList();
    }

    protected boolean cleanUpDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            LOG.info("Cleaning up " + dir.getName());
            for (String string : children = dir.list()) {
                boolean success = this.cleanUpDir(new File(dir, string));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    class EmptyWatcher
    implements Watcher {
        EmptyWatcher() {
        }

        public void process(WatchedEvent event) {
        }
    }

    class ThrottleTestCallback
    implements AsyncCallback.ReadCallback {
        int throttle;

        ThrottleTestCallback(int threshold) {
            this.throttle = threshold;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> seq, Object ctx) {
            SyncObj sync = (SyncObj)ctx;
            sync.setLedgerEntries(seq);
            sync.setReturnCode(rc);
            SyncObj syncObj = sync;
            synchronized (syncObj) {
                sync.counter += this.throttle;
                sync.notify();
            }
            LOG.info("Current counter: " + sync.counter);
        }
    }

    class SyncObj {
        long lastConfirmed = -1L;
        volatile int counter = 0;
        boolean value = false;
        AtomicInteger rc = new AtomicInteger(0);
        Enumeration<LedgerEntry> ls = null;

        void setReturnCode(int rc) {
            this.rc.compareAndSet(0, rc);
        }

        int getReturnCode() {
            return this.rc.get();
        }

        void setLedgerEntries(Enumeration<LedgerEntry> ls) {
            this.ls = ls;
        }

        Enumeration<LedgerEntry> getLedgerEntries() {
            return this.ls;
        }
    }
}

