/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import io.netty.buffer.ByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieResources;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.LegacyCookieValidation;
import org.apache.bookkeeper.bookie.MockUncleanShutdownDetection;
import org.apache.bookkeeper.bookie.ReadOnlyBookie;
import org.apache.bookkeeper.bookie.UncleanShutdownDetection;
import org.apache.bookkeeper.bookie.UncleanShutdownDetectionImpl;
import org.apache.bookkeeper.client.BookKeeperTestClient;
import org.apache.bookkeeper.common.allocator.ByteBufAllocatorWithOomHandler;
import org.apache.bookkeeper.common.allocator.PoolingPolicy;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.metastore.InMemoryMetaStore;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.AutoRecoveryMain;
import org.apache.bookkeeper.replication.ReplicationWorker;
import org.apache.bookkeeper.server.Main;
import org.apache.bookkeeper.shaded.com.google.common.base.Stopwatch;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.test.TmpDirs;
import org.apache.bookkeeper.test.ZooKeeperCluster;
import org.apache.bookkeeper.test.ZooKeeperClusterUtil;
import org.apache.bookkeeper.test.ZooKeeperUtil;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.bookkeeper.util.PortManager;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BookKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(BookKeeperClusterTestCase.class);
    @Rule
    public final TestName runtime = new TestName();
    @Rule
    public final Timeout globalTimeout;
    protected final ZooKeeperCluster zkUtil;
    protected ZooKeeper zkc;
    protected String metadataServiceUri;
    protected final TmpDirs tmpDirs = new TmpDirs();
    protected final List<ServerTester> servers = new LinkedList<ServerTester>();
    protected int numBookies;
    protected BookKeeperTestClient bkc;
    protected boolean useUUIDasBookieId = true;
    protected final ServerConfiguration baseConf = TestBKConfiguration.newServerConfiguration();
    protected final ClientConfiguration baseClientConf = TestBKConfiguration.newClientConfiguration();
    private final ByteBufAllocatorWithOomHandler allocator = BookieResources.createAllocator((ServerConfiguration)this.baseConf);
    private boolean isAutoRecoveryEnabled;
    SynchronousQueue<Throwable> asyncExceptions = new SynchronousQueue();

    protected void captureThrowable(Runnable c) {
        try {
            c.run();
        }
        catch (Throwable e) {
            LOG.error("Captured error: ", e);
            this.asyncExceptions.add(e);
        }
    }

    public BookKeeperClusterTestCase(int numBookies) {
        this(numBookies, 120);
    }

    public BookKeeperClusterTestCase(int numBookies, int testTimeoutSecs) {
        this(numBookies, 1, testTimeoutSecs);
    }

    public BookKeeperClusterTestCase(int numBookies, int numOfZKNodes, int testTimeoutSecs) {
        this.numBookies = numBookies;
        this.globalTimeout = Timeout.seconds((long)testTimeoutSecs);
        if (numOfZKNodes == 1) {
            this.zkUtil = new ZooKeeperUtil();
        } else {
            try {
                this.zkUtil = new ZooKeeperClusterUtil(numOfZKNodes);
            }
            catch (IOException | InterruptedException | KeeperException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Before
    public void setUp() throws Exception {
        this.setUp("/ledgers");
    }

    protected void setUp(String ledgersRootPath) throws Exception {
        LOG.info("Setting up test {}", this.getClass());
        InMemoryMetaStore.reset();
        this.setMetastoreImplClass((AbstractConfiguration)this.baseConf);
        this.setMetastoreImplClass((AbstractConfiguration)this.baseClientConf);
        Stopwatch sw = Stopwatch.createStarted();
        try {
            this.startZKCluster();
            this.metadataServiceUri = this.getMetadataServiceUri(ledgersRootPath);
            this.startBKCluster(this.metadataServiceUri);
            LOG.info("Setup testcase {} @ metadata service {} in {} ms.", new Object[]{this.runtime.getMethodName(), this.metadataServiceUri, sw.elapsed(TimeUnit.MILLISECONDS)});
        }
        catch (Exception e) {
            LOG.error("Error setting up", (Throwable)e);
            throw e;
        }
    }

    protected String getMetadataServiceUri(String ledgersRootPath) {
        return this.zkUtil.getMetadataServiceUri(ledgersRootPath);
    }

    @After
    public void tearDown() throws Exception {
        boolean failed = false;
        for (Throwable e : this.asyncExceptions) {
            LOG.error("Got async exception: ", e);
            failed = true;
        }
        Assert.assertFalse((String)"Async failure", (boolean)failed);
        Stopwatch sw = Stopwatch.createStarted();
        LOG.info("TearDown");
        Exception tearDownException = null;
        try {
            this.stopBKCluster();
        }
        catch (Exception e) {
            LOG.error("Got Exception while trying to stop BKCluster", (Throwable)e);
            tearDownException = e;
        }
        try {
            this.stopZKCluster();
        }
        catch (Exception e) {
            LOG.error("Got Exception while trying to stop ZKCluster", (Throwable)e);
            tearDownException = e;
        }
        try {
            this.tmpDirs.cleanup();
        }
        catch (Exception e) {
            LOG.error("Got Exception while trying to cleanupTempDirs", (Throwable)e);
            tearDownException = e;
        }
        LOG.info("Tearing down test {} in {} ms.", (Object)this.runtime.getMethodName(), (Object)sw.elapsed(TimeUnit.MILLISECONDS));
        if (tearDownException != null) {
            throw tearDownException;
        }
    }

    protected void startZKCluster() throws Exception {
        this.zkUtil.startCluster();
        this.zkc = this.zkUtil.getZooKeeperClient();
    }

    protected void stopZKCluster() throws Exception {
        this.zkUtil.killCluster();
    }

    protected void startBKCluster(String metadataServiceUri) throws Exception {
        this.baseConf.setMetadataServiceUri(metadataServiceUri);
        this.baseClientConf.setMetadataServiceUri(metadataServiceUri);
        this.baseClientConf.setAllocatorPoolingPolicy(PoolingPolicy.UnpooledHeap);
        if (this.numBookies > 0) {
            this.bkc = new BookKeeperTestClient(this.baseClientConf, new TestStatsProvider());
        }
        for (int i = 0; i < this.numBookies; ++i) {
            this.startNewBookie();
        }
    }

    protected void stopBKCluster() throws Exception {
        if (this.bkc != null) {
            this.bkc.close();
        }
        this.stopReplicationService();
        for (ServerTester t : this.servers) {
            t.shutdown();
        }
        this.servers.clear();
    }

    protected ServerConfiguration newServerConfiguration() throws Exception {
        File f = this.tmpDirs.createNew("bookie", "test");
        int port = this.baseConf.isEnableLocalTransport() || !this.baseConf.getAllowEphemeralPorts() ? PortManager.nextFreePort() : 0;
        return this.newServerConfiguration(port, f, new File[]{f});
    }

    protected ClientConfiguration newClientConfiguration() {
        return new ClientConfiguration((AbstractConfiguration)this.baseConf);
    }

    protected ServerConfiguration newServerConfiguration(int port, File journalDir, File[] ledgerDirs) {
        ServerConfiguration conf = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        conf.setBookiePort(port);
        conf.setJournalDirName(journalDir.getPath());
        String[] ledgerDirNames = new String[ledgerDirs.length];
        for (int i = 0; i < ledgerDirs.length; ++i) {
            ledgerDirNames[i] = ledgerDirs[i].getPath();
        }
        conf.setLedgerDirNames(ledgerDirNames);
        conf.setEnableTaskExecutionStats(true);
        conf.setAllocatorPoolingPolicy(PoolingPolicy.UnpooledHeap);
        return conf;
    }

    protected void stopAllBookies() throws Exception {
        this.stopAllBookies(true);
    }

    protected void stopAllBookies(boolean shutdownClient) throws Exception {
        this.stopReplicationService();
        for (ServerTester t : this.servers) {
            t.shutdown();
        }
        this.servers.clear();
        if (shutdownClient && this.bkc != null) {
            this.bkc.close();
            this.bkc = null;
        }
    }

    protected String newMetadataServiceUri(String ledgersRootPath) {
        return this.zkUtil.getMetadataServiceUri(ledgersRootPath);
    }

    protected String newMetadataServiceUri(String ledgersRootPath, String type) {
        return this.zkUtil.getMetadataServiceUri(ledgersRootPath, type);
    }

    public BookieId getBookie(int index) throws Exception {
        return this.servers.get(index).getServer().getBookieId();
    }

    protected List<BookieId> bookieAddresses() throws Exception {
        ArrayList<BookieId> bookieIds = new ArrayList<BookieId>();
        for (ServerTester a : this.servers) {
            bookieIds.add(a.getServer().getBookieId());
        }
        return bookieIds;
    }

    protected List<File> bookieLedgerDirs() throws Exception {
        return this.servers.stream().flatMap(t -> Arrays.stream(t.getConfiguration().getLedgerDirs())).collect(Collectors.toList());
    }

    protected List<File> bookieJournalDirs() throws Exception {
        return this.servers.stream().flatMap(t -> Arrays.stream(t.getConfiguration().getJournalDirs())).collect(Collectors.toList());
    }

    protected BookieId addressByIndex(int index) throws Exception {
        return this.servers.get(index).getServer().getBookieId();
    }

    protected BookieServer serverByIndex(int index) throws Exception {
        return this.servers.get(index).getServer();
    }

    protected ServerConfiguration confByIndex(int index) throws Exception {
        return this.servers.get(index).getConfiguration();
    }

    private Optional<ServerTester> byAddress(BookieId addr) throws UnknownHostException {
        for (ServerTester s : this.servers) {
            if (!s.getServer().getBookieId().equals((Object)addr)) continue;
            return Optional.of(s);
        }
        return Optional.empty();
    }

    protected int indexOfServer(BookieServer b) throws Exception {
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!this.servers.get(i).getServer().equals(b)) continue;
            return i;
        }
        return -1;
    }

    protected int lastBookieIndex() {
        return this.servers.size() - 1;
    }

    protected int bookieCount() {
        return this.servers.size();
    }

    private OptionalInt indexByAddress(BookieId addr) throws UnknownHostException {
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!addr.equals((Object)this.servers.get(i).getServer().getBookieId())) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public ServerConfiguration getBkConf(BookieId addr) throws Exception {
        return this.byAddress(addr).get().getConfiguration();
    }

    public ServerConfiguration killBookie(BookieId addr) throws Exception {
        Optional<ServerTester> tester = this.byAddress(addr);
        if (tester.isPresent()) {
            if (tester.get().autoRecovery != null && tester.get().autoRecovery.getAuditor() != null && tester.get().autoRecovery.getAuditor().isRunning()) {
                LOG.warn("Killing bookie {} who is the current Auditor", (Object)addr);
            }
            this.servers.remove(tester.get());
            tester.get().shutdown();
            return tester.get().getConfiguration();
        }
        return null;
    }

    public void setBookieToReadOnly(BookieId addr) throws Exception {
        Optional<ServerTester> tester = this.byAddress(addr);
        if (tester.isPresent()) {
            tester.get().getServer().getBookie().getStateManager().transitionToReadOnlyMode().get();
        }
    }

    public ServerConfiguration killBookie(int index) throws Exception {
        ServerTester tester = this.servers.remove(index);
        tester.shutdown();
        return tester.getConfiguration();
    }

    public ServerConfiguration killBookieAndWaitForZK(int index) throws Exception {
        ServerTester tester = this.servers.get(index);
        ServerConfiguration ret = this.killBookie(index);
        while (this.zkc.exists(ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseConf) + "/" + "available" + "/" + tester.getServer().getBookieId().toString(), false) != null) {
            Thread.sleep(500L);
        }
        return ret;
    }

    public CountDownLatch sleepBookie(BookieId addr, final int seconds) throws Exception {
        final Optional<ServerTester> tester = this.byAddress(addr);
        if (tester.isPresent()) {
            final CountDownLatch latch = new CountDownLatch(1);
            Thread sleeper = new Thread(){

                @Override
                public void run() {
                    try {
                        ((ServerTester)tester.get()).getServer().suspendProcessing();
                        LOG.info("bookie {} is asleep", (Object)((ServerTester)tester.get()).getAddress());
                        latch.countDown();
                        Thread.sleep(seconds * 1000);
                        ((ServerTester)tester.get()).getServer().resumeProcessing();
                        LOG.info("bookie {} is awake", (Object)((ServerTester)tester.get()).getAddress());
                    }
                    catch (Exception e) {
                        LOG.error("Error suspending bookie", (Throwable)e);
                    }
                }
            };
            sleeper.start();
            return latch;
        }
        throw new IOException("Bookie not found");
    }

    public void sleepBookie(BookieId addr, CountDownLatch l) throws InterruptedException, IOException {
        CountDownLatch suspendLatch = new CountDownLatch(1);
        this.sleepBookie(addr, l, suspendLatch);
        suspendLatch.await();
    }

    public void sleepBookie(BookieId addr, final CountDownLatch l, final CountDownLatch suspendLatch) throws InterruptedException, IOException {
        Optional<ServerTester> tester = this.byAddress(addr);
        if (!tester.isPresent()) {
            throw new IOException("Bookie not found");
        }
        final BookieServer bookie = tester.get().getServer();
        LOG.info("Sleep bookie {}.", (Object)addr);
        Thread sleeper = new Thread(){

            @Override
            public void run() {
                try {
                    bookie.suspendProcessing();
                    if (null != suspendLatch) {
                        suspendLatch.countDown();
                    }
                    l.await();
                    bookie.resumeProcessing();
                }
                catch (Exception e) {
                    LOG.error("Error suspending bookie", (Throwable)e);
                }
            }
        };
        sleeper.start();
    }

    public void restartBookies() throws Exception {
        this.restartBookies(c -> c);
    }

    public void restartBookie(BookieId addr) throws Exception {
        OptionalInt toRemove = this.indexByAddress(addr);
        if (!toRemove.isPresent()) {
            throw new IOException("Bookie not found");
        }
        ServerConfiguration newConfig = this.killBookie(toRemove.getAsInt());
        Thread.sleep(1000L);
        this.startAndAddBookie(newConfig);
    }

    public void restartBookies(Function<ServerConfiguration, ServerConfiguration> reconfFunction) throws Exception {
        ArrayList<ServerConfiguration> confs = new ArrayList<ServerConfiguration>();
        this.stopReplicationService();
        for (ServerTester server : this.servers) {
            server.shutdown();
            confs.add(server.getConfiguration());
        }
        this.servers.clear();
        Thread.sleep(1000L);
        for (ServerConfiguration conf : confs) {
            this.startAndAddBookie(reconfFunction.apply(conf));
        }
    }

    public int startNewBookie() throws Exception {
        return this.startNewBookieAndReturnAddress().getPort();
    }

    public BookieSocketAddress startNewBookieAndReturnAddress() throws Exception {
        ServerConfiguration conf = this.newServerConfiguration();
        LOG.info("Starting new bookie on port: {}", (Object)conf.getBookiePort());
        return this.startAndAddBookie(conf).getServer().getLocalAddress();
    }

    public BookieId startNewBookieAndReturnBookieId() throws Exception {
        ServerConfiguration conf = this.newServerConfiguration();
        LOG.info("Starting new bookie on port: {}", (Object)conf.getBookiePort());
        return this.startAndAddBookie(conf).getServer().getBookieId();
    }

    protected ServerTester startAndAddBookie(ServerConfiguration conf) throws Exception {
        ServerTester server = this.startBookie(conf);
        this.servers.add(server);
        return server;
    }

    protected ServerTester startAndAddBookie(ServerConfiguration conf, Bookie b) throws Exception {
        ServerTester server = this.startBookie(conf, b);
        this.servers.add(server);
        return server;
    }

    protected ServerTester startBookie(ServerConfiguration conf) throws Exception {
        ServerTester tester = new ServerTester(conf);
        if (this.bkc == null) {
            this.bkc = new BookKeeperTestClient(this.baseClientConf, new TestStatsProvider());
        }
        BookieId address = tester.getServer().getBookieId();
        Future<?> waitForBookie = conf.isForceReadOnlyBookie() ? this.bkc.waitForReadOnlyBookie(address) : this.bkc.waitForWritableBookie(address);
        tester.getServer().start();
        waitForBookie.get(30L, TimeUnit.SECONDS);
        LOG.info("New bookie '{}' has been created.", (Object)address);
        if (this.isAutoRecoveryEnabled()) {
            tester.startAutoRecovery();
        }
        return tester;
    }

    protected ServerTester startBookie(ServerConfiguration conf, Bookie b) throws Exception {
        ServerTester tester = new ServerTester(conf, b);
        if (this.bkc == null) {
            this.bkc = new BookKeeperTestClient(this.baseClientConf, new TestStatsProvider());
        }
        BookieId address = tester.getServer().getBookieId();
        Future<?> waitForBookie = conf.isForceReadOnlyBookie() ? this.bkc.waitForReadOnlyBookie(address) : this.bkc.waitForWritableBookie(address);
        tester.getServer().start();
        waitForBookie.get(30L, TimeUnit.SECONDS);
        LOG.info("New bookie '{}' has been created.", (Object)address);
        if (this.isAutoRecoveryEnabled()) {
            tester.startAutoRecovery();
        }
        return tester;
    }

    public void setMetastoreImplClass(AbstractConfiguration conf) {
        conf.setMetastoreImplClass(InMemoryMetaStore.class.getName());
    }

    public void setAutoRecoveryEnabled(boolean isAutoRecoveryEnabled) {
        this.isAutoRecoveryEnabled = isAutoRecoveryEnabled;
    }

    public boolean isAutoRecoveryEnabled() {
        return this.isAutoRecoveryEnabled;
    }

    public void startReplicationService() throws Exception {
        for (ServerTester t : this.servers) {
            t.startAutoRecovery();
        }
    }

    public void stopReplicationService() throws Exception {
        for (ServerTester t : this.servers) {
            t.stopAutoRecovery();
        }
    }

    public Auditor getAuditor(int timeout, TimeUnit unit) throws Exception {
        long timeoutAt = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, unit);
        while (System.nanoTime() < timeoutAt) {
            for (ServerTester t : this.servers) {
                Auditor a = t.getAuditor();
                ReplicationWorker replicationWorker = t.getReplicationWorker();
                if (a != null && a.isRunning() && replicationWorker != null && replicationWorker.isRunning()) {
                    int deathWatchInterval = t.getConfiguration().getDeathWatchInterval();
                    Thread.sleep(deathWatchInterval + 1000);
                }
                if (a == null || !a.isRunning() || replicationWorker == null || !replicationWorker.isRunning()) continue;
                LOG.info("Found Auditor Bookie {}", (Object)t.server.getBookieId());
                return a;
            }
            Thread.sleep(100L);
        }
        throw new Exception("No auditor found");
    }

    public boolean isCreatedFromIp(BookieId bookieId) {
        BookieSocketAddress addr = this.bkc.getBookieAddressResolver().resolve(bookieId);
        return addr.getSocketAddress().toString().startsWith("/");
    }

    public void resetBookieOpLoggers() {
        this.servers.forEach(t -> t.getStatsProvider().clear());
    }

    public TestStatsProvider getStatsProvider(BookieId addr) throws UnknownHostException {
        return this.byAddress(addr).get().getStatsProvider();
    }

    public TestStatsProvider getStatsProvider(int index) throws Exception {
        return this.servers.get(index).getStatsProvider();
    }

    public class ServerTester {
        private final ServerConfiguration conf;
        private final TestStatsProvider provider;
        private final Bookie bookie;
        private final BookieServer server;
        private final BookieSocketAddress address;
        private final MetadataBookieDriver metadataDriver;
        private final RegistrationManager registrationManager;
        private final LedgerManagerFactory lmFactory;
        private final LedgerManager ledgerManager;
        private final LedgerStorage storage;
        private AutoRecoveryMain autoRecovery;

        public ServerTester(ServerConfiguration conf) throws Exception {
            this.conf = conf;
            this.provider = new TestStatsProvider();
            TestStatsProvider.TestStatsLogger rootStatsLogger = this.provider.getStatsLogger("");
            StatsLogger bookieStats = rootStatsLogger.scope("bookie");
            this.metadataDriver = BookieResources.createMetadataDriver((ServerConfiguration)conf, (StatsLogger)bookieStats);
            this.registrationManager = this.metadataDriver.createRegistrationManager();
            this.lmFactory = this.metadataDriver.getLedgerManagerFactory();
            this.ledgerManager = this.lmFactory.newLedgerManager();
            LegacyCookieValidation cookieValidation = new LegacyCookieValidation(conf, this.registrationManager);
            cookieValidation.checkCookies(Main.storageDirectoriesFromConf((ServerConfiguration)conf));
            DiskChecker diskChecker = BookieResources.createDiskChecker((ServerConfiguration)conf);
            LedgerDirsManager ledgerDirsManager = BookieResources.createLedgerDirsManager((ServerConfiguration)conf, (DiskChecker)diskChecker, (StatsLogger)bookieStats.scope("ledger"));
            LedgerDirsManager indexDirsManager = BookieResources.createIndexDirsManager((ServerConfiguration)conf, (DiskChecker)diskChecker, (StatsLogger)bookieStats.scope("index"), (LedgerDirsManager)ledgerDirsManager);
            UncleanShutdownDetectionImpl uncleanShutdownDetection = new UncleanShutdownDetectionImpl(ledgerDirsManager);
            this.storage = BookieResources.createLedgerStorage((ServerConfiguration)conf, (LedgerManager)this.ledgerManager, (LedgerDirsManager)ledgerDirsManager, (LedgerDirsManager)indexDirsManager, (StatsLogger)bookieStats, (ByteBufAllocator)BookKeeperClusterTestCase.this.allocator);
            this.bookie = conf.isForceReadOnlyBookie() ? new ReadOnlyBookie(conf, this.registrationManager, this.storage, diskChecker, ledgerDirsManager, indexDirsManager, bookieStats, (ByteBufAllocator)BookKeeperClusterTestCase.this.allocator, BookieServiceInfo.NO_INFO) : new BookieImpl(conf, this.registrationManager, this.storage, diskChecker, ledgerDirsManager, indexDirsManager, bookieStats, (ByteBufAllocator)BookKeeperClusterTestCase.this.allocator, BookieServiceInfo.NO_INFO);
            this.server = new BookieServer(conf, this.bookie, (StatsLogger)rootStatsLogger, (ByteBufAllocator)BookKeeperClusterTestCase.this.allocator, (UncleanShutdownDetection)uncleanShutdownDetection);
            this.address = BookieImpl.getBookieAddress((ServerConfiguration)conf);
            this.autoRecovery = null;
        }

        public ServerTester(ServerConfiguration conf, Bookie b) throws Exception {
            this.conf = conf;
            this.provider = new TestStatsProvider();
            this.metadataDriver = null;
            this.registrationManager = null;
            this.ledgerManager = null;
            this.lmFactory = null;
            this.storage = null;
            this.bookie = b;
            this.server = new BookieServer(conf, b, (StatsLogger)this.provider.getStatsLogger(""), (ByteBufAllocator)BookKeeperClusterTestCase.this.allocator, (UncleanShutdownDetection)new MockUncleanShutdownDetection());
            this.address = BookieImpl.getBookieAddress((ServerConfiguration)conf);
            this.autoRecovery = null;
        }

        public void startAutoRecovery() throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting Auditor Recovery for the bookie: {}", (Object)this.address);
            }
            this.autoRecovery = new AutoRecoveryMain(this.conf);
            this.autoRecovery.start();
        }

        public void stopAutoRecovery() {
            if (this.autoRecovery != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Shutdown Auditor Recovery for the bookie: {}", (Object)this.address);
                }
                this.autoRecovery.shutdown();
            }
        }

        public Auditor getAuditor() {
            if (this.autoRecovery != null) {
                return this.autoRecovery.getAuditor();
            }
            return null;
        }

        public ReplicationWorker getReplicationWorker() {
            if (this.autoRecovery != null) {
                return this.autoRecovery.getReplicationWorker();
            }
            return null;
        }

        public ServerConfiguration getConfiguration() {
            return this.conf;
        }

        public BookieServer getServer() {
            return this.server;
        }

        public TestStatsProvider getStatsProvider() {
            return this.provider;
        }

        public BookieSocketAddress getAddress() {
            return this.address;
        }

        public void shutdown() throws Exception {
            this.server.shutdown();
            if (this.ledgerManager != null) {
                this.ledgerManager.close();
            }
            if (this.lmFactory != null) {
                this.lmFactory.close();
            }
            if (this.registrationManager != null) {
                this.registrationManager.close();
            }
            if (this.metadataDriver != null) {
                this.metadataDriver.close();
            }
            if (this.autoRecovery != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Shutdown auto recovery for bookie server: {}", (Object)this.address);
                }
                this.autoRecovery.shutdown();
            }
        }
    }
}

