/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.util.LinkedList;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.replication.AuditorCheckAllLedgersTask;
import org.apache.bookkeeper.replication.AuditorStats;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditorCheckAllLedgersTaskTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AuditorCheckAllLedgersTaskTest.class);
    private static final int maxNumberOfConcurrentOpenLedgerOperations = 500;
    private static final int acquireConcurrentOpenLedgerOperationsTimeoutMSec = 120000;
    private BookKeeperAdmin admin;
    private LedgerManager ledgerManager;
    private LedgerUnderreplicationManager ledgerUnderreplicationManager;

    public AuditorCheckAllLedgersTaskTest() {
        super(3);
        this.baseConf.setPageLimit(1);
        this.baseConf.setAutoRecoveryDaemonEnabled(false);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        BookKeeper bookKeeper = new BookKeeper(this.baseClientConf);
        this.admin = new BookKeeperAdmin(bookKeeper, (StatsLogger)NullStatsLogger.INSTANCE, new ClientConfiguration((AbstractConfiguration)this.baseClientConf));
        LedgerManagerFactory ledgerManagerFactory = bookKeeper.getLedgerManagerFactory();
        this.ledgerManager = ledgerManagerFactory.newLedgerManager();
        this.ledgerUnderreplicationManager = ledgerManagerFactory.newLedgerUnderreplicationManager();
        this.baseConf.setAuditorMaxNumberOfConcurrentOpenLedgerOperations(500);
        this.baseConf.setAuditorAcquireConcurrentOpenLedgerOperationsTimeoutMSec(120000);
    }

    @Test
    public void testCheckAllLedgers() throws Exception {
        int numLedgers = 10;
        LinkedList<Long> ids = new LinkedList<Long>();
        for (int i = 0; i < 10; ++i) {
            LedgerHandle lh = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, "passwd".getBytes());
            ids.add(lh.getId());
            for (int j = 0; j < 2; ++j) {
                lh.addEntry("testdata".getBytes());
            }
            lh.close();
        }
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("auditor");
        AuditorStats auditorStats = new AuditorStats((StatsLogger)statsLogger);
        AuditorCheckAllLedgersTask auditorCheckAllLedgersTask = new AuditorCheckAllLedgersTask(this.baseConf, auditorStats, this.admin, this.ledgerManager, this.ledgerUnderreplicationManager, null, (flag, throwable) -> flag.set(false));
        auditorCheckAllLedgersTask.runTask();
        Assert.assertEquals((String)"CHECK_ALL_LEDGERS_TIME", (long)1L, (long)((TestStatsProvider.TestOpStatsLogger)statsLogger.getOpStatsLogger("CHECK_ALL_LEDGERS_TIME")).getSuccessCount());
        Assert.assertEquals((String)"NUM_LEDGERS_CHECKED", (long)10L, (long)statsLogger.getCounter("NUM_LEDGERS_CHECKED").get());
    }
}

