/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta.zk;

import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.discover.ZKRegistrationManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataBookieDriver;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverTestBase;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"javax.xml.*", "org.xml.*", "org.w3c.*", "com.sun.org.apache.xerces.*"})
@PrepareForTest(value={ZKMetadataDriverBase.class, ZooKeeperClient.class, ZKMetadataBookieDriver.class})
public class ZKMetadataBookieDriverTest
extends ZKMetadataDriverTestBase {
    private ZKMetadataBookieDriver driver;
    private ServerConfiguration conf;

    @Before
    public void setup() throws Exception {
        this.conf = new ServerConfiguration();
        super.setup((AbstractConfiguration<?>)this.conf);
        this.driver = new ZKMetadataBookieDriver();
    }

    @After
    public void teardown() {
        this.driver.close();
    }

    @Test
    public void testGetRegManager() throws Exception {
        RegistrationManager.RegistrationListener listener = (RegistrationManager.RegistrationListener)Mockito.mock(RegistrationManager.RegistrationListener.class);
        this.driver.initialize(this.conf, (StatsLogger)NullStatsLogger.INSTANCE);
        Assert.assertSame((Object)this.conf, (Object)this.driver.serverConf);
        ZKRegistrationManager mockRegManager = (ZKRegistrationManager)PowerMockito.mock(ZKRegistrationManager.class);
        PowerMockito.whenNew(ZKRegistrationManager.class).withParameterTypes(ServerConfiguration.class, new Class[]{ZooKeeper.class}).withArguments(ArgumentMatchers.any(ServerConfiguration.class), new Object[]{ArgumentMatchers.any(ZooKeeper.class)}).thenReturn((Object)mockRegManager);
        try (RegistrationManager manager = this.driver.createRegistrationManager();){
            Assert.assertSame((Object)mockRegManager, (Object)manager);
            PowerMockito.verifyNew(ZKRegistrationManager.class, (VerificationMode)Mockito.times((int)1)).withArguments(ArgumentMatchers.same((Object)this.conf), new Object[]{ArgumentMatchers.same((Object)this.mockZkc)});
        }
    }
}

