/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerManagerTestCase;
import org.apache.bookkeeper.meta.LongHierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerMetadataCreationTest
extends LedgerManagerTestCase {
    static final Logger LOG = LoggerFactory.getLogger(LedgerMetadataCreationTest.class);

    public LedgerMetadataCreationTest(Class<? extends LedgerManagerFactory> lmFactoryCls) {
        super(lmFactoryCls, 4);
        this.baseConf.setGcWaitTime(100000L);
    }

    @Test
    public void testLedgerCreationAndDeletionWithRandomLedgerIds() throws Exception {
        this.testExecution(true);
    }

    @Test
    public void testLedgerCreationAndDeletion() throws Exception {
        this.testExecution(false);
    }

    public void testExecution(boolean randomLedgerId) throws Exception {
        ConcurrentHashMap.KeySetView createRequestsLedgerIds = ConcurrentHashMap.newKeySet();
        ConcurrentLinkedDeque existingLedgerIds = new ConcurrentLinkedDeque();
        Vector failedCreates = new Vector();
        Vector failedDeletes = new Vector();
        BookKeeper bookKeeper = new BookKeeper(this.baseClientConf);
        ExecutorService executor = Executors.newFixedThreadPool(300);
        Random rand = new Random();
        int numberOfOperations = 20000;
        for (int i = 0; i < numberOfOperations; ++i) {
            int iteration = i;
            if (rand.nextBoolean() || existingLedgerIds.isEmpty()) {
                executor.submit(() -> {
                    long ledgerId = -1L;
                    try {
                        if (randomLedgerId) {
                            do {
                                ledgerId = Math.abs(rand.nextLong());
                                if (this.baseClientConf.getLedgerManagerFactoryClass().equals(LongHierarchicalLedgerManagerFactory.class)) continue;
                                ledgerId %= 9999999999L;
                            } while (!createRequestsLedgerIds.add(ledgerId));
                        } else {
                            ledgerId = iteration;
                        }
                        bookKeeper.createLedgerAdv(ledgerId, 3, 2, 2, BookKeeper.DigestType.CRC32, "passwd".getBytes(), null);
                        existingLedgerIds.add(ledgerId);
                    }
                    catch (Exception e) {
                        LOG.error("Got Exception while creating Ledger with ledgerId " + ledgerId, (Throwable)e);
                        failedCreates.add(ledgerId);
                    }
                });
                continue;
            }
            executor.submit(() -> {
                Long ledgerId = null;
                ledgerId = rand.nextBoolean() ? (Long)existingLedgerIds.pollFirst() : (Long)existingLedgerIds.pollLast();
                if (ledgerId == null) {
                    return;
                }
                try {
                    bookKeeper.deleteLedger(ledgerId.longValue());
                }
                catch (Exception e) {
                    LOG.error("Got Exception while deleting Ledger with ledgerId " + ledgerId, (Throwable)e);
                    failedDeletes.add(ledgerId);
                }
            });
        }
        executor.shutdown();
        Assert.assertTrue((String)"All the ledger create/delete operations should have'been completed", (boolean)executor.awaitTermination(120L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("There should be no failed creates. But there are " + failedCreates.size() + " failedCreates"), (boolean)failedCreates.isEmpty());
        Assert.assertTrue((String)("There should be no failed deletes. But there are " + failedDeletes.size() + " failedDeletes"), (boolean)failedDeletes.isEmpty());
        bookKeeper.close();
    }

    @Test
    public void testParentNodeDeletion() throws Exception {
        Assume.assumeTrue((this.baseClientConf.getLedgerManagerFactoryClass().equals(HierarchicalLedgerManagerFactory.class) || this.baseClientConf.getLedgerManagerFactoryClass().equals(LongHierarchicalLedgerManagerFactory.class) ? 1 : 0) != 0);
        ZooKeeper zkc = new ZooKeeper(this.zkUtil.getZooKeeperConnectString(), 10000, null);
        BookKeeper bookKeeper = new BookKeeper(this.baseClientConf);
        bookKeeper.createLedgerAdv(1L, 3, 2, 2, BookKeeper.DigestType.CRC32, "passwd".getBytes(), null);
        String ledgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseClientConf);
        String parentZnodePath = this.baseClientConf.getLedgerManagerFactoryClass().equals(HierarchicalLedgerManagerFactory.class) ? ledgersRootPath + "/00" : ledgersRootPath + "/000";
        Assert.assertTrue((String)(parentZnodePath + " zNode should exist"), (null != zkc.exists(parentZnodePath, false) ? 1 : 0) != 0);
        bookKeeper.deleteLedger(1L);
        Assert.assertTrue((String)(parentZnodePath + " zNode should not exist anymore"), (null == zkc.exists(parentZnodePath, false) ? 1 : 0) != 0);
        bookKeeper.close();
        zkc.close();
    }
}

