/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.MockBookKeeperTestCase;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class BookKeeperBuildersOpenLedgerTest
extends MockBookKeeperTestCase {
    private static final int ensembleSize = 3;
    private static final int writeQuorumSize = 2;
    private static final int ackQuorumSize = 1;
    private static final long ledgerId = 12342L;
    private static final Map<String, byte[]> customMetadata = new HashMap<String, byte[]>();
    private static final byte[] password = new byte[3];
    private static final byte[] entryData = new byte[32];
    private boolean withRecovery;

    public BookKeeperBuildersOpenLedgerTest(boolean withRecovery) {
        this.withRecovery = withRecovery;
    }

    @Parameterized.Parameters(name="withRecovery:({0})")
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void testOpenLedger() throws Exception {
        LedgerMetadata ledgerMetadata = this.generateLedgerMetadata(3, 2, 1, password, customMetadata);
        this.registerMockLedgerMetadata(12342L, ledgerMetadata);
        ledgerMetadata.getAllEnsembles().values().forEach(bookieAddressList -> bookieAddressList.forEach(bookieAddress -> {
            this.registerMockEntryForRead(12342L, -1L, (BookieId)bookieAddress, entryData, -1L);
            this.registerMockEntryForRead(12342L, 0L, (BookieId)bookieAddress, entryData, -1L);
        }));
        FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().withPassword(ledgerMetadata.getPassword()).withDigestType(DigestType.CRC32).withLedgerId(12342L).withRecovery(this.withRecovery).execute());
    }

    @Test
    public void testOpenLedgerWithTimeoutEx() throws Exception {
        this.mockReadEntryTimeout();
        LedgerMetadata ledgerMetadata = this.generateLedgerMetadata(3, 2, 1, password, customMetadata);
        this.registerMockLedgerMetadata(12342L, ledgerMetadata);
        ledgerMetadata.getAllEnsembles().values().forEach(bookieAddressList -> bookieAddressList.forEach(bookieAddress -> {
            this.registerMockEntryForRead(12342L, -1L, (BookieId)bookieAddress, entryData, -1L);
            this.registerMockEntryForRead(12342L, 0L, (BookieId)bookieAddress, entryData, -1L);
        }));
        try {
            FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().withPassword(ledgerMetadata.getPassword()).withDigestType(DigestType.CRC32).withLedgerId(12342L).withRecovery(this.withRecovery).execute());
            Assert.fail((String)"Expect timeout error");
        }
        catch (BKException.BKTimeoutException bKTimeoutException) {
            // empty catch block
        }
        this.resetBKClient();
    }

    protected LedgerMetadata generateLedgerMetadata(int ensembleSize, int writeQuorumSize, int ackQuorumSize, byte[] password, Map<String, byte[]> customMetadata) throws BKException.BKNotEnoughBookiesException {
        return LedgerMetadataBuilder.create().withId(12L).withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).withPassword(password).withDigestType(BookKeeper.DigestType.CRC32.toApiDigestType()).withCustomMetadata(customMetadata).withCreationTime(System.currentTimeMillis()).newEnsembleEntry(0L, this.generateNewEnsemble(ensembleSize)).build();
    }

    private void mockReadEntryTimeout() {
        ((BookieClient)Mockito.doAnswer(invocation -> {
            long ledgerId = (Long)invocation.getArguments()[1];
            long entryId = (Long)invocation.getArguments()[2];
            BookkeeperInternalCallbacks.ReadEntryCallback callback = (BookkeeperInternalCallbacks.ReadEntryCallback)invocation.getArguments()[3];
            Object ctx = invocation.getArguments()[4];
            callback.readEntryComplete(-23, ledgerId, entryId, null, ctx);
            return null;
        }).when((Object)this.bookieClient)).readEntry((BookieId)Mockito.any(BookieId.class), Mockito.anyLong(), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)Mockito.any(BookkeeperInternalCallbacks.ReadEntryCallback.class), Mockito.any(), Mockito.anyInt(), (byte[])Mockito.any());
        ((BookieClient)Mockito.doAnswer(invocation -> {
            long ledgerId = (Long)invocation.getArguments()[1];
            BookkeeperInternalCallbacks.ReadLacCallback callback = (BookkeeperInternalCallbacks.ReadLacCallback)invocation.getArguments()[2];
            Object ctx = invocation.getArguments()[3];
            callback.readLacComplete(-23, ledgerId, null, null, ctx);
            return null;
        }).when((Object)this.bookieClient)).readLac((BookieId)Mockito.any(BookieId.class), Mockito.anyLong(), (BookkeeperInternalCallbacks.ReadLacCallback)Mockito.any(BookkeeperInternalCallbacks.ReadLacCallback.class), Mockito.any());
    }

    private void resetBKClient() throws Exception {
        this.tearDown();
        this.setup();
    }
}

