/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieClientImpl;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGetBookieInfoTimeout
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestGetBookieInfoTimeout.class);
    BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32C;
    public EventLoopGroup eventLoopGroup;
    public OrderedExecutor executor;
    private ScheduledExecutorService scheduler;

    public TestGetBookieInfoTimeout() {
        super(5);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.eventLoopGroup = new NioEventLoopGroup();
        this.executor = OrderedExecutor.newBuilder().name("BKClientOrderedSafeExecutor").numThreads(2).build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("BookKeeperClientScheduler"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.scheduler.shutdown();
        this.eventLoopGroup.shutdownGracefully();
        this.executor.shutdown();
    }

    @Test
    public void testGetBookieInfoTimeout() throws Exception {
        LedgerHandle writelh = this.bkc.createLedger(3, 3, this.digestType, "testPasswd".getBytes());
        String tmp = "Foobar";
        int numEntries = 10;
        for (int i = 0; i < 10; ++i) {
            writelh.addEntry(tmp.getBytes());
        }
        ClientConfiguration cConf = new ClientConfiguration();
        cConf.setGetBookieInfoTimeout(2);
        cConf.setReadEntryTimeout(100000);
        BookieId bookieToSleep = (BookieId)writelh.getLedgerMetadata().getEnsembleAt(0L).get(0);
        int sleeptime = cConf.getBookieInfoTimeout() * 3;
        CountDownLatch latch = this.sleepBookie(bookieToSleep, sleeptime);
        latch.await();
        BookieClientImpl bc = new BookieClientImpl(cConf, this.eventLoopGroup, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, this.executor, this.scheduler, (StatsLogger)NullStatsLogger.INSTANCE, this.bkc.getBookieAddressResolver());
        long flags = 3L;
        class CallbackObj {
            int rc;
            long requested;
            long freeDiskSpace;
            long totalDiskCapacity;
            CountDownLatch latch = new CountDownLatch(1);

            CallbackObj(long requested) {
                this.requested = requested;
                this.rc = 0;
                this.freeDiskSpace = 0L;
                this.totalDiskCapacity = 0L;
            }
        }
        CallbackObj obj = new CallbackObj(flags);
        bc.getBookieInfo(bookieToSleep, flags, new BookkeeperInternalCallbacks.GetBookieInfoCallback(){

            public void getBookieInfoComplete(int rc, BookieInfoReader.BookieInfo bInfo, Object ctx) {
                CallbackObj obj = (CallbackObj)ctx;
                obj.rc = rc;
                if (rc == 0) {
                    if ((obj.requested & 2L) != 0L) {
                        obj.freeDiskSpace = bInfo.getFreeDiskSpace();
                    }
                    if ((obj.requested & 1L) != 0L) {
                        obj.totalDiskCapacity = bInfo.getTotalDiskSpace();
                    }
                }
                obj.latch.countDown();
            }
        }, (Object)obj);
        obj.latch.await();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Return code: " + obj.rc);
        }
        Assert.assertTrue((String)("GetBookieInfo failed with unexpected error code: " + obj.rc), (obj.rc == -23 ? 1 : 0) != 0);
    }

    @Test
    public void testGetBookieInfoWithAllStoppedBookies() throws Exception {
        Map bookieInfo = this.bkc.getBookieInfo();
        Assert.assertEquals((long)5L, (long)bookieInfo.size());
        this.stopAllBookies(false);
        bookieInfo = this.bkc.getBookieInfo();
        Assert.assertEquals((long)0L, (long)bookieInfo.size());
    }
}

