/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.security.GeneralSecurityException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.MockBookKeeper;
import org.apache.bookkeeper.client.MockReadHandle;
import org.apache.bookkeeper.client.api.LastConfirmedAndEntry;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockLedgerHandle
extends LedgerHandle {
    final ArrayList<LedgerEntryImpl> entries = Lists.newArrayList();
    final MockBookKeeper bk;
    final long id;
    final BookKeeper.DigestType digest;
    final byte[] passwd;
    final ReadHandle readHandle;
    long lastEntry = -1L;
    boolean fenced = false;
    private static final Logger log = LoggerFactory.getLogger(MockLedgerHandle.class);

    MockLedgerHandle(MockBookKeeper bk, long id, BookKeeper.DigestType digest, byte[] passwd) throws GeneralSecurityException {
        super(bk.getClientCtx(), id, new Versioned((Object)MockLedgerHandle.createMetadata(digest, passwd), (Version)new LongVersion(0L)), digest, passwd, WriteFlag.NONE);
        this.bk = bk;
        this.id = id;
        this.digest = digest;
        this.passwd = Arrays.copyOf(passwd, passwd.length);
        this.readHandle = new MockReadHandle(bk, id, this.getLedgerMetadata(), this.entries);
    }

    public void asyncClose(AsyncCallback.CloseCallback cb, Object ctx) {
        if (this.bk.getProgrammedFailStatus()) {
            cb.closeComplete(this.bk.failReturnCode, (LedgerHandle)this, ctx);
            return;
        }
        this.fenced = true;
        try {
            this.bk.executor.execute(() -> cb.closeComplete(0, (LedgerHandle)this, ctx));
        }
        catch (RejectedExecutionException e) {
            cb.closeComplete(0, (LedgerHandle)this, ctx);
        }
    }

    void executeOrdered(Runnable runnable) throws RejectedExecutionException {
        this.bk.executor.execute(runnable);
    }

    public void asyncReadEntries(final long firstEntry, final long lastEntry, final AsyncCallback.ReadCallback cb, final Object ctx) {
        if (this.bk.isStopped()) {
            cb.readComplete(-1, (LedgerHandle)this, null, ctx);
            return;
        }
        this.bk.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (MockLedgerHandle.this.bk.getProgrammedFailStatus()) {
                    cb.readComplete(MockLedgerHandle.this.bk.failReturnCode, (LedgerHandle)MockLedgerHandle.this, null, ctx);
                    return;
                }
                if (MockLedgerHandle.this.bk.isStopped()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Bookkeeper is closed!");
                    }
                    cb.readComplete(-1, (LedgerHandle)MockLedgerHandle.this, null, ctx);
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("readEntries: first={} last={} total={}", new Object[]{firstEntry, lastEntry, MockLedgerHandle.this.entries.size()});
                }
                final ArrayDeque<LedgerEntry> seq = new ArrayDeque<LedgerEntry>();
                long entryId = firstEntry;
                while (entryId <= lastEntry && entryId < (long)MockLedgerHandle.this.entries.size()) {
                    seq.add(new LedgerEntry(MockLedgerHandle.this.entries.get((int)entryId++).duplicate()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("Entries read: {}", seq);
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                cb.readComplete(0, (LedgerHandle)MockLedgerHandle.this, (Enumeration)new Enumeration<LedgerEntry>(){

                    @Override
                    public boolean hasMoreElements() {
                        return !seq.isEmpty();
                    }

                    @Override
                    public LedgerEntry nextElement() {
                        return (LedgerEntry)seq.remove();
                    }
                }, ctx);
            }
        });
    }

    public long addEntry(byte[] data) throws InterruptedException, BKException {
        try {
            this.bk.checkProgrammedFail();
        }
        catch (BKException e) {
            this.fenced = true;
            throw e;
        }
        if (this.fenced) {
            throw BKException.create((int)-101);
        }
        if (this.bk.isStopped()) {
            throw BKException.create((int)-3);
        }
        this.lastEntry = this.entries.size();
        this.entries.add(LedgerEntryImpl.create((long)this.ledgerId, (long)this.lastEntry, (long)data.length, (ByteBuf)Unpooled.wrappedBuffer((byte[])data)));
        return this.lastEntry;
    }

    public void asyncAddEntry(byte[] data, AsyncCallback.AddCallback cb, Object ctx) {
        this.asyncAddEntry(data, 0, data.length, cb, ctx);
    }

    public void asyncAddEntry(byte[] data, int offset, int length, AsyncCallback.AddCallback cb, Object ctx) {
        this.asyncAddEntry(Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)length), cb, ctx);
    }

    public void asyncAddEntry(final ByteBuf data, final AsyncCallback.AddCallback cb, final Object ctx) {
        if (this.bk.isStopped()) {
            cb.addComplete(-1, (LedgerHandle)this, -1L, ctx);
            return;
        }
        data.retain();
        this.bk.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (MockLedgerHandle.this.bk.getProgrammedFailStatus()) {
                    MockLedgerHandle.this.fenced = true;
                    data.release();
                    cb.addComplete(MockLedgerHandle.this.bk.failReturnCode, (LedgerHandle)MockLedgerHandle.this, -1L, ctx);
                    return;
                }
                if (MockLedgerHandle.this.bk.isStopped()) {
                    data.release();
                    cb.addComplete(-1, (LedgerHandle)MockLedgerHandle.this, -1L, ctx);
                    return;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (MockLedgerHandle.this.fenced) {
                    data.release();
                    cb.addComplete(-101, (LedgerHandle)MockLedgerHandle.this, -1L, ctx);
                } else {
                    MockLedgerHandle.this.lastEntry = MockLedgerHandle.this.entries.size();
                    byte[] storedData = new byte[data.readableBytes()];
                    data.readBytes(storedData);
                    MockLedgerHandle.this.entries.add(LedgerEntryImpl.create((long)MockLedgerHandle.this.ledgerId, (long)MockLedgerHandle.this.lastEntry, (long)storedData.length, (ByteBuf)Unpooled.wrappedBuffer((byte[])storedData)));
                    data.release();
                    cb.addComplete(0, (LedgerHandle)MockLedgerHandle.this, MockLedgerHandle.this.lastEntry, ctx);
                }
            }
        });
    }

    public long getId() {
        return this.ledgerId;
    }

    public long getLastAddConfirmed() {
        return this.lastEntry;
    }

    public long getLength() {
        long length = 0L;
        for (LedgerEntryImpl entry : this.entries) {
            length += entry.getLength();
        }
        return length;
    }

    public CompletableFuture<LedgerEntries> readAsync(long firstEntry, long lastEntry) {
        return this.readHandle.readAsync(firstEntry, lastEntry);
    }

    public CompletableFuture<LedgerEntries> readUnconfirmedAsync(long firstEntry, long lastEntry) {
        return this.readHandle.readUnconfirmedAsync(firstEntry, lastEntry);
    }

    public CompletableFuture<Long> readLastAddConfirmedAsync() {
        return this.readHandle.readLastAddConfirmedAsync();
    }

    public CompletableFuture<Long> tryReadLastAddConfirmedAsync() {
        return this.readHandle.tryReadLastAddConfirmedAsync();
    }

    public boolean isClosed() {
        return this.readHandle.isClosed();
    }

    public CompletableFuture<LastConfirmedAndEntry> readLastAddConfirmedAndEntryAsync(long entryId, long timeOutInMillis, boolean parallel) {
        return this.readHandle.readLastAddConfirmedAndEntryAsync(entryId, timeOutInMillis, parallel);
    }

    private static LedgerMetadata createMetadata(BookKeeper.DigestType digest, byte[] passwd) {
        ArrayList ensemble = Lists.newArrayList((Object[])new BookieId[]{new BookieSocketAddress("192.0.2.1", 1234).toBookieId(), new BookieSocketAddress("192.0.2.2", 1234).toBookieId(), new BookieSocketAddress("192.0.2.3", 1234).toBookieId()});
        return LedgerMetadataBuilder.create().withId(124L).withDigestType(digest.toApiDigestType()).withPassword(passwd).newEnsembleEntry(0L, (List)ensemble).build();
    }
}

