/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.ClientUtil;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.LedgerRecovery2Test;
import org.apache.bookkeeper.client.MockClientContext;
import org.apache.bookkeeper.client.PendingAddOp;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.MockBookieClient;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.util.TestUtils;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleFailuresTest {
    private static final Logger log = LoggerFactory.getLogger(LedgerRecovery2Test.class);
    private static final BookieId b1 = new BookieSocketAddress("b1", 3181).toBookieId();
    private static final BookieId b2 = new BookieSocketAddress("b2", 3181).toBookieId();
    private static final BookieId b3 = new BookieSocketAddress("b3", 3181).toBookieId();
    private static final BookieId b4 = new BookieSocketAddress("b4", 3181).toBookieId();
    private static final BookieId b5 = new BookieSocketAddress("b5", 3181).toBookieId();

    @Test(timeout=30000L)
    public void testChangeTriggeredOneTimeForOneFailure() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        clientCtx.getMockBookieClient().errorBookies(b1);
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        lh.appendAsync("entry1".getBytes());
        lh.appendAsync("entry2".getBytes());
        lh.appendAsync("entry3".getBytes());
        lh.appendAsync("entry4".getBytes());
        lh.appendAsync("entry5".getBytes()).get();
        ((LedgerManager)Mockito.verify((Object)clientCtx.getLedgerManager(), (VerificationMode)Mockito.times((int)1))).writeLedgerMetadata(ArgumentMatchers.anyLong(), (LedgerMetadata)ArgumentMatchers.any(), (Version)ArgumentMatchers.any());
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b4, b2, b3}));
    }

    @Test(timeout=30000L)
    public void testSecondFailureOccursWhileFirstBeingHandled() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        clientCtx.getMockRegistrationClient().addBookies(b4, b5).get();
        CompletableFuture b2blocker = new CompletableFuture();
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> {
            if (bookie.equals((Object)b1)) {
                return FutureUtils.exception((Throwable)new BKException.BKWriteException());
            }
            if (bookie.equals((Object)b2)) {
                return b2blocker;
            }
            return FutureUtils.value(null);
        });
        CompletableFuture metadataNotifier = new CompletableFuture();
        CompletableFuture<Object> metadataBlocker = new CompletableFuture<Object>();
        clientCtx.getMockLedgerManager().setPreWriteHook((ledgerId, metadata) -> {
            metadataNotifier.complete(null);
            return metadataBlocker;
        });
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        lh.appendAsync("entry1".getBytes());
        lh.appendAsync("entry2".getBytes());
        lh.appendAsync("entry3".getBytes());
        lh.appendAsync("entry4".getBytes());
        CompletableFuture future = lh.appendAsync("entry5".getBytes());
        metadataNotifier.get();
        b2blocker.completeExceptionally(new BKException.BKWriteException());
        metadataBlocker.complete(null);
        future.get();
        ((LedgerManager)Mockito.verify((Object)clientCtx.getLedgerManager(), (VerificationMode)Mockito.times((int)2))).writeLedgerMetadata(ArgumentMatchers.anyLong(), (LedgerMetadata)ArgumentMatchers.any(), (Version)ArgumentMatchers.any());
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
        Assert.assertTrue((boolean)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).contains(b3));
        Assert.assertTrue((boolean)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).contains(b4));
        Assert.assertTrue((boolean)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).contains(b5));
    }

    @Test(timeout=30000L)
    public void testHandlingFailuresOneBookieFailsImmediately() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        clientCtx.getMockBookieClient().errorBookies(b1);
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        lh.append("entry1".getBytes());
        lh.close();
        Assert.assertTrue((boolean)lh.getLedgerMetadata().isClosed());
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b4, b2, b3}));
    }

    @Test(timeout=30000L)
    public void testHandlingFailuresOneBookieFailsAfterOneEntry() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        lh.append("entry1".getBytes());
        clientCtx.getMockBookieClient().errorBookies(b1);
        lh.append("entry2".getBytes());
        lh.close();
        Assert.assertTrue((boolean)lh.getLedgerMetadata().isClosed());
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)2L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(1L), (Object)Lists.newArrayList((Object[])new BookieId[]{b4, b2, b3}));
        Assert.assertEquals((long)lh.getLedgerMetadata().getLastEntryId(), (long)1L);
    }

    @Test(timeout=30000L)
    public void testHandlingFailuresMultipleBookieFailImmediatelyNotEnoughToReplace() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        clientCtx.getMockBookieClient().errorBookies(b1, b2);
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        try {
            lh.append("entry1".getBytes());
            Assert.fail((String)"Shouldn't have been able to add");
        }
        catch (BKException.BKNotEnoughBookiesException bke) {
            TestUtils.assertEventuallyTrue("Failure to add should trigger ledger closure", () -> lh.getLedgerMetadata().isClosed());
            Assert.assertEquals((String)"Ledger should be empty", (long)lh.getLedgerMetadata().getLastEntryId(), (long)-1L);
            Assert.assertEquals((String)"Should be only one ensemble", (long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
            Assert.assertEquals((String)"Ensemble shouldn't have changed", lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        }
    }

    @Test(timeout=30000L)
    public void testHandlingFailuresMultipleBookieFailAfterOneEntryNotEnoughToReplace() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        lh.append("entry1".getBytes());
        clientCtx.getMockBookieClient().errorBookies(b1, b2);
        try {
            lh.append("entry2".getBytes());
            Assert.fail((String)"Shouldn't have been able to add");
        }
        catch (BKException.BKNotEnoughBookiesException bke) {
            TestUtils.assertEventuallyTrue("Failure to add should trigger ledger closure", () -> lh.getLedgerMetadata().isClosed());
            Assert.assertEquals((String)"Ledger should be empty", (long)lh.getLedgerMetadata().getLastEntryId(), (long)0L);
            Assert.assertEquals((String)"Should be only one ensemble", (long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
            Assert.assertEquals((String)"Ensemble shouldn't have changed", lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        }
    }

    @Test(timeout=30000L)
    public void testClientClosesWhileFailureHandlerInProgress() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        clientCtx.getMockBookieClient().errorBookies(b2);
        CompletableFuture changeInProgress = new CompletableFuture();
        CompletableFuture<Object> blockEnsembleChange = new CompletableFuture<Object>();
        clientCtx.getMockLedgerManager().setPreWriteHook((ledgerId, metadata) -> {
            if (((BookieId)((List)metadata.getAllEnsembles().get(0L)).get(1)).equals((Object)b4)) {
                changeInProgress.complete(null);
                return blockEnsembleChange;
            }
            return FutureUtils.value(null);
        });
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        CompletableFuture future = lh.appendAsync("entry1".getBytes());
        changeInProgress.get();
        lh.close();
        blockEnsembleChange.complete(null);
        try {
            future.get();
            Assert.fail((String)"Add shouldn't have succeeded");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(ee.getCause().getClass(), BKException.BKLedgerClosedException.class);
        }
        Assert.assertTrue((boolean)lh.getLedgerMetadata().isClosed());
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        Assert.assertEquals((long)lh.getLedgerMetadata().getLastEntryId(), (long)-1L);
    }

    @Test(timeout=30000L)
    public void testMetadataSetToClosedDuringFailureHandler() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        clientCtx.getMockBookieClient().errorBookies(b2);
        CompletableFuture changeInProgress = new CompletableFuture();
        CompletableFuture<Object> blockEnsembleChange = new CompletableFuture<Object>();
        clientCtx.getMockLedgerManager().setPreWriteHook((ledgerId, metadata) -> {
            if (((BookieId)((List)metadata.getAllEnsembles().get(0L)).get(1)).equals((Object)b4)) {
                changeInProgress.complete(null);
                return blockEnsembleChange;
            }
            return FutureUtils.value(null);
        });
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        CompletableFuture future = lh.appendAsync("entry1".getBytes());
        changeInProgress.get();
        ClientUtil.transformMetadata(clientCtx, 10L, metadata -> LedgerMetadataBuilder.from((LedgerMetadata)metadata).withClosedState().withLastEntryId(1234L).withLength(10L).build());
        blockEnsembleChange.complete(null);
        try {
            future.get();
            Assert.fail((String)"Add shouldn't have succeeded");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(ee.getCause().getClass(), BKException.BKLedgerClosedException.class);
        }
        Assert.assertTrue((boolean)lh.getLedgerMetadata().isClosed());
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        Assert.assertEquals((long)lh.getLedgerMetadata().getLastEntryId(), (long)1234L);
    }

    @Test(timeout=30000L)
    public void testMetadataSetToInRecoveryDuringFailureHandler() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        clientCtx.getMockBookieClient().errorBookies(b2);
        CompletableFuture changeInProgress = new CompletableFuture();
        CompletableFuture<Object> blockEnsembleChange = new CompletableFuture<Object>();
        clientCtx.getMockLedgerManager().setPreWriteHook((ledgerId, metadata) -> {
            if (((BookieId)((List)metadata.getAllEnsembles().get(0L)).get(1)).equals((Object)b4)) {
                changeInProgress.complete(null);
                return blockEnsembleChange;
            }
            return FutureUtils.value(null);
        });
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        CompletableFuture future = lh.appendAsync("entry1".getBytes());
        changeInProgress.get();
        ClientUtil.transformMetadata(clientCtx, 10L, metadata -> LedgerMetadataBuilder.from((LedgerMetadata)metadata).withInRecoveryState().build());
        blockEnsembleChange.complete(null);
        try {
            future.get();
            Assert.fail((String)"Add shouldn't have succeeded");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(ee.getCause().getClass(), BKException.BKLedgerFencedException.class);
        }
        Assert.assertFalse((boolean)lh.getLedgerMetadata().isClosed());
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
    }

    @Test(timeout=30000L)
    public void testOldEnsembleChangedDuringFailureHandler() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        lh.append("entry1".getBytes());
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        clientCtx.getMockBookieClient().errorBookies(b3);
        lh.append("entry2".getBytes());
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)2L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(1L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b4}));
        CompletableFuture changeInProgress = new CompletableFuture();
        CompletableFuture<Object> blockEnsembleChange = new CompletableFuture<Object>();
        clientCtx.getMockLedgerManager().setPreWriteHook((ledgerId, metadata) -> {
            if (metadata.getAllEnsembles().size() > 2 && ((BookieId)((List)metadata.getAllEnsembles().get(2L)).get(0)).equals((Object)b5)) {
                changeInProgress.complete(null);
                return blockEnsembleChange;
            }
            return FutureUtils.value(null);
        });
        clientCtx.getMockRegistrationClient().addBookies(b5).get();
        clientCtx.getMockBookieClient().errorBookies(b1);
        CompletableFuture future = lh.appendAsync("entry3".getBytes());
        changeInProgress.get();
        ClientUtil.transformMetadata(clientCtx, 10L, metadata -> LedgerMetadataBuilder.from((LedgerMetadata)metadata).replaceEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b4, b2, b5})).build());
        blockEnsembleChange.complete(null);
        future.get();
        Assert.assertFalse((boolean)lh.getLedgerMetadata().isClosed());
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)3L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b4, b2, b5}));
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(1L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b4}));
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(2L), (Object)Lists.newArrayList((Object[])new BookieId[]{b5, b2, b4}));
    }

    @Test(timeout=30000L)
    public void testNoAddsAreCompletedWhileFailureHandlingInProgress() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(2).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        clientCtx.getMockBookieClient().errorBookies(b3);
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        lh.append("entry1".getBytes());
        CompletableFuture changeInProgress = new CompletableFuture();
        CompletableFuture<Object> blockEnsembleChange = new CompletableFuture<Object>();
        clientCtx.getMockLedgerManager().setPreWriteHook((ledgerId, metadata) -> {
            if (((BookieId)((List)metadata.getAllEnsembles().get(1L)).get(2)).equals((Object)b4)) {
                changeInProgress.complete(null);
                return blockEnsembleChange;
            }
            return FutureUtils.value(null);
        });
        CompletableFuture future = lh.appendAsync("entry2".getBytes());
        changeInProgress.get();
        try {
            future.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Shouldn't complete");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        blockEnsembleChange.complete(null);
        future.get();
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)2L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(1L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b4}));
    }

    @Test(timeout=30000L)
    public void testHandleFailureBookieNotInWriteSet() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(2).withAckQuorumSize(1).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        CompletableFuture b1Delay = new CompletableFuture();
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> {
            if (bookie.equals((Object)b1)) {
                return b1Delay;
            }
            return FutureUtils.value(null);
        });
        CompletableFuture changeInProgress = new CompletableFuture();
        CompletableFuture<Object> blockEnsembleChange = new CompletableFuture<Object>();
        clientCtx.getMockLedgerManager().setPreWriteHook((ledgerId, metadata) -> {
            changeInProgress.complete(null);
            return blockEnsembleChange;
        });
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        log.info("b2 should be enough to complete first add");
        lh.append("entry1".getBytes());
        log.info("when b1 completes with failure, handleFailures should kick off");
        b1Delay.completeExceptionally(new BKException.BKWriteException());
        log.info("write second entry, should have enough bookies, but blocks completion on failure handling");
        AtomicReference e2 = new AtomicReference();
        ((MockBookieClient)clientCtx.getBookieClient()).getExecutor().chooseThread(lh.ledgerId).execute(() -> e2.set(lh.appendAsync("entry2".getBytes())));
        changeInProgress.get();
        TestUtils.assertEventuallyTrue("e2 should eventually complete", () -> ((PendingAddOp)lh.pendingAddOps.peek()).completed);
        Assert.assertFalse((String)"e2 shouldn't be completed to client", (boolean)((CompletableFuture)e2.get()).isDone());
        blockEnsembleChange.complete(null);
        log.info("e2 should complete");
        ((CompletableFuture)e2.get()).get(10L, TimeUnit.SECONDS);
    }
}

