/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.MockBookKeeperTestCase;
import org.apache.bookkeeper.client.api.WriteAdvHandle;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.net.BookieId;
import org.junit.Assert;
import org.junit.Test;

public class DeferredSyncTest
extends MockBookKeeperTestCase {
    static final byte[] PASSWORD = "password".getBytes();
    static final ByteBuf DATA = Unpooled.wrappedBuffer((byte[])"foobar".getBytes());
    static final int NUM_ENTRIES = 100;

    @Test
    public void testAddEntryLastAddConfirmedDoesNotAdvance() throws Exception {
        try (WriteHandle wh = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(2).withPassword(PASSWORD).withWriteFlags(new WriteFlag[]{WriteFlag.DEFERRED_SYNC}).execute());){
            for (int i = 0; i < 99; ++i) {
                FutureUtils.result((CompletableFuture)wh.appendAsync(DATA.retainedDuplicate()));
            }
            long lastEntryID = (Long)FutureUtils.result((CompletableFuture)wh.appendAsync(DATA.retainedDuplicate()));
            Assert.assertEquals((long)99L, (long)lastEntryID);
            Assert.assertEquals((long)99L, (long)wh.getLastAddPushed());
            Assert.assertEquals((long)-1L, (long)wh.getLastAddConfirmed());
        }
    }

    @Test
    public void testAddEntryLastAddConfirmedAdvanceWithForce() throws Exception {
        try (WriteHandle wh = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(2).withPassword(PASSWORD).withWriteFlags(new WriteFlag[]{WriteFlag.DEFERRED_SYNC}).execute());){
            for (int i = 0; i < 99; ++i) {
                FutureUtils.result((CompletableFuture)wh.appendAsync(DATA.retainedDuplicate()));
            }
            long lastEntryID = (Long)FutureUtils.result((CompletableFuture)wh.appendAsync(DATA.retainedDuplicate()));
            Assert.assertEquals((long)99L, (long)lastEntryID);
            Assert.assertEquals((long)99L, (long)wh.getLastAddPushed());
            Assert.assertEquals((long)-1L, (long)wh.getLastAddConfirmed());
            FutureUtils.result((CompletableFuture)wh.force());
            Assert.assertEquals((long)99L, (long)wh.getLastAddConfirmed());
        }
    }

    @Test
    public void testForceOnWriteAdvHandle() throws Exception {
        try (WriteAdvHandle wh = (WriteAdvHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(2).withPassword(PASSWORD).withWriteFlags(new WriteFlag[]{WriteFlag.DEFERRED_SYNC}).makeAdv().execute());){
            CompletableFuture w0 = wh.writeAsync(0L, DATA.retainedDuplicate());
            CompletableFuture w2 = wh.writeAsync(2L, DATA.retainedDuplicate());
            CompletableFuture w3 = wh.writeAsync(3L, DATA.retainedDuplicate());
            FutureUtils.result((CompletableFuture)w0);
            FutureUtils.result((CompletableFuture)wh.force());
            Assert.assertEquals((long)0L, (long)wh.getLastAddConfirmed());
            CompletableFuture w1 = wh.writeAsync(1L, DATA.retainedDuplicate());
            FutureUtils.result((CompletableFuture)w3);
            Assert.assertTrue((boolean)w1.isDone());
            Assert.assertTrue((boolean)w2.isDone());
            CompletableFuture w5 = wh.writeAsync(5L, DATA.retainedDuplicate());
            FutureUtils.result((CompletableFuture)wh.force());
            Assert.assertEquals((long)3L, (long)wh.getLastAddConfirmed());
            wh.writeAsync(4L, DATA.retainedDuplicate());
            FutureUtils.result((CompletableFuture)w5);
            FutureUtils.result((CompletableFuture)wh.force());
            Assert.assertEquals((long)5L, (long)wh.getLastAddConfirmed());
        }
    }

    @Test
    public void testForceRequiresFullEnsemble() throws Exception {
        try (WriteHandle wh = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withEnsembleSize(3).withWriteQuorumSize(2).withAckQuorumSize(2).withPassword(PASSWORD).withWriteFlags(new WriteFlag[]{WriteFlag.DEFERRED_SYNC}).execute());){
            for (int i = 0; i < 99; ++i) {
                FutureUtils.result((CompletableFuture)wh.appendAsync(DATA.retainedDuplicate()));
            }
            long lastEntryID = (Long)FutureUtils.result((CompletableFuture)wh.appendAsync(DATA.retainedDuplicate()));
            Assert.assertEquals((long)99L, (long)lastEntryID);
            Assert.assertEquals((long)99L, (long)wh.getLastAddPushed());
            Assert.assertEquals((long)-1L, (long)wh.getLastAddConfirmed());
            BookieId bookieAddress = (BookieId)wh.getLedgerMetadata().getEnsembleAt(wh.getLastAddPushed()).get(0);
            this.killBookie(bookieAddress);
            FutureUtils.result((CompletableFuture)wh.appendAsync(DATA.retainedDuplicate()));
            try {
                FutureUtils.result((CompletableFuture)wh.force());
            }
            catch (BKException.BKBookieException bKBookieException) {
                // empty catch block
            }
            this.startKilledBookie(bookieAddress);
            FutureUtils.result((CompletableFuture)wh.force());
        }
    }

    @Test
    public void testForceWillAdvanceLacOnlyUpToLastAcknoledgedWrite() throws Exception {
        try (WriteHandle wh = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).withPassword(PASSWORD).withWriteFlags(new WriteFlag[]{WriteFlag.DEFERRED_SYNC}).execute());){
            for (int i = 0; i < 99; ++i) {
                FutureUtils.result((CompletableFuture)wh.appendAsync(DATA.retainedDuplicate()));
            }
            long lastEntryIdBeforeSuspend = (Long)FutureUtils.result((CompletableFuture)wh.appendAsync(DATA.retainedDuplicate()));
            Assert.assertEquals((long)99L, (long)lastEntryIdBeforeSuspend);
            Assert.assertEquals((long)-1L, (long)wh.getLastAddConfirmed());
            BookieId bookieAddress = (BookieId)wh.getLedgerMetadata().getEnsembleAt(wh.getLastAddPushed()).get(0);
            this.suspendBookieForceLedgerAcks(bookieAddress);
            CompletableFuture forceResult = wh.force();
            Assert.assertEquals((long)-1L, (long)wh.getLastAddConfirmed());
            long lastEntry = wh.append(DATA.retainedDuplicate());
            this.resumeBookieWriteAcks(bookieAddress);
            FutureUtils.result((CompletableFuture)forceResult);
            Assert.assertEquals((long)lastEntryIdBeforeSuspend, (long)wh.getLastAddConfirmed());
            FutureUtils.result((CompletableFuture)wh.force());
            Assert.assertEquals((long)lastEntry, (long)wh.getLastAddConfirmed());
        }
    }

    @Test
    public void testForbiddenEnsembleChange() throws Exception {
        try (WriteHandle wh = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withEnsembleSize(1).withWriteQuorumSize(1).withAckQuorumSize(1).withPassword(PASSWORD).withWriteFlags(new WriteFlag[]{WriteFlag.DEFERRED_SYNC}).execute());){
            for (int i = 0; i < 99; ++i) {
                wh.append(DATA.retainedDuplicate());
            }
            Assert.assertEquals((long)1L, (long)this.availableBookies.size());
            this.killBookie((BookieId)wh.getLedgerMetadata().getEnsembleAt(wh.getLastAddPushed()).get(0));
            Assert.assertEquals((long)0L, (long)this.availableBookies.size());
            this.startNewBookie();
            Assert.assertEquals((long)1L, (long)this.availableBookies.size());
            try {
                wh.append(DATA.retainedDuplicate());
                Assert.fail((String)"since ensemble change is disable we cannot be able to write any more");
            }
            catch (BKException.BKWriteException i) {
                // empty catch block
            }
            LedgerHandle lh = (LedgerHandle)wh;
            Assert.assertFalse((boolean)lh.hasDelayedWriteFailedBookies());
        }
    }

    @Test(expected=BKException.BKLedgerClosedException.class)
    public void testCannotIssueForceOnClosedLedgerHandle() throws Exception {
        WriteHandle wh = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withEnsembleSize(1).withWriteQuorumSize(1).withAckQuorumSize(1).withPassword(PASSWORD).withWriteFlags(new WriteFlag[]{WriteFlag.DEFERRED_SYNC}).execute());
        wh.close();
        FutureUtils.result((CompletableFuture)wh.force());
    }
}

