/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import java.io.File;
import java.util.ArrayList;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.storage.ldb.PersistentEntryLogMetadataMap;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class PersistentEntryLogMetadataMapTest {
    private final ServerConfiguration configuration;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    public PersistentEntryLogMetadataMapTest() {
        this.configuration = new ServerConfiguration();
    }

    @Test
    public void simple() throws Exception {
        int i;
        File tmpDir = this.tempFolder.newFolder("metadata-cache");
        String path = tmpDir.getAbsolutePath();
        PersistentEntryLogMetadataMap entryMetadataMap = new PersistentEntryLogMetadataMap(path, this.configuration);
        ArrayList metadatas = Lists.newArrayList();
        int totalMetadata = 1000;
        for (i = 1; i <= totalMetadata; ++i) {
            EntryLogMetadata entryLogMeta = this.createEntryLogMetadata(i, i);
            metadatas.add(entryLogMeta);
            entryMetadataMap.put((long)i, entryLogMeta);
        }
        for (i = 1; i <= totalMetadata; ++i) {
            Assert.assertTrue((boolean)entryMetadataMap.containsKey((long)i));
        }
        Assert.assertEquals((long)entryMetadataMap.size(), (long)totalMetadata);
        entryMetadataMap.forEach((logId, metadata) -> {
            Assert.assertEquals((long)((EntryLogMetadata)metadatas.get(logId.intValue() - 1)).getTotalSize(), (long)metadata.getTotalSize());
            for (int i = 0; i < logId.intValue(); ++i) {
                Assert.assertTrue((boolean)metadata.containsLedger((long)i));
            }
        });
        metadatas.forEach(meta -> {
            long logId = meta.getEntryLogId();
            try {
                entryMetadataMap.forKey(logId, (entryLogId, persistedMeta) -> {
                    Assert.assertEquals((long)meta.getEntryLogId(), (long)persistedMeta.getEntryLogId());
                    Assert.assertEquals((long)meta.getTotalSize(), (long)persistedMeta.getTotalSize());
                    Assert.assertEquals((long)logId, (long)entryLogId);
                });
            }
            catch (BookieException.EntryLogMetadataMapException e) {
                throw new RuntimeException(e);
            }
        });
        for (i = 1; i <= totalMetadata; ++i) {
            entryMetadataMap.remove((long)i);
        }
        for (i = 1; i <= totalMetadata; ++i) {
            Assert.assertFalse((boolean)entryMetadataMap.containsKey((long)i));
        }
        Assert.assertEquals((long)entryMetadataMap.size(), (long)0L);
        entryMetadataMap.close();
    }

    @Test
    public void closeAndOpen() throws Exception {
        int i;
        File tmpDir = this.tempFolder.newFolder();
        String path = tmpDir.getAbsolutePath();
        PersistentEntryLogMetadataMap entryMetadataMap = new PersistentEntryLogMetadataMap(path, this.configuration);
        ArrayList metadatas = Lists.newArrayList();
        int totalMetadata = 1000;
        for (i = 1; i <= totalMetadata; ++i) {
            EntryLogMetadata entryLogMeta = this.createEntryLogMetadata(i, i);
            metadatas.add(entryLogMeta);
            entryMetadataMap.put((long)i, entryLogMeta);
        }
        for (i = 1; i <= totalMetadata; ++i) {
            Assert.assertTrue((boolean)entryMetadataMap.containsKey((long)i));
        }
        entryMetadataMap.close();
        entryMetadataMap = new PersistentEntryLogMetadataMap(path, this.configuration);
        entryMetadataMap.forEach((logId, metadata) -> {
            Assert.assertEquals((long)((EntryLogMetadata)metadatas.get(logId.intValue() - 1)).getTotalSize(), (long)logId);
            for (int i = 0; i < logId.intValue(); ++i) {
                Assert.assertTrue((boolean)metadata.containsLedger((long)i));
            }
        });
        entryMetadataMap.close();
    }

    private EntryLogMetadata createEntryLogMetadata(long logId, long totalLedgers) {
        EntryLogMetadata metadata = new EntryLogMetadata(logId);
        int i = 0;
        while ((long)i < totalLedgers) {
            metadata.addLedgerSize((long)i, 1L);
            ++i;
        }
        return metadata;
    }
}

