/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieFileChannel;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.DefaultFileChannel;
import org.apache.bookkeeper.bookie.DefaultFileChannelProvider;
import org.apache.bookkeeper.bookie.FileChannelProvider;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.bookie.JournalChannel;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LogMark;
import org.apache.bookkeeper.bookie.stats.JournalStats;
import org.apache.bookkeeper.common.collections.BatchedArrayBlockingQueue;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"javax.xml.*", "org.xml.*", "org.w3c.*", "javax.xml.*", "com.sun.org.apache.xerces.*"})
@PrepareForTest(value={JournalChannel.class, Journal.class, DefaultFileChannel.class})
public class BookieJournalForceTest {
    private static final Logger log = LoggerFactory.getLogger(BookieJournalForceTest.class);
    private static final ByteBuf DATA = Unpooled.wrappedBuffer((byte[])new byte[0]);
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();

    @Test
    public void testAckAfterSync() throws Exception {
        File journalDir = this.tempDir.newFolder();
        BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)journalDir));
        ServerConfiguration conf = ((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setJournalDirName(journalDir.getPath()).setMetadataServiceUri(null)).setJournalAdaptiveGroupWrites(false);
        JournalChannel jc = (JournalChannel)Mockito.spy((Object)new JournalChannel(journalDir, 1L));
        PowerMockito.whenNew(JournalChannel.class).withAnyArguments().thenReturn((Object)jc);
        LedgerDirsManager ledgerDirsManager = (LedgerDirsManager)Mockito.mock(LedgerDirsManager.class);
        Journal journal = new Journal(0, journalDir, conf, ledgerDirsManager);
        CountDownLatch forceWriteThreadSuspendedLatch = new CountDownLatch(1);
        BatchedArrayBlockingQueue<Journal.ForceWriteRequest> supportQueue = this.enableForceWriteThreadSuspension(forceWriteThreadSuspendedLatch, journal);
        journal.start();
        LogMark lastLogMarkBeforeWrite = journal.getLastLogMark().markLog().getCurMark();
        final CountDownLatch latch = new CountDownLatch(1);
        long ledgerId = 1L;
        long entryId = 0L;
        journal.logAddEntry(ledgerId, entryId, DATA, false, new BookkeeperInternalCallbacks.WriteCallback(){

            public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
                latch.countDown();
            }
        }, null);
        while (supportQueue.isEmpty()) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)latch.getCount());
        Assert.assertEquals((long)1L, (long)supportQueue.size());
        ((JournalChannel)Mockito.verify((Object)jc, (VerificationMode)Mockito.times((int)0))).forceWrite(true);
        forceWriteThreadSuspendedLatch.countDown();
        Assert.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
        ((JournalChannel)Mockito.verify((Object)jc, (VerificationMode)Mockito.atLeast((int)1))).forceWrite(false);
        Assert.assertEquals((long)0L, (long)supportQueue.size());
        Journal.LastLogMark lastLogMarkAfterForceWrite = journal.getLastLogMark();
        Assert.assertTrue((lastLogMarkAfterForceWrite.getCurMark().compare(lastLogMarkBeforeWrite) > 0 ? 1 : 0) != 0);
        journal.shutdown();
    }

    @Test
    public void testAckBeforeSync() throws Exception {
        File journalDir = this.tempDir.newFolder();
        BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)journalDir));
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        ((ServerConfiguration)conf.setJournalDirName(journalDir.getPath()).setMetadataServiceUri(null)).setJournalAdaptiveGroupWrites(false);
        JournalChannel jc = (JournalChannel)Mockito.spy((Object)new JournalChannel(journalDir, 1L));
        PowerMockito.whenNew(JournalChannel.class).withAnyArguments().thenReturn((Object)jc);
        LedgerDirsManager ledgerDirsManager = (LedgerDirsManager)Mockito.mock(LedgerDirsManager.class);
        Journal journal = new Journal(0, journalDir, conf, ledgerDirsManager);
        CountDownLatch forceWriteThreadSuspendedLatch = new CountDownLatch(1);
        this.enableForceWriteThreadSuspension(forceWriteThreadSuspendedLatch, journal);
        journal.start();
        LogMark lastLogMarkBeforeWrite = journal.getLastLogMark().markLog().getCurMark();
        final CountDownLatch latch = new CountDownLatch(1);
        long ledgerId = 1L;
        long entryId = 0L;
        journal.logAddEntry(ledgerId, entryId, DATA, true, new BookkeeperInternalCallbacks.WriteCallback(){

            public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
                latch.countDown();
            }
        }, null);
        latch.await(20L, TimeUnit.SECONDS);
        ((JournalChannel)Mockito.verify((Object)jc, (VerificationMode)Mockito.times((int)0))).forceWrite(true);
        ((JournalChannel)Mockito.verify((Object)jc, (VerificationMode)Mockito.times((int)0))).forceWrite(false);
        Journal.LastLogMark lastLogMarkAfterForceWrite = journal.getLastLogMark();
        Assert.assertEquals((long)0L, (long)lastLogMarkAfterForceWrite.getCurMark().compare(lastLogMarkBeforeWrite));
        forceWriteThreadSuspendedLatch.countDown();
        journal.shutdown();
    }

    @Test
    public void testAckBeforeSyncWithJournalBufferedEntriesThreshold() throws Exception {
        File journalDir = this.tempDir.newFolder();
        BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)journalDir));
        int journalBufferedEntriesThreshold = 10;
        int numEntries = 60;
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        ((ServerConfiguration)conf.setJournalDirName(journalDir.getPath()).setJournalBufferedEntriesThreshold(10).setMetadataServiceUri(null)).setJournalAdaptiveGroupWrites(false);
        JournalChannel jc = (JournalChannel)Mockito.spy((Object)new JournalChannel(journalDir, 1L));
        PowerMockito.whenNew(JournalChannel.class).withAnyArguments().thenReturn((Object)jc);
        LedgerDirsManager ledgerDirsManager = (LedgerDirsManager)Mockito.mock(LedgerDirsManager.class);
        Journal journal = new Journal(0, journalDir, conf, ledgerDirsManager);
        CountDownLatch forceWriteThreadSuspendedLatch = new CountDownLatch(1);
        this.enableForceWriteThreadSuspension(forceWriteThreadSuspendedLatch, journal);
        JournalStats journalStats = journal.getJournalStats();
        TestStatsProvider testStatsProvider = new TestStatsProvider();
        Counter flushMaxOutstandingBytesCounter = testStatsProvider.getStatsLogger("test").getCounter("flushMaxOutstandingBytesCounter");
        Whitebox.setInternalState((Object)journalStats, (String)"flushMaxOutstandingBytesCounter", (Object)flushMaxOutstandingBytesCounter);
        journal.start();
        LogMark lastLogMarkBeforeWrite = journal.getLastLogMark().markLog().getCurMark();
        final CountDownLatch latch = new CountDownLatch(60);
        long ledgerId = 1L;
        for (long entryId = 0L; entryId < 60L; ++entryId) {
            journal.logAddEntry(ledgerId, entryId, DATA, true, new BookkeeperInternalCallbacks.WriteCallback(){

                public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
                    latch.countDown();
                }
            }, null);
        }
        latch.await(20L, TimeUnit.SECONDS);
        ((JournalChannel)Mockito.verify((Object)jc, (VerificationMode)Mockito.times((int)0))).forceWrite(true);
        ((JournalChannel)Mockito.verify((Object)jc, (VerificationMode)Mockito.times((int)0))).forceWrite(false);
        Journal.LastLogMark lastLogMarkAfterForceWrite = journal.getLastLogMark();
        Assert.assertEquals((long)0L, (long)lastLogMarkAfterForceWrite.getCurMark().compare(lastLogMarkBeforeWrite));
        forceWriteThreadSuspendedLatch.countDown();
        Assert.assertTrue((flushMaxOutstandingBytesCounter.get() > 1L ? 1 : 0) != 0);
        journal.shutdown();
    }

    @Test
    public void testInterleavedRequests() throws Exception {
        File journalDir = this.tempDir.newFolder();
        BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)journalDir));
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir.getPath()).setMetadataServiceUri(null);
        JournalChannel jc = (JournalChannel)Mockito.spy((Object)new JournalChannel(journalDir, 1L));
        PowerMockito.whenNew(JournalChannel.class).withAnyArguments().thenReturn((Object)jc);
        LedgerDirsManager ledgerDirsManager = (LedgerDirsManager)Mockito.mock(LedgerDirsManager.class);
        Journal journal = new Journal(0, journalDir, conf, ledgerDirsManager);
        journal.start();
        int numEntries = 100;
        final CountDownLatch latchAckBeforeSynch = new CountDownLatch(100);
        final CountDownLatch latchAckAfterSynch = new CountDownLatch(100);
        long ledgerIdAckBeforeSync = 1L;
        long ledgerIdAckAfterSync = 2L;
        for (long entryId = 0L; entryId < 100L; ++entryId) {
            journal.logAddEntry(ledgerIdAckBeforeSync, entryId, DATA, true, new BookkeeperInternalCallbacks.WriteCallback(){

                public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
                    latchAckBeforeSynch.countDown();
                }
            }, null);
            journal.logAddEntry(ledgerIdAckAfterSync, entryId, DATA, false, new BookkeeperInternalCallbacks.WriteCallback(){

                public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
                    latchAckAfterSynch.countDown();
                }
            }, null);
        }
        Assert.assertTrue((boolean)latchAckBeforeSynch.await(20L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)latchAckAfterSynch.await(20L, TimeUnit.SECONDS));
        ((JournalChannel)Mockito.verify((Object)jc, (VerificationMode)Mockito.times((int)0))).forceWrite(true);
        ((JournalChannel)Mockito.verify((Object)jc, (VerificationMode)Mockito.atLeast((int)1))).forceWrite(false);
        journal.shutdown();
    }

    private BatchedArrayBlockingQueue<Journal.ForceWriteRequest> enableForceWriteThreadSuspension(CountDownLatch forceWriteThreadSuspendedLatch, Journal journal) throws InterruptedException {
        BatchedArrayBlockingQueue supportQueue = new BatchedArrayBlockingQueue(10000);
        BatchedArrayBlockingQueue forceWriteRequests = (BatchedArrayBlockingQueue)Mockito.mock(BatchedArrayBlockingQueue.class);
        ((BatchedArrayBlockingQueue)Mockito.doAnswer(iom -> {
            supportQueue.put(iom.getArgument(0));
            return null;
        }).when((Object)forceWriteRequests)).put(ArgumentMatchers.any(Journal.ForceWriteRequest.class));
        ((BatchedArrayBlockingQueue)Mockito.doAnswer(iom -> {
            forceWriteThreadSuspendedLatch.await();
            Object[] array = (Journal.ForceWriteRequest[])iom.getArgument(0);
            return supportQueue.takeAll(array);
        }).when((Object)forceWriteRequests)).takeAll((Object[])ArgumentMatchers.any());
        Whitebox.setInternalState((Object)journal, (String)"forceWriteRequests", (Object)forceWriteRequests);
        return supportQueue;
    }

    @Test
    public void testForceLedger() throws Exception {
        File journalDir = this.tempDir.newFolder();
        BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)journalDir));
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir.getPath());
        conf.setJournalAdaptiveGroupWrites(false);
        JournalChannel jc = (JournalChannel)Mockito.spy((Object)new JournalChannel(journalDir, 1L));
        PowerMockito.whenNew(JournalChannel.class).withAnyArguments().thenReturn((Object)jc);
        LedgerDirsManager ledgerDirsManager = (LedgerDirsManager)Mockito.mock(LedgerDirsManager.class);
        Journal journal = new Journal(0, journalDir, conf, ledgerDirsManager);
        CountDownLatch forceWriteThreadSuspendedLatch = new CountDownLatch(1);
        BatchedArrayBlockingQueue<Journal.ForceWriteRequest> supportQueue = this.enableForceWriteThreadSuspension(forceWriteThreadSuspendedLatch, journal);
        journal.start();
        LogMark lastLogMarkBeforeWrite = journal.getLastLogMark().markLog().getCurMark();
        final CountDownLatch latch = new CountDownLatch(1);
        long ledgerId = 1L;
        journal.forceLedger(ledgerId, new BookkeeperInternalCallbacks.WriteCallback(){

            public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
                latch.countDown();
            }
        }, null);
        while (supportQueue.isEmpty()) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)latch.getCount());
        Assert.assertEquals((long)1L, (long)supportQueue.size());
        ((JournalChannel)Mockito.verify((Object)jc, (VerificationMode)Mockito.times((int)0))).forceWrite(true);
        forceWriteThreadSuspendedLatch.countDown();
        Assert.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
        ((JournalChannel)Mockito.verify((Object)jc, (VerificationMode)Mockito.atLeast((int)1))).forceWrite(false);
        Assert.assertEquals((long)0L, (long)supportQueue.size());
        Journal.LastLogMark lastLogMarkAfterForceWrite = journal.getLastLogMark();
        Assert.assertTrue((lastLogMarkAfterForceWrite.getCurMark().compare(lastLogMarkBeforeWrite) > 0 ? 1 : 0) != 0);
        journal.shutdown();
    }

    @Test
    public void testFileChannelProvider() throws Exception {
        File bookieFileDirectory = this.tempDir.newFile();
        ServerConfiguration config = TestBKConfiguration.newServerConfiguration();
        DefaultFileChannel defaultFileChannel = (DefaultFileChannel)Mockito.spy((Object)new DefaultFileChannel(bookieFileDirectory, config));
        FileChannelProvider provider = (FileChannelProvider)Mockito.spy(DefaultFileChannelProvider.class);
        Mockito.when((Object)provider.open(bookieFileDirectory, config)).thenReturn((Object)defaultFileChannel);
        log.info("Journal Channel Provider: " + config.getJournalChannelProvider());
        BookieFileChannel bookieFileChannel = provider.open(bookieFileDirectory, config);
        bookieFileChannel.getFileChannel();
        ((DefaultFileChannel)Mockito.verify((Object)defaultFileChannel, (VerificationMode)Mockito.times((int)1))).getFileChannel();
        bookieFileChannel.getFD();
        ((DefaultFileChannel)Mockito.verify((Object)defaultFileChannel, (VerificationMode)Mockito.times((int)1))).getFD();
        bookieFileChannel.fileExists(bookieFileDirectory);
        ((DefaultFileChannel)Mockito.verify((Object)defaultFileChannel, (VerificationMode)Mockito.times((int)1))).fileExists(bookieFileDirectory);
        provider.close(bookieFileChannel);
        ((DefaultFileChannel)Mockito.verify((Object)defaultFileChannel, (VerificationMode)Mockito.times((int)1))).close();
    }
}

