/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.util.collections.ConcurrentOpenHashMap;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentOpenHashMapTest {
    static final int Iterations = 1;
    static final int ReadIterations = 100;
    static final int N = 1000000;

    @Test
    public void testConstructor() {
        try {
            ConcurrentOpenHashMap.newBuilder().expectedItems(0).build();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ConcurrentOpenHashMap.newBuilder().expectedItems(16).concurrencyLevel(0).build();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ConcurrentOpenHashMap.newBuilder().expectedItems(4).concurrencyLevel(8).build();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReduceUnnecessaryExpansions() {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().expectedItems(2).concurrencyLevel(1).build();
        Assert.assertNull((Object)map.put((Object)"1", (Object)"1"));
        Assert.assertNull((Object)map.put((Object)"2", (Object)"2"));
        Assert.assertNull((Object)map.put((Object)"3", (Object)"3"));
        Assert.assertNull((Object)map.put((Object)"4", (Object)"4"));
        Assert.assertEquals((Object)map.remove((Object)"1"), (Object)"1");
        Assert.assertEquals((Object)map.remove((Object)"2"), (Object)"2");
        Assert.assertEquals((Object)map.remove((Object)"3"), (Object)"3");
        Assert.assertEquals((Object)map.remove((Object)"4"), (Object)"4");
        Assert.assertEquals((long)0L, (long)map.getUsedBucketCount());
    }

    @Test
    public void simpleInsertions() {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().expectedItems(16).build();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertNull((Object)map.put((Object)"1", (Object)"one"));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertNull((Object)map.put((Object)"2", (Object)"two"));
        Assert.assertNull((Object)map.put((Object)"3", (Object)"three"));
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((Object)map.get((Object)"1"), (Object)"one");
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((Object)map.remove((Object)"1"), (Object)"one");
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((Object)map.get((Object)"1"), null);
        Assert.assertEquals((Object)map.get((Object)"5"), null);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertNull((Object)map.put((Object)"1", (Object)"one"));
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((Object)map.put((Object)"1", (Object)"uno"), (Object)"one");
        Assert.assertEquals((long)map.size(), (long)3L);
    }

    @Test
    public void testClear() {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().expectedItems(2).concurrencyLevel(1).autoShrink(true).mapIdleFactor(0.25f).build();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertNull((Object)map.put((Object)"k1", (Object)"v1"));
        Assert.assertNull((Object)map.put((Object)"k2", (Object)"v2"));
        Assert.assertNull((Object)map.put((Object)"k3", (Object)"v3"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        map.clear();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
    }

    @Test
    public void testExpandAndShrink() {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().expectedItems(2).concurrencyLevel(1).autoShrink(true).mapIdleFactor(0.25f).build();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertNull((Object)map.put((Object)"k1", (Object)"v1"));
        Assert.assertNull((Object)map.put((Object)"k2", (Object)"v2"));
        Assert.assertNull((Object)map.put((Object)"k3", (Object)"v3"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove((Object)"k1", (Object)"v1"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove((Object)"k2", (Object)"v2"));
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertNull((Object)map.put((Object)"k4", (Object)"v4"));
        Assert.assertNull((Object)map.put((Object)"k5", (Object)"v5"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertNull((Object)map.put((Object)"k6", (Object)"v6"));
        Assert.assertTrue((boolean)map.remove((Object)"k6", (Object)"v6"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
    }

    @Test
    public void testExpandShrinkAndClear() {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().expectedItems(2).concurrencyLevel(1).autoShrink(true).mapIdleFactor(0.25f).build();
        long initCapacity = map.capacity();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertNull((Object)map.put((Object)"k1", (Object)"v1"));
        Assert.assertNull((Object)map.put((Object)"k2", (Object)"v2"));
        Assert.assertNull((Object)map.put((Object)"k3", (Object)"v3"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove((Object)"k1", (Object)"v1"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove((Object)"k2", (Object)"v2"));
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove((Object)"k3", (Object)"v3"));
        Assert.assertTrue((map.capacity() == initCapacity ? 1 : 0) != 0);
        map.clear();
        Assert.assertTrue((map.capacity() == initCapacity ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().build();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertNull((Object)map.put((Object)"1", (Object)"one"));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertFalse((boolean)map.remove((Object)"0", (Object)"zero"));
        Assert.assertFalse((boolean)map.remove((Object)"1", (Object)"uno"));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertTrue((boolean)map.remove((Object)"1", (Object)"one"));
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testRehashing() {
        int n = 16;
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().expectedItems(n / 2).concurrencyLevel(1).build();
        Assert.assertEquals((long)map.capacity(), (long)n);
        Assert.assertEquals((long)map.size(), (long)0L);
        for (int i = 0; i < n; ++i) {
            map.put((Object)Integer.toString(i), (Object)i);
        }
        Assert.assertEquals((long)map.capacity(), (long)(2 * n));
        Assert.assertEquals((long)map.size(), (long)n);
    }

    @Test
    public void testRehashingWithDeletes() {
        int i;
        int n = 16;
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().expectedItems(n / 2).concurrencyLevel(1).build();
        Assert.assertEquals((long)map.capacity(), (long)n);
        Assert.assertEquals((long)map.size(), (long)0L);
        for (i = 0; i < n / 2; ++i) {
            map.put((Object)i, (Object)i);
        }
        for (i = 0; i < n / 2; ++i) {
            map.remove((Object)i);
        }
        for (i = n; i < 2 * n; ++i) {
            map.put((Object)i, (Object)i);
        }
        Assert.assertEquals((long)map.capacity(), (long)(2 * n));
        Assert.assertEquals((long)map.size(), (long)n);
    }

    @Test
    public void concurrentInsertions() throws Throwable {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().build();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int n = 100000;
        String value = "value";
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n2 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key = random.nextLong();
                    key -= key % (long)(threadIdx + 1);
                    map.put((Object)key, (Object)value);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)map.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void concurrentInsertionsAndReads() throws Throwable {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().build();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int n = 100000;
        String value = "value";
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n2 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key = random.nextLong();
                    key -= key % (long)(threadIdx + 1);
                    map.put((Object)key, (Object)value);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)map.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void testIteration() {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().build();
        Assert.assertEquals((Object)map.keys(), Collections.emptyList());
        Assert.assertEquals((Object)map.values(), Collections.emptyList());
        map.put((Object)0L, (Object)"zero");
        Assert.assertEquals((Object)map.keys(), (Object)Lists.newArrayList((Object[])new Long[]{0L}));
        Assert.assertEquals((Object)map.values(), (Object)Lists.newArrayList((Object[])new String[]{"zero"}));
        map.remove((Object)0L);
        Assert.assertEquals((Object)map.keys(), Collections.emptyList());
        Assert.assertEquals((Object)map.values(), Collections.emptyList());
        map.put((Object)0L, (Object)"zero");
        map.put((Object)1L, (Object)"one");
        map.put((Object)2L, (Object)"two");
        List keys = map.keys();
        Collections.sort(keys);
        Assert.assertEquals((Object)keys, (Object)Lists.newArrayList((Object[])new Long[]{0L, 1L, 2L}));
        List values = map.values();
        Collections.sort(values);
        Assert.assertEquals((Object)values, (Object)Lists.newArrayList((Object[])new String[]{"one", "two", "zero"}));
        map.put((Object)1L, (Object)"uno");
        keys = map.keys();
        Collections.sort(keys);
        Assert.assertEquals((Object)keys, (Object)Lists.newArrayList((Object[])new Long[]{0L, 1L, 2L}));
        values = map.values();
        Collections.sort(values);
        Assert.assertEquals((Object)values, (Object)Lists.newArrayList((Object[])new String[]{"two", "uno", "zero"}));
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testHashConflictWithDeletion() {
        int buckets = 16;
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().expectedItems(16).concurrencyLevel(1).build();
        long key1 = 1L;
        long key2 = 27L;
        int bucket1 = ConcurrentOpenHashMap.signSafeMod((long)ConcurrentOpenHashMap.hash((Object)key1), (int)16);
        int bucket2 = ConcurrentOpenHashMap.signSafeMod((long)ConcurrentOpenHashMap.hash((Object)key2), (int)16);
        Assert.assertEquals((long)bucket1, (long)bucket2);
        Assert.assertEquals((Object)map.put((Object)key1, (Object)"value-1"), null);
        Assert.assertEquals((Object)map.put((Object)key2, (Object)"value-2"), null);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((Object)map.remove((Object)key1), (Object)"value-1");
        Assert.assertEquals((long)map.size(), (long)1L);
        Assert.assertEquals((Object)map.put((Object)key1, (Object)"value-1-overwrite"), null);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((Object)map.remove((Object)key1), (Object)"value-1-overwrite");
        Assert.assertEquals((long)map.size(), (long)1L);
        Assert.assertEquals((Object)map.put((Object)key2, (Object)"value-2-overwrite"), (Object)"value-2");
        Assert.assertEquals((Object)map.get((Object)key2), (Object)"value-2-overwrite");
        Assert.assertEquals((long)map.size(), (long)1L);
        Assert.assertEquals((Object)map.remove((Object)key2), (Object)"value-2-overwrite");
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testPutIfAbsent() {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().build();
        Assert.assertEquals((Object)map.putIfAbsent((Object)1L, (Object)"one"), null);
        Assert.assertEquals((Object)map.get((Object)1L), (Object)"one");
        Assert.assertEquals((Object)map.putIfAbsent((Object)1L, (Object)"uno"), (Object)"one");
        Assert.assertEquals((Object)map.get((Object)1L), (Object)"one");
    }

    @Test
    public void testComputeIfAbsent() {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().expectedItems(16).concurrencyLevel(1).build();
        AtomicInteger counter = new AtomicInteger();
        Function<Integer, Integer> provider = key -> counter.getAndIncrement();
        Assert.assertEquals((long)((Integer)map.computeIfAbsent((Object)0, provider)).intValue(), (long)0L);
        Assert.assertEquals((long)((Integer)map.get((Object)0)).intValue(), (long)0L);
        Assert.assertEquals((long)((Integer)map.computeIfAbsent((Object)1, provider)).intValue(), (long)1L);
        Assert.assertEquals((long)((Integer)map.get((Object)1)).intValue(), (long)1L);
        Assert.assertEquals((long)((Integer)map.computeIfAbsent((Object)1, provider)).intValue(), (long)1L);
        Assert.assertEquals((long)((Integer)map.get((Object)1)).intValue(), (long)1L);
        Assert.assertEquals((long)((Integer)map.computeIfAbsent((Object)2, provider)).intValue(), (long)2L);
        Assert.assertEquals((long)((Integer)map.get((Object)2)).intValue(), (long)2L);
    }

    @Test
    public void testRemoval() {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().build();
        map.put((Object)0, (Object)"0");
        map.put((Object)1, (Object)"1");
        map.put((Object)3, (Object)"3");
        map.put((Object)6, (Object)"6");
        map.put((Object)7, (Object)"7");
        List keys = map.keys();
        Collections.sort(keys);
        Assert.assertEquals((Object)keys, (Object)Lists.newArrayList((Object[])new Integer[]{0, 1, 3, 6, 7}));
        int numOfItemsDeleted = map.removeIf((BiPredicate)new BiPredicate<Integer, String>(){

            @Override
            public boolean test(Integer k, String v) {
                return k < 5;
            }
        });
        Assert.assertEquals((long)numOfItemsDeleted, (long)3L);
        Assert.assertEquals((long)map.size(), (long)(keys.size() - numOfItemsDeleted));
        keys = map.keys();
        Collections.sort(keys);
        Assert.assertEquals((Object)keys, (Object)Lists.newArrayList((Object[])new Integer[]{6, 7}));
    }

    @Test
    public void testEqualsKeys() {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().build();
        class T {
            int value;

            T(int value) {
                this.value = value;
            }

            public int hashCode() {
                return Integer.hashCode(this.value);
            }

            public boolean equals(Object obj) {
                if (obj instanceof T) {
                    return this.value == ((T)obj).value;
                }
                return false;
            }
        }
        T t1 = new T(1);
        T t1B = new T(1);
        T t2 = new T(2);
        Assert.assertEquals((Object)t1, (Object)t1B);
        Assert.assertFalse((boolean)t1.equals(t2));
        Assert.assertFalse((boolean)t1B.equals(t2));
        Assert.assertNull((Object)map.put((Object)t1, (Object)"t1"));
        Assert.assertEquals((Object)map.get((Object)t1), (Object)"t1");
        Assert.assertEquals((Object)map.get((Object)t1B), (Object)"t1");
        Assert.assertNull((Object)map.get((Object)t2));
        Assert.assertEquals((Object)map.remove((Object)t1B), (Object)"t1");
        Assert.assertNull((Object)map.get((Object)t1));
        Assert.assertNull((Object)map.get((Object)t1B));
    }

    public void benchConcurrentOpenHashMap() throws Exception {
        ConcurrentOpenHashMap map = ConcurrentOpenHashMap.newBuilder().expectedItems(1000000).concurrencyLevel(1).build();
        for (long i = 0L; i < 1L; ++i) {
            for (int j = 0; j < 1000000; ++j) {
                map.put((Object)i, (Object)"value");
            }
            for (long h = 0L; h < 100L; ++h) {
                for (int j = 0; j < 1000000; ++j) {
                    map.get((Object)i);
                }
            }
            for (long j = 0L; j < 1000000L; ++j) {
                map.remove((Object)i);
            }
        }
    }

    public void benchConcurrentHashMap() throws Exception {
        ConcurrentHashMap<Long, String> map = new ConcurrentHashMap<Long, String>(1000000, 0.66f, 1);
        for (long i = 0L; i < 1L; ++i) {
            int j;
            for (j = 0; j < 1000000; ++j) {
                map.put(i, "value");
            }
            for (long h = 0L; h < 100L; ++h) {
                for (int j2 = 0; j2 < 1000000; ++j2) {
                    map.get(i);
                }
            }
            for (j = 0; j < 1000000; ++j) {
                map.remove(i);
            }
        }
    }

    void benchHashMap() throws Exception {
        HashMap<Long, String> map = new HashMap<Long, String>(1000000, 0.66f);
        for (long i = 0L; i < 1L; ++i) {
            int j;
            for (j = 0; j < 1000000; ++j) {
                map.put(i, "value");
            }
            for (long h = 0L; h < 100L; ++h) {
                for (int j2 = 0; j2 < 1000000; ++j2) {
                    map.get(i);
                }
            }
            for (j = 0; j < 1000000; ++j) {
                map.remove(i);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ConcurrentOpenHashMapTest t = new ConcurrentOpenHashMapTest();
        long start = System.nanoTime();
        long end = System.nanoTime();
        System.out.println("HM:   " + TimeUnit.NANOSECONDS.toMillis(end - start) + " ms");
        start = System.nanoTime();
        t.benchConcurrentHashMap();
        end = System.nanoTime();
        System.out.println("CHM:  " + TimeUnit.NANOSECONDS.toMillis(end - start) + " ms");
        start = System.nanoTime();
        end = System.nanoTime();
        System.out.println("CLHM: " + TimeUnit.NANOSECONDS.toMillis(end - start) + " ms");
    }
}

