/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDiskChecker {
    DiskChecker diskChecker;
    final List<File> tempDirs = new ArrayList<File>();
    private static final float THRESHOLD = 0.99f;

    @Before
    public void setup() throws IOException {
        this.diskChecker = new DiskChecker(0.99f, 0.99f);
        File placeHolderDir = IOUtils.createTempDir((String)"DiskCheck", (String)"test-placeholder");
        this.tempDirs.add(placeHolderDir);
        File placeHolder = new File(placeHolderDir, "test");
        FileOutputStream placeHolderStream = new FileOutputStream(placeHolder);
        placeHolderStream.write(new byte[102400]);
        placeHolderStream.close();
    }

    @After
    public void tearDown() throws Exception {
        for (File dir : this.tempDirs) {
            FileUtils.deleteDirectory((File)dir);
        }
        this.tempDirs.clear();
    }

    File createTempDir(String prefix, String suffix) throws IOException {
        File dir = IOUtils.createTempDir((String)prefix, (String)suffix);
        this.tempDirs.add(dir);
        return dir;
    }

    @Test(expected=DiskChecker.DiskOutOfSpaceException.class)
    public void testCheckDiskFull() throws IOException {
        File file = this.createTempDir("DiskCheck", "test");
        long usableSpace = file.getUsableSpace();
        long totalSpace = file.getTotalSpace();
        float threshold = TestDiskChecker.minMaxThreshold(1.0f - (float)usableSpace / (float)totalSpace - 0.00999999f);
        this.diskChecker.setDiskSpaceThreshold(threshold, threshold);
        this.diskChecker.checkDiskFull(file);
    }

    @Test(expected=DiskChecker.DiskWarnThresholdException.class)
    public void testDiskWarnThresholdException() throws IOException {
        File file = this.createTempDir("DiskCheck", "test");
        long usableSpace = file.getUsableSpace();
        long totalSpace = file.getTotalSpace();
        float diskSpaceThreshold = TestDiskChecker.minMaxThreshold((1.0f - (float)usableSpace / (float)totalSpace) * 1.5f);
        float diskWarnThreshold = TestDiskChecker.minMaxThreshold((1.0f - (float)usableSpace / (float)totalSpace) * 0.5f);
        this.diskChecker.setDiskSpaceThreshold(diskSpaceThreshold, diskWarnThreshold);
        this.diskChecker.checkDiskFull(file);
    }

    @Test(expected=DiskChecker.DiskOutOfSpaceException.class)
    public void testCheckDiskFullOnNonExistFile() throws IOException {
        File file = this.createTempDir("DiskCheck", "test");
        long usableSpace = file.getUsableSpace();
        long totalSpace = file.getTotalSpace();
        float threshold = TestDiskChecker.minMaxThreshold((1.0f - (float)usableSpace / (float)totalSpace) * 0.5f);
        this.diskChecker.setDiskSpaceThreshold(threshold, threshold);
        Assert.assertTrue((boolean)file.delete());
        this.diskChecker.checkDiskFull(file);
    }

    @Test(expected=DiskChecker.DiskErrorException.class)
    public void testCheckDiskErrorForFile() throws Exception {
        File parent = this.createTempDir("DiskCheck", "test");
        File child = File.createTempFile("DiskCheck", "test", parent);
        this.diskChecker.checkDir(child);
    }

    @Test
    public void testCheckDiskErrorForDir() throws Exception {
        File parent = this.createTempDir("DiskCheck", "test");
        File child = File.createTempFile("DiskCheck", "test", parent);
        child.delete();
        child.mkdir();
        this.diskChecker.checkDir(child);
    }

    private static float minMaxThreshold(float threshold) {
        float minThreshold = 1.0E-7f;
        float maxThreshold = 0.999999f;
        threshold = Math.min(threshold, 0.999999f);
        threshold = Math.max(threshold, 1.0E-7f);
        return threshold;
    }
}

